/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.salesreports.nn;

import com.gridnine.xtrip.common.reports.model.AirTicketsTemplateReportSegment;
import com.gridnine.xtrip.common.reports.model.AirTicketsTemplateReportSegmentTariff;
import com.gridnine.xtrip.common.reports.model.AirTicketsTemplateReportTicket;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.reports.prepare.salesreports.nn.NNReportHelper;
import com.gridnine.xtrip.server.reports.prepare.salesreports.nn.NNSellReportTicket;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class NNRefundReportTicket
extends NNSellReportTicket {
    private final BigDecimal penalty;

    public static List<NNRefundReportTicket> createRefundTickets(AirTicketsTemplateReportTicket ticket) {
        ArrayList<NNRefundReportTicket> result = new ArrayList<NNRefundReportTicket>();
        for (AirTicketsTemplateReportSegmentTariff st : ticket.getSegmentTariffs()) {
            int segmentNumber = NNReportHelper.findFinancialSegmentNumber(ticket, st);
            for (int n = 0; n < st.getSegments().size(); ++n) {
                result.add(new NNRefundReportTicket(ticket, st, (AirTicketsTemplateReportSegment)st.getSegments().get(n), n == segmentNumber, n == 0));
            }
        }
        return result;
    }

    public NNRefundReportTicket(AirTicketsTemplateReportTicket ticket, AirTicketsTemplateReportSegmentTariff st, AirTicketsTemplateReportSegment seg, boolean includeFinanceFields, boolean includePenalty) {
        super(ticket, st, seg, includeFinanceFields);
        this.penalty = includePenalty ? MiscUtil.guarded((BigDecimal)ticket.getPenalty()) : BigDecimal.ZERO;
    }

    public BigDecimal getPenalty() {
        return this.penalty;
    }
}

