/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.salesreports.nn;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.reports.model.AirTicketsTemplateReportSegment;
import com.gridnine.xtrip.common.reports.model.AirTicketsTemplateReportSegmentTariff;
import com.gridnine.xtrip.common.reports.model.AirTicketsTemplateReportTicket;
import com.gridnine.xtrip.server.reports.prepare.salesreports.nn.NNTransportationType;
import java.util.Collection;

public class NNReportHelper {
    public static NNTransportationType getTransportationType(AirTicketsTemplateReportTicket ticket) {
        if (ticket.isRouteContainsCrimea()) {
            return NNTransportationType.CRIMEA;
        }
        if (ticket.getTransportationType() == TransportationType.DOMESTIC) {
            return NNTransportationType.VVL;
        }
        return NNTransportationType.MVL;
    }

    public static String getAgencyCode(EntityReference<Organization> agency) {
        EntityContainer agencyCtr = EntityStorage.get().resolve(agency);
        if (agencyCtr == null) {
            return "?";
        }
        return (String)SystemHelper.getMetadata((Collection)((Organization)agencyCtr.getEntity()).getMetadata(), (MetadataKey)MetadataKey.KEY_NN_AGENCY_CODE);
    }

    private NNReportHelper() {
    }

    public static int findFinancialSegmentNumber(AirTicketsTemplateReportTicket ticket, AirTicketsTemplateReportSegmentTariff st) {
        if (st.getSegments().size() == 1) {
            return 0;
        }
        if (ticket.isRouteContainsCrimea()) {
            int n = 0;
            for (AirTicketsTemplateReportSegment seg : st.getSegments()) {
                if (AirProductHelper.isCrimea((DictionaryReference)seg.getDepartureLocation()) || AirProductHelper.isCrimea((DictionaryReference)seg.getArrivalLocation())) {
                    return n;
                }
                ++n;
            }
            return n;
        }
        if (ticket.getTransportationType() == TransportationType.INTERNATIONAL) {
            int n = 0;
            for (AirTicketsTemplateReportSegment seg : st.getSegments()) {
                if (!NNReportHelper.isDomestic((DictionaryReference<GeoLocation>)seg.getDepartureLocation()) && !NNReportHelper.isDomestic((DictionaryReference<GeoLocation>)seg.getArrivalLocation())) {
                    return n;
                }
                ++n;
            }
        }
        return 0;
    }

    private static boolean isDomestic(DictionaryReference<GeoLocation> departureLocation) {
        GeoLocation loc = (GeoLocation)DictionaryCache.get().resolveReference(departureLocation);
        if (loc == null) {
            return false;
        }
        Country country = (Country)DictionaryCache.get().resolveReference(loc.getCountry());
        return country != null && country.isDomestic();
    }
}

