/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.salesreports.nn;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.reports.model.AirTicketsTemplateReportSegment;
import com.gridnine.xtrip.common.reports.model.AirTicketsTemplateReportSegmentTariff;
import com.gridnine.xtrip.common.reports.model.AirTicketsTemplateReportTicket;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.reports.prepare.salesreports.nn.NNReportHelper;
import com.gridnine.xtrip.server.reports.prepare.salesreports.nn.NNTicketType;
import com.gridnine.xtrip.server.reports.prepare.salesreports.nn.NNTransportationType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class NNSellReportTicket {
    private final NNTicketType type;
    private final String bpdNumer;
    private final Date operationDate;
    private final String airport;
    private final String flightNumber;
    private final Date departureDate;
    private BigDecimal equivalentFare = BigDecimal.ZERO;
    private BigDecimal taxForBlank = BigDecimal.ZERO;
    private BigDecimal taxForFuel = BigDecimal.ZERO;
    private BigDecimal commissionRate = BigDecimal.ZERO;
    private BigDecimal commissionValue = BigDecimal.ZERO;
    private BigDecimal total = BigDecimal.ZERO;
    private final String agencyCode;
    private final NNTransportationType transportationType;

    public static List<NNSellReportTicket> createSellTickets(AirTicketsTemplateReportTicket ticket) {
        ArrayList<NNSellReportTicket> result = new ArrayList<NNSellReportTicket>();
        for (AirTicketsTemplateReportSegmentTariff st : ticket.getSegmentTariffs()) {
            int segmentNumber = NNReportHelper.findFinancialSegmentNumber(ticket, st);
            for (int n = 0; n < st.getSegments().size(); ++n) {
                result.add(new NNSellReportTicket(ticket, st, (AirTicketsTemplateReportSegment)st.getSegments().get(n), n == segmentNumber));
            }
        }
        return result;
    }

    public NNSellReportTicket(AirTicketsTemplateReportTicket ticket, AirTicketsTemplateReportSegmentTariff st, AirTicketsTemplateReportSegment seg, boolean includeFinanceFields) {
        this.type = NNTicketType.TCT;
        this.agencyCode = NNReportHelper.getAgencyCode((EntityReference<Organization>)ticket.getAgency());
        this.bpdNumer = ticket.getTicketNumber();
        this.operationDate = ticket.getIssueDate();
        this.airport = String.format("%s %s", this.getCityCode((DictionaryReference<GeoLocation>)seg.getDepartureLocation()), this.getCityCode((DictionaryReference<GeoLocation>)seg.getArrivalLocation()));
        this.flightNumber = seg.getFlightNumber();
        this.departureDate = seg.getDepartureDate();
        if (includeFinanceFields) {
            this.equivalentFare = st.getTariff();
            this.taxForBlank = GeneralProductHelper.getEquivalentTaxesAmountByCodes((Collection)st.getTaxes(), (boolean)true, (String[])new String[]{"RU"});
            this.taxForFuel = GeneralProductHelper.getEquivalentTaxesAmountByCodes((Collection)st.getTaxes(), (boolean)true, (String[])new String[]{"SA", "XT"});
            this.commissionRate = st.getVendorCommissionRate() != null ? BigDecimal.valueOf(st.getVendorCommissionRate()) : BigDecimal.ZERO;
            this.commissionValue = st.getVendorCommissionValue();
            this.total = MiscUtil.sum((BigDecimal[])new BigDecimal[]{this.equivalentFare, GeneralProductHelper.getEquivalentTaxesAmountByCodes((Collection)st.getTaxes(), (boolean)false, (String[])new String[0])});
        }
        this.transportationType = NNReportHelper.getTransportationType(ticket);
    }

    private String getCityCode(DictionaryReference<GeoLocation> ref) {
        GeoLocation loc = (GeoLocation)DictionaryCache.get().resolveReference(ref);
        if (loc == null) {
            return "?";
        }
        if (loc.getType() == LocationType.AIRPORT && (loc = (GeoLocation)DictionaryCache.get().resolveReference(loc.getParent())) == null) {
            return "?";
        }
        String res = DictHelper.getCodeVariant((BaseDictionary)loc, Arrays.asList(CodeSystem.CRT, CodeSystem.IATA));
        return res == null ? "?" : res;
    }

    public NNTicketType getType() {
        return this.type;
    }

    public String getBpdNumer() {
        return this.bpdNumer;
    }

    public Date getOperationDate() {
        return this.operationDate;
    }

    public String getAirport() {
        return this.airport;
    }

    public String getFlightNumber() {
        return this.flightNumber;
    }

    public BigDecimal getEquivalentFare() {
        return this.equivalentFare;
    }

    public BigDecimal getTaxForBlank() {
        return this.taxForBlank;
    }

    public BigDecimal getTaxForFuel() {
        return this.taxForFuel;
    }

    public BigDecimal getCommissionRate() {
        return this.commissionRate;
    }

    public BigDecimal getCommissionValue() {
        return this.commissionValue;
    }

    public BigDecimal getTotal() {
        return this.total;
    }

    public String getAgencyCode() {
        return this.agencyCode;
    }

    public NNTransportationType getTransportationType() {
        return this.transportationType;
    }

    public Date getDepartureDate() {
        return this.departureDate;
    }
}

