/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.salesreports.s7;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductEntryType;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.finance.CreditBankTransferOrder;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.reports.model.BaseReportParameters;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSalesReportTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.s7.S7RegistryLetterItem;
import com.gridnine.xtrip.common.reports.render.salesreports.s7.S7Ticket;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuSalesReportBatchData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuTicket;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.reports.prepare.salesreports.su.BaseSuSalesReportPrepareHandler;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.LoggerFactory;

public class S7SalesReportPrepareHandler
extends BaseSuSalesReportPrepareHandler {
    private static String[] carrierTaxes = new String[]{"RU", "\u0420\u0423", "XP", "ER", "KS", "SA", "Y1", "P4", "P7", "P8", "P9"};
    private static String[] rebookingTaxes = new String[]{"CP", "PO"};
    private static String[] refundTaxes = new String[]{"P1"};

    @Override
    protected String getPenaltyTaxCode() {
        return "P1";
    }

    @Override
    protected void afterFillDataLists(Map<String, Object> data, List<Message> messages) throws Exception {
        super.afterFillDataLists(data, messages);
        Collection batchDataList = (Collection)data.get("key-batch-data-list");
        if (batchDataList != null) {
            for (SuSalesReportBatchData batchData : batchDataList) {
                block1: for (SuTicket ticket : batchData.getTickets()) {
                    if (ticket.getStatus() == ProductStatus.VOID) continue;
                    boolean moveToNextTicket = false;
                    for (Segment segment : ticket.getSegments()) {
                        GeoLocation departureLocation = (GeoLocation)DictionaryCache.get().resolveReference(segment.getDepartureLocation());
                        GeoLocation arriveLocation = (GeoLocation)DictionaryCache.get().resolveReference(segment.getArriveLocation());
                        if (departureLocation == null || departureLocation.getType() != LocationType.AIRPORT) {
                            SystemHelper.addMessage(messages, (String)"S7StockControlReportPrepareHandler_ticketSegmentDepartureLocationMustBeAirport", null, (MessageType)MessageType.WARNING, (Object[])new Object[]{ticket.getTicketNumber()});
                            moveToNextTicket = true;
                        }
                        if (arriveLocation == null || arriveLocation.getType() != LocationType.AIRPORT) {
                            SystemHelper.addMessage(messages, (String)"S7StockControlReportPrepareHandler_ticketSegmentArriveLocationMustBeAirport", null, (MessageType)MessageType.WARNING, (Object[])new Object[]{ticket.getTicketNumber()});
                            moveToNextTicket = true;
                        }
                        if (!moveToNextTicket) continue;
                        continue block1;
                    }
                }
            }
        }
    }

    @Override
    protected String getVendorCode() {
        return "S7";
    }

    @Override
    public String getId() {
        return "s7-sales-report";
    }

    @Override
    protected String getFuelTaxCode() {
        return "YR";
    }

    private static boolean isContainsCode(String[] codes, String code) {
        if (codes == null || TextUtil.isBlank((String)code)) {
            return false;
        }
        for (String tax : codes) {
            if (!tax.equals(code)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected SuTicket getTicketInstance(Product product, List<Message> messages) throws Exception {
        return new S7Ticket(product, messages);
    }

    private Map<String, S7RegistryLetterItem> getRegistryLettersItems(Map<String, Object> data) {
        TreeMap items = (TreeMap)data.get("key-registry-letters-data");
        if (items == null) {
            items = new TreeMap();
            data.put("key-registry-letters-data", items);
        }
        return items;
    }

    private S7RegistryLetterItem getS7RegistryLetterItem(Map<String, S7RegistryLetterItem> items, ProductStatus opType, TransportationType tranType, S7RegistryLetterItem.FieldDefinition fieldDef) {
        S7RegistryLetterItem item = items.get(tranType.name() + opType.name() + fieldDef.name());
        if (item == null) {
            item = new S7RegistryLetterItem();
            item.fieldDef = fieldDef;
            items.put(tranType.name() + opType.name() + fieldDef.name(), item);
        }
        return item;
    }

    private S7RegistryLetterItem getS7RegistryLetterItem(Map<String, S7RegistryLetterItem> items, TransportationType tranType, S7RegistryLetterItem.FieldDefinition fieldDef) {
        S7RegistryLetterItem item = items.get(tranType.name() + fieldDef.name());
        if (item == null) {
            item = new S7RegistryLetterItem();
            item.fieldDef = fieldDef;
            items.put(tranType.name() + fieldDef.name(), item);
        }
        return item;
    }

    private void addToRegItem(BigDecimal value, Map<String, S7RegistryLetterItem> items, ProductStatus opType, TransportationType tranType, S7RegistryLetterItem.FieldDefinition fieldDef) {
        if (value == null) {
            return;
        }
        S7RegistryLetterItem item = this.getS7RegistryLetterItem(items, opType, tranType, fieldDef);
        item.sum += value.doubleValue();
    }

    private void addToRegItem(double value, Map<String, S7RegistryLetterItem> items, ProductStatus opType, TransportationType tranType, S7RegistryLetterItem.FieldDefinition fieldDef) {
        S7RegistryLetterItem item = this.getS7RegistryLetterItem(items, opType, tranType, fieldDef);
        item.sum += value;
    }

    @Override
    protected void updateTicketRegistryLetterData(SuTicket ticket, String batchId, Map<String, Object> data) {
        if (ticket.getStatus() == null) {
            return;
        }
        TransportationType tranType = TransportationType.DOMESTIC;
        if (ticket.getTransportationType() != TransportationType.DOMESTIC) {
            tranType = TransportationType.INTERNATIONAL;
        }
        Map<String, S7RegistryLetterItem> items = this.getRegistryLettersItems(data);
        FareCommissionInfo taxInfo = this.getFareAndTaxInfo(ticket);
        if (batchId.equals("SALE")) {
            if (ticket.getProductCategory() == ProductCategory.MCO) {
                if (ticket.getMcoCategory() == MCOCategory.SEAT_RESERVATION || ticket.getMcoCategory() == MCOCategory.SPECIAL_FOOD || ticket.getMcoCategory() == MCOCategory.ADDITIONAL_SERVICES) {
                    this.addToRegItem(taxInfo.getFare(), items, ProductStatus.SELL, tranType, S7RegistryLetterItem.FieldDefinition.RuTax);
                } else if (ticket.getMcoCategory() == MCOCategory.REBOOKING) {
                    this.addToRegItem(taxInfo.getRebookingPenalty(), items, ProductStatus.SELL, tranType, S7RegistryLetterItem.FieldDefinition.Penalty);
                }
                if (ticket.getMcoCategory() != MCOCategory.REBOOKING && ticket.getMcoCategory() != MCOCategory.STICKER && ticket.getMcoCategory() != MCOCategory.RESIDUAL_VALUE_FOR_REFUND) {
                    this.addToRegItem(taxInfo.getTaxVendor(), items, ProductStatus.SELL, tranType, S7RegistryLetterItem.FieldDefinition.RuTax);
                }
                if (ticket.getMcoCategory() == MCOCategory.ADDITIONAL_SERVICES) {
                    return;
                }
                if (ticket.getMcoCategory() == MCOCategory.ANIMALS) {
                    this.addToRegItem(taxInfo.getFare(), items, ProductStatus.SELL, tranType, S7RegistryLetterItem.FieldDefinition.Fare);
                }
                if (ticket.getMcoCategory() == MCOCategory.EXCESS_LUGGAGE || ticket.getMcoCategory() == MCOCategory.ADDITIONAL_TARIFF || ticket.getMcoCategory() == MCOCategory.VOUCHER) {
                    this.addToRegItem(taxInfo.getFare(), items, ProductStatus.SELL, tranType, S7RegistryLetterItem.FieldDefinition.Fare);
                }
                this.addToRegItem(taxInfo.getTaxYR(), items, ProductStatus.SELL, tranType, S7RegistryLetterItem.FieldDefinition.YqTax);
                this.addToRegItem(taxInfo.getOtherTax(), items, ProductStatus.SELL, tranType, S7RegistryLetterItem.FieldDefinition.OtherTax);
                this.addToRegItem(taxInfo.getCommission(), items, ProductStatus.SELL, tranType, S7RegistryLetterItem.FieldDefinition.Comm);
                this.addToRegItem(taxInfo.getCashFop(), items, ProductStatus.SELL, tranType, S7RegistryLetterItem.FieldDefinition.CashFop);
                this.addToRegItem(taxInfo.getOtherFop(), items, ProductStatus.SELL, tranType, S7RegistryLetterItem.FieldDefinition.OtherFop);
                return;
            }
            this.addToRegItem(taxInfo.getFare(), items, ProductStatus.SELL, tranType, ticket.isSticker() ? S7RegistryLetterItem.FieldDefinition.Penalty : S7RegistryLetterItem.FieldDefinition.Fare);
            this.addToRegItem(taxInfo.getTaxVendor(), items, ProductStatus.SELL, tranType, S7RegistryLetterItem.FieldDefinition.RuTax);
            if (!MCOCategory.REBOOKING.equals((Object)ticket.getMcoCategory())) {
                this.addToRegItem(taxInfo.getRebookingPenalty(), items, ProductStatus.SELL, tranType, S7RegistryLetterItem.FieldDefinition.Penalty);
            }
            this.addToRegItem(taxInfo.getTaxYR(), items, ProductStatus.SELL, tranType, S7RegistryLetterItem.FieldDefinition.YqTax);
            this.addToRegItem(taxInfo.getOtherTax(), items, ProductStatus.SELL, tranType, S7RegistryLetterItem.FieldDefinition.OtherTax);
            this.addToRegItem(taxInfo.getCommission(), items, ProductStatus.SELL, tranType, S7RegistryLetterItem.FieldDefinition.Comm);
            this.addToRegItem(taxInfo.getCashFop(), items, ProductStatus.SELL, tranType, S7RegistryLetterItem.FieldDefinition.CashFop);
            this.addToRegItem(taxInfo.getOtherFop(), items, ProductStatus.SELL, tranType, S7RegistryLetterItem.FieldDefinition.OtherFop);
        }
        if (batchId.equals("REFUND")) {
            if (ticket.getProductCategory() == ProductCategory.MCO) {
                if (ticket.getMcoCategory() == MCOCategory.RETURN_FARE_DIFFERENCE || ticket.getMcoCategory() == MCOCategory.EXCESS_LUGGAGE && ticket.isEticket()) {
                    this.addToRegItem(ticket.getEquivalentFare().negate(), items, ProductStatus.REFUND, tranType, S7RegistryLetterItem.FieldDefinition.Fare);
                }
                if (ticket.getMcoCategory() == MCOCategory.PENALTY) {
                    this.addToRegItem(taxInfo.getFare(), items, ProductStatus.REFUND, tranType, S7RegistryLetterItem.FieldDefinition.Penalty);
                }
                if (ticket.getMcoCategory() == MCOCategory.RESIDUAL_VALUE_FOR_REFUND) {
                    this.addToRegItem(MiscUtil.guarded((BigDecimal)ticket.getEquivalentFare()).negate(), items, ProductStatus.REFUND, tranType, S7RegistryLetterItem.FieldDefinition.Fare);
                }
                if (ticket.getMcoCategory().equals((Object)MCOCategory.SEAT_RESERVATION) || ticket.getMcoCategory().equals((Object)MCOCategory.SPECIAL_FOOD) || ticket.getMcoCategory().equals((Object)MCOCategory.UNESCORTED_MINOR)) {
                    this.addToRegItem(taxInfo.getTaxVendor(), items, ProductStatus.REFUND, tranType, S7RegistryLetterItem.FieldDefinition.RuTax);
                }
                this.addToRegItem(taxInfo.getTaxYR(), items, ProductStatus.REFUND, tranType, S7RegistryLetterItem.FieldDefinition.YqTax);
                this.addToRegItem(taxInfo.getOtherTax(), items, ProductStatus.REFUND, tranType, S7RegistryLetterItem.FieldDefinition.OtherTax);
                this.addToRegItem(taxInfo.getCommission(), items, ProductStatus.REFUND, tranType, S7RegistryLetterItem.FieldDefinition.Comm);
                this.addToRegItem(taxInfo.getCashFop(), items, ProductStatus.REFUND, tranType, S7RegistryLetterItem.FieldDefinition.CashFop);
                this.addToRegItem(taxInfo.getOtherFop(), items, ProductStatus.REFUND, tranType, S7RegistryLetterItem.FieldDefinition.OtherFop);
                return;
            }
            this.addToRegItem(taxInfo.getFare(), items, ProductStatus.REFUND, tranType, S7RegistryLetterItem.FieldDefinition.Fare);
            this.addToRegItem(taxInfo.getTaxVendor(), items, ProductStatus.REFUND, tranType, S7RegistryLetterItem.FieldDefinition.RuTax);
            this.addToRegItem(taxInfo.getTaxYR(), items, ProductStatus.REFUND, tranType, S7RegistryLetterItem.FieldDefinition.YqTax);
            this.addToRegItem(taxInfo.getOtherTax(), items, ProductStatus.REFUND, tranType, S7RegistryLetterItem.FieldDefinition.OtherTax);
            this.addToRegItem(taxInfo.getCommission(), items, ProductStatus.REFUND, tranType, S7RegistryLetterItem.FieldDefinition.Comm);
            this.addToRegItem(taxInfo.getRefPenalty(), items, ProductStatus.REFUND, tranType, S7RegistryLetterItem.FieldDefinition.Penalty);
            this.addToRegItem(taxInfo.getCashFop(), items, ProductStatus.SELL, tranType, S7RegistryLetterItem.FieldDefinition.CashFop);
            this.addToRegItem(taxInfo.getOtherFop(), items, ProductStatus.SELL, tranType, S7RegistryLetterItem.FieldDefinition.OtherFop);
        }
        if (batchId.equals("EXC")) {
            ProductStatus prodStatus = ProductStatus.SELL;
            if (ticket.getMcoCategory() == MCOCategory.REBOOKING) {
                if (taxInfo.getRebookingPenalty() > 0.0) {
                    this.addToRegItem(taxInfo.getRebookingPenalty(), items, prodStatus, tranType, S7RegistryLetterItem.FieldDefinition.Penalty);
                } else {
                    this.addToRegItem(taxInfo.getFare(), items, prodStatus, tranType, S7RegistryLetterItem.FieldDefinition.Penalty);
                }
            } else {
                this.addToRegItem(taxInfo.getFare(), items, prodStatus, tranType, S7RegistryLetterItem.FieldDefinition.Fare);
                this.addToRegItem(taxInfo.getRebookingPenalty(), items, ProductStatus.SELL, tranType, S7RegistryLetterItem.FieldDefinition.Penalty);
            }
            this.addToRegItem(taxInfo.getTaxVendor(), items, prodStatus, tranType, S7RegistryLetterItem.FieldDefinition.RuTax);
            this.addToRegItem(taxInfo.getTaxYR(), items, prodStatus, tranType, S7RegistryLetterItem.FieldDefinition.YqTax);
            this.addToRegItem(taxInfo.getOtherTax(), items, prodStatus, tranType, S7RegistryLetterItem.FieldDefinition.OtherTax);
            this.addToRegItem(taxInfo.getCommission(), items, prodStatus, tranType, S7RegistryLetterItem.FieldDefinition.Comm);
            this.addToRegItem(taxInfo.getCashFop(), items, prodStatus, tranType, S7RegistryLetterItem.FieldDefinition.CashFop);
            this.addToRegItem(taxInfo.getOtherFop(), items, prodStatus, tranType, S7RegistryLetterItem.FieldDefinition.OtherFop);
        }
    }

    @Override
    protected SuTicket createSticker(Product mco, List<Message> messages) throws Exception {
        return super.createSticker(mco, messages, false);
    }

    private FareCommissionInfo getFareAndTaxInfo(SuTicket ticket) {
        double allFopsValue;
        FareCommissionInfo result = new FareCommissionInfo();
        MCOCategory mcoCategory = ticket.getMcoCategory();
        double equivalentFare = ticket.getEquivalentFare() == null ? 0.0 : ticket.getEquivalentFare().doubleValue();
        switch (ticket.getStatus()) {
            case SELL: 
            case EXCHANGE: {
                result.setFare(equivalentFare);
                break;
            }
            case REFUND: {
                result.setFare(Math.abs(equivalentFare));
                break;
            }
            case VOID: {
                return result;
            }
        }
        double otherTax = 0.0;
        double vendorTax = 0.0;
        double sellTaxAmount = 0.0;
        double fuelTax = 0.0;
        for (Tax tax : ticket.getTaxes()) {
            double amount = tax.getEquivalentAmount() == null ? 0.0 : tax.getEquivalentAmount().doubleValue();
            String code = tax.getCode();
            if (ticket.getStatus() == ProductStatus.REFUND) {
                if (S7SalesReportPrepareHandler.isContainsCode(refundTaxes, code)) continue;
                if (S7SalesReportPrepareHandler.isContainsCode(carrierTaxes, code)) {
                    vendorTax += Math.abs(amount);
                    continue;
                }
                if ("YR".equals(code)) {
                    fuelTax += Math.abs(amount);
                    continue;
                }
                if (S7SalesReportPrepareHandler.isContainsCode(rebookingTaxes, code)) {
                    result.setRebookingPenalty(Math.abs(amount));
                    continue;
                }
                otherTax += Math.abs(amount);
                continue;
            }
            if (S7SalesReportPrepareHandler.isContainsCode(refundTaxes, code)) continue;
            if (S7SalesReportPrepareHandler.isContainsCode(carrierTaxes, code)) {
                vendorTax += amount;
                continue;
            }
            if ("YR".equals(code)) {
                fuelTax += amount;
                continue;
            }
            if (S7SalesReportPrepareHandler.isContainsCode(rebookingTaxes, code)) {
                result.setRebookingPenalty(amount);
                continue;
            }
            otherTax += amount;
        }
        if (ticket.getStatus() == ProductStatus.REFUND) {
            double penalty = ticket.getPenalty() != null ? ticket.getPenalty().doubleValue() : 0.0;
            result.setRefPenalty(penalty);
        } else if (ticket.getStatus() == ProductStatus.SELL && (mcoCategory == MCOCategory.REBOOKING || mcoCategory == MCOCategory.STICKER) || mcoCategory == null && ticket.getPrevTicket() != null && ticket.getPrevTicket().getStatus() == ProductStatus.EXCHANGE) {
            if (ticket.getPenalty() != null) {
                result.setRebookingPenalty(ticket.getPenalty().doubleValue());
            } else if (equivalentFare > 0.0 && ticket.getProductCategory().equals((Object)ProductCategory.MCO) && ticket.isEticket()) {
                result.setRebookingPenalty(equivalentFare);
            }
        }
        double otherFopValue = ticket.getStatus() != ProductStatus.EXCHANGE ? AirProductHelper.getVendorContractRelation((Product)ticket.getProduct()).getFops().stream().filter(item -> item.getType() == PaymentType.MTD || item.getType() == PaymentType.CREDIT_CARD || item.getType() == PaymentType.CREDIT_CARD_TCH || item.getType() == PaymentType.CREDIT || item.getType() == PaymentType.VOUCHER).map(item -> item.getAmount() != null ? (ticket.getStatus() == ProductStatus.REFUND ? MiscUtil.negate((BigDecimal)item.getAmount().getValue()) : item.getAmount().getValue()) : null).reduce(BigDecimal.ZERO, (xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1})).doubleValue() : 0.0;
        double d = allFopsValue = ticket.getStatus() != ProductStatus.EXCHANGE ? AirProductHelper.getVendorContractRelation((Product)ticket.getProduct()).getFops().stream().filter(item -> item.getType() != PaymentType.TICKET).map(item -> item.getAmount() != null ? (ticket.getStatus() == ProductStatus.REFUND ? MiscUtil.negate((BigDecimal)item.getAmount().getValue()) : item.getAmount().getValue()) : null).reduce(BigDecimal.ZERO, (xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1})).doubleValue() : 0.0;
        if (MiscUtil.scale((BigDecimal)BigDecimal.valueOf(otherFopValue), (int)2, (RoundingMode)RoundingMode.HALF_UP).compareTo(BigDecimal.ZERO) != 0) {
            StringBuilder debug = new StringBuilder();
            debug.append(ticket.getTicketNumber());
            debug.append(";");
            debug.append(ticket.getStatus());
            debug.append(";");
            debug.append(otherFopValue);
            debug.append(";");
            debug.append(ticket.getFopCodes() != null ? ticket.getFopCodes().replace(";", " ") : "");
            LoggerFactory.getLogger((String)"s7report").debug(debug.toString());
        }
        result.setCashFop(allFopsValue - otherFopValue);
        result.setOtherFop(otherFopValue);
        result.setTaxYR(fuelTax);
        result.setOtherTax(otherTax);
        result.setTaxVendor(vendorTax);
        result.setSellTaxVendor(sellTaxAmount);
        double commission = ticket.getVendorEquivalentCommission() == null ? 0.0 : (ticket.getStatus() == ProductStatus.REFUND ? -ticket.getVendorEquivalentCommission().doubleValue() : ticket.getVendorEquivalentCommission().doubleValue());
        result.setCommission(commission);
        return result;
    }

    @Override
    protected MetadataKey getAgencyReportCode(BaseReportParameters params) {
        return MetadataKey.KEY_S7_AGENCY_CODE;
    }

    @Override
    protected String getStockControlReportUid() {
        return "s7-stock-control";
    }

    @Override
    protected void updateAgencyMemoProductLetterData(SuTicket ticket, String batchId, Map<String, Object> data) {
        if (ticket.getReportTicketType() != BaseSalesReportTicket.ReportTicketType.MEMO) {
            return;
        }
        Map<String, S7RegistryLetterItem> items = this.getAgencyMemoProductLettersItems(data);
        Map agencyMemoEquivalentFares = ticket.getAgencyMemoProductEquivalentAmounts();
        BigDecimal tariff = (BigDecimal)agencyMemoEquivalentFares.get(AgencyMemoProductEntryType.TARIFF);
        BigDecimal taxCarrier = (BigDecimal)agencyMemoEquivalentFares.get(AgencyMemoProductEntryType.TAX_CARRIER);
        BigDecimal taxFuel = (BigDecimal)agencyMemoEquivalentFares.get(AgencyMemoProductEntryType.TAX_FUEL);
        BigDecimal taxState = (BigDecimal)agencyMemoEquivalentFares.get(AgencyMemoProductEntryType.TAX_STATE);
        BigDecimal taxOther = (BigDecimal)agencyMemoEquivalentFares.get(AgencyMemoProductEntryType.TAX_OTHERS);
        BigDecimal contractPenalty = (BigDecimal)agencyMemoEquivalentFares.get(AgencyMemoProductEntryType.CONTRACT_PENALTY);
        BigDecimal penalty = (BigDecimal)agencyMemoEquivalentFares.get(AgencyMemoProductEntryType.PENALTY);
        BigDecimal commission = MiscUtil.negate((BigDecimal)((BigDecimal)agencyMemoEquivalentFares.get(AgencyMemoProductEntryType.COMMISSION)));
        if (ticket.getAgencyMemoProductType() != AgencyMemoProductType.ADM) {
            tariff = MiscUtil.negate((BigDecimal)tariff);
            taxCarrier = MiscUtil.negate((BigDecimal)taxCarrier);
            taxFuel = MiscUtil.negate((BigDecimal)taxFuel);
            taxState = MiscUtil.negate((BigDecimal)taxState);
            taxOther = MiscUtil.negate((BigDecimal)taxOther);
            contractPenalty = MiscUtil.negate((BigDecimal)contractPenalty);
            penalty = MiscUtil.negate((BigDecimal)penalty);
            commission = MiscUtil.negate((BigDecimal)commission);
        }
        TransportationType tranType = TransportationType.DOMESTIC;
        if (ticket.getTransportationType() != TransportationType.DOMESTIC) {
            tranType = TransportationType.INTERNATIONAL;
        }
        this.addToRegItem(tariff, items, tranType, S7RegistryLetterItem.FieldDefinition.Fare);
        this.addToRegItem(taxCarrier, items, tranType, S7RegistryLetterItem.FieldDefinition.RuTax);
        this.addToRegItem(taxFuel, items, tranType, S7RegistryLetterItem.FieldDefinition.YqTax);
        this.addToRegItem(taxState, items, tranType, S7RegistryLetterItem.FieldDefinition.OtherTax);
        this.addToRegItem(taxOther, items, tranType, S7RegistryLetterItem.FieldDefinition.OtherTax);
        this.addToRegItem(contractPenalty, items, tranType, S7RegistryLetterItem.FieldDefinition.OtherTax);
        this.addToRegItem(penalty, items, tranType, S7RegistryLetterItem.FieldDefinition.Penalty);
        this.addToRegItem(commission, items, tranType, S7RegistryLetterItem.FieldDefinition.Comm);
    }

    private Map<String, S7RegistryLetterItem> getAgencyMemoProductLettersItems(Map<String, Object> data) {
        TreeMap items = (TreeMap)data.get("key-agency-memos-registry-letter-data");
        if (items == null) {
            items = new TreeMap();
            data.put("key-agency-memos-registry-letter-data", items);
        }
        return items;
    }

    private void addToRegItem(BigDecimal value, Map<String, S7RegistryLetterItem> items, TransportationType trType, S7RegistryLetterItem.FieldDefinition fieldDef) {
        if (value == null) {
            return;
        }
        S7RegistryLetterItem item = this.getS7RegistryLetterItem(items, trType, fieldDef);
        item.sum += value.doubleValue();
    }

    @Override
    protected void putGlobalData(Map<String, Object> data, List<Message> messages) throws Exception {
        super.putGlobalData(data, messages);
        this.putCreditBankTransferOrderInfo(data, messages);
    }

    @Override
    protected String getCreditOrderName(CreditBankTransferOrder order) {
        return String.format("\u2116 \u041f/\u041f %s \u043e\u0442 %s %s", order.getIncomeDocNumber(), new SimpleDateFormat("dd.MM.yyyy").format(order.getIncomeDocDate()), order.getPayer());
    }

    class FareCommissionInfo {
        private double fare;
        private double taxYR;
        private double taxVendor;
        private double otherTax;
        private double commission;
        private double refPenalty;
        private double sellPenalty;
        private double rebookingPenalty;
        private double cashFop;
        private double otherFop;
        private double sellTaxVendor;

        FareCommissionInfo() {
        }

        public double getCommission() {
            return this.commission;
        }

        public void setCommission(double value) {
            this.commission = value;
        }

        public double getFare() {
            return this.fare;
        }

        public void setFare(double value) {
            this.fare = value;
        }

        public double getTaxYR() {
            return this.taxYR;
        }

        public void setTaxYR(double value) {
            this.taxYR = value;
        }

        public double getTaxVendor() {
            return this.taxVendor;
        }

        public void setTaxVendor(double value) {
            this.taxVendor = value;
        }

        public double getOtherTax() {
            return this.otherTax;
        }

        public void setOtherTax(double value) {
            this.otherTax = value;
        }

        public double getRefPenalty() {
            return this.refPenalty;
        }

        public void setRefPenalty(double value) {
            this.refPenalty = value;
        }

        public double getSellPenalty() {
            return this.sellPenalty;
        }

        public void setSellPenalty(double value) {
            this.sellPenalty = value;
        }

        public double getCashFop() {
            return this.cashFop;
        }

        public void setCashFop(double value) {
            this.cashFop = value;
        }

        public double getOtherFop() {
            return this.otherFop;
        }

        public void setOtherFop(double value) {
            this.otherFop = value;
        }

        public void setSellTaxVendor(double sellTaxVendorValue) {
            this.sellTaxVendor = sellTaxVendorValue;
        }

        public double getSellTaxVendor() {
            return this.sellTaxVendor;
        }

        public double getRebookingPenalty() {
            return this.rebookingPenalty;
        }

        public void setRebookingPenalty(double value) {
            this.rebookingPenalty = value;
        }
    }
}

