/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.salesreports.s7.tripartite.newform;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.ReportBatchData;
import com.gridnine.xtrip.common.reports.model.TripartiteReportParameters;
import com.gridnine.xtrip.common.reports.render.salesreports.s7.tripartite.S7TripartiteReportTicket;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.helpers.ProfileDao;
import com.gridnine.xtrip.server.reports.prepare.BaseReportPrepareHandler;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class S7TripartiteReportNewFormPrepareHandler
extends BaseReportPrepareHandler {
    private ReportBatchData<S7TripartiteReportTicket> refundList = null;
    ReportBatchData<S7TripartiteReportTicket> sellList = null;

    @Override
    protected void addProductProxyTicket(Product product, Map<String, Object> data, List<Message> messages) throws Exception {
        S7TripartiteReportTicket ticket;
        ArrayList<ReportBatchData<S7TripartiteReportTicket>> batchDataList = (ArrayList<ReportBatchData<S7TripartiteReportTicket>>)data.get("key-batch-data-list");
        if (batchDataList == null) {
            batchDataList = new ArrayList<ReportBatchData<S7TripartiteReportTicket>>();
            this.sellList = new ReportBatchData();
            this.sellList.setBatchId("SELL");
            batchDataList.add(this.sellList);
            this.refundList = new ReportBatchData();
            this.refundList.setBatchId("REFUND");
            batchDataList.add(this.refundList);
            data.put("key-batch-data-list", batchDataList);
        }
        if ((ticket = new S7TripartiteReportTicket(product, messages)).getStatus() == ProductStatus.SELL) {
            this.sellList.getTickets().add(ticket);
        } else {
            this.refundList.getTickets().add(ticket);
        }
    }

    @Override
    protected Collection<? extends Product> getData(Map<String, Object> data, List<Message> messages) throws Exception {
        List blankOwners = ProfileDao.getBlankOwnersByAirline((DictionaryReference)new AirlineReference("S7"));
        if (blankOwners.isEmpty()) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.S7TripartiteReportPrepareHandler_cantFindProfileSiberia, (Object[])new Object[0]));
            return Collections.emptyList();
        }
        if (blankOwners.size() > 1) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.S7TripartiteReportPrepareHandler_haveFewProfileBlankOwnerS7, (Object[])new Object[0]));
            return Collections.emptyList();
        }
        TripartiteReportParameters params = (TripartiteReportParameters)data.get("key-report-params");
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.ticketType.name(), (Object)TicketType.OWN));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ProductIndex.Property.status.name(), (Object)ProductStatus.SELL), SearchCriterion.eq((String)ProductIndex.Property.status.name(), (Object)ProductStatus.REFUND)}));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.agency.name(), (Object)params.getAgency()));
        if (params.getContract() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.tripartiteContract.name(), (Object)params.getContract()));
        } else {
            query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ProductIndex.Property.tripartiteContract.name(), null));
        }
        if (!TextUtil.isBlank((String)params.getContractCode())) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ProductIndex.Property.tripartiteContractCode.name(), (Object)params.getContractCode()), SearchCriterion.eq((String)ProductIndex.Property.tripartiteContractDiscountCode.name(), (Object)params.getContractCode())}));
        } else {
            query.getCriteria().getCriterions().add(SearchCriterion.isNotEmpty((String)ProductIndex.Property.tripartiteContractCode.name()));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)ProductIndex.Property.issueDate.name(), (Object)params.getPeriodBegin()), SearchCriterion.le((String)ProductIndex.Property.issueDate.name(), (Object)params.getPeriodEnd()), SearchCriterion.eq((String)ProductIndex.Property.dateOfVendorPayment.name(), null)}), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)ProductIndex.Property.dateOfVendorPayment.name(), (Object)params.getPeriodBegin()), SearchCriterion.le((String)ProductIndex.Property.dateOfVendorPayment.name(), (Object)params.getPeriodEnd())})}));
        HashMap<EntityReference, EntityContainer> bookings = new HashMap<EntityReference, EntityContainer>();
        EntityStorage es = EntityStorage.get();
        HashSet<Product> result = new HashSet<Product>();
        for (ProductIndex index : es.search(ProductIndex.class, query).getData()) {
            EntityReference ref = index.getSource();
            EntityContainer ctr = (EntityContainer)bookings.get(ref);
            if (ctr == null) {
                ctr = es.resolve(ref);
                bookings.put(ref, ctr);
            }
            result.add((Product)BookingHelper.findProduct((BookingFile)((BookingFile)ctr.getEntity()), (String)index.getNavigationKey()));
        }
        if (result.isEmpty()) {
            SystemHelper.addMessage(messages, (String)Messages.reportNoTicket, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            this.log.warn("There are no tickets in the report");
        }
        return result;
    }

    @Override
    protected void putGlobalData(Map<String, Object> data, List<Message> messages) throws Exception {
        TripartiteReportParameters params = (TripartiteReportParameters)data.get("key-report-params");
        EntityContainer contract = EntityStorage.get().resolve(params.getContract());
        if (contract == null) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.S7TripartiteReportPrepareHandler_cantFindTripartiteContract, (Object[])new Object[0]));
        }
        boolean found = false;
        if (contract != null) {
            for (ContractCustomerInfo info : ((Contract)contract.getEntity()).getCustomers()) {
                if (!MiscUtil.equals((Object)info.getContractCode(), (Object)params.getContractCode())) continue;
                if (info.getIssueDate() == null) {
                    messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.S7TripartiteReportPrepareHandler_noDateSigningContract, (Object[])new Object[0]));
                    return;
                }
                data.put("REPORT_TITLE", L10nResourcesManager.getStr((String)"S7TripartiteReportPrepareHandler_byTripartCorpContract", (Object[])new Object[]{info.getNumber(), new SimpleDateFormat("dd.MM.yyyy").format(info.getIssueDate())}));
                data.put("REPORT_FILENAME", String.format("Tripartite_%s_%s-%s.xls", info.getContractCode(), new SimpleDateFormat("dd.MM").format(params.getPeriodBegin()), new SimpleDateFormat("dd.MM.yyyy").format(params.getPeriodEnd())));
                found = true;
            }
        } else {
            data.put("REPORT_TITLE", L10nResourcesManager.getStr((String)"S7TripartiteReportPrepareHandler_byMultipleContracts", (Object[])new Object[0]));
            data.put("REPORT_FILENAME", String.format("Tripartite_multiple_tour_codes_%s-%s.xls", new SimpleDateFormat("dd.MM").format(params.getPeriodBegin()), new SimpleDateFormat("dd.MM.yyyy").format(params.getPeriodEnd())));
            found = true;
        }
        if (!found) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.S7TripartiteReportPrepareHandler_noNumberAndDateContract, (Object[])new Object[0]));
            return;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(params.getPeriodBegin());
        String monthName = null;
        switch (cal.get(2)) {
            case 0: {
                monthName = "\u044f\u043d\u0432\u0430\u0440\u044c";
                break;
            }
            case 1: {
                monthName = "\u0444\u0435\u0432\u0440\u0430\u043b\u044c";
                break;
            }
            case 2: {
                monthName = "\u043c\u0430\u0440\u0442";
                break;
            }
            case 3: {
                monthName = "\u0430\u043f\u0440\u0435\u043b\u044c";
                break;
            }
            case 4: {
                monthName = "\u043c\u0430\u0439";
                break;
            }
            case 5: {
                monthName = "\u0438\u044e\u043d\u044c";
                break;
            }
            case 6: {
                monthName = "\u0438\u044e\u043b\u044c";
                break;
            }
            case 7: {
                monthName = "\u0430\u0432\u0433\u0443\u0441\u0442";
                break;
            }
            case 8: {
                monthName = "\u0441\u0435\u043d\u0442\u044f\u0431\u0440\u044c";
                break;
            }
            case 9: {
                monthName = "\u043e\u043a\u0442\u044f\u0431\u0440\u044c";
                break;
            }
            case 10: {
                monthName = "\u043d\u043e\u044f\u0431\u0440\u044c";
                break;
            }
            default: {
                monthName = "\u0434\u0435\u043a\u0430\u0431\u0440\u044c";
            }
        }
        data.put("REPORT_PERIOD", String.format("%s %s \u0433.", monthName, Integer.toString(cal.get(1))));
        EntityContainer agency = EntityStorage.get().resolve(params.getAgency());
        if (agency == null) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.S7TripartiteReportPrepareHandler_cantLoadProfileAgency, (Object[])new Object[0]));
            return;
        }
        String agencyCode = SystemHelper.findMetadataAsString((Collection)((Organization)agency.getEntity()).getMetadata(), (MetadataKey)MetadataKey.KEY_S7_AGENCY_CODE);
        if (TextUtil.isBlank((String)agencyCode)) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.S7TripartiteReportPrepareHandler_inProfileNoCodeS7, (Object[])new Object[]{params.getAgency()}));
            return;
        }
        data.put("AGENCY_CODE", agencyCode);
        EntityContainer client = EntityStorage.get().resolve(params.getClient());
        if (client == null) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.S7TripartiteReportPrepareHandler_cantLoadProfileCorpClient, (Object[])new Object[0]));
        }
        if (client != null) {
            data.put("CLIENT_NAME", L10nResourcesManager.getStr((String)Messages.S7TripartiteReportPrepareHandler_code, (Object[])new Object[]{ProfileHelper.getFullName((Organization)((Organization)client.getEntity()), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false), params.getContractCode()}));
        } else {
            data.put("CLIENT_NAME", L10nResourcesManager.getStr((String)Messages.S7TripartiteReportPrepareHandler_multipleClients, (Object[])new Object[0]));
        }
    }

    @Override
    public String getId() {
        return "s7-tripartite-report-new-form";
    }

    @Override
    protected void validateProductToReport(Product product, Map<String, Object> data, List<Message> messages) throws Exception {
        super.validateProductToReport(product, data, messages);
        if (product.getTripartiteContractDetails().getContract() == null) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.S7TripartiteReportPrepareHandler_ticketTripartiteAgreement, (Object[])new Object[]{product.getSystemNumber()}));
        }
        if (product.getTripartiteContractDetails().getContractCode() == null) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.S7TripartiteReportPrepareHandler_noContractCode, (Object[])new Object[]{product.getSystemNumber()}));
        }
        if (product.getTripartiteContractDetails().getDiscountValue() == null) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.S7TripartiteReportPrepareHandler_ticketNoDiscount, (Object[])new Object[]{product.getSystemNumber()}));
        }
    }

    @Override
    protected void checkReportParameters(Map<String, Object> data, List<Message> messages) throws Exception {
        super.checkReportParameters(data, messages);
        TripartiteReportParameters params = (TripartiteReportParameters)data.get("key-report-params");
        if (params == null) {
            return;
        }
        if (params.getAgency() == null) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.BaseSsodDivergenceReportPrepareHandler_noAgency, (Object[])new Object[0]));
        }
        if (params.getClient() == null) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.S7TripartiteReportPrepareHandler_noClient, (Object[])new Object[0]));
        }
        if (params.getContract() == null) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.S7TripartiteReportPrepareHandler_noContract, (Object[])new Object[0]));
        }
        if (params.getContractCode() == null) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.S7TripartiteReportPrepareHandler_noContractCode, (Object[])new Object[0]));
        }
        if (params.getPeriodBegin() == null || params.getPeriodEnd() == null) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.S7TripartiteReportPrepareHandler_noPeriodReport, (Object[])new Object[0]));
        }
    }
}

