/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.salesreports.su;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.booking.CurrencyRateType;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProduct;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductEntry;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductEntryAssociationType;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductEntryType;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductIndex;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductType;
import com.gridnine.xtrip.common.model.booking.air.AirProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BlankCategory;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.PassengerStatus;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AgencyMemoProductHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductTaxHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.helpers.ValidatorHelper;
import com.gridnine.xtrip.common.model.profile.BaseContractAppendix;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.SUBlockCharterAppendix;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.SalesPointIndex;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.BaseReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseSalesReportTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuRegistryLetterItem;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuSalesReportBatchData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuTicket;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.model.helpers.ProfileDao;
import com.gridnine.xtrip.server.reports.prepare.PrepareHandlersRegistry;
import com.gridnine.xtrip.server.reports.prepare.salesreports.BaseSalesReportPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.salesreports.SalesReportPrepareHelper;
import com.gridnine.xtrip.server.reports.prepare.salesreports.su.SUBCReportPrepareHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.LoggerFactory;

public abstract class BaseSuSalesReportPrepareHandler
extends BaseSalesReportPrepareHandler<SuTicket> {
    protected String getPenaltyTaxCode() {
        return "CP";
    }

    protected boolean checkFopTypes(SuTicket ticket) {
        for (ProductFop fop : ticket.getFops()) {
            if (fop.getType() != null) continue;
            return false;
        }
        return true;
    }

    protected Product copyAsMcoGroupPenalty(Product product) throws Exception {
        Product mco = (Product)XCloneHelper.clone((XCloneable)product, (boolean)false);
        Collection taxesList = AirProductTaxHelper.getTaxesByCodes((Product)product, (String[])new String[]{"R2"});
        Tax r2Tax = null;
        if (!taxesList.isEmpty()) {
            r2Tax = (Tax)taxesList.iterator().next();
        }
        BigDecimal eFare = AirProductHelper.getEquivalentFare((Product)mco);
        Money fare = AirProductHelper.getBaseFare((Product)mco);
        if (r2Tax == null) {
            r2Tax = new Tax();
            mco.getTaxes().add(r2Tax);
            r2Tax.setAmount(new Money());
            r2Tax.getAmount().setValue(eFare == null ? null : eFare.abs());
            r2Tax.getAmount().setCurrency(DictHelper.getLocalCurrency());
            r2Tax.setCode("R2");
            r2Tax.setEquivalentAmount(eFare == null ? null : eFare.abs());
        }
        AirProductHelper.setEquivalentFare((Product)mco, (BigDecimal)(eFare == null ? null : eFare.negate()));
        if (fare != null && fare.getValue() != null) {
            fare.setValue(fare.getValue().negate());
            AirProductHelper.setBaseFare((Product)mco, (Money)fare);
        }
        AirProductHelper.recalcFops((Product)mco);
        return mco;
    }

    @Override
    protected void addProductProxyTicket(Product prod, Map<String, Object> data, List<Message> messages) throws Exception {
        SuTicket ticket = null;
        if (prod.getProductCategory() == ProductCategory.MCO && prod.getMcoCategory() == MCOCategory.ADDITIONAL_SERVICES && !prod.getBlankOwnerNumber().equals("421")) {
            return;
        }
        try {
            ticket = prod.getMcoCategory() == MCOCategory.GROUP_PENALTY ? this.getTicketInstance(this.copyAsMcoGroupPenalty(prod), messages) : this.getTicketInstance(prod, messages);
        }
        catch (Exception e) {
            this.log.error("Can't create SuTicket for product \"" + prod.getSystemNumber() + "\"", (Throwable)e);
            return;
        }
        if (ticket.getStatus() != ProductStatus.VOID && !this.checkFopTypes(ticket)) {
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_FopTypeIsNotSet", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{ticket.getTicketNumber()});
            this.log.error("Fop type is not set for ticket " + ticket.getTicketNumber());
            return;
        }
        this.setSpecificTicketData(ticket, prod, data, messages);
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        EntityReference agencyReference = params.getAgency();
        ArrayList<SuSalesReportBatchData<SuTicket>> batchDataList = (ArrayList<SuSalesReportBatchData<SuTicket>>)data.get("key-batch-data-list");
        if (batchDataList == null) {
            batchDataList = new ArrayList<SuSalesReportBatchData<SuTicket>>();
            data.put("key-batch-data-list", batchDataList);
        }
        if (!(ticket.getTariffType() != TariffType.BLOCKCHARTER && ticket.getTariffType() != TariffType.CHARTER || MCOCategory.NOT_SOLD_SEATS.equals((Object)ticket.getMcoCategory()))) {
            SUBCReportPrepareHelper.addProductProxyTicket(prod, data, messages);
        }
        SuSalesReportBatchData<SuTicket> batch = this.selectBatch(ticket.getBatchId(), ticket.getAgencyCode(), batchDataList, agencyReference.getCaption());
        boolean excludeFromSelectedBatch = false;
        if (batch.getBatchId().equals("SALE")) {
            SuSalesReportBatchData<SuTicket> refundBatch;
            if (!(prod.getProductCategory() != ProductCategory.MCO || prod.getMcoCategory() != MCOCategory.REBOOKING && prod.getMcoCategory() != MCOCategory.STICKER || prod.getRelatedProducts().isEmpty())) {
                Product relProd = (Product)prod.getRelatedProducts().get(0);
                ticket.setVendorCommissionRate(Double.valueOf(0.0));
                if (ticket.getBaseFare() != null) {
                    ticket.getBaseFare().setValue(BigDecimal.ZERO);
                }
                ticket.setEquivalentFare(BigDecimal.ZERO);
                ticket.setVendorEquivalentCommission(BigDecimal.ZERO);
                if (prod.getMcoCategory() == MCOCategory.STICKER && relProd != null && relProd.getStatus() == ProductStatus.SELL) {
                    SuTicket sticker = this.createSticker(prod, messages);
                    batch.getTickets().add(sticker);
                    this.updateTicketRegistryLetterData(sticker, batch.getBatchId(), data);
                }
            }
            if (prod.getProductCategory() == ProductCategory.MCO && prod.getMcoCategory() == MCOCategory.RETURN_FARE_DIFFERENCE && !prod.getRelatedProducts().isEmpty()) {
                SuTicket returnFareDifferenceAsRefund = this.createReturnFareDifferenceAsRefund(prod, messages);
                refundBatch = this.selectBatch("REFUND", ticket.getAgencyCode(), batchDataList, agencyReference.getCaption());
                refundBatch.getTickets().add(returnFareDifferenceAsRefund);
                this.updateTicketRegistryLetterData(returnFareDifferenceAsRefund, refundBatch.getBatchId(), data);
                ticket.setEquivalentFare(BigDecimal.ZERO);
                ticket.setVendorEquivalentCommission(BigDecimal.ZERO);
                for (ProductFop productFop : ticket.getFops()) {
                    productFop.getAmount().setValue(BigDecimal.ZERO);
                }
                ticket.getBaseFare().setValue(BigDecimal.ZERO);
            }
            if (prod.getProductCategory() == ProductCategory.MCO && prod.getMcoCategory() == MCOCategory.RESIDUAL_VALUE_FOR_REFUND) {
                SuTicket residualValueMCO = this.createResidalValueMCO(prod, messages);
                refundBatch = this.selectBatch("REFUND", ticket.getAgencyCode(), batchDataList, agencyReference.getCaption());
                refundBatch.getTickets().add(residualValueMCO);
                this.updateTicketRegistryLetterData(residualValueMCO, refundBatch.getBatchId(), data);
                excludeFromSelectedBatch = true;
            }
        }
        if (!excludeFromSelectedBatch) {
            batch.getTickets().add(ticket);
            if (!MCOCategory.NOT_SOLD_SEATS.equals((Object)ticket.getMcoCategory())) {
                this.updateTicketRegistryLetterData(ticket, batch.getBatchId(), data);
            }
        }
    }

    protected boolean isCreditCardUsed(SuTicket ticket) {
        for (ProductFop pf : ticket.getFops()) {
            if (pf.getType() != PaymentType.CREDIT_CARD) continue;
            return true;
        }
        return false;
    }

    protected void updateTicketRegistryLetterData(SuTicket ticket, String batchId, Map<String, Object> data) {
        boolean interline;
        Map<String, SuRegistryLetterItem> items = this.getRegistryLettersItems(data);
        ProductStatus status = ticket.getStatus();
        boolean ebt = ticket.getProductCategory() == ProductCategory.EXCESS_BAGAGE;
        boolean bl = interline = ticket.isInterline() || ticket.getTariffType() == TariffType.GROUP;
        if (ticket.getProductCategory() == ProductCategory.MCO && (!MiscUtil.equals((Object)"SU", (Object)ticket.getBlankOwnerCode()) && ticket.getMcoCategory() == MCOCategory.PENALTY || ticket.getMcoCategory() == MCOCategory.ADDITIONAL_TARIFF) || ticket.getProductCategory() == ProductCategory.AIR && (ticket.getTariffType() == TariffType.BLOCKCHARTER || ticket.getTariffType() == TariffType.CHARTER)) {
            return;
        }
        if (batchId.equals("EXC")) {
            status = ProductStatus.EXCHANGE;
        }
        TransportationType tranType = TransportationType.DOMESTIC;
        if (ticket.getTransportationType() != TransportationType.DOMESTIC) {
            tranType = TransportationType.INTERNATIONAL;
        }
        HashMap<SuRegistryLetterItem.TableDefinition, BigDecimal> temp = new HashMap<SuRegistryLetterItem.TableDefinition, BigDecimal>();
        block33: for (SuRegistryLetterItem.TableDefinition def : SuRegistryLetterItem.TableDefinition.values()) {
            double sum;
            block49: {
                Product firstProduct;
                SuRegistryLetterItem item;
                block48: {
                    if (ticket.isDuplicate()) {
                        switch (def) {
                            case CCPenalty: 
                            case Penalty: {
                                status = ProductStatus.EXCHANGE;
                                break;
                            }
                            case CCRuTax: 
                            case RuTax: {
                                status = ProductStatus.SELL;
                                break;
                            }
                            default: {
                                continue block33;
                            }
                        }
                    }
                    item = items.get(tranType.name() + status.name() + def.name());
                    if (ticket.isDeputy() && def != SuRegistryLetterItem.TableDefinition.Comm && def != SuRegistryLetterItem.TableDefinition.Bonus && (item = items.get(tranType.name() + "DEPUTY" + def.name())) == null) {
                        item = new SuRegistryLetterItem();
                        item.credit = 0.0;
                        item.debit = 0.0;
                        item.docCount = 0;
                        items.put(tranType.name() + "DEPUTY" + def.name(), item);
                    }
                    sum = 0.0;
                    if (item == null) {
                        item = new SuRegistryLetterItem();
                        item.credit = 0.0;
                        item.debit = 0.0;
                        item.docCount = 0;
                        items.put(tranType.name() + status.name() + def.name(), item);
                    }
                    if (!this.isCreditCardUsed(ticket)) break block48;
                    switch (def) {
                        case CCFare: {
                            if (!interline && !ebt) {
                                sum = ticket.getEquivalentFare() == null ? 0.0 : ticket.getEquivalentFare().doubleValue();
                                ++item.docCount;
                                break;
                            }
                            break block49;
                        }
                        case CCInterlineFare: {
                            if (interline && !ebt) {
                                sum = ticket.getPrepayed() != null && ticket.getEquivalentFare() != null ? ticket.getEquivalentFare().doubleValue() - ticket.getPrepayed().doubleValue() : (ticket.getEquivalentFare() == null ? 0.0 : ticket.getEquivalentFare().doubleValue());
                                ++item.docCount;
                                break;
                            }
                            break block49;
                        }
                        case CCRuTax: {
                            sum = ticket.getTaxEquivAmountByCode(this.getSupplierTaxCode());
                            if (!ticket.isDuplicate()) {
                                sum += ticket.getTaxEquivAmountByCode("YR");
                                break;
                            }
                            if (ticket.getRelatedProducts().length > 0 && (firstProduct = ticket.getRelatedProducts()[0]) != null) {
                                sum = this.updateDuplicateByRuTax(sum, firstProduct);
                                break;
                            }
                            break block49;
                        }
                        case CCYqTax: {
                            sum = ticket.getTaxEquivAmountByCode(this.getFuelTaxCode());
                            break;
                        }
                        case CCOtherTax: {
                            sum = ticket.getOtherTaxAmount();
                            break;
                        }
                        case CCComm: {
                            sum = ticket.getVendorEquivalentCommission() == null ? 0.0 : ticket.getVendorEquivalentCommission().doubleValue();
                            break;
                        }
                        case CCPenalty: {
                            sum = ticket.getPenalty() == null ? 0.0 : ticket.getPenalty().doubleValue();
                            break;
                        }
                    }
                    break block49;
                }
                switch (def) {
                    case Fare: {
                        if (interline || ebt) break;
                        double d = sum = ticket.getEquivalentFare() == null ? 0.0 : ticket.getEquivalentFare().doubleValue();
                        if (ticket.getStatus() == ProductStatus.EXCHANGE) break;
                        ++item.docCount;
                        break;
                    }
                    case InterlineFare: {
                        if (!interline || ebt) break;
                        if (ticket.getPrepayed() != null && ticket.getEquivalentFare() != null) {
                            sum = ticket.getEquivalentFare().doubleValue() - ticket.getPrepayed().doubleValue();
                        } else {
                            double d = sum = ticket.getEquivalentFare() == null ? 0.0 : ticket.getEquivalentFare().doubleValue();
                        }
                        if (ticket.getStatus() == ProductStatus.EXCHANGE) break;
                        ++item.docCount;
                        break;
                    }
                    case EbtFare: {
                        if (!ebt) break;
                        double d = sum = ticket.getEquivalentFare() == null ? 0.0 : ticket.getEquivalentFare().doubleValue();
                        if (ticket.getStatus() == ProductStatus.EXCHANGE) break;
                        ++item.docCount;
                        break;
                    }
                    case RuTax: {
                        sum = ticket.getTaxEquivAmountByCode(this.getSupplierTaxCode());
                        if (!ticket.isDuplicate()) {
                            sum += ticket.getTaxEquivAmountByCode("YR");
                            break;
                        }
                        if (ticket.getRelatedProducts().length <= 0 || (firstProduct = ticket.getRelatedProducts()[0]) == null) break;
                        sum = this.updateDuplicateByRuTax(sum, firstProduct);
                        break;
                    }
                    case YqTax: {
                        sum = ticket.getTaxEquivAmountByCode(this.getFuelTaxCode());
                        break;
                    }
                    case OtherTax: {
                        sum = ticket.getOtherTaxAmount();
                        break;
                    }
                    case Comm: {
                        sum = ticket.getVendorEquivalentCommission() == null ? 0.0 : ticket.getVendorEquivalentCommission().doubleValue();
                        break;
                    }
                    case Penalty: {
                        sum = ticket.getPenalty() == null ? 0.0 : ticket.getPenalty().doubleValue();
                        break;
                    }
                }
            }
            switch (status) {
                case SELL: 
                case EXCHANGE: {
                    switch (def) {
                        case CCComm: 
                        case Comm: {
                            temp.put(def, MiscUtil.negate((BigDecimal)MiscUtil.scale((BigDecimal)BigDecimal.valueOf(sum), (int)2, (RoundingMode)RoundingMode.HALF_UP)));
                            item.credit += sum;
                            continue block33;
                        }
                    }
                    temp.put(def, MiscUtil.scale((BigDecimal)BigDecimal.valueOf(sum), (int)2, (RoundingMode)RoundingMode.HALF_UP));
                    item.debit += sum;
                    continue block33;
                }
                case REFUND: {
                    switch (def) {
                        case CCPenalty: 
                        case Penalty: 
                        case CCComm: 
                        case Comm: {
                            temp.put(def, MiscUtil.scale((BigDecimal)BigDecimal.valueOf(Math.abs(sum)), (int)2, (RoundingMode)RoundingMode.HALF_UP));
                            item.debit += Math.abs(sum);
                            continue block33;
                        }
                    }
                    temp.put(def, MiscUtil.negate((BigDecimal)MiscUtil.scale((BigDecimal)BigDecimal.valueOf(Math.abs(sum)), (int)2, (RoundingMode)RoundingMode.HALF_UP)));
                    item.credit += Math.abs(sum);
                    continue block33;
                }
            }
        }
        StringBuilder debug = new StringBuilder();
        debug.append(ticket.getTicketNumber());
        debug.append(";");
        debug.append(ticket.getStatus());
        for (SuRegistryLetterItem.TableDefinition def : SuRegistryLetterItem.TableDefinition.values()) {
            debug.append(";");
            debug.append(temp.get(def));
        }
        debug.append(";");
        debug.append(ticket.getFopCodes() != null ? ticket.getFopCodes().replace(";", " ") : "");
        LoggerFactory.getLogger((String)"sureport").debug(debug.toString());
    }

    private Map<String, SuRegistryLetterItem> getRegistryLettersItems(Map<String, Object> data) {
        TreeMap items = (TreeMap)data.get("key-registry-letters-data");
        if (items == null) {
            items = new TreeMap();
            data.put("key-registry-letters-data", items);
        }
        return items;
    }

    protected SuSalesReportBatchData<SuTicket> selectBatch(String batchId, String agencyCode, List<SuSalesReportBatchData<SuTicket>> batchDataList, String mainAgencyCode) {
        boolean multiReportMode = this.getMultiReportMode();
        for (SuSalesReportBatchData<SuTicket> batchOuter : batchDataList) {
            this.log.debug("debug: entered foreach");
            if (!(batchOuter instanceof SuSalesReportBatchData)) {
                this.log.debug("skipped batch");
                continue;
            }
            this.log.debug("batch is instance of SuSalesReportBatchData");
            SuSalesReportBatchData<SuTicket> batch = batchOuter;
            if (!(multiReportMode ? batch.getBatchId().equals(batchId) && batch.getSubagencyCode().equals(agencyCode) : batch.getBatchId().equals(batchId))) continue;
            return batch;
        }
        SuSalesReportBatchData newBatch = new SuSalesReportBatchData();
        newBatch.setBatchId(batchId);
        newBatch.setSubagencyCode(agencyCode);
        newBatch.setAgencyCode(mainAgencyCode);
        batchDataList.add((SuSalesReportBatchData<SuTicket>)newBatch);
        return newBatch;
    }

    protected SuTicket createSticker(Product mco, List<Message> messages) throws Exception {
        return this.createSticker(mco, messages, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SuTicket createSticker(Product mco, List<Message> messages, boolean needSegmentTariffs) throws Exception {
        if (needSegmentTariffs && mco.getSegmentTariffs().isEmpty()) {
            return null;
        }
        if (mco.getRelatedProducts().isEmpty()) {
            SystemHelper.addMessage(messages, (String)Messages.SuSalesReportPrepareHandler_unableFindRelatedTicket, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{mco.getSystemNumber()});
            return null;
        }
        Product sell = (Product)mco.getRelatedProducts().get(0);
        Product sticker = new Product();
        mco.getReservation().getProducts().add(sticker);
        sticker.setReservation(mco.getReservation());
        sticker.setIssueDate(mco.getIssueDate());
        sticker.setSystemNumber(sell.getSystemNumber());
        sticker.setConjCount(sell.getConjCount());
        sticker.setEticket(sell.isEticket());
        sticker.setValidatorCode(mco.getValidatorCode());
        sticker.setProductCategory(ProductCategory.AIR);
        sticker.setStatus(ProductStatus.SELL);
        sticker.setBlankOwnerNumber(sell.getBlankOwnerNumber());
        sticker.setCarrierNumber(sell.getCarrierNumber());
        sticker.setTraveller(sell.getTraveller());
        sticker.setBlankType(sell.getBlankType());
        sticker.setCarrier(sell.getCarrier());
        BigDecimal equivalentFare = AirProductHelper.getEquivalentFare((Product)mco);
        AirProductHelper.setBaseFare((Product)sticker, (Money)AirProductHelper.getBaseFare((Product)mco));
        AirProductHelper.setEquivalentFare((Product)sticker, (BigDecimal)equivalentFare);
        if (mco.getPenalty() != null && !mco.getPenalty().equals(BigDecimal.ZERO)) {
            Tax taxPO = new Tax();
            taxPO.setAmount(new Money());
            taxPO.getAmount().setValue(mco.getPenalty());
            taxPO.getAmount().setCurrency(DictHelper.getLocalCurrency());
            taxPO.setEquivalentAmount(mco.getPenalty());
            taxPO.setCode("PO");
            sticker.getTaxes().add(taxPO);
        }
        for (Object tax : mco.getTaxes()) {
            sticker.getTaxes().add(XCloneHelper.clone((XCloneable)tax, (boolean)true));
        }
        List stickerFops = AirProductHelper.getVendorContractRelation((Product)sticker).getFops();
        for (ProductFop fop : AirProductHelper.getVendorFops((Product)mco)) {
            stickerFops.add(XCloneHelper.clone((XCloneable)fop, (boolean)true));
        }
        for (SegmentTariff tariff : mco.getSegmentTariffs()) {
            SegmentTariff st = (SegmentTariff)XCloneHelper.clone((XCloneable)tariff, (boolean)true);
            sticker.getSegmentTariffs().add(st);
            st.getSegments().clear();
            for (Segment segment : tariff.getSegments()) {
                Segment seg = (Segment)XCloneHelper.clone((XCloneable)segment, (boolean)true);
                st.getSegments().add(seg);
            }
        }
        for (AirProductContractRelationData item : AirProductHelper.getContractRelations((Product)sticker)) {
            AirProductContractRelationData relation = AirProductHelper.findContractRelation((List)AirProductHelper.getContractRelations((Product)mco), (EntityReference)item.getDescription());
            if (relation == null) continue;
            for (Commission comm : relation.getCommissions()) {
                SegmentTariff st = comm.getSegmentTariff();
                try {
                    item.getCommissions().add(XCloneHelper.clone((XCloneable)comm, (boolean)true));
                }
                finally {
                    comm.setSegmentTariff(st);
                }
            }
        }
        SuTicket result = new SuTicket(sticker, messages);
        result.setProduct(sticker);
        int couponsCount = sell.getConjCount() + 1;
        BlankType blankType = (BlankType)DictionaryCache.get().resolveReference(sell.getBlankType());
        if (sell.getBlankType() != null) {
            couponsCount = (sell.getConjCount() + 1) * blankType.getCouponsCount();
        }
        StringBuilder buf = new StringBuilder();
        block9: for (int n = 1; n <= couponsCount; ++n) {
            for (SegmentTariff tariff : mco.getSegmentTariffs()) {
                for (Segment segment : tariff.getSegments()) {
                    if (n != segment.getRecordNumber()) continue;
                    buf.append("F");
                    continue block9;
                }
            }
            buf.append("V");
        }
        result.setStickerCouponNames(buf.toString());
        result.setSticker(true);
        return result;
    }

    @Override
    protected void afterFillDataLists(Map<String, Object> data, List<Message> messages) throws Exception {
        List batchDataList = (List)data.get("key-batch-data-list");
        SUBCReportPrepareHelper.clearAuxiliaryData(data);
        if (batchDataList == null || batchDataList.isEmpty()) {
            return;
        }
        if (this.getMultiReportMode()) {
            Collections.sort(batchDataList, new Comparator<SuSalesReportBatchData<SuTicket>>(){

                @Override
                public int compare(SuSalesReportBatchData<SuTicket> o1, SuSalesReportBatchData<SuTicket> o2) {
                    String mainAgencyCode = o1.getAgencyCode();
                    String subagencyCode1 = o1.getSubagencyCode();
                    String subagencyCode2 = o2.getSubagencyCode();
                    if (TextUtil.isBlank((String)subagencyCode1) || TextUtil.isBlank((String)subagencyCode2)) {
                        return 1;
                    }
                    if (subagencyCode1.equals(mainAgencyCode) && subagencyCode2.equals(mainAgencyCode)) {
                        return o1.getSortOrder().compareTo(o2.getSortOrder());
                    }
                    if (subagencyCode1.equals(mainAgencyCode)) {
                        return -1;
                    }
                    if (subagencyCode2.equals(mainAgencyCode)) {
                        return 1;
                    }
                    if (!subagencyCode1.equals(subagencyCode2)) {
                        return subagencyCode1.compareTo(subagencyCode2);
                    }
                    return o1.getSortOrder().compareTo(o2.getSortOrder());
                }
            });
        } else {
            Collections.sort(batchDataList, new Comparator<SuSalesReportBatchData<SuTicket>>(){

                @Override
                public int compare(SuSalesReportBatchData<SuTicket> o1, SuSalesReportBatchData<SuTicket> o2) {
                    return o1.getSortOrder().compareTo(o2.getSortOrder());
                }
            });
        }
        this.sortTicketsOfBatches(data, messages);
    }

    protected SuTicket getTicketInstance(Product product, List<Message> messages) throws Exception {
        return new SuTicket(product, messages);
    }

    protected SuTicket getTicketInstance(AgencyMemoProduct agencyMemoProduct, List<Message> messages) throws Exception {
        return new SuTicket(agencyMemoProduct, messages);
    }

    protected String getVendorCode() {
        return "SU";
    }

    @Override
    protected void validateProductToReport(Product product, Map<String, Object> data, List<Message> messages) throws Exception {
        super.validateProductToReport(product, data, messages);
        if (TextUtil.isBlank((String)product.getValidatorCode())) {
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Message_NoValidator", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{product.getSystemNumber()});
        }
        if (product.getTariffType() == null) {
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Message_TariffTypeIsUndefined", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{product.getSystemNumber()});
        }
        if (TextUtil.isBlank((String)product.getSystemNumber())) {
            String description = Optional.ofNullable(product.getReservation()).map(CommonReservationGdsNameInfoHelper::getDisplayedRecordLocator).orElse(null);
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Message_EmptySystemNumber", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{description});
        }
    }

    protected void setSpecificTicketData(SuTicket aTicket, Product ticket, Map<String, Object> data, List<Message> messages) throws Exception {
        if (ticket.getTariffType() == TariffType.BLOCKCHARTER || ticket.getTariffType() == TariffType.CHARTER) {
            if (!MCOCategory.NOT_SOLD_SEATS.equals((Object)ticket.getMcoCategory())) {
                aTicket.setBlockCharterAgenencyId((String)data.get("KEY_BLOCK_CHARTER_CONTRACT_CLIENT_ID"));
                String blockCharterContractNo = this.getBlockCharterContractNo(ticket);
                if (TextUtil.isBlank((String)blockCharterContractNo)) {
                    messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.SuSalesReportPrepareHandler_ticketNotFoundNumber, (Object[])new Object[]{ticket.getSystemNumber()}));
                } else {
                    aTicket.setBlockCharterContractNo(blockCharterContractNo);
                }
            } else {
                PassengerStatus passengerStatus;
                ProductFop productFop;
                List vendorFops;
                aTicket.setBlockCharterAgenencyId((String)data.get("KEY_BLOCK_CHARTER_CONTRACT_CLIENT_ID"));
                if (ticket.getCarrier() != null && ticket.getCarrier().getCode() != null && ticket.getCarrier().getCode() == "UN" && (vendorFops = AirProductHelper.getVendorFops((Product)ticket)) != null && !vendorFops.isEmpty() && (productFop = (ProductFop)vendorFops.get(0)).getType() == PaymentType.MTD && (passengerStatus = productFop.getPassengerStatus()) == PassengerStatus.VS_MO) {
                    aTicket.setBlockCharterAgenencyId(PassengerStatus.VS_MO.name());
                }
                aTicket.setBlockCharterContractNo((String)data.get("KEY_BLOCK_CHARTER_CONTRACT_NO"));
                if (TextUtil.isBlank((String)aTicket.getBlockCharterContractNo())) {
                    aTicket.setBlockCharterContractNo(this.getBlockCharterContractNo2(ticket));
                }
                if (TextUtil.isBlank((String)aTicket.getBlockCharterContractNo())) {
                    messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.SuSalesReportPrepareHandler_ticketNotFoundNumber, (Object[])new Object[]{ticket.getSystemNumber()}));
                }
                if (TextUtil.isBlank((String)aTicket.getBlockCharterAgenencyId())) {
                    messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.SuSalesReportPrepareHandler_ticketNotFoundCodeClient, (Object[])new Object[]{ticket.getSystemNumber()}));
                }
            }
        }
        switch (ticket.getStatus()) {
            case VOID: {
                if (ticket.getProductCategory() == ProductCategory.MCO && aTicket.getBlankCategory().equals((Object)BlankCategory.PRINTED_NUMBER)) {
                    aTicket.setScn("");
                }
                return;
            }
            case SELL: {
                Object equivFare;
                Tax tax2;
                if (ticket.getProductCategory() != ProductCategory.AIR) break;
                if (ticket.getPreviousProduct() != null && ticket.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE) {
                    Object mcoPenalty;
                    Tax penaltyTax;
                    Product mcoPenaltyProduct = null;
                    Product mcoAddTariffProduct = null;
                    for (Product p : AirProductHelper.getMcoByRelatedProduct((Product)ticket)) {
                        if (p.getProductCategory() != ProductCategory.MCO) continue;
                        if (p.getMcoCategory() == MCOCategory.REBOOKING) {
                            mcoPenaltyProduct = p;
                            break;
                        }
                        if (p.getMcoCategory() != MCOCategory.ADDITIONAL_TARIFF) continue;
                        mcoAddTariffProduct = p;
                        break;
                    }
                    if (mcoPenaltyProduct == null) {
                        Collection penaltyTaxList = AirProductTaxHelper.getTaxesByCodes((Product)ticket, (String[])new String[]{"CP"});
                        if (!penaltyTaxList.isEmpty()) {
                            aTicket.setPenalty(((Tax)penaltyTaxList.iterator().next()).getEquivalentAmount());
                        }
                        if (aTicket.getPenalty() != null && aTicket.getPenalty().compareTo(BigDecimal.ZERO) != 0 && penaltyTaxList.isEmpty()) {
                            penaltyTax = new Tax();
                            penaltyTax.setEquivalentAmount(aTicket.getPenalty());
                            if ("UN".equals(this.getVendorCode()) || "5N".equals(this.getVendorCode())) {
                                penaltyTax.setCode("P2");
                            } else {
                                penaltyTax.setCode("CP");
                            }
                            aTicket.getTaxes().add(penaltyTax);
                        }
                    }
                    if (mcoPenaltyProduct != null && !"S7".equals(this.getVendorCode()) && (mcoPenalty = AirProductHelper.getEquivalentFare(mcoPenaltyProduct)) != null) {
                        Money fopAmount;
                        penaltyTax = new Tax();
                        penaltyTax.setEquivalentAmount((BigDecimal)mcoPenalty);
                        penaltyTax.setCode("CP");
                        aTicket.getTaxes().add(penaltyTax);
                        aTicket.setPenalty((BigDecimal)mcoPenalty);
                        if (!aTicket.getFops().isEmpty()) {
                            ProductFop fop2 = (ProductFop)aTicket.getFops().iterator().next();
                            fopAmount = fop2.getAmount();
                            if (fopAmount != null) {
                                BigDecimal value = fopAmount.getValue();
                                fopAmount.setValue((BigDecimal)(value == null ? mcoPenalty : value.add((BigDecimal)mcoPenalty)));
                            } else {
                                fopAmount = new Money();
                                fopAmount.setCurrency(DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB"));
                                fopAmount.setValue((BigDecimal)mcoPenalty);
                                fop2.setAmount(fopAmount);
                            }
                        } else {
                            ProductFop newFop = new ProductFop();
                            aTicket.getFops().add(newFop);
                            newFop.setType(PaymentType.CASH);
                            fopAmount = new Money();
                            fopAmount.setCurrency(DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB"));
                            fopAmount.setValue((BigDecimal)mcoPenalty);
                            newFop.setAmount(fopAmount);
                        }
                    }
                    if (mcoAddTariffProduct != null && !mcoAddTariffProduct.isEticket()) {
                        for (Tax tax2 : mcoAddTariffProduct.getTaxes()) {
                            Tax newTax = (Tax)XCloneHelper.clone((XCloneable)tax2, (boolean)true);
                            aTicket.getTaxes().add(newTax);
                        }
                        Money baseFare = aTicket.getBaseFare();
                        equivFare = aTicket.getEquivalentFare();
                        Money mcoBaseFare = AirProductHelper.getBaseFare((Product)mcoAddTariffProduct);
                        BigDecimal mcoEqivFare = AirProductHelper.getEquivalentFare((Product)mcoAddTariffProduct);
                        if (baseFare != null && baseFare.getValue() != null) {
                            baseFare.setValue(baseFare.getValue().add(mcoBaseFare == null || mcoBaseFare.getValue() == null ? BigDecimal.ZERO : mcoBaseFare.getValue()));
                        }
                        if (equivFare != null && mcoEqivFare != null) {
                            aTicket.setEquivalentFare(((BigDecimal)equivFare).add(mcoEqivFare));
                        }
                        if (!AirProductHelper.getVendorContractRelation((Product)mcoAddTariffProduct).getFops().isEmpty()) {
                            ProductFop fop = (ProductFop)AirProductHelper.getVendorContractRelation((Product)mcoAddTariffProduct).getFops().get(0);
                            boolean found = false;
                            if (fop.getAmount() != null && fop.getAmount().getValue() != null) {
                                for (ProductFop f : aTicket.getFops()) {
                                    if (f.getType() != fop.getType() || f.getAmount() == null || f.getAmount().getValue() == null) continue;
                                    f.getAmount().setValue(f.getAmount().getValue().add(fop.getAmount().getValue()));
                                    found = true;
                                    break;
                                }
                                if (!found && !aTicket.getFops().isEmpty()) {
                                    ProductFop f = (ProductFop)aTicket.getFops().iterator().next();
                                    f.getAmount().setValue(f.getAmount().getValue().add(fop.getAmount().getValue()));
                                }
                            }
                        }
                    }
                }
                Collection mcoList = AirProductHelper.getMcoByRelatedProduct((Product)ticket);
                Product unescortedMinorMco = null;
                Product comfortMco = null;
                equivFare = mcoList.iterator();
                while (equivFare.hasNext()) {
                    Product mco = (Product)equivFare.next();
                    if (mco.getMcoCategory() == null || mco.isEticket()) continue;
                    switch (mco.getMcoCategory()) {
                        case UNESCORTED_MINOR: {
                            unescortedMinorMco = mco;
                            break;
                        }
                        case COMFORT_PLUS: {
                            comfortMco = mco;
                            break;
                        }
                    }
                }
                if (unescortedMinorMco != null) {
                    tax2 = new Tax();
                    tax2.setAmount(new Money());
                    tax2.setEquivalentAmount(AirProductHelper.getEquivalentFare(unescortedMinorMco));
                    if (tax2.getEquivalentAmount() != null && BigDecimal.ZERO.compareTo(tax2.getEquivalentAmount()) < 0) {
                        tax2.getAmount().setValue(tax2.getEquivalentAmount());
                        tax2.getAmount().setCurrency(DictHelper.getLocalCurrency());
                        tax2.setCode("6A");
                        unescortedMinorMco.getTaxes().add(tax2);
                        AirProductHelper.setEquivalentFare((Product)unescortedMinorMco, (BigDecimal)BigDecimal.ZERO);
                    }
                }
                if (comfortMco == null) break;
                tax2 = new Tax();
                tax2.setAmount(new Money());
                tax2.setEquivalentAmount(AirProductHelper.getEquivalentFare(comfortMco));
                if (tax2.getEquivalentAmount() == null || BigDecimal.ZERO.compareTo(tax2.getEquivalentAmount()) >= 0) break;
                tax2.getAmount().setValue(tax2.getEquivalentAmount());
                tax2.getAmount().setCurrency(DictHelper.getLocalCurrency());
                tax2.setCode("6B");
                comfortMco.getTaxes().add(tax2);
                break;
            }
            case EXCHANGE: {
                ProductFop fop;
                if (aTicket.getBaseFare() != null && aTicket.getBaseFare().getValue() != null) {
                    aTicket.getBaseFare().setValue(aTicket.getBaseFare().getValue().negate());
                }
                if (aTicket.getEquivalentFare() != null) {
                    aTicket.setEquivalentFare(aTicket.getEquivalentFare().negate());
                }
                for (Tax tax : aTicket.getTaxes()) {
                    if (tax.getAmount() != null && tax.getAmount().getValue() != null) {
                        tax.getAmount().setValue(tax.getAmount().getValue().negate());
                    }
                    if (tax.getEquivalentAmount() == null) continue;
                    tax.setEquivalentAmount(tax.getEquivalentAmount().negate());
                }
                for (ProductFop fop2 : aTicket.getFops()) {
                    if (fop2.getAmount() == null || fop2.getAmount().getValue() == null) continue;
                    fop2.getAmount().setValue(fop2.getAmount().getValue().negate());
                }
                BigDecimal commissionValue = aTicket.getVendorEquivalentCommission();
                if (commissionValue != null) {
                    aTicket.setVendorEquivalentCommission(aTicket.getVendorEquivalentCommission().negate());
                }
                if (!"S7".equals(this.getVendorCode())) break;
                Product rebookingMco = null;
                Product sellProduct = null;
                if (ticket.getNextProduct() != null && ProductStatus.SELL.equals((Object)ticket.getNextProduct().getStatus())) {
                    sellProduct = ticket.getNextProduct();
                }
                ArrayList mcoByRelatedProduct = new ArrayList();
                mcoByRelatedProduct.addAll(AirProductHelper.getMcoByRelatedProduct((Product)ticket));
                mcoByRelatedProduct.addAll(AirProductHelper.getMcoByRelatedProduct((Product)sellProduct));
                Iterator found = mcoByRelatedProduct.iterator();
                while (found.hasNext()) {
                    Product mco = (Product)found.next();
                    if (mco.getMcoCategory() != MCOCategory.REBOOKING) continue;
                    rebookingMco = mco;
                }
                if (rebookingMco == null || rebookingMco.isEticket()) break;
                if (rebookingMco.getPenalty() != null && rebookingMco.getPenalty().compareTo(BigDecimal.ZERO) > 0) {
                    Tax tax = new Tax();
                    tax.setAmount(new Money());
                    tax.setEquivalentAmount(rebookingMco.getPenalty());
                    tax.getAmount().setValue(tax.getEquivalentAmount());
                    tax.getAmount().setCurrency(DictHelper.getLocalCurrency());
                    tax.setCode("PO");
                    if (sellProduct != null) {
                        sellProduct.getTaxes().add(tax);
                        sellProduct.getTaxes().addAll(rebookingMco.getTaxes());
                        rebookingMco.setPenalty(null);
                    }
                }
                BigDecimal fopSum = BigDecimal.ZERO;
                for (ProductFop fop3 : AirProductHelper.getVendorContractRelation((Product)rebookingMco).getFops()) {
                    if (fop3.getAmount() == null || fop3.getAmount().getValue() == null) continue;
                    fopSum = fopSum.add(fop3.getAmount().getValue());
                }
                if (aTicket.getFops().isEmpty() || (fop = (ProductFop)aTicket.getFops().iterator().next()).getAmount() == null || fop.getAmount().getValue() == null) break;
                fop.getAmount().setValue(fop.getAmount().getValue().add(fopSum));
                break;
            }
            case REFUND: {
                Product[] mcoProducts;
                Money baseFare;
                BigDecimal equivalentFare = aTicket.getEquivalentFare();
                BigDecimal commissionValue = aTicket.getVendorEquivalentCommission();
                if (equivalentFare != null) {
                    aTicket.setEquivalentFare(aTicket.getEquivalentFare().negate());
                }
                if (commissionValue != null) {
                    aTicket.setVendorEquivalentCommission(aTicket.getVendorEquivalentCommission().negate());
                }
                if ((baseFare = aTicket.getBaseFare()) != null && baseFare.getValue() != null) {
                    baseFare.setValue(baseFare.getValue().negate());
                    aTicket.setBaseFare(baseFare);
                }
                for (Tax t : aTicket.getTaxes()) {
                    if (t.getEquivalentAmount() == null) continue;
                    t.setEquivalentAmount(t.getEquivalentAmount().negate());
                }
                this.setRefundPenaltyTax(aTicket, ticket, data, messages);
                BigDecimal fopRefundSum = BigDecimal.ZERO;
                String currency = null;
                PaymentType pType = aTicket.getFops().size() > 1 ? PaymentType.CASH : null;
                for (ProductFop fop : aTicket.getFops()) {
                    if (fop.getAmount() == null || fop.getAmount().getValue() == null) continue;
                    fopRefundSum = fopRefundSum.add(fop.getAmount().getValue());
                    fop.getAmount().setValue(fop.getAmount().getValue().negate());
                    currency = fop.getAmount().getCurrency();
                    if (pType != null) continue;
                    pType = fop.getType();
                }
                Product[] productArray = mcoProducts = aTicket.getRelatedProducts() != null && aTicket.getRelatedProducts().length > 0 ? aTicket.getRelatedProducts() : null;
                if (mcoProducts == null) break;
                for (Product mcoProduct : mcoProducts) {
                    if (fopRefundSum.equals(BigDecimal.ZERO) || mcoProduct.isEticket()) continue;
                    for (ProductFop prodFop : AirProductHelper.getVendorContractRelation((Product)mcoProduct).getFops()) {
                        if (prodFop == null || prodFop.getAmount() == null || prodFop.getAmount().getValue() == null) continue;
                        BigDecimal subtractor = prodFop.getAmount().getValue();
                        fopRefundSum = fopRefundSum.subtract(subtractor);
                    }
                    aTicket.getFops().clear();
                    ProductFop newFop = new ProductFop();
                    Money amount = new Money();
                    amount.setValue(fopRefundSum.negate());
                    amount.setCurrency(currency);
                    newFop.setAmount(amount);
                    newFop.setType(pType);
                    aTicket.getFops().add(newFop);
                }
                break;
            }
        }
        if (BlankCategory.PRINTED_NUMBER.equals((Object)aTicket.getBlankCategory()) && TextUtil.isSame((String)aTicket.getTicketNumber(), (String)aTicket.getScn())) {
            aTicket.setScn("");
        }
        if (ticket.getProductCategory() == null) {
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_ProductCategoryIsNotSet", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{ticket.getSystemNumber()});
            this.log.error("product category is not set for ticket " + ticket.getSystemNumber());
            return;
        }
        if (ticket.getProductCategory() == ProductCategory.MCO && ticket.getMcoCategory() == null) {
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_MCOCategoryIsNotSet", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{ticket.getSystemNumber()});
            this.log.error("mco category is not set for ticket " + ticket.getSystemNumber());
            return;
        }
        if (ticket.getProductCategory().equals((Object)ProductCategory.MCO)) {
            Money amount;
            if (ticket.getMcoCategory() == MCOCategory.PENALTY || ticket.getMcoCategory() == MCOCategory.REBOOKING || ticket.getMcoCategory() == MCOCategory.STICKER || ticket.getMcoCategory() == MCOCategory.ADDITIONAL_TARIFF || ticket.getMcoCategory() == MCOCategory.INFORMATION || ticket.getMcoCategory() == MCOCategory.DUPLICATE_TICKET) {
                for (ProductFop fop : aTicket.getFops()) {
                    if (fop == null || fop.getAmount() == null || fop.getAmount().getValue() == null) continue;
                    fop.getAmount().setValue(BigDecimal.ZERO);
                }
                if (ticket.getMcoCategory() == MCOCategory.DUPLICATE_TICKET) {
                    if (aTicket.getBaseFare() != null) {
                        aTicket.getBaseFare().setValue(BigDecimal.ZERO);
                    }
                    aTicket.setEquivalentFare(BigDecimal.ZERO);
                    aTicket.getTaxes().clear();
                }
            } else if (ticket.getMcoCategory() == MCOCategory.SEAT_RESERVATION) {
                Tax p8 = new Tax();
                amount = new Money();
                amount.setValue(aTicket.getEquivalentFare());
                amount.setCurrency(DictHelper.getCurrencyByAnyCode((String)DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB")));
                p8.setAmount(amount);
                p8.setCode("P8");
                p8.setEquivalentAmount(aTicket.getEquivalentFare());
                aTicket.getTaxes().add(p8);
                if (aTicket.getBaseFare() != null) {
                    aTicket.getBaseFare().setValue(BigDecimal.ZERO);
                }
                aTicket.setEquivalentFare(BigDecimal.ZERO);
            } else if (ticket.getMcoCategory() == MCOCategory.PAPER_SURCHARGE) {
                Tax ps = new Tax();
                amount = new Money();
                amount.setValue(aTicket.getEquivalentFare());
                amount.setCurrency(DictHelper.getCurrencyByAnyCode((String)DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB")));
                ps.setAmount(amount);
                ps.setCode("PS");
                ps.setEquivalentAmount(aTicket.getEquivalentFare());
                aTicket.getTaxes().add(ps);
                if (aTicket.getBaseFare() != null) {
                    aTicket.getBaseFare().setValue(BigDecimal.ZERO);
                }
                aTicket.setEquivalentFare(BigDecimal.ZERO);
            } else if (ticket.getMcoCategory() == MCOCategory.NOT_SOLD_SEATS) {
                Tax r1 = new Tax();
                amount = new Money();
                amount.setValue(aTicket.getPenalty());
                amount.setCurrency(DictHelper.getCurrencyByAnyCode((String)DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB")));
                r1.setAmount(amount);
                r1.setCode("R1");
                r1.setEquivalentAmount(aTicket.getPenalty());
                aTicket.getTaxes().add(r1);
                if (aTicket.getBaseFare() != null) {
                    aTicket.getBaseFare().setValue(BigDecimal.ZERO);
                }
                aTicket.setEquivalentFare(BigDecimal.ZERO);
            }
            if (ticket.getMcoCategory() == MCOCategory.SPECIAL_FOOD) {
                Tax p7 = new Tax();
                amount = new Money();
                amount.setValue(aTicket.getEquivalentFare());
                amount.setCurrency(DictHelper.getCurrencyByAnyCode((String)DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB")));
                p7.setAmount(amount);
                p7.setCode("P7");
                p7.setEquivalentAmount(aTicket.getEquivalentFare());
                aTicket.getTaxes().add(p7);
                if (aTicket.getBaseFare() != null) {
                    aTicket.getBaseFare().setValue(BigDecimal.ZERO);
                }
                aTicket.setEquivalentFare(BigDecimal.ZERO);
            }
        }
        if (ticket.getProductCategory().equals((Object)ProductCategory.MCO) && ticket.isEticket() && ticket.getPenalty() != null && !BigDecimal.ZERO.equals(ticket.getPenalty())) {
            Money fare = new Money();
            fare.setValue(ticket.getPenalty());
            fare.setCurrency(DictHelper.getCurrencyByAnyCode((String)DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB")));
            aTicket.setBaseFare(fare);
            aTicket.setEquivalentFare(ticket.getPenalty());
            aTicket.setPenalty(null);
        }
        if (MCOCategory.UNESCORTED_MINOR.equals((Object)ticket.getMcoCategory())) {
            boolean has6A = false;
            for (Tax t : ticket.getTaxes()) {
                if (!"6A".equals(t.getCode())) continue;
                has6A = true;
                break;
            }
            if (!has6A && AirProductHelper.getEquivalentFare((Product)ticket) != null) {
                Tax tax = new Tax();
                tax.setAmount(new Money());
                tax.setEquivalentAmount(ticket.getStatus() == ProductStatus.REFUND || ticket.getStatus() == ProductStatus.EXCHANGE ? MiscUtil.negate((BigDecimal)AirProductHelper.getEquivalentFare((Product)ticket)) : AirProductHelper.getEquivalentFare((Product)ticket));
                if (BigDecimal.ZERO.compareTo(tax.getEquivalentAmount()) != 0) {
                    tax.getAmount().setValue(tax.getEquivalentAmount());
                    tax.getAmount().setCurrency(DictHelper.getLocalCurrency());
                    tax.setCode("6A");
                    aTicket.getTaxes().add(tax);
                    if (aTicket.getBaseFare() != null) {
                        aTicket.getBaseFare().setValue(BigDecimal.ZERO);
                    }
                    aTicket.setEquivalentFare(BigDecimal.ZERO);
                }
            }
        }
    }

    @Override
    protected void putGlobalData(Map<String, Object> data, List<Message> messages) throws Exception {
        String contractClientIdStr;
        ReportParameters params;
        super.putGlobalData(data, messages);
        Organization vendor = (Organization)data.get("key-vendor");
        if (vendor != null) {
            Airline airline = (Airline)DictionaryCache.get().resolveReference(vendor.getAirline());
            if (airline == null) {
                SystemHelper.addMessage(messages, (String)Messages.SuSalesReportPrepareHandler_couldtDetermineBlankOwner, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{vendor.toString()});
                this.log.error("unable to resolve airline for " + vendor.toString());
                return;
            }
            for (Locale locale : airline.getTranslations().keySet()) {
                if (!locale.getLanguage().equals("ru")) continue;
                data.put("AIRLINE_NAME", airline.getTranslations().get(locale));
                break;
            }
            data.put("AIRLINE_IATA_CODE", airline.getAirlineNumber());
            data.put("AIRLINE_IATA_ALPHABETICAL_CODE", airline.getCode());
        }
        if ((params = (ReportParameters)data.get("key-report-params")) == null) {
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_Internal_error", null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            this.log.error("internal report handler error: params is empty");
            return;
        }
        EntityContainer ac = EntityStorage.get().resolve(params.getAgency());
        if (ac == null) {
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_FailedLoadingEntity", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{params.getAgency()});
            this.log.debug("Could not find entity in database");
            return;
        }
        Organization agency = (Organization)ac.getEntity();
        String contractNoStr = SystemHelper.findMetadataAsString((Collection)agency.getMetadata(), (MetadataKey)MetadataKey.KEY_BLOCK_CHARTER_CONTRACT_NO);
        if (contractNoStr == null) {
            contractNoStr = "";
        }
        if ((contractClientIdStr = SystemHelper.findMetadataAsString((Collection)agency.getMetadata(), (MetadataKey)MetadataKey.KEY_BLOCK_CHARTER_CONTRACT_CLIENT_ID)) == null) {
            contractClientIdStr = "";
        }
        data.put("KEY_BLOCK_CHARTER_CONTRACT_CLIENT_ID", contractClientIdStr);
        data.put("KEY_BLOCK_CHARTER_CONTRACT_NO", contractNoStr);
        data.put("client_list", this.getClients((Organization)data.get("key-vendor")));
        HashSet<String> agencyProfileCodes = new HashSet<String>();
        EntityStorage es = EntityStorage.get();
        List agencies = es.search(OrganizationIndex.class, new SearchQuery()).getData();
        for (OrganizationIndex index : agencies) {
            agencyProfileCodes.add(index.getCode());
        }
        data.put("AGENCY_CODES_LIST", agencyProfileCodes);
        CurrencyRate usdRate = BookingHelper.findCurrencyRate((String)"USD", (Date)params.getPeriodBegin(), (CurrencyRateType)CurrencyRateType.IATA, (TariffType)TariffType.REGULAR, null);
        if (usdRate != null) {
            data.put("IATA_USD_RATE", BigDecimal.valueOf(usdRate.getRate()));
        }
        SUBCReportPrepareHelper.putGlobalBlockCharterData(data, messages);
    }

    private void setRefundPenaltyTax(SuTicket aTicket, Product ticket, Map<String, Object> data, List<Message> messages) throws Exception {
        if (ticket == null || ticket.getStatus() != ProductStatus.REFUND || aTicket == null) {
            return;
        }
        String penaltyTaxCode = this.getPenaltyTaxCode();
        try {
            if (ticket.getPenalty() != null) {
                Tax penaltyTax = new Tax();
                penaltyTax.setEquivalentAmount(ticket.getPenalty());
                penaltyTax.setCode(penaltyTaxCode);
                aTicket.getTaxes().add(penaltyTax);
            }
            Product mcoPenalty = null;
            BigDecimal penalty = null;
            for (Product mcoProd : aTicket.getRelatedProducts()) {
                if (mcoProd.getMcoCategory() != MCOCategory.PENALTY || (penalty = AirProductHelper.getEquivalentFare((Product)mcoProd)) == null || penalty.compareTo(BigDecimal.ZERO) == 0) continue;
                mcoPenalty = mcoProd;
                break;
            }
            if (mcoPenalty != null && !mcoPenalty.isEticket() && mcoPenalty.getProductCategory() == ProductCategory.MCO && mcoPenalty.getMcoCategory() == MCOCategory.PENALTY) {
                Tax taxRu;
                String[] taxCodes = new String[]{"RU"};
                Collection taxes = AirProductTaxHelper.getTaxesByCodes((Product)mcoPenalty, (String[])taxCodes);
                Tax tax = taxRu = taxes != null && !taxes.isEmpty() ? (Tax)taxes.iterator().next() : null;
                if (taxRu != null) {
                    aTicket.getTaxes().add(taxRu);
                }
                if (penalty != null && penalty.compareTo(BigDecimal.ZERO) != 0) {
                    if (aTicket.getPenalty() == BigDecimal.ZERO) {
                        aTicket.setPenalty(aTicket.getPenalty().add(penalty));
                    }
                    Tax penaltyTax = null;
                    for (Tax tax2 : aTicket.getTaxes()) {
                        if (!tax2.getCode().equals(penaltyTaxCode)) continue;
                        penaltyTax = tax2;
                        break;
                    }
                    if (penaltyTax == null) {
                        penaltyTax = new Tax();
                        penaltyTax.setCode(penaltyTaxCode);
                        penaltyTax.setEquivalentAmount(penalty);
                        aTicket.getTaxes().add(penaltyTax);
                    } else {
                        penaltyTax.setEquivalentAmount(penaltyTax.getEquivalentAmount().add(penalty));
                    }
                }
            }
        }
        catch (Exception e) {
            SystemHelper.addMessage(messages, (String)Messages.SuSalesReportPrepareHandler_errorOccuredWhile, (String)TextUtil.getExceptionStackTrace((Throwable)e), (MessageType)MessageType.WARNING, (Object[])new Object[]{ticket});
            this.log.error(Messages.SuSalesReportPrepareHandler_errorOccuredWhile + ticket, (Throwable)e);
        }
    }

    protected Collection<Organization> getClients(Organization vendor) throws Exception {
        if (vendor == null) {
            return Collections.emptyList();
        }
        HashSet<Organization> clients = new HashSet<Organization>();
        for (String client : SystemHelper.getMetadataAsStringsCollection((Collection)vendor.getMetadata(), (MetadataKey)MetadataKey.KEY_CLIENT_PROFILE_CODE)) {
            EntityContainer corporateClient = ProfileDao.findProfileByCode((String)client, OrganizationIndex.class, (boolean)true);
            if (corporateClient == null) continue;
            clients.add((Organization)corporateClient.getEntity());
        }
        return clients;
    }

    @Override
    public String getId() {
        return "su-sales-report";
    }

    @Override
    protected void sortProducts(List<Product> products, Map<String, Object> data) {
        Collections.sort(products, new Comparator<Product>(){

            @Override
            public int compare(Product o1, Product o2) {
                Product product1 = o1;
                Product product2 = o2;
                if (o1.getProductCategory() == ProductCategory.MCO && !o1.getRelatedProducts().isEmpty() && (product1 = (Product)o1.getRelatedProducts().get(0)).getSystemNumber().equals(product2.getSystemNumber())) {
                    return 1;
                }
                if (o2.getProductCategory() == ProductCategory.MCO && !o2.getRelatedProducts().isEmpty() && (product2 = (Product)o2.getRelatedProducts().get(0)).getSystemNumber().equals(product1.getSystemNumber())) {
                    return -1;
                }
                return TextUtil.compare((String)product1.getSystemNumber(), (String)product2.getSystemNumber(), (boolean)false, (boolean)false);
            }
        });
    }

    private boolean getMultiReportMode() {
        return "YES".equalsIgnoreCase(DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.XML_REPORT_TICKET_ORDER_FOR_MULTYAGENCY_REPORT, null));
    }

    protected String getFuelTaxCode() {
        return "YQ";
    }

    protected String getSupplierTaxCode() {
        return "RU";
    }

    @Override
    protected MetadataKey getAgencyReportCode(BaseReportParameters params) {
        return MetadataKey.KEY_SU_2013_AGENCY_CODE;
    }

    protected void sortTicketsOfBatches(Map<String, Object> data, List<Message> messages) throws Exception {
        List batchDataList = (List)data.get("key-batch-data-list");
        if (batchDataList != null) {
            int batchNo = 1;
            for (SuSalesReportBatchData batchData : batchDataList) {
                batchData.sortTickets();
                batchNo = batchData.enumerateTickets(batchNo, batchData.getBatchId());
                ++batchNo;
            }
        }
    }

    @Override
    public void prepareData(Map<String, Object> data) throws Exception {
        try {
            super.prepareData(data);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("", (Throwable)e);
            throw e;
        }
        this.prepareStockData(data);
    }

    protected void prepareStockData(Map<String, Object> data) throws Exception {
        ReportParameters params = (ReportParameters)XCloneHelper.clone((XCloneable)((ReportParameters)data.get("key-report-params")), (boolean)true);
        params.getAdditionalCriterions().clear();
        List profiles = ProfileDao.getProfileReferenceByCode((String)this.getVendorCode(), OrganizationIndex.class);
        params.setBlankOwner(profiles.isEmpty() ? null : (EntityReference)profiles.get(0));
        HashMap<String, Object> stControlData = new HashMap<String, Object>();
        stControlData.put("key-report-params", params);
        stControlData.put("KEY_REPORT_FILENAME", data.get("KEY_REPORT_FILENAME"));
        stControlData.put("AIRLINE_IATA_CODE", data.get("AIRLINE_IATA_CODE"));
        stControlData.put("AIRLINE_IATA_ALPHABETICAL_CODE", data.get("AIRLINE_IATA_ALPHABETICAL_CODE"));
        stControlData.put("AGENCY_IATA_CODE", data.get("AGENCY_IATA_CODE"));
        String stockControlReportUid = this.getStockControlReportUid();
        this.log.debug("prepareData() BEGIN handler=" + stockControlReportUid);
        ((PrepareHandlersRegistry)Environment.getPublished(PrepareHandlersRegistry.class)).get(stockControlReportUid).prepareData(stControlData);
        this.log.debug("prepareData() END handler=" + stockControlReportUid);
        List messages = (List)data.get("key-messages");
        List stControlMessages = (List)stControlData.get("key-messages");
        if (messages != null) {
            for (Message message : stControlMessages) {
                if (messages.contains(message)) continue;
                messages.add(message);
            }
        }
        data.put("key-stock-control-data", stControlData);
    }

    protected String getStockControlReportUid() {
        return "su-stock-control-report";
    }

    protected List<ProductIndex> selectProducts(Map<String, Object> data) throws Exception {
        return SalesReportPrepareHelper.selectProducts(data);
    }

    @Override
    protected Set<Product> getData(Map<String, Object> data, List<Message> messages) throws Exception {
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        EntityStorage es = EntityStorage.get();
        EntityReference salesPointReference = params.getSalesPoint();
        EntityReference agencyReference = params.getAgency();
        EntityReference subagencyReference = params.getSubagency();
        List<ProductIndex> allData = this.selectProducts(data);
        HashSet<String> productIndexList = new HashSet<String>();
        HashSet<EntityReference> bfRefs = new HashSet<EntityReference>();
        for (ProductIndex index : allData) {
            if (params.getBlankOwner() == null || !params.getBlankOwner().equals((Object)index.getBlankOwner()) || !SalesReportPrepareHelper.isHasAppropriateReportAgency(index, (EntityReference<Organization>)agencyReference, data, messages) || !this.isHasAppropriateSalesPoint(index, (EntityReference<SalesPoint>)salesPointReference, data, messages) || !this.isHasAppropriateSubagency(index, (EntityReference<Organization>)subagencyReference, data, messages) || params.getSupplier() != null && !params.getSupplier().equals((Object)index.getSupplier())) continue;
            productIndexList.add(index.getNavigationKey());
            bfRefs.add(index.getSource());
        }
        HashSet<Product> result = new HashSet<Product>();
        for (EntityReference bfRef : bfRefs) {
            EntityContainer container = es.resolve(bfRef);
            if (container == null) {
                SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_FailedLoadingEntity", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{bfRef});
                this.log.debug("Unable to load booking file container " + bfRef.getUid() + ". All products of the booking will be excluded from report.");
                return Collections.emptySet();
            }
            BookingFile bookingFile = (BookingFile)container.getEntity();
            for (Reservation res : bookingFile.getReservations()) {
                block3: for (BaseProduct prod : res.getProducts()) {
                    String uid = prod.getUid();
                    for (String productUid : productIndexList) {
                        if (!productUid.equals(uid) || !(prod instanceof Product)) continue;
                        result.add((Product)prod);
                        continue block3;
                    }
                }
            }
        }
        if (result.isEmpty()) {
            SystemHelper.addMessage(messages, (String)Messages.reportNoTicket, null, (MessageType)MessageType.WARNING, (Object[])new Object[0]);
            this.log.warn("There are no tickets in the report");
        }
        return result;
    }

    private double updateDuplicateByRuTax(double value, Product firstProduct) {
        Collection taxes = AirProductTaxHelper.getTaxesByCodes((Product)firstProduct, (String[])new String[]{this.getSupplierTaxCode()});
        for (Tax tax : taxes) {
            if (tax.getEquivalentAmount() == null) continue;
            value -= tax.getEquivalentAmount().doubleValue();
        }
        return value;
    }

    private String getBlockCharterContractNo(Product ticket) throws Exception {
        String result = null;
        if (ticket == null) {
            return null;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractIndex.Property.contractType.name(), (Object)ContractType.VENDOR), SearchCriterion.eq((String)ContractIndex.Property.vendor.name(), (Object)ticket.getBlankOwnerRef()), SearchCriterion.eq((String)ContractIndex.Property.supplier.name(), (Object)AirProductHelper.getSupplier((Product)ticket))}));
        EntityStorage es = EntityStorage.get();
        EntityContainer contract = null;
        SUBlockCharterAppendix suBlockCharterAppendix = null;
        String fareBasis = null;
        Date flightDate = null;
        block0: for (ContractIndex contractIndex : es.search(ContractIndex.class, query).getData()) {
            contract = es.resolve(contractIndex.getSource());
            for (ContractCustomerInfo contractCustomerInfo : ((Contract)contract.getEntity()).getCustomers()) {
                if (!contractCustomerInfo.getCustomer().equals((Object)AirProductHelper.getAgency((Product)ticket)) || contractCustomerInfo.getStartDate() != null && contractCustomerInfo.getStartDate().compareTo(ticket.getIssueDate()) > 0 || contractCustomerInfo.getEndDate() != null && contractCustomerInfo.getEndDate().compareTo(ticket.getIssueDate()) < 0) continue;
                for (BaseContractAppendix baseContractAppendix : contractCustomerInfo.getAppendices()) {
                    if (!(baseContractAppendix instanceof SUBlockCharterAppendix)) continue;
                    suBlockCharterAppendix = (SUBlockCharterAppendix)baseContractAppendix;
                    if (ticket.getSegmentTariffs() != null && ticket.getSegmentTariffs().size() > 0 && ((SegmentTariff)ticket.getSegmentTariffs().get(0)).getSegments() != null && ((SegmentTariff)ticket.getSegmentTariffs().get(0)).getSegments().size() > 0 && ((Segment)((SegmentTariff)ticket.getSegmentTariffs().get(0)).getSegments().get(0)).getFareBasis() != null && ((Segment)((SegmentTariff)ticket.getSegmentTariffs().get(0)).getSegments().get(0)).getStartDate() != null) {
                        fareBasis = ((Segment)((SegmentTariff)ticket.getSegmentTariffs().get(0)).getSegments().get(0)).getFareBasis();
                        flightDate = ((Segment)((SegmentTariff)ticket.getSegmentTariffs().get(0)).getSegments().get(0)).getStartDate();
                    }
                    if (suBlockCharterAppendix.getFareBasis() == null || fareBasis == null || !suBlockCharterAppendix.getFareBasis().contains(fareBasis) || suBlockCharterAppendix.getStartDate() != null && suBlockCharterAppendix.getStartDate().compareTo(flightDate) > 0 || suBlockCharterAppendix.getEndDate() != null && suBlockCharterAppendix.getEndDate().compareTo(flightDate) < 0) continue;
                    result = contractCustomerInfo.getNumber();
                    break block0;
                }
            }
        }
        return result;
    }

    private String getBlockCharterContractNo2(Product ticket) throws Exception {
        String result = null;
        if (ticket == null) {
            return null;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractIndex.Property.contractType.name(), (Object)ContractType.VENDOR), SearchCriterion.eq((String)ContractIndex.Property.vendor.name(), (Object)ticket.getBlankOwnerRef()), SearchCriterion.eq((String)ContractIndex.Property.supplier.name(), (Object)AirProductHelper.getSupplier((Product)ticket))}));
        EntityStorage es = EntityStorage.get();
        EntityContainer contract = null;
        block0: for (ContractIndex contractIndex : es.search(ContractIndex.class, query).getData()) {
            contract = es.resolve(contractIndex.getSource());
            for (ContractCustomerInfo contractCustomerInfo : ((Contract)contract.getEntity()).getCustomers()) {
                if (!contractCustomerInfo.getCustomer().equals((Object)AirProductHelper.getAgency((Product)ticket)) || contractCustomerInfo.getStartDate() != null && contractCustomerInfo.getStartDate().compareTo(ticket.getIssueDate()) > 0 || contractCustomerInfo.getEndDate() != null && contractCustomerInfo.getEndDate().compareTo(ticket.getIssueDate()) < 0) continue;
                result = contractCustomerInfo.getNumber();
                break block0;
            }
        }
        return result;
    }

    protected SuTicket createReturnFareDifferenceAsRefund(Product mco, List<Message> messages) throws Exception {
        if (mco.getProductCategory() != ProductCategory.MCO && mco.getMcoCategory() != MCOCategory.RETURN_FARE_DIFFERENCE) {
            return null;
        }
        if (mco.getRelatedProducts().isEmpty()) {
            SystemHelper.addMessage(messages, (String)Messages.SuSalesReportPrepareHandler_unableFindRelatedTicket, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{mco.getSystemNumber()});
            return null;
        }
        Product refundMco = (Product)XCloneHelper.clone((XCloneable)mco);
        refundMco.setStatus(ProductStatus.REFUND);
        SuTicket result = new SuTicket(refundMco, messages);
        result.setScn(null);
        if (result.getEquivalentFare() != null) {
            result.setEquivalentFare(result.getEquivalentFare().negate());
        }
        if (result.getVendorEquivalentCommission() != null) {
            result.setVendorEquivalentCommission(result.getVendorEquivalentCommission().negate());
        }
        for (ProductFop productFop : result.getFops()) {
            if (productFop.getAmount() == null || productFop.getAmount().getValue() == null) continue;
            productFop.getAmount().setValue(productFop.getAmount().getValue().negate());
        }
        if (result.getBaseFare() != null && result.getBaseFare().getValue() != null) {
            result.getBaseFare().setValue(result.getBaseFare().getValue().negate());
        }
        return result;
    }

    protected SuTicket createResidalValueMCO(Product mco, List<Message> messages) throws Exception {
        if (mco.getProductCategory() != ProductCategory.MCO || mco.getMcoCategory() != MCOCategory.RESIDUAL_VALUE_FOR_REFUND) {
            return null;
        }
        SuTicket result = new SuTicket(mco, messages);
        return result;
    }

    @Override
    protected Collection<? extends AgencyMemoProduct> getAgencyMemoProductData(Map<String, Object> data, List<Message> messages) throws Exception {
        ReportParameters parameters = (ReportParameters)data.get("key-report-params");
        EntityStorage entityStorage = EntityStorage.get();
        Date periodBegin = parameters.getPeriodBegin();
        Date periodEnd = parameters.getPeriodEnd();
        EntityReference blankOwnerReference = parameters.getBlankOwner();
        EntityReference supplierReference = parameters.getSupplier();
        EntityReference agencyReference = parameters.getAgency();
        SearchQuery query = new SearchQuery();
        if (periodBegin != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.ge((String)AgencyMemoProductIndex.Property.targetReportDate.name(), (Object)MiscUtil.clearTime((Date)periodBegin)));
        }
        if (periodEnd != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.le((String)AgencyMemoProductIndex.Property.targetReportDate.name(), (Object)MiscUtil.setDayEndTime((Date)periodEnd)));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)AgencyMemoProductIndex.Property.blankOwner.name(), (Object)blankOwnerReference));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)AgencyMemoProductIndex.Property.supplier.name(), (Object)supplierReference));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)AgencyMemoProductIndex.Property.agency.name(), (Object)agencyReference));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)AgencyMemoProductIndex.Property.includeToReport.name(), (Object)Boolean.TRUE));
        List agencyMemoProductIndexes = entityStorage.search(AgencyMemoProductIndex.class, query).getData();
        HashMap<EntityReference, ArrayList<String>> agencyMemoProductUids = new HashMap<EntityReference, ArrayList<String>>();
        for (AgencyMemoProductIndex agencyMemoProductIndex : agencyMemoProductIndexes) {
            EntityReference bookingFileReference = agencyMemoProductIndex.getSource();
            ArrayList<String> uids = (ArrayList<String>)agencyMemoProductUids.get(bookingFileReference);
            if (uids == null) {
                uids = new ArrayList<String>();
                agencyMemoProductUids.put(bookingFileReference, uids);
            }
            uids.add(agencyMemoProductIndex.getNavigationKey());
        }
        HashSet<AgencyMemoProduct> agencyMemoProducts = new HashSet<AgencyMemoProduct>();
        for (Map.Entry entry : agencyMemoProductUids.entrySet()) {
            EntityReference bookingFileReference = (EntityReference)entry.getKey();
            List uids = (List)entry.getValue();
            EntityContainer bookingFileContainer = entityStorage.resolve(bookingFileReference);
            if (bookingFileContainer == null) {
                SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_FailedLoadingEntity", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{"null"});
                this.log.debug("Unable to load booking file container " + bookingFileReference.getUid() + ". All agency memo products will be excluded from report.");
                continue;
            }
            for (String uid : uids) {
                AgencyMemoProduct agencyMemoProduct = (AgencyMemoProduct)BookingHelper.findProductByUid((String)uid, (BookingFile)((BookingFile)bookingFileContainer.getEntity()), AgencyMemoProduct.class);
                if (agencyMemoProduct == null) continue;
                agencyMemoProducts.add(agencyMemoProduct);
            }
        }
        return agencyMemoProducts;
    }

    @Override
    protected void addAgencyMemoProductProxyTicket(AgencyMemoProduct agencyMemoProduct, Map<String, Object> data, List<Message> messages) throws Exception {
        SuTicket ticket = null;
        try {
            ticket = this.getTicketInstance(agencyMemoProduct, messages);
        }
        catch (Exception e) {
            this.log.error("Can't create SuTicket for agency memo product \"" + agencyMemoProduct.getSystemNumber() + "\"", (Throwable)e);
            return;
        }
        this.setSpecificAgencyMemoProductTicketData(ticket, agencyMemoProduct, data, messages);
        ReportParameters parameters = (ReportParameters)data.get("key-report-params");
        EntityReference agencyReference = parameters.getAgency();
        ArrayList<SuSalesReportBatchData<SuTicket>> batchDataList = (ArrayList<SuSalesReportBatchData<SuTicket>>)data.get("key-batch-data-list");
        if (batchDataList == null) {
            batchDataList = new ArrayList<SuSalesReportBatchData<SuTicket>>();
            data.put("key-batch-data-list", batchDataList);
        }
        SuSalesReportBatchData<SuTicket> batch = this.selectBatch(ticket.getBatchId(), ticket.getAgencyCode(), batchDataList, agencyReference.getCaption());
        batch.getTickets().add(ticket);
        this.updateAgencyMemoProductLetterData(ticket, batch.getBatchId(), data);
    }

    protected void setSpecificAgencyMemoProductTicketData(SuTicket ticket, AgencyMemoProduct agencyMemoProduct, Map<String, Object> data, List<Message> messages) throws Exception {
        block10: {
            EntityStorage entityStorage;
            block9: {
                entityStorage = EntityStorage.get();
                boolean reportAssociatedAgencyMemo = AgencyMemoProductHelper.isReportAssociated((Collection)agencyMemoProduct.getEntries());
                if (!reportAssociatedAgencyMemo) break block9;
                ticket.setTariffType(TariffType.REGULAR);
                ticket.setTransportationType(TransportationType.NONE);
                Validator validator = null;
                SearchQuery query = new SearchQuery();
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)SalesPointIndex.Property.agency.name(), (Object)agencyMemoProduct.getAgency()));
                List salesPointIndexes = entityStorage.search(SalesPointIndex.class, query).getData();
                for (SalesPointIndex salesPointIndex : salesPointIndexes) {
                    EntityReference salesPointReference = salesPointIndex.getSource();
                    EntityContainer salesPointContainer = EntityStorage.get().resolve(salesPointReference);
                    if (salesPointContainer == null) continue;
                    SalesPoint salesPoint = (SalesPoint)salesPointContainer.getEntity();
                    Validator salesPointValidator = ValidatorHelper.findValidator((EntityReference)salesPointReference, (EntityReference)agencyMemoProduct.getBlankOwner(), (EntityReference)agencyMemoProduct.getSupplier(), (EntityReference)agencyMemoProduct.getAgency(), (Date)new Date());
                    if (salesPointValidator == null || TextUtil.isBlank((String)salesPointValidator.getNumber())) continue;
                    if (validator == null) {
                        validator = salesPointValidator;
                    }
                    if (!ProfileHelper.isMainSalesPoint((SalesPoint)salesPoint)) continue;
                    validator = salesPointValidator;
                    break;
                }
                if (validator == null) break block10;
                ticket.setValidatorCode(validator.getNumber());
                break block10;
            }
            Collection vendorRelatedProductEntries = AgencyMemoProductHelper.filterEntries((Collection)agencyMemoProduct.getEntries(), null, null, Collections.singleton(AgencyMemoProductEntryAssociationType.PRODUCT));
            for (AgencyMemoProductEntry vendorRelatedProductEntry : vendorRelatedProductEntries) {
                if (TextUtil.isBlank((String)vendorRelatedProductEntry.getRelatedProductNumber())) continue;
                SearchQuery query = new SearchQuery();
                query.getCriteria().getCriterions().add(SearchCriterion.contains((String)ProductIndex.Property.ticketNumbers.name(), (Object)vendorRelatedProductEntry.getRelatedProductNumber()));
                List productIndexes = entityStorage.search(ProductIndex.class, query).getData();
                if (productIndexes.isEmpty()) {
                    SystemHelper.addMessage(messages, (String)Messages.S7SalesReportPrepareHandler_cantFindProduct, null, (MessageType)MessageType.WARNING, (Object[])new Object[]{agencyMemoProduct.getSystemNumber(), vendorRelatedProductEntry.getRelatedProductNumber()});
                }
                for (ProductIndex productIndex : productIndexes) {
                    EntityReference bookingFileReference = productIndex.getSource();
                    EntityContainer bookingFileContainer = entityStorage.resolve(bookingFileReference);
                    if (bookingFileContainer == null) continue;
                    BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
                    Product product = (Product)BookingHelper.findProductByUid((String)productIndex.getNavigationKey(), (BookingFile)bookingFile, Product.class);
                    if (product == null) continue;
                    if (ticket.getTariffType() == null) {
                        ticket.setTariffType(product.getTariffType());
                    }
                    if (ticket.getTransportationType() == null) {
                        ticket.setTransportationType(AirProductHelper.getTransportationType((Product)product));
                    }
                    if (!TextUtil.isBlank((String)ticket.getValidatorCode())) continue;
                    ticket.setValidatorCode(product.getValidatorCode());
                }
                if (ticket.getTransportationType() == null || TextUtil.isBlank((String)ticket.getValidatorCode())) continue;
                break;
            }
        }
        if (ticket.getTariffType() == null) {
            SystemHelper.addMessage(messages, (String)Messages.SUSalesReportPrepareHandler_cantSpotTariffType, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{agencyMemoProduct.getSystemNumber()});
        }
        if (TextUtil.isBlank((String)ticket.getValidatorCode())) {
            SystemHelper.addMessage(messages, (String)Messages.S7SalesReportPrepareHandler_cantSpotValidator, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{agencyMemoProduct.getSystemNumber()});
        }
    }

    protected void updateAgencyMemoProductLetterData(SuTicket ticket, String batchId, Map<String, Object> data) {
        if (ticket.getReportTicketType() != BaseSalesReportTicket.ReportTicketType.MEMO) {
            return;
        }
        BigDecimal bonus = (BigDecimal)ticket.getAgencyMemoProductEquivalentAmounts().get(AgencyMemoProductEntryType.BONUS);
        if (bonus != null) {
            Map<String, SuRegistryLetterItem> items = this.getRegistryLettersItems(data);
            String statusForBonus = ProductStatus.SELL.name();
            TransportationType tranTypeForBonus = TransportationType.DOMESTIC;
            SuRegistryLetterItem bonusItem = items.get(tranTypeForBonus.name() + statusForBonus + SuRegistryLetterItem.TableDefinition.Bonus.name());
            if (bonusItem == null) {
                bonusItem = new SuRegistryLetterItem();
                items.put(tranTypeForBonus.name() + statusForBonus + SuRegistryLetterItem.TableDefinition.Bonus.name(), bonusItem);
            }
            if (ticket.getAgencyMemoProductType() == AgencyMemoProductType.ADM) {
                bonusItem.credit -= bonus.doubleValue();
            } else if (ticket.getAgencyMemoProductType() == AgencyMemoProductType.ACM) {
                bonusItem.credit += bonus.doubleValue();
            }
            ++bonusItem.docCount;
        }
        for (Map.Entry entry : ticket.getAgencyMemoProductEquivalentAmounts().entrySet()) {
            AgencyMemoProductEntryType type = (AgencyMemoProductEntryType)entry.getKey();
            BigDecimal value = (BigDecimal)entry.getValue();
            if (type == null || value == null) continue;
            SuRegistryLetterItem.TableDefinition tableDefinition = null;
            if (type == AgencyMemoProductEntryType.TARIFF) {
                tableDefinition = SuRegistryLetterItem.TableDefinition.AgencyMemoTariff;
            } else if (type == AgencyMemoProductEntryType.TAX_CARRIER) {
                tableDefinition = SuRegistryLetterItem.TableDefinition.AgencyMemoTaxCarrier;
            } else if (type == AgencyMemoProductEntryType.TAX_FUEL) {
                tableDefinition = SuRegistryLetterItem.TableDefinition.AgencyMemoTaxFuel;
            } else if (type == AgencyMemoProductEntryType.TAX_STATE) {
                tableDefinition = SuRegistryLetterItem.TableDefinition.AgencyMemoTaxState;
            } else if (type == AgencyMemoProductEntryType.TAX_OTHERS) {
                tableDefinition = SuRegistryLetterItem.TableDefinition.AgencyMemoTaxOthers;
            } else if (type == AgencyMemoProductEntryType.PENALTY) {
                tableDefinition = SuRegistryLetterItem.TableDefinition.AgencyMemoPenalty;
            } else if (type == AgencyMemoProductEntryType.CONTRACT_PENALTY) {
                tableDefinition = SuRegistryLetterItem.TableDefinition.AgencyMemoContractPenalty;
            } else if (type == AgencyMemoProductEntryType.COMMISSION) {
                tableDefinition = SuRegistryLetterItem.TableDefinition.AgencyMemoCommission;
            } else if (type == AgencyMemoProductEntryType.BONUS) {
                tableDefinition = SuRegistryLetterItem.TableDefinition.AgencyMemoBonus;
            } else if (type == AgencyMemoProductEntryType.FEE) {
                tableDefinition = SuRegistryLetterItem.TableDefinition.AgencyMemoFee;
            }
            if (tableDefinition == null) continue;
            Map<String, SuRegistryLetterItem> items = this.getRegistryLettersItems(data);
            SuRegistryLetterItem item = items.get("AGENCY_MEMO" + tableDefinition.name());
            if (item == null) {
                item = new SuRegistryLetterItem();
                items.put("AGENCY_MEMO" + tableDefinition.name(), item);
            }
            if (ticket.getAgencyMemoProductType() == AgencyMemoProductType.ADM) {
                if (tableDefinition != SuRegistryLetterItem.TableDefinition.AgencyMemoCommission && tableDefinition != SuRegistryLetterItem.TableDefinition.AgencyMemoBonus) {
                    item.debit += value.doubleValue();
                } else {
                    item.credit += value.doubleValue();
                }
            } else if (ticket.getAgencyMemoProductType() == AgencyMemoProductType.ACM) {
                if (tableDefinition != SuRegistryLetterItem.TableDefinition.AgencyMemoCommission && tableDefinition != SuRegistryLetterItem.TableDefinition.AgencyMemoBonus) {
                    item.credit += value.doubleValue();
                } else {
                    item.debit += value.doubleValue();
                }
            }
            ++item.docCount;
        }
    }
}

