/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.salesreports.su;

import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.booking.CurrencyRateType;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.PassengerTypeValue;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.cache.entity.advanced.AECManager;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictPredifinedValueProvider;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ManagerType;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.cache.EntityCacheManager;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileDao;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.BaseContractAppendix;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerIndex;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SUBlockCharterAppendix;
import com.gridnine.xtrip.common.model.profile.SUBlockCharterAppendixType;
import com.gridnine.xtrip.common.model.profile.SUBlockCharterQuota;
import com.gridnine.xtrip.common.model.profile.SUBlockCharterTariffInfo;
import com.gridnine.xtrip.common.model.profile.VendorContractType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.ReportHelper;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCAppendixData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCDateData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCFlightData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCQuotaData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.su.bc.SUBCTicketsData;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.reports.prepare.salesreports.SalesReportPrepareHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SUBCReportPrepareHelper {
    private static final Logger log = LoggerFactory.getLogger(SUBCReportPrepareHelper.class);
    private static String QUOTA_BINDING_KEY = "key_quota_binding";
    private static String CONTRACT_TO_APPENDIXES_LIST_KEY = "key_contract_to_appendixes";

    static void putGlobalBlockCharterData(Map<String, Object> data, List<Message> messages) throws Exception {
        String agentCodeSU2013;
        HashMap contract2AppsMap = new HashMap();
        data.put(CONTRACT_TO_APPENDIXES_LIST_KEY, contract2AppsMap);
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        EntityStorage es = EntityStorage.get();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.contractType.name(), (Object)ContractType.VENDOR));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.vendor.name(), (Object)params.getBlankOwner()));
        if (params.getSupplier() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.supplier.name(), (Object)params.getSupplier()));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.customer.name(), (Object)params.getAgency()));
        Date startDate = params.getPeriodBegin();
        Date endDate = params.getPeriodEnd();
        if (startDate == null) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.U6SalesReportPrepareHandler_noDatePeriodEnd, (Object[])new Object[0]));
            return;
        }
        if (endDate == null) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.SUBCReportPrepareHelper_noDataFinishReport, (Object[])new Object[0]));
            return;
        }
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.endDate.name(), null), SearchCriterion.ge((String)ContractCustomerIndex.Property.endDate.name(), (Object)startDate)}));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.startDate.name(), null), SearchCriterion.le((String)ContractCustomerIndex.Property.startDate.name(), (Object)endDate)}));
        List indexes = es.search(ContractCustomerIndex.class, query).getData();
        if (indexes.isEmpty()) {
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_NoContracts", null, (MessageType)MessageType.WARNING, (Object[])new Object[0]);
            log.debug("No block-charter contracts found for the report parameters");
            return;
        }
        HashMap<String, SUBCData> bcDataMap = new HashMap<String, SUBCData>();
        HashMap<String, SUBCData> chartDataMap = new HashMap<String, SUBCData>();
        HashMap<SUBCQuotaData, String> quotaBinding = new HashMap<SUBCQuotaData, String>();
        boolean appendicesExist = false;
        HashSet<EntityReference> contracts = new HashSet<EntityReference>();
        for (ContractCustomerIndex index : indexes) {
            contracts.add(index.getSource());
        }
        for (EntityReference ref : contracts) {
            for (ContractCustomerInfo info : ((Contract)es.resolve(ref).getEntity()).getCustomers()) {
                for (BaseContractAppendix app : info.getAppendices()) {
                    SUBCData bcData;
                    if (app.getStartDate() != null && endDate.before(app.getStartDate()) || app.getEndDate() != null && startDate.after(app.getEndDate()) || !(app instanceof SUBlockCharterAppendix)) continue;
                    appendicesExist = true;
                    SUBlockCharterAppendix subc = (SUBlockCharterAppendix)app;
                    if (info.getVendorContractType() == VendorContractType.CHARTER) {
                        bcData = (SUBCData)chartDataMap.get(info.getNumber());
                        if (bcData == null) {
                            bcData = new SUBCData();
                            contract2AppsMap.put(bcData, new ArrayList());
                            chartDataMap.put(info.getNumber(), bcData);
                        }
                        ((List)contract2AppsMap.get(bcData)).add(subc);
                        SUBCReportPrepareHelper.updateBCData(params, bcData, subc, info, (EntityReference<Contract>)ref, quotaBinding, messages);
                        continue;
                    }
                    bcData = (SUBCData)bcDataMap.get(info.getNumber());
                    if (bcData == null) {
                        bcData = new SUBCData();
                        contract2AppsMap.put(bcData, new ArrayList());
                        bcDataMap.put(info.getNumber(), bcData);
                    }
                    ((List)contract2AppsMap.get(bcData)).add(subc);
                    SUBCReportPrepareHelper.updateBCData(params, bcData, subc, info, (EntityReference<Contract>)ref, quotaBinding, messages);
                }
            }
        }
        if (!appendicesExist) {
            return;
        }
        HashSet<String> locationCodes = new HashSet<String>();
        ArrayList appendices = new ArrayList();
        appendices.addAll(bcDataMap.values());
        appendices.addAll(chartDataMap.values());
        for (SUBCData item : appendices) {
            for (BaseContractAppendix app : item.getAppendices()) {
                locationCodes.addAll(SUBCReportPrepareHelper.getItems(app.getRoute()));
            }
        }
        data.put("KEY_BLOCK_CHARTER_CONTRACT_LOCATION_CODES", locationCodes);
        data.put("KEY_BLOCK_CHARTER_DATA", bcDataMap);
        data.put("KEY_CHARTER_DATA", chartDataMap);
        EntityContainer agencyCtr = EntityStorage.get().resolve(params.getAgency());
        EntityReference agencyReference = agencyCtr.toReference();
        Organization agency = (Organization)agencyCtr.getEntity();
        String agentCode = SystemHelper.findMetadataAsString((Collection)agency.getMetadata(), (MetadataKey)MetadataKey.KEY_SU_AGENCY_CODE);
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1, 2012);
        cal.set(2, 11);
        cal.set(5, 20);
        if (startDate.after(cal.getTime()) && !TextUtil.isBlank((String)(agentCodeSU2013 = SystemHelper.findMetadataAsString((Collection)agency.getMetadata(), (MetadataKey)MetadataKey.KEY_SU_2013_AGENCY_CODE)))) {
            agentCode = agentCode + "/" + agentCodeSU2013;
        }
        ArrayList values = new ArrayList(bcDataMap.values());
        values.addAll(chartDataMap.values());
        for (SUBCData bcData : values) {
            bcData.setAgentCode(agentCode);
            bcData.setAgentINN(agency.getRegistrationId());
            bcData.setAgentName(ProfileHelper.getFullName((Organization)agency, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
            List employees = ProfileDao.getEmployees((EntityReference)agencyReference, (ManagerType[])new ManagerType[0], (Date)new Date());
            for (Person employee : employees) {
                String fullName = ProfileHelper.getFullName((Person)employee, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false);
                Set standardPositions = ProfileHelper.getStandardPositions((List)employee.getEmployments(), (EntityReference)agencyReference);
                for (ManagerType standardPosition : standardPositions) {
                    if (standardPosition == ManagerType.DIRECTOR) {
                        bcData.setDirector(fullName);
                        continue;
                    }
                    if (standardPosition != ManagerType.CHIEF_ACCOUNTANT) continue;
                    bcData.setAccountant(fullName);
                }
            }
            for (Communication man : agency.getCommunications()) {
                if (man.getType() == CommunicationType.WORK_PHONE || man.getType() == CommunicationType.MOBILE) {
                    bcData.setPhone(man.getSense());
                }
                if (man.getType() != CommunicationType.EMAIL) continue;
                bcData.setEmail(man.getSense());
            }
        }
        SUBCReportPrepareHelper.fillAppendices(params, data, quotaBinding, messages);
        data.put(QUOTA_BINDING_KEY, quotaBinding);
    }

    private static void fillAppendices(ReportParameters params, Map<String, Object> data, HashMap<SUBCQuotaData, String> quotaBinding, List<Message> messages) throws Exception {
        Collection<Product> products = SUBCReportPrepareHelper.selectAppropriateProducts(params, data, messages);
        if (ReportHelper.isHasErrors(messages)) {
            return;
        }
        block0: for (Product prod : products) {
            boolean manuallyBinded = SUBCReportPrepareHelper.isManuallyBinded(prod);
            ArrayList<Message> msgs2 = new ArrayList<Message>();
            SUBCTicket ticket = new SUBCTicket(prod, msgs2, data);
            messages.addAll(msgs2);
            if (ReportHelper.isHasErrors(msgs2)) continue;
            msgs2 = new ArrayList();
            boolean added = false;
            boolean hasAppropriateRoute = false;
            ArrayList values = new ArrayList(((Map)data.get("KEY_BLOCK_CHARTER_DATA")).values());
            values.addAll(((Map)data.get("KEY_CHARTER_DATA")).values());
            for (SUBCData bcData : values) {
                for (SUBCAppendixData app : bcData.getAppendices()) {
                    SUBCFlightData backwardFlight;
                    SUBCFlightData forwardFlight;
                    block19: {
                        if ((!manuallyBinded || !SUBCReportPrepareHelper.isAppropriateForAppendix(prod, app, quotaBinding)) && !SUBCReportPrepareHelper.isAppropriateForAppendix(ticket.getDirection(), ticket.getFareBasis(), app)) continue;
                        hasAppropriateRoute = true;
                        ((AECManager)EntityCacheManager.get()).isCached(BookingFile.class);
                        if (app.getType() == SUBlockCharterAppendixType.ROUND_TRIP && ticket.getFirstFlightDate() != null && ticket.getFirstFlightDate().before(params.getPeriodBegin())) {
                            log.debug(String.format("ticket %s is excluded because its first flight date is out of report period", ticket.getTicketNumber()));
                            continue block0;
                        }
                        forwardFlight = null;
                        backwardFlight = null;
                        if (manuallyBinded) {
                            for (SUBCDateData date : app.getDates()) {
                                for (SUBCFlightData flight : date.getFlights()) {
                                    if (forwardFlight == null && SUBCReportPrepareHelper.isAppropriateForForwardFlight(prod, flight, quotaBinding)) {
                                        forwardFlight = flight;
                                    }
                                    if (backwardFlight != null || !SUBCReportPrepareHelper.isAppropriateForBackwardFlight(prod, flight, quotaBinding)) continue;
                                    backwardFlight = flight;
                                }
                            }
                        } else {
                            for (SUBCDateData date : app.getDates()) {
                                for (SUBCFlightData flight : date.getFlights()) {
                                    if (app.getType() == SUBlockCharterAppendixType.ROUND_TRIP && ticket.getFlightNumbers().contains(flight.getFlightNumber()) && SUBCReportPrepareHelper.equals(date.getDate(), ticket.getFirstFlightDate())) {
                                        forwardFlight = flight;
                                        break block19;
                                    }
                                    if (app.getType() == SUBlockCharterAppendixType.ONE_WAY && ticket.getFlightNumbers().contains(flight.getFlightNumber()) && SUBCReportPrepareHelper.equals(date.getDate(), ticket.getFirstFlightDate()) && !flight.isBackwardDirection()) {
                                        forwardFlight = flight;
                                        continue;
                                    }
                                    if (app.getType() != SUBlockCharterAppendixType.ONE_WAY || !SUBCReportPrepareHelper.equals(date.getDate(), ticket.getLastFlightDate()) || !ticket.getFlightNumbers().contains(flight.getFlightNumber()) || !flight.isBackwardDirection()) continue;
                                    backwardFlight = flight;
                                }
                            }
                        }
                    }
                    if (forwardFlight == null && backwardFlight == null) {
                        msgs2.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.SUBCReportPrepareHelper_ticketNoSuitableFlight, (Object[])new Object[]{ticket.getTicketNumber(), app.getAppendixNumber(), ticket.getFlightNumbers(), ticket.getFirstFlightDate(), ticket.getLastFlightDate()}));
                        continue;
                    }
                    if (forwardFlight != null && SUBCReportPrepareHelper.addToFlight(forwardFlight, new SUBCTicket(prod, msgs2, data), false, quotaBinding, prod, msgs2)) {
                        added = true;
                    }
                    if (backwardFlight == null) continue;
                    SUBCTicket tkt = new SUBCTicket(prod, msgs2, data);
                    if (tkt.isRoundTrip()) {
                        boolean ignoreFinanceFields = true;
                        if ((prod.getStatus() == ProductStatus.REFUND || prod.getStatus() == ProductStatus.EXCHANGE) && ticket.getFirstFlightDate() != null && ticket.getFirstFlightDate().before(params.getPeriodBegin()) && ticket.getLastFlightDate() != null && ticket.getLastFlightDate().after(params.getPeriodBegin())) {
                            ignoreFinanceFields = false;
                        }
                        tkt.setIgnoreFinanceFields(ignoreFinanceFields);
                    }
                    if (!SUBCReportPrepareHelper.addToFlight(backwardFlight, tkt, true, quotaBinding, prod, msgs2)) continue;
                    added = true;
                }
            }
            if (!hasAppropriateRoute) {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.SUBCReportPrepareHelper_ticketCantDetermineApplication, (Object[])new Object[]{ticket.getTicketNumber(), ticket.getRoute(), ticket.getFareBasis()}));
                continue;
            }
            if (added) continue;
            messages.addAll(msgs2);
        }
    }

    private static boolean isAppropriateForBackwardFlight(Product prod, SUBCFlightData flight, Map<SUBCQuotaData, String> quotaBinding) {
        for (SUBCQuotaData quota : flight.getQuotas()) {
            if (!quotaBinding.get(quota).equals(prod.getCharterQuotaBinding().getBackwardQuota().getQuotaUid())) continue;
            return true;
        }
        return false;
    }

    private static boolean isAppropriateForForwardFlight(Product prod, SUBCFlightData flight, HashMap<SUBCQuotaData, String> quotaBinding) {
        for (SUBCQuotaData quota : flight.getQuotas()) {
            if (!quotaBinding.get(quota).equals(prod.getCharterQuotaBinding().getForwardQuota().getQuotaUid())) continue;
            return true;
        }
        return false;
    }

    private static boolean isAppropriateForAppendix(Product prod, SUBCAppendixData app, HashMap<SUBCQuotaData, String> quotaBinding) {
        for (SUBCDateData dateData : app.getDates()) {
            for (SUBCFlightData flight : dateData.getFlights()) {
                for (SUBCQuotaData quota : flight.getQuotas()) {
                    if (!quotaBinding.get(quota).equals(prod.getCharterQuotaBinding().getForwardQuota().getQuotaUid()) && !quotaBinding.get(quota).equals(prod.getCharterQuotaBinding().getBackwardQuota().getQuotaUid())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isManuallyBinded(Product prod) {
        return prod.getCharterQuotaBinding().getForwardQuota().getQuotaUid() != null || prod.getCharterQuotaBinding().getBackwardQuota().getQuotaUid() != null;
    }

    private static boolean isAppropriateForAppendix(String route, String fareBasis, SUBCAppendixData app) {
        return SUBCReportPrepareHelper.isAppropriateForAppendix(route, fareBasis, app.getRoute(), app.getFareBasis());
    }

    private static boolean isAppropriateForAppendix(String route, String fareBasis, SUBlockCharterAppendix app) {
        return SUBCReportPrepareHelper.isAppropriateForAppendix(route, fareBasis, app.getItinerary(), app.getFareBasis());
    }

    private static boolean isAppropriateForAppendix(String route, String fareBasis, String appRoute, String appFareBasis) {
        Set<String> items2;
        Set<String> items1 = SUBCReportPrepareHelper.getItems(route);
        if (!items1.containsAll(items2 = SUBCReportPrepareHelper.getItems(appRoute)) || !items2.containsAll(items1)) {
            return false;
        }
        return fareBasis != null && appFareBasis != null && appFareBasis.contains(fareBasis);
    }

    private static Set<String> getItems(String route) {
        if (TextUtil.isBlank((String)route)) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        for (String item : route.split("-")) {
            if (TextUtil.isBlank((String)item)) continue;
            result.add(item.trim().toUpperCase());
        }
        return result;
    }

    private static boolean addToFlight(SUBCFlightData aFlightData, SUBCTicket ticket, boolean backwardFlight, HashMap<SUBCQuotaData, String> quotaBinding, Product prod, List<Message> messages) {
        int increment;
        SUBCTicketsData ticketsData;
        SUBCQuotaData quotaData = null;
        if (SUBCReportPrepareHelper.isManuallyBinded(prod)) {
            for (SUBCQuotaData quota : aFlightData.getQuotas()) {
                if (backwardFlight && quotaBinding.get(quota).equals(prod.getCharterQuotaBinding().getBackwardQuota().getQuotaUid())) {
                    quotaData = quota;
                }
                if (backwardFlight || !quotaBinding.get(quota).equals(prod.getCharterQuotaBinding().getForwardQuota().getQuotaUid())) continue;
                quotaData = quota;
            }
        } else {
            for (SUBCQuotaData quota : aFlightData.getQuotas()) {
                String string = quota.getClassOfBooking();
                String string2 = ticket.isRoundTrip() ? (backwardFlight ? ticket.getBackwardClassOfBooking() : ticket.getForwardClassOfBooking()) : ticket.getForwardClassOfBooking();
                if (!string.equals(string2)) continue;
                quotaData = quota;
                break;
            }
        }
        if (quotaData == null) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.SUBCReportPrepareHelper_ticketNoGoodQuotas, (Object[])new Object[]{ticket.getTicketNumber(), aFlightData.getDateData().getAppendix().getAppendixNumber(), ticket.getFlightNumbers(), ticket.getFirstFlightDate(), ticket.getLastFlightDate(), ticket.getForwardClassOfBooking(), ticket.getBackwardClassOfBooking(), aFlightData.getDateData().getDate(), aFlightData.getFlightNumber()}));
            return false;
        }
        if (ticket.isRegionFlight()) {
            quotaData.getFlight().getRegionTickets().add(ticket);
            quotaData.getFlight().getDateData().getRegionTickets().add(ticket);
        } else {
            quotaData.getFlight().getDirectTickets().add(ticket);
            quotaData.getFlight().getDateData().getDirectTickets().add(ticket);
        }
        if (ProductStatusHandler.getAllVoidStatuses().contains(ticket.getStatus())) {
            return true;
        }
        SUBCTicketsData sUBCTicketsData = ticketsData = ticket.isRegionFlight() ? quotaData.getRegionFlightsData() : quotaData.getDirectFlightsData();
        if (ticketsData == null) {
            if (ticket.isRegionFlight()) {
                ticketsData = new SUBCTicketsData(quotaData, true);
                quotaData.setRegionFlightsData(ticketsData);
            } else {
                ticketsData = new SUBCTicketsData(quotaData, false);
                quotaData.setDirectFlightsData(ticketsData);
            }
        }
        boolean adult = SUBCReportPrepareHelper.isAdult((DictionaryReference<PassengerType>)ticket.getPassengerType());
        int n = increment = ticket.getStatus() == ProductStatus.SELL ? 1 : -1;
        if (ticket.isRoundTrip()) {
            if (ticket.isHasMixedClasses()) {
                if (adult) {
                    ticketsData.setTotalRTMixedClassAdult(ticketsData.getTotalRTMixedClassAdult() + increment);
                } else {
                    ticketsData.setTotalRTMixedClassInfant(ticketsData.getTotalRTMixedClassInfant() + increment);
                }
            } else if (adult) {
                ticketsData.setTotalRTSingleClassAdult(ticketsData.getTotalRTSingleClassAdult() + increment);
            } else {
                ticketsData.setTotalRTSingleClassInfant(ticketsData.getTotalRTSingleClassInfant() + increment);
            }
        } else if (adult) {
            ticketsData.setTotalOWAdult(ticketsData.getTotalOWAdult() + increment);
        } else {
            ticketsData.setTotalOWInfant(ticketsData.getTotalOWInfant() + increment);
        }
        return true;
    }

    private static boolean isAdult(DictionaryReference<PassengerType> passengerType) {
        return passengerType == null || DictHelper.isEqualsPredifinedValue(passengerType, (DictPredifinedValueProvider[])new DictPredifinedValueProvider[]{PassengerTypeValue.ADULT, PassengerTypeValue.ADULT_COMPANION, PassengerTypeValue.ADULT_WITH_COMPANION, PassengerTypeValue.CHILD, PassengerTypeValue.CHILD_UNACCOMPANIED});
    }

    private static Collection<Product> selectAppropriateProducts(ReportParameters params, Map<String, Object> data, List<Message> messages) throws Exception {
        SearchQuery query = SalesReportPrepareHelper.createQuery(params, true);
        query.getPreferredProperties().clear();
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ProductIndex.Property.ticketType.name(), (Object)TicketType.OWN), SearchCriterion.eq((String)ProductIndex.Property.ticketType.name(), (Object)TicketType.NOT_OWN), SearchCriterion.eq((String)ProductIndex.Property.ticketType.name(), null)}));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ProductIndex.Property.tariffType.name(), (Object)TariffType.CHARTER), SearchCriterion.eq((String)ProductIndex.Property.tariffType.name(), (Object)TariffType.BLOCKCHARTER), SearchCriterion.eq((String)ProductIndex.Property.tariffType.name(), null)}));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ProductIndex.Property.status.name(), (Object)ProductStatus.BOOKING));
        query.getCriteria().getCriterions().add(SearchQueryHelper.buildAndNeEnumCriterion((String)ProductIndex.Property.status.name(), (Collection)ProductStatusHandler.getAllVoidStatuses()));
        Date periodEnd = MiscUtil.setDayEndTime((Date)params.getPeriodEnd());
        Date periodBegin = MiscUtil.clearTime((Date)params.getPeriodBegin());
        Date extendedPeriodEnd = new Date(periodEnd.getTime() + 86400000L);
        Date extendedPeriodBegin = new Date(periodBegin.getTime() - 86400000L);
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)ProductIndex.Property.firstFlightDate.name(), (Object)extendedPeriodBegin), SearchCriterion.le((String)ProductIndex.Property.firstFlightDate.name(), (Object)extendedPeriodEnd)}), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)ProductIndex.Property.lastFlightDate.name(), (Object)extendedPeriodBegin), SearchCriterion.le((String)ProductIndex.Property.lastFlightDate.name(), (Object)extendedPeriodEnd)})}));
        query.getCriteria().getCriterions().addAll(params.getAdditionalCriterions());
        EntityStorage es = EntityStorage.get();
        List allData = es.search(ProductIndex.class, query).getData();
        HashSet<String> productIndexList = new HashSet<String>();
        HashSet<EntityReference> bfrefs = new HashSet<EntityReference>();
        HashSet<Product> result = new HashSet<Product>();
        for (ProductIndex index : allData) {
            productIndexList.add(index.getNavigationKey());
            bfrefs.add(index.getSource());
        }
        for (EntityReference bfref : bfrefs) {
            EntityContainer container = es.resolve(bfref);
            BookingFile bookingFile = (BookingFile)container.getEntity();
            for (Reservation res : bookingFile.getReservations()) {
                block3: for (BaseProduct prod : res.getProducts()) {
                    String uid = prod.getUid();
                    for (String productUid : productIndexList) {
                        if (!productUid.equals(uid) || !(prod instanceof Product)) continue;
                        Product product = (Product)prod;
                        SUBCTicket.LocationsData locData = SUBCTicket.getLocationsData((Product)product, (Set)((Set)data.get("KEY_BLOCK_CHARTER_CONTRACT_LOCATION_CODES")));
                        if (locData.departure != null && locData.departure.flightDate != null && MiscUtil.compare((Date)locData.departure.flightDate, (Date)periodBegin) >= 0 && MiscUtil.compare((Date)locData.departure.flightDate, (Date)periodEnd) <= 0) {
                            result.add(product);
                            continue block3;
                        }
                        if (locData.arrival == null || locData.arrival.flightDate == null || MiscUtil.compare((Date)locData.arrival.flightDate, (Date)periodBegin) < 0 || MiscUtil.compare((Date)locData.arrival.flightDate, (Date)periodEnd) > 0) continue;
                        result.add(product);
                        continue block3;
                    }
                }
            }
        }
        return result;
    }

    private static void updateBCData(ReportParameters params, SUBCData bcData, SUBlockCharterAppendix subc, ContractCustomerInfo info, EntityReference<Contract> contractRef, HashMap<SUBCQuotaData, String> quotaBinding, List<Message> messages) {
        bcData.setContractNumber(info.getNumber());
        Calendar cal = Calendar.getInstance();
        cal.setTime(params.getPeriodBegin());
        int startDate = cal.get(5);
        cal.setTime(params.getPeriodEnd());
        int endDate = cal.get(5);
        bcData.setReportPeriod(String.format("\u0441 %s \u043f\u043e %s %s %s\u0433", Integer.toString(startDate), Integer.toString(endDate), SUBCReportPrepareHelper.getMonthName(cal.get(2)), Integer.toString(cal.get(1))));
        bcData.setReportDecada(String.format("%s \u0434\u0435\u043a\u0430\u0434\u0443 %s", Integer.toString(startDate < 11 ? 1 : (startDate < 21 ? 2 : 3)), SUBCReportPrepareHelper.getMonthName(cal.get(2))));
        SUBCAppendixData appData = new SUBCAppendixData(bcData);
        appData.setFareBasis(subc.getFareBasis());
        appData.setAppendixNumber(subc.getNumber());
        if (subc.getCurrency() == null) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.SUBCReportPrepareHelper_inAppNoCurrency, (Object[])new Object[]{subc.getNumber()}));
            return;
        }
        BigDecimal rate = (BigDecimal)bcData.getRates().get(subc.getCurrency());
        if (rate == null) {
            CurrencyRate cRate = BookingHelper.findCurrencyRate((String)subc.getCurrency(), (Date)MiscUtil.setDayEndTime((Date)params.getPeriodEnd()), (CurrencyRateType)CurrencyRateType.IATA, null, null);
            if (cRate == null) {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.SUBCReportPrepareHelper_inDirectory, (Object[])new Object[]{subc.getCurrency(), MiscUtil.setDayEndTime((Date)params.getPeriodEnd())}));
                return;
            }
            bcData.getRates().put(subc.getCurrency(), BigDecimal.valueOf(cRate.getRate()));
        }
        appData.setCurrencyCode(subc.getCurrency());
        appData.setRoute(subc.getItinerary());
        appData.setType(subc.getType());
        HashMap<SUBlockCharterQuota, SUBlockCharterTariffInfo> quotaTariffMap = new HashMap<SUBlockCharterQuota, SUBlockCharterTariffInfo>();
        ArrayList<SUBlockCharterQuota> quotas = new ArrayList<SUBlockCharterQuota>();
        for (SUBlockCharterTariffInfo tariff : subc.getTariffs()) {
            if (tariff.getOwAdultTariff() == null && subc.getType() == SUBlockCharterAppendixType.ONE_WAY) {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.SUBCReportPrepareHelper_inAppNoTariffOneWay, (Object[])new Object[]{subc.getNumber()}));
                return;
            }
            if (tariff.getRtAdultTariff() == null) {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.SUBCReportPrepareHelper_inAppNoTariffRoundTrip, (Object[])new Object[]{subc.getNumber()}));
                return;
            }
            if (TextUtil.isBlank((String)tariff.getClassOfBooking())) {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.SUBCReportPrepareHelper_inAppNoClassBooking, (Object[])new Object[]{subc.getNumber()}));
                return;
            }
            if (subc.getType() == SUBlockCharterAppendixType.ONE_WAY && (tariff.getRtAdultTariff() == null || tariff.getOwAdultTariff() == null)) {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.SUBCReportPrepareHelper_inAppNoAllTariff, (Object[])new Object[]{subc.getNumber()}));
                return;
            }
            if (tariff.getRtAdultTariff() == null && tariff.getOwAdultTariff() == null) {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.SUBCReportPrepareHelper_inAppNoTariff, (Object[])new Object[]{subc.getNumber()}));
                return;
            }
            for (Object quota : tariff.getQuotas()) {
                quotas.add((SUBlockCharterQuota)quota);
                quotaTariffMap.put((SUBlockCharterQuota)quota, tariff);
            }
        }
        Collections.sort(quotas, new Comparator<SUBlockCharterQuota>(){

            @Override
            public int compare(SUBlockCharterQuota o1, SUBlockCharterQuota o2) {
                if (o1.isBackwardDirection() != o2.isBackwardDirection()) {
                    return o1.isBackwardDirection() ? 1 : -1;
                }
                return MiscUtil.compare((Date)o1.getFlightDate(), (Date)o2.getFlightDate(), (boolean)false);
            }
        });
        for (SUBlockCharterQuota quota : quotas) {
            Object dd2;
            if (appData.getType() == SUBlockCharterAppendixType.ROUND_TRIP && quota.isBackwardDirection()) continue;
            if (quota.getFlightDate() == null) {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.SUBCReportPrepareHelper_noDateDeparture, (Object[])new Object[]{subc.getNumber()}));
                return;
            }
            if (TextUtil.isBlank((String)quota.getFlightNumber())) {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.SUBCReportPrepareHelper_inAppNoNumberFlight, (Object[])new Object[]{subc.getNumber()}));
                return;
            }
            if (quota.getFlightDate().after(params.getPeriodEnd()) || quota.getFlightDate().before(params.getPeriodBegin())) continue;
            Object dateData = null;
            for (Object dd2 : appData.getDates()) {
                if (!SUBCReportPrepareHelper.equals(dd2.getDate(), quota.getFlightDate())) continue;
                dateData = dd2;
                break;
            }
            if (dateData == null) {
                dateData = new SUBCDateData(appData);
                dateData.setDate(quota.getFlightDate());
            }
            SUBCFlightData flightData = null;
            dd2 = dateData.getFlights().iterator();
            while (dd2.hasNext()) {
                SUBCFlightData fd = (SUBCFlightData)dd2.next();
                if (!fd.getFlightNumber().equals(quota.getFlightNumber())) continue;
                flightData = fd;
                break;
            }
            SUBlockCharterTariffInfo tariff = (SUBlockCharterTariffInfo)quotaTariffMap.get(quota);
            if (flightData == null) {
                flightData = new SUBCFlightData(dateData);
                flightData.setFlightNumber(quota.getFlightNumber());
                flightData.setBackwardDirection(quota.isBackwardDirection());
            }
            SUBCQuotaData quotaData = null;
            for (SUBCQuotaData qd : flightData.getQuotas()) {
                if (!tariff.getClassOfBooking().equals(qd.getClassOfBooking())) continue;
                quotaData = qd;
                break;
            }
            if (quotaData == null) {
                quotaData = new SUBCQuotaData(flightData);
                quotaData.setClassOfBooking(tariff.getClassOfBooking());
                quotaData.setOneWayTariff(tariff.getOwAdultTariff());
                quotaData.setRtTariff(tariff.getRtAdultTariff());
                quotaBinding.put(quotaData, quota.getUid());
            }
            quotaData.setQuota(quotaData.getQuota() + quota.getQuota());
        }
    }

    public static void addProductProxyTicket(Product prod, Map<String, Object> data, List<Message> messages) throws Exception {
        Map bcdataMap = (Map)data.get("KEY_BLOCK_CHARTER_DATA");
        if (bcdataMap == null) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.SUBCReportPrepareHelper_noDataBlockCharters, (Object[])new Object[0]));
            return;
        }
        ArrayList values = new ArrayList(bcdataMap.values());
        Map charterData = (Map)data.get("KEY_CHARTER_DATA");
        if (charterData != null) {
            values.addAll(charterData.values());
        }
        if (values.isEmpty()) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.SUBCReportPrepareHelper_noBlockcharterDate, (Object[])new Object[0]));
            return;
        }
        SUBCTicket ticket = new SUBCTicket(prod, messages, data);
        if (prod.getStatus() == ProductStatus.REFUND) {
            ticket.setRelatedSellNumber(SUBCReportPrepareHelper.findRelatedSellNumber(prod, messages));
        }
        if (prod.getStatus() == ProductStatus.EXCHANGE && prod.getNextProduct() != null) {
            ticket.setRelatedSellNumber(prod.getNextProduct().getSystemNumber());
        }
        if (values.size() == 1) {
            ((SUBCData)values.get(0)).getTickets().add(ticket);
            return;
        }
        Map contract2AppsMap = (Map)data.get(CONTRACT_TO_APPENDIXES_LIST_KEY);
        if (SUBCReportPrepareHelper.isManuallyBinded(prod)) {
            for (SUBCData bcData : values) {
                for (SUBlockCharterAppendix appData : (List)contract2AppsMap.get(bcData)) {
                    for (SUBlockCharterTariffInfo tariffInfo : appData.getTariffs()) {
                        for (SUBlockCharterQuota quota : tariffInfo.getQuotas()) {
                            if (!prod.getCharterQuotaBinding().getForwardQuota().getQuotaUid().equals(quota.getUid()) && !prod.getCharterQuotaBinding().getBackwardQuota().getQuotaUid().equals(quota.getUid())) continue;
                            bcData.getTickets().add(ticket);
                            return;
                        }
                    }
                }
            }
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.SUBCReportPrepareHelper_ticketCantFindApp, (Object[])new Object[]{ticket.getTicketNumber(), ticket.getRoute(), ticket.getFareBasis()}));
            return;
        }
        for (SUBCData bcData : values) {
            for (SUBlockCharterAppendix appData : (List)contract2AppsMap.get(bcData)) {
                if (!SUBCReportPrepareHelper.isAppropriateForAppendix(ticket.getDirection(), ticket.getFareBasis(), appData)) continue;
                for (SUBlockCharterTariffInfo tariffInfo : appData.getTariffs()) {
                    if (!TextUtil.isSame((String)ticket.getBackwardClassOfBooking(), (String)tariffInfo.getClassOfBooking()) && !TextUtil.isSame((String)ticket.getForwardClassOfBooking(), (String)tariffInfo.getClassOfBooking())) continue;
                    for (SUBlockCharterQuota quota : tariffInfo.getQuotas()) {
                        if (!MiscUtil.isSameDay((Date)quota.getFlightDate(), (Date)ticket.getFirstFlightDate()) && !MiscUtil.isSameDay((Date)quota.getFlightDate(), (Date)ticket.getLastFlightDate()) || !ticket.getFlightNumbers().contains(quota.getFlightNumber())) continue;
                        bcData.getTickets().add(ticket);
                        return;
                    }
                }
            }
        }
        messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.SUBCReportPrepareHelper_ticketCantFindApp, (Object[])new Object[]{ticket.getTicketNumber(), ticket.getDirection(), ticket.getFareBasis()}));
    }

    private static String findRelatedSellNumber(Product prod, List<Message> messages) throws Exception {
        EntityStorage es = EntityStorage.get();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"navigationKey", (Object)prod.getUid()));
        List data = es.search(ProductIndex.class, query).getData();
        if (data.isEmpty() || ((ProductIndex)data.get(0)).getDateOfVendorPayment() == null) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.SUBCReportPrepareHelper_ticketNotDeterminedDateExtract, (Object[])new Object[]{prod.getSystemNumber()}));
            return null;
        }
        query = new SearchQuery();
        query.getCriteria().getOrders().put(ProductIndex.Property.sortingTicketNumber.name(), SortOrder.ASC);
        Date date = ((ProductIndex)data.get(0)).getIssueDate();
        Date gDate = new Date(date.getTime() + 2592000000L);
        query.getCriteria().getCriterions().add(SearchCriterion.le((String)ProductIndex.Property.issueDate.name(), (Object)gDate));
        query.getCriteria().getCriterions().add(SearchCriterion.ge((String)ProductIndex.Property.issueDate.name(), (Object)date));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.status.name(), (Object)ProductStatus.SELL));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ProductIndex.Property.tariffType.name(), (Object)TariffType.BLOCKCHARTER), SearchCriterion.eq((String)ProductIndex.Property.tariffType.name(), (Object)TariffType.CHARTER)}));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.travellerName.name(), (Object)((ProductIndex)data.get(0)).getTravellerName()));
        data = es.search(ProductIndex.class, query).getData();
        if (data.isEmpty()) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.SUBCReportPrepareHelper_ticketCantFindRelatedTicket, (Object[])new Object[]{prod.getSystemNumber()}));
            return null;
        }
        if (data.size() > 1) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.SUBCReportPrepareHelper_ticketFindedFewRelatedTickets, (Object[])new Object[]{prod.getSystemNumber(), ((ProductIndex)data.get(0)).getTicketNumbers().isEmpty() ? "" : ((ProductIndex)data.get(0)).getTicketNumbers().iterator().next()}));
        }
        return (String)((ProductIndex)data.get(0)).getTicketNumbers().iterator().next();
    }

    private static boolean equals(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return false;
        }
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        return cal1.get(1) == cal2.get(1) && cal1.get(2) == cal2.get(2) && cal1.get(5) == cal2.get(5);
    }

    private static String getMonthName(int i) {
        switch (i) {
            case 0: {
                return "\u044f\u043d\u0432\u0430\u0440\u044f";
            }
            case 1: {
                return "\u0444\u0435\u0432\u0440\u0430\u043b\u044f";
            }
            case 2: {
                return "\u043c\u0430\u0440\u0442\u0430";
            }
            case 3: {
                return "\u0430\u043f\u0440\u0435\u043b\u044f";
            }
            case 4: {
                return "\u043c\u0430\u044f";
            }
            case 5: {
                return "\u0438\u044e\u043d\u044f";
            }
            case 6: {
                return "\u0438\u044e\u043b\u044f";
            }
            case 7: {
                return "\u0430\u0432\u0433\u0443\u0441\u0442\u0430";
            }
            case 8: {
                return "\u0441\u0435\u043d\u0442\u044f\u0431\u0440\u044f";
            }
            case 9: {
                return "\u043e\u043a\u0442\u044f\u0431\u0440\u044f";
            }
            case 10: {
                return "\u043d\u043e\u044f\u0431\u0440\u044f";
            }
        }
        return "\u0434\u0435\u043a\u0430\u0431\u0440\u044f";
    }

    static void clearAuxiliaryData(Map<String, Object> data) {
        data.remove(QUOTA_BINDING_KEY);
        data.remove(CONTRACT_TO_APPENDIXES_LIST_KEY);
    }
}

