/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.salesreports.su;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.PaymentCardHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.reports.model.BaseReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.salesreports.SalesReportHelper;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuSalesReportBatchData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuTicket;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.reports.prepare.salesreports.BaseSalesReportPrepareHandler;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SuPaymentCardSalesReportPrepareHandler
extends BaseSalesReportPrepareHandler<SuTicket> {
    @Override
    public String getId() {
        return "su-payment-card-sales-report";
    }

    @Override
    protected MetadataKey getAgencyReportCode(BaseReportParameters params) {
        Date januaryTheFirst = new GregorianCalendar(2013, 0, 1).getTime();
        MetadataKey codeKey = params.getPeriodEnd().after(januaryTheFirst) ? MetadataKey.KEY_SU_2013_AGENCY_CODE : MetadataKey.KEY_SU_AGENCY_CODE;
        return codeKey;
    }

    @Override
    protected void addProductProxyTicket(Product product, Map<String, Object> data, List<Message> messages) throws Exception {
        if (product.getStatus() != ProductStatus.SELL && product.getStatus() != ProductStatus.REFUND) {
            return;
        }
        if (TextUtil.isBlank((String)product.getValidatorCode())) {
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Message_NoValidator", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{product.getSystemNumber()});
        }
        if (!this.checkFopTypes(product)) {
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_FopTypeIsNotSet", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{product.getSystemNumber()});
            this.log.error("Fop type is not set for product " + product.getSystemNumber());
            return;
        }
        SuTicket ticket = new SuTicket(product, messages);
        if (!this.isPaymentCardUsed(product) && !this.isExchangeExists(ticket)) {
            return;
        }
        if (PaymentCardHelper.isPaymentCardMasked((Product)product)) {
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_PaymentCardNumberIsMasked", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{product.getSystemNumber()});
            this.log.error("Payment card number is masked for " + product.getSystemNumber());
            return;
        }
        if (this.isPaymentCardSecurityCodeEmpty(product)) {
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_PaymentCardSecurityCodeIsEmpty", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{product.getSystemNumber()});
            this.log.error("Payment card authorization is empty for product " + product.getSystemNumber());
            return;
        }
        ArrayList<SuSalesReportBatchData<SuTicket>> batchDataList = (ArrayList<SuSalesReportBatchData<SuTicket>>)data.get("key-batch-data-list");
        if (batchDataList == null) {
            batchDataList = new ArrayList<SuSalesReportBatchData<SuTicket>>();
            data.put("key-batch-data-list", batchDataList);
        }
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        EntityReference agencyReference = params.getAgency();
        SuSalesReportBatchData<SuTicket> batch = null;
        batch = this.selectBatch(ticket.getBatchId(), ticket.getAgencyCode(), batchDataList, agencyReference.getCaption());
        if (this.isPaymentCardUsed(ticket.getProduct())) {
            batch.getTickets().add(ticket);
        }
        Product soldProduct = null;
        if (this.isExchangeExists(ticket) && ticket.getPrevTicket() != null && ticket.getPrevTicket().getPreviousProduct() != null && this.isPaymentCardUsed(soldProduct = ticket.getPrevTicket().getPreviousProduct()) && soldProduct.getIssueDate() != null && (soldProduct.getIssueDate().equals(params.getPeriodBegin()) || soldProduct.getIssueDate().equals(params.getPeriodEnd()) || soldProduct.getIssueDate().after(params.getPeriodBegin()) && soldProduct.getIssueDate().before(params.getPeriodEnd()))) {
            SuTicket previousTicket = new SuTicket(soldProduct, messages);
            if (ticket.getEquivalentFare() != null && previousTicket.getBaseFare() != null) {
                BigDecimal eqFare = ticket.getEquivalentFare().subtract(previousTicket.getEquivalentFare());
                ticket.setEquivalentFare(eqFare);
            }
            if (ticket.getCreditCardValue() != null && previousTicket.getCreditCardValue() != null) {
                BigDecimal ccValue = ticket.getCreditCardValue();
                ticket.setCreditCardValue(ccValue);
            }
            if (ticket.getVendorEquivalentCommission() != null && previousTicket.getVendorEquivalentCommission() != null) {
                BigDecimal baseFare = ticket.getVendorEquivalentCommission().subtract(previousTicket.getVendorEquivalentCommission());
                ticket.setVendorEquivalentCommission(baseFare);
            }
            List newTaxes = SalesReportHelper.calculateTaxesDifference((Collection)ticket.getTaxes(), (Collection)previousTicket.getTaxes());
            ticket.getTaxes().clear();
            ticket.getTaxes().addAll(newTaxes);
            BigDecimal fopAmountEq = BigDecimal.ZERO;
            fopAmountEq = fopAmountEq.add(ticket.getEquivalentFare());
            for (Tax t : ticket.getTaxes()) {
                if (t == null || t.getEquivalentAmount() == null) continue;
                fopAmountEq = fopAmountEq.add(t.getEquivalentAmount());
            }
            if (ticket.getPenalty() != null) {
                fopAmountEq = fopAmountEq.add(ticket.getPenalty());
            }
            boolean fopSet = false;
            Iterator iter = ticket.getFops().iterator();
            while (iter.hasNext()) {
                ProductFop f = (ProductFop)iter.next();
                if (!PaymentType.TICKET.equals((Object)f.getType()) && !PaymentType.MCO.equals((Object)f.getType())) {
                    if (!fopSet && f.getAmount() != null) {
                        f.getAmount().setValue(fopAmountEq);
                        fopSet = true;
                        continue;
                    }
                    iter.remove();
                    continue;
                }
                if (PaymentType.MCO.equals((Object)f.getType())) continue;
                iter.remove();
            }
        }
    }

    @Override
    protected void putGlobalData(Map<String, Object> data, List<Message> messages) throws Exception {
        super.putGlobalData(data, messages);
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        if (params.getSupplier() == null) {
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_SupplierIsEmpty", null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            return;
        }
        Organization organization = (Organization)EntityStorage.get().resolve(params.getSupplier()).getEntity();
        data.put("AIRLINE_NAME", organization.getLegalForm() != null ? organization.getLegalForm() + " \"" + organization.getFullName() + "\"" : (organization.getFullName() != null ? organization.getFullName().toString() : null));
        EntityContainer agencyEntity = EntityStorage.get().resolve(params.getAgency());
        if (agencyEntity == null) {
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_FailedLoadingEntity", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{params.getAgency()});
            this.log.debug("Could not find entity in database");
            return;
        }
        Organization agency = (Organization)agencyEntity.getEntity();
        String agencyCode = SystemHelper.findMetadataAsString((Collection)agency.getMetadata(), (MetadataKey)this.getAgencyReportCode((BaseReportParameters)((ReportParameters)data.get("key-report-params"))));
        if (agencyCode != null && agencyCode.isEmpty()) {
            SystemHelper.addMessage(messages, (String)"BaseStockControlReportPrepareHandler_Message_AgencyCodeIsEmpty", null, (MessageType)MessageType.WARNING, (Object[])new Object[]{params.getAgency().getCaption(), params.getSupplier().getCaption()});
        }
        data.put("AGENCY_IATA_CODE", agencyCode);
    }

    @Override
    protected void afterFillDataLists(Map<String, Object> data, List<Message> messages) throws Exception {
        List batchDataList = (List)data.get("key-batch-data-list");
        if (batchDataList == null) {
            return;
        }
        for (SuSalesReportBatchData batchData : batchDataList) {
            Collections.sort(batchData.getTickets(), new Comparator<SuTicket>(){

                @Override
                public int compare(SuTicket o1, SuTicket o2) {
                    return TextUtil.compare((String)o1.getTicketNumber(), (String)o2.getTicketNumber(), (boolean)false, (boolean)true);
                }
            });
        }
    }

    private boolean checkFopTypes(Product product) {
        for (ProductFop fop : AirProductHelper.getVendorContractRelation((Product)product).getFops()) {
            if (fop.getType() != null) continue;
            return false;
        }
        return true;
    }

    private SuSalesReportBatchData<SuTicket> selectBatch(String batchId, String agencyCode, List<SuSalesReportBatchData<SuTicket>> batchDataList, String mainAgencyCode) {
        for (SuSalesReportBatchData<SuTicket> batch : batchDataList) {
            if (!batch.getBatchId().equals(batchId)) continue;
            return batch;
        }
        SuSalesReportBatchData newBatch = new SuSalesReportBatchData();
        newBatch.setBatchId(batchId);
        newBatch.setSubagencyCode(agencyCode);
        newBatch.setAgencyCode(mainAgencyCode);
        batchDataList.add((SuSalesReportBatchData<SuTicket>)newBatch);
        return newBatch;
    }

    private boolean isExchangeExists(SuTicket ticket) {
        boolean result = false;
        if ("EXC".equals(ticket.getBatchId())) {
            result = true;
        }
        return result;
    }

    private boolean isPaymentCardUsed(Product product) {
        boolean result = false;
        for (ProductFop productFop : AirProductHelper.getClientContractRelation((Product)product).getFops()) {
            if (productFop.getType() != PaymentType.CREDIT_CARD) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean isPaymentCardSecurityCodeEmpty(Product product) {
        boolean result = false;
        for (ProductFop productFop : AirProductHelper.getClientContractRelation((Product)product).getFops()) {
            if (productFop.getType() != PaymentType.CREDIT_CARD || productFop.getCard() != null && productFop.getCard().getSecurityCode() != null) continue;
            result = true;
            break;
        }
        return result;
    }
}

