/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.salesreports.su;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.BaseReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuSalesReportBatchData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuTicket;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.reports.prepare.BaseReportPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.salesreports.SalesReportPrepareHelper;
import com.gridnine.xtrip.server.reports.prepare.salesreports.su.SuSalesReportPrepareHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class SuSalesRegistersReportPrepareHandler
extends SuSalesReportPrepareHandler {
    @Override
    protected void addProductProxyTicket(Product product, Map<String, Object> data, List<Message> messages) throws Exception {
        if (product.getTariffType() == TariffType.BLOCKCHARTER || product.getTariffType() == TariffType.CHARTER) {
            return;
        }
        SuTicket ticket = this.getTicketInstance(product, messages);
        ArrayList<SuSalesReportBatchData<SuTicket>> batchDataList = (ArrayList<SuSalesReportBatchData<SuTicket>>)data.get("key-batch-data-list");
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        EntityReference agencyReference = params.getAgency();
        if (batchDataList == null) {
            batchDataList = new ArrayList<SuSalesReportBatchData<SuTicket>>();
            data.put("key-batch-data-list", batchDataList);
        }
        if (ticket.getProductCategory() == ProductCategory.MCO && ticket.getMcoCategory() != MCOCategory.RETURN_TICKET) {
            ticket.setBatchId("SALE");
        }
        this.setSpecificTicketData(ticket, product, data, messages);
        this.updateTicketRegistryLetterData(ticket, ticket.getBatchId(), data);
        String creditCardPostfix = this.hasCreditCardFop(ticket) ? PaymentType.CREDIT_CARD.name() : "";
        String batchId = ticket.getStatus() == ProductStatus.VOID ? ticket.getBatchId() : ticket.getBatchId() + ticket.getTransportationType().name() + creditCardPostfix;
        SuSalesReportBatchData<SuTicket> batch = this.selectBatch(batchId, ticket.getAgencyCode(), batchDataList, agencyReference.getCaption());
        batch.getTickets().add(ticket);
    }

    private boolean hasCreditCardFop(SuTicket ticket) {
        for (ProductFop fop : ticket.getFops()) {
            if (fop.getType() == null || !fop.getType().equals((Object)PaymentType.CREDIT_CARD)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getId() {
        return "su-sales-registers-report";
    }

    @Override
    protected void prepareStockData(Map<String, Object> data) throws Exception {
    }

    @Override
    protected List<ProductIndex> selectProducts(Map<String, Object> data) throws Exception {
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        EntityStorage es = EntityStorage.get();
        SearchQuery query = SalesReportPrepareHelper.createProductQuery(params.getPeriodBegin(), params.getPeriodEnd(), null);
        query.getCriteria().getCriterions().addAll(params.getAdditionalCriterions());
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ProductIndex.Property.tariffType.name(), (Object)TariffType.REGULAR), SearchCriterion.eq((String)ProductIndex.Property.tariffType.name(), (Object)TariffType.GROUP), SearchCriterion.eq((String)ProductIndex.Property.tariffType.name(), null)}));
        if (params.getBlankOwner() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.blankOwner.name(), (Object)params.getBlankOwner()));
        }
        return es.search(ProductIndex.class, query).getData();
    }

    @Override
    protected void putGlobalData(Map<String, Object> data, List<Message> messages) throws Exception {
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        if (params.getBlankOwner() == null) {
            SystemHelper.addMessage(messages, (String)Messages.XFSalesReportPrepareHandler_reportParamNoBlankOwner, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            return;
        }
        if (params.getBlankOwner() == null) {
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_NoVendor", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{this.getVendorCode()});
            return;
        }
        EntityContainer blankOwnerCtr = EntityStorage.get().resolve(params.getBlankOwner());
        if (blankOwnerCtr == null) {
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_NoVendor", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{this.getVendorCode()});
            this.log.error("No vendor profile defined for code " + this.getVendorCode());
            return;
        }
        data.put("key-vendor", blankOwnerCtr.getEntity());
        Airline airline = (Airline)DictionaryCache.get().resolveReference(((Organization)blankOwnerCtr.getEntity()).getAirline());
        if (airline == null) {
            SystemHelper.addMessage(messages, (String)Messages.SuSalesRegistersReportPrepareHandler_cantIdentifyAirline, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{((Organization)blankOwnerCtr.getEntity()).toString()});
            this.log.error("unable to resolve airline for " + ((Organization)blankOwnerCtr.getEntity()).toString());
            return;
        }
        data.put("AIRLINE_IATA_CODE", airline.getAirlineNumber());
        String vendorName = ProfileHelper.getFullName((Organization)((Organization)blankOwnerCtr.getEntity()), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false);
        vendorName = vendorName == null ? "" : vendorName.toUpperCase();
        data.put("AIRLINE_NAME", vendorName);
        data.put("REPORT_PERIOD_NO", "000");
        data.put("AGENT_NAME", this.getAgentFullName());
        SuSalesRegistersReportPrepareHandler.putStandardReportParameters(params.getPeriodBegin(), params.getPeriodEnd(), data, messages);
        BaseReportPrepareHandler.putStandardAgencyData((EntityReference<Organization>)params.getAgency(), data, messages);
        this.prepareContractData(data, (EntityContainer<Organization>)blankOwnerCtr, messages);
        EntityContainer ac = EntityStorage.get().resolve(params.getAgency());
        if (ac == null) {
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_FailedLoadingEntity", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{params.getAgency()});
            this.log.debug("Could not find entity in database");
            return;
        }
        Organization agency = (Organization)ac.getEntity();
        String agencyCode = SystemHelper.findMetadataAsString((Collection)agency.getMetadata(), (MetadataKey)this.getAgencyReportCode((BaseReportParameters)((ReportParameters)data.get("key-report-params"))));
        if (agencyCode != null && agencyCode.isEmpty()) {
            String airlineName = "";
            airlineName = L10nStringHelper.getValue((L10nString)((Organization)blankOwnerCtr.getEntity()).getFullName(), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false);
            SystemHelper.addMessage(messages, (String)"BaseStockControlReportPrepareHandler_Message_AgencyCodeIsEmpty", null, (MessageType)MessageType.WARNING, (Object[])new Object[]{agency.getFullName(), airlineName});
        }
        data.put("AGENCY_IATA_CODE", agencyCode);
    }
}

