/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.salesreports.su;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.PaymentCardHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.reports.model.BaseReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.salesreports.SalesReportHelper;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuSalesReportBatchData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuTicket;
import com.gridnine.xtrip.server.reports.prepare.salesreports.su.BaseSuSalesReportPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.salesreports.su.SUBCReportPrepareHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SuSalesReportPrepareHandler
extends BaseSuSalesReportPrepareHandler {
    @Override
    protected MetadataKey getAgencyReportCode(BaseReportParameters params) {
        Date januaryTheFirst = new GregorianCalendar(2013, 0, 1).getTime();
        MetadataKey codeKey = params.getPeriodEnd().after(januaryTheFirst) ? MetadataKey.KEY_SU_2013_AGENCY_CODE : MetadataKey.KEY_SU_AGENCY_CODE;
        return codeKey;
    }

    @Override
    protected void addProductProxyTicket(Product prod, Map<String, Object> data, List<Message> messages) throws Exception {
        SuTicket ticket = null;
        try {
            if (prod.getMcoCategory() == MCOCategory.GROUP_PENALTY) {
                ticket = this.getTicketInstance(this.copyAsMcoGroupPenalty(prod), messages);
            } else {
                if (ProductStatus.EXCHANGE.equals((Object)prod.getStatus())) {
                    return;
                }
                if (prod.getPreviousProduct() != null && ProductStatus.EXCHANGE.equals((Object)prod.getPreviousProduct().getStatus())) {
                    Product exchangeProduct = prod.getPreviousProduct();
                    SuTicket exchangeTicket = this.getTicketInstance(exchangeProduct, messages);
                    ticket = this.getTicketInstance(prod, messages);
                    ticket.setFareRate(BigDecimal.ZERO);
                    if (ticket.getEquivalentFare() != null && exchangeTicket.getBaseFare() != null) {
                        BigDecimal eqFare = ticket.getEquivalentFare().subtract(exchangeTicket.getEquivalentFare());
                        if ("SU".equals(ticket.getBlankOwnerCode())) {
                            eqFare = eqFare.subtract(this.getDecreasedTaxesAmount(ticket.getTaxes(), exchangeTicket.getTaxes()));
                        }
                        ticket.setEquivalentFare(eqFare);
                    }
                    if (ticket.getVendorEquivalentCommission() != null && exchangeTicket.getVendorEquivalentCommission() != null) {
                        BigDecimal baseFare = ticket.getVendorEquivalentCommission().subtract(exchangeTicket.getVendorEquivalentCommission());
                        ticket.setVendorEquivalentCommission(baseFare);
                    }
                    List newTaxes = SalesReportHelper.calculateTaxesDifference((Collection)ticket.getTaxes(), (Collection)exchangeTicket.getTaxes());
                    ticket.getTaxes().clear();
                    ticket.getTaxes().addAll(newTaxes);
                    BigDecimal fopAmountEq = BigDecimal.ZERO;
                    fopAmountEq = fopAmountEq.add(ticket.getEquivalentFare());
                    for (Tax t : ticket.getTaxes()) {
                        if (t == null || t.getEquivalentAmount() == null) continue;
                        fopAmountEq = fopAmountEq.add(t.getEquivalentAmount());
                    }
                    if (ticket.getPenalty() != null) {
                        fopAmountEq = fopAmountEq.add(ticket.getPenalty());
                    }
                    boolean fopSet = false;
                    Iterator iter = ticket.getFops().iterator();
                    while (iter.hasNext()) {
                        ProductFop f = (ProductFop)iter.next();
                        if (!PaymentType.TICKET.equals((Object)f.getType()) && !PaymentType.MCO.equals((Object)f.getType())) {
                            if (!fopSet && f.getAmount() != null) {
                                f.getAmount().setValue(fopAmountEq);
                                fopSet = true;
                                continue;
                            }
                            iter.remove();
                            continue;
                        }
                        if (PaymentType.MCO.equals((Object)f.getType())) continue;
                        iter.remove();
                    }
                } else {
                    ticket = this.getTicketInstance(prod, messages);
                }
            }
        }
        catch (Exception e) {
            this.log.error("Can't create SuTicket for product \"" + prod.getSystemNumber() + "\"", (Throwable)e);
            return;
        }
        if (ticket.getStatus() != ProductStatus.VOID && !this.checkFopTypes(ticket)) {
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_FopTypeIsNotSet", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{ticket.getTicketNumber()});
            this.log.error("Fop type is not set for ticket " + ticket.getTicketNumber());
            return;
        }
        if (ticket.getStatus() != ProductStatus.VOID && this.isCreditCardUsed(ticket) && PaymentCardHelper.isPaymentCardMasked((Collection)ticket.getFops())) {
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_PaymentCardNumberIsMasked", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{ticket.getTicketNumber()});
            this.log.error("Payment card number is masked for " + ticket.getTicketNumber());
            return;
        }
        this.setSpecificTicketData(ticket, prod, data, messages);
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        EntityReference agencyReference = params.getAgency();
        ArrayList<SuSalesReportBatchData<SuTicket>> batchDataList = (ArrayList<SuSalesReportBatchData<SuTicket>>)data.get("key-batch-data-list");
        if (batchDataList == null) {
            batchDataList = new ArrayList<SuSalesReportBatchData<SuTicket>>();
            data.put("key-batch-data-list", batchDataList);
        }
        if (!(ticket.getTariffType() != TariffType.BLOCKCHARTER && ticket.getTariffType() != TariffType.CHARTER || MCOCategory.NOT_SOLD_SEATS.equals((Object)ticket.getMcoCategory()))) {
            SUBCReportPrepareHelper.addProductProxyTicket(prod, data, messages);
        }
        SuSalesReportBatchData<SuTicket> batch = null;
        batch = this.selectBatch(ticket.getBatchId(), ticket.getAgencyCode(), batchDataList, agencyReference.getCaption());
        if (batch.getBatchId().equals("SALE")) {
            if (!(prod.getProductCategory() != ProductCategory.MCO || prod.getMcoCategory() != MCOCategory.REBOOKING && prod.getMcoCategory() != MCOCategory.STICKER || prod.getRelatedProducts().isEmpty())) {
                Product relProd = (Product)prod.getRelatedProducts().get(0);
                ticket.setVendorCommissionRate(Double.valueOf(0.0));
                if (ticket.getBaseFare() != null) {
                    ticket.getBaseFare().setValue(BigDecimal.ZERO);
                }
                ticket.setEquivalentFare(BigDecimal.ZERO);
                ticket.setVendorEquivalentCommission(BigDecimal.ZERO);
                if (prod.getMcoCategory() == MCOCategory.STICKER && relProd != null && relProd.getStatus() == ProductStatus.SELL) {
                    SuTicket sticker = this.createSticker(prod, messages);
                    batch.getTickets().add(sticker);
                    this.updateTicketRegistryLetterData(sticker, batch.getBatchId(), data);
                }
            }
            if (prod.getProductCategory() == ProductCategory.MCO && prod.getMcoCategory() == MCOCategory.RETURN_FARE_DIFFERENCE && !prod.getRelatedProducts().isEmpty()) {
                SuTicket returnFareDifferenceAsRefund = this.createReturnFareDifferenceAsRefund(prod, messages);
                SuSalesReportBatchData<SuTicket> refundBatch = this.selectBatch("REFUND", ticket.getAgencyCode(), batchDataList, agencyReference.getCaption());
                refundBatch.getTickets().add(returnFareDifferenceAsRefund);
                this.updateTicketRegistryLetterData(returnFareDifferenceAsRefund, refundBatch.getBatchId(), data);
                ticket.setEquivalentFare(BigDecimal.ZERO);
                ticket.setVendorEquivalentCommission(BigDecimal.ZERO);
                for (ProductFop productFop : ticket.getFops()) {
                    productFop.getAmount().setValue(BigDecimal.ZERO);
                }
                if (ticket.getBaseFare() == null) {
                    Money money = new Money();
                    money.setValue(BigDecimal.ZERO);
                    money.setCurrency(DictHelper.getLocalCurrencyCode());
                    ticket.setBaseFare(money);
                }
                ticket.getBaseFare().setValue(BigDecimal.ZERO);
            }
        }
        batch.getTickets().add(ticket);
        if (!MCOCategory.NOT_SOLD_SEATS.equals((Object)ticket.getMcoCategory())) {
            this.updateTicketRegistryLetterData(ticket, batch.getBatchId(), data);
        }
    }

    private BigDecimal getDecreasedTaxesAmount(Collection<Tax> curTaxes, Collection<Tax> prevTaxes) {
        BigDecimal val;
        BigDecimal res = BigDecimal.ZERO;
        HashMap<String, BigDecimal> curTaxesMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> prevTaxesMap = new HashMap<String, BigDecimal>();
        for (Tax tax : curTaxes) {
            if (tax.getClass() == null || tax.getEquivalentAmount() == null) continue;
            val = (BigDecimal)curTaxesMap.get(tax.getCode());
            if (val == null) {
                curTaxesMap.put(tax.getCode(), tax.getEquivalentAmount());
                continue;
            }
            curTaxesMap.put(tax.getCode(), val.add(tax.getEquivalentAmount()));
        }
        for (Tax tax : prevTaxes) {
            if (tax.getClass() == null || tax.getEquivalentAmount() == null) continue;
            val = (BigDecimal)prevTaxesMap.get(tax.getCode());
            if (val == null) {
                prevTaxesMap.put(tax.getCode(), tax.getEquivalentAmount());
                continue;
            }
            prevTaxesMap.put(tax.getCode(), val.add(tax.getEquivalentAmount()));
        }
        for (Map.Entry entry : prevTaxesMap.entrySet()) {
            if (!curTaxesMap.keySet().contains(entry.getKey())) {
                res = res.add((BigDecimal)entry.getValue());
                continue;
            }
            if (((BigDecimal)entry.getValue()).compareTo((BigDecimal)curTaxesMap.get(entry.getKey())) <= 0) continue;
            res = res.add(((BigDecimal)entry.getValue()).subtract((BigDecimal)curTaxesMap.get(entry.getKey())));
        }
        return res;
    }
}

