/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.salesreports.subagent.vip.tch;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.BaseReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportBatchData;
import com.gridnine.xtrip.common.reports.render.salesreports.subagent.vip.tch.TchVipReportRenderHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.subagent.vip.tch.TchVipReportSettingsHelper;
import com.gridnine.xtrip.common.reports.render.salesreports.subagent.vip.tch.TchVipSummaryData;
import com.gridnine.xtrip.common.reports.render.salesreports.subagent.vip.tch.TchVipTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.TchTicket;
import com.gridnine.xtrip.server.reports.prepare.salesreports.BaseSalesReportPrepareHandler;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TchVipSalesReportPrepareHandler
extends BaseSalesReportPrepareHandler<TchTicket> {
    @Override
    public String getId() {
        return "tch-vip-sales-report";
    }

    @Override
    protected MetadataKey getAgencyReportCode(BaseReportParameters params) {
        return MetadataKey.KEY_TCH_AGENCY_CODE;
    }

    @Override
    protected void putGlobalData(Map<String, Object> data, List<Message> messages) throws Exception {
        super.putGlobalData(data, messages);
        ArrayList<ReportBatchData> batchDataList = new ArrayList<ReportBatchData>();
        data.put("key-batch-data-list", batchDataList);
        for (TchVipReportRenderHandler.Definition item : TchVipReportRenderHandler.Definition.values()) {
            ReportBatchData batch = new ReportBatchData();
            batch.setBatchId(item.name());
            batchDataList.add(batch);
        }
        data.put("TCH_VIP_MVL_SUMMARY_DATA", new TchVipSummaryData());
        data.put("TCH_VIP_VVL_SUMMARY_DATA", new TchVipSummaryData());
    }

    @Override
    protected void addProductProxyTicket(Product product, Map<String, Object> data, List<Message> messages) throws Exception {
        if (product.getStatus() == null) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.TchVipSalesReportPrepareHandler_ticketNoState, (Object[])new Object[]{product.getSystemNumber()}));
            return;
        }
        if (product.getStatus() == ProductStatus.EXCHANGE) {
            return;
        }
        TchVipTicket ticket = new TchVipTicket(product, messages);
        if (ticket.isMvl()) {
            this.getBatch(TchVipReportRenderHandler.Definition.REGISTRY_MVL.name(), data).getTickets().add(ticket);
            this.getBatch(TchVipReportRenderHandler.Definition.SUMMARY_MVL.name(), data).getTickets().add(ticket);
            return;
        }
        this.getBatch(TchVipReportRenderHandler.Definition.REGISTRY_VVL.name(), data).getTickets().add(ticket);
        this.getBatch(TchVipReportRenderHandler.Definition.SUMMARY_VVL.name(), data).getTickets().add(ticket);
    }

    private ReportBatchData<TchVipTicket> getBatch(String batchId, Map<String, Object> data) {
        List batchDataList = (List)data.get("key-batch-data-list");
        for (ReportBatchData item : batchDataList) {
            if (!item.getBatchId().equals(batchId)) continue;
            return item;
        }
        throw new IllegalStateException(L10nResourcesManager.getStr((String)(Messages.TchVipSalesReportPrepareHandler_internalError + batchId), (Object[])new Object[0]));
    }

    @Override
    protected void afterFillDataLists(Map<String, Object> data, List<Message> messages) throws Exception {
        super.afterFillDataLists(data, messages);
        this.updateSummaryData((TchVipSummaryData)data.get("TCH_VIP_MVL_SUMMARY_DATA"), this.getBatch(TchVipReportRenderHandler.Definition.REGISTRY_MVL.name(), data).getTickets());
        this.updateSummaryData((TchVipSummaryData)data.get("TCH_VIP_VVL_SUMMARY_DATA"), this.getBatch(TchVipReportRenderHandler.Definition.REGISTRY_VVL.name(), data).getTickets());
    }

    private void updateSummaryData(TchVipSummaryData summaryData, List<TchVipTicket> tickets) {
        int airBlanksCount = 0;
        int mcoBlanksCount = 0;
        for (TchVipTicket ticket : tickets) {
            if (ticket.getStatus() != ProductStatus.SELL && ticket.getStatus() != ProductStatus.EXCHANGE) continue;
            if (ticket.getProductCategory() == ProductCategory.AIR || ticket.getMcoCategory() == MCOCategory.PTA) {
                ++airBlanksCount;
                continue;
            }
            ++mcoBlanksCount;
        }
        summaryData.setBlankCount(mcoBlanksCount + airBlanksCount);
        summaryData.setSumForBlanks(BigDecimal.valueOf(mcoBlanksCount).multiply(BigDecimal.valueOf(TchVipReportSettingsHelper.getSumForMCOBlanks())).add(BigDecimal.valueOf(airBlanksCount).multiply(BigDecimal.valueOf(TchVipReportSettingsHelper.getSumForAirBlanks()))));
    }
}

