/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.salesreports.tch;

import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProduct;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductIndex;
import com.gridnine.xtrip.common.model.booking.air.AirProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ManagerType;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileDao;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.BaseReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportBatchData;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.salesreports.SalesReportHelper;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.TchSubsidizedTariffRegistryTicketsBatch;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.TchTicket;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.handlers.rules.TchRulesHelper;
import com.gridnine.xtrip.server.reports.prepare.salesreports.BaseSalesReportPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.salesreports.SalesReportPrepareHelper;
import com.gridnine.xtrip.server.reports.prepare.salesreports.tch.TchSubsidizedTariffsReportPrepareHandler;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class TchSalesReportPrepareHandler
extends BaseSalesReportPrepareHandler<TchTicket> {
    @Override
    protected void addProductProxyTicket(Product product, Map<String, Object> data, List<Message> messages) throws Exception {
        this.addTicket(product, data, messages);
    }

    private void addTicket(Product product, Map<String, Object> data, List<Message> messages) throws Exception {
        boolean addToPKList;
        boolean addToCCList;
        boolean addToCashList;
        TchTicket ticket = new TchTicket(product, messages);
        ProductStatus status = ticket.getStatus();
        if (status == null) {
            SystemHelper.addMessage(messages, (String)Messages.TchSalesReportPrepareHandler_productStatusUndefined, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{product.getSystemNumber()});
            return;
        }
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        boolean canBeIncludedInFinanceReport = true;
        boolean canBeIncludedInRegistries = true;
        Calendar cal = Calendar.getInstance();
        cal.setTime(params.getPeriodBegin());
        if (!product.isEticket() && cal.get(1) >= 2015) {
            Date reportDate = this.getReportDate(product);
            canBeIncludedInFinanceReport = MiscUtil.compare((Date)reportDate, (Date)params.getPeriodBegin()) < 0;
            canBeIncludedInRegistries = MiscUtil.compare((Date)reportDate, (Date)params.getPeriodBegin()) >= 0;
        }
        boolean mcoInfo = ticket.getProductCategory() == ProductCategory.MCO && ticket.getMcoCategory() == MCOCategory.INFORMATION;
        boolean isVoid = status == ProductStatus.VOID || mcoInfo || ("99A".equals(ticket.getCarrierNumber()) || "99\u0410".equals(ticket.getCarrierNumber())) && !ticket.isFakeProduct() && product.getSegmentTariffs().size() > 1;
        HashSet fops = new HashSet(ticket.getFops());
        if (mcoInfo) {
            fops.addAll(ticket.getRelatedProductFops());
        }
        boolean bl = addToCashList = !isVoid && (SalesReportHelper.isHasFop(fops, (PaymentType)PaymentType.CASH) || SalesReportHelper.isHasFop(fops, (PaymentType)PaymentType.INVOICE) || SalesReportHelper.isHasFop(fops, (PaymentType)PaymentType.MTD) || SalesReportHelper.isHasFop(fops, (PaymentType)PaymentType.PTA)) || SalesReportHelper.isHasFop(fops, (PaymentType)PaymentType.CREDIT);
        if (addToCashList && canBeIncludedInFinanceReport) {
            this.addTicket(data, ticket, "CASH");
        }
        boolean bl2 = addToCCList = !isVoid && SalesReportHelper.isHasFop(fops, (PaymentType)PaymentType.CREDIT_CARD);
        if (addToCCList && canBeIncludedInFinanceReport) {
            if (ticket.getCardVendor() == null) {
                SystemHelper.addMessage(messages, (String)Messages.TchSalesReportPrepareHandler_productNoCardVendorVisaUsed, null, (MessageType)MessageType.WARNING, (Object[])new Object[]{ticket.getTicketNumber()});
                this.log.debug("Ticket " + ticket.getTicketNumber() + " does not have Card Organization. Visa will be used");
                ticket.setCardVendor(CardVendor.VISA);
            }
            if (MiscUtil.guarded((BigDecimal)MiscUtil.sum((BigDecimal[])new BigDecimal[]{ticket.getFareCC(), ticket.getXtTaxCC(), ticket.getTchTaxCC()})).compareTo(BigDecimal.ZERO) != 0) {
                data.put("key-is-has-cc", Boolean.TRUE);
            }
            this.addTicket(data, ticket, "CC");
        }
        boolean bl3 = addToPKList = !isVoid && (SalesReportHelper.isHasFop(fops, (PaymentType)PaymentType.CREDIT_CARD_TCH) || BigDecimal.ZERO.compareTo(ticket.getPkClientFeeEquivalentValue()) != 0);
        if (addToPKList && canBeIncludedInFinanceReport) {
            if (ticket.getCardVendor() == null) {
                SystemHelper.addMessage(messages, (String)Messages.TchSalesReportPrepareHandler_productNoCardVendorVisaUsed, null, (MessageType)MessageType.WARNING, (Object[])new Object[]{ticket.getTicketNumber()});
                this.log.debug("Ticket " + ticket.getTicketNumber() + " does not have Card Organization. Visa will be used");
                ticket.setCardVendor(CardVendor.VISA);
            }
            data.put("key-is-has-pk", Boolean.TRUE);
            this.addTicket(data, ticket, "PK");
        }
        if (!(addToCashList || isVoid || addToCCList || addToPKList)) {
            SystemHelper.addMessage(messages, (String)Messages.TchSalesReportPrepareHandler_productTicketNotVoidNotIncludedCredit, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{ticket.getTicketNumber()});
            this.log.debug("Ticket " + ticket.getTicketNumber() + " is not void but is not included in CreditCard or Cash lists");
        }
        if (ticket.isFakeProduct()) {
            return;
        }
        if (product.isEticket() && !this.isAppropriateEticket(product, ticket)) {
            return;
        }
        if (!canBeIncludedInRegistries) {
            return;
        }
        switch (status) {
            case SELL: {
                String[] conjunctions;
                this.addTicket(data, ticket, "PACK");
                for (String ticketNo : conjunctions = ticket.getConjunctions()) {
                    TchTicket caTicket = new TchTicket(product, messages);
                    caTicket.setTicketNumber(ticketNo);
                    caTicket.setConjunctedTicket(true);
                    this.addTicket(data, caTicket, "PACK");
                }
                break;
            }
            case EXCHANGE: {
                boolean firstTicket = true;
                String relatedTicketNo = null;
                for (int n = 0; n < product.getSegmentTariffs().size(); ++n) {
                    TchTicket caTicket;
                    if (firstTicket) {
                        caTicket = new TchTicket(product, messages);
                        relatedTicketNo = caTicket.getRelatedTicketNo();
                        firstTicket = false;
                    } else {
                        caTicket = new TchTicket(product, messages);
                        caTicket.setAdditionalSegment(true);
                        caTicket.setRelatedTicketNo(relatedTicketNo);
                    }
                    caTicket.setTicketNumber(product.getSystemNumber());
                    caTicket.setStatus(ProductStatus.EXCHANGE);
                    this.addTicket(data, caTicket, "PACK");
                }
                break;
            }
            case REFUND: {
                if (product.getProductCategory() == ProductCategory.MCO && product.getSegmentTariffs().isEmpty()) {
                    TchTicket caTicket = new TchTicket(product, messages);
                    caTicket.setTicketNumber(product.getSystemNumber());
                    caTicket.setStatus(ProductStatus.REFUND);
                    this.addTicket(data, caTicket, "PACK");
                    break;
                }
                for (int n = 0; n < product.getSegmentTariffs().size(); ++n) {
                    TchTicket caTicket;
                    if (n == 0) {
                        caTicket = new TchTicket(product, messages);
                    } else {
                        caTicket = new TchTicket(product, messages);
                        caTicket.setAdditionalSegment(true);
                    }
                    caTicket.setTicketNumber(product.getSystemNumber());
                    caTicket.setStatus(ProductStatus.REFUND);
                    this.addTicket(data, caTicket, "PACK");
                }
                break;
            }
            case VOID: {
                ticket.setStatus(ProductStatus.VOID);
                this.addTicket(data, ticket, "PACK");
                break;
            }
        }
    }

    private boolean isAppropriateEticket(Product product, TchTicket ticket) {
        ProductCategory productCategory = product.getProductCategory();
        ProductStatus status = product.getStatus();
        if (status == null || productCategory == null) {
            return false;
        }
        if (SalesReportHelper.isHasFop((Collection)ticket.getFops(), (PaymentType)PaymentType.CREDIT_CARD)) {
            return true;
        }
        if (SalesReportHelper.isHasFop((Collection)ticket.getFops(), (PaymentType)PaymentType.CREDIT_CARD_TCH) || BigDecimal.ZERO.compareTo(ticket.getPkClientFeeEquivalentValue()) != 0) {
            return true;
        }
        if (product.isSubsidizedTariff()) {
            return true;
        }
        if (product.isContainsReturnFareDifferenceData()) {
            return true;
        }
        if (productCategory == ProductCategory.MCO) {
            MCOCategory mcoCategory = product.getMcoCategory();
            if (mcoCategory == MCOCategory.PENALTY || mcoCategory == MCOCategory.INFORMATION) {
                Product relProd = AirProductHelper.findRelatedAirProduct((Product)product, (ProductStatus)ProductStatus.REFUND, (boolean)false);
                if (relProd != null) {
                    return SalesReportHelper.isHasFop((Collection)AirProductHelper.getVendorFops((Product)relProd), (PaymentType)PaymentType.CREDIT_CARD) || SalesReportHelper.isHasFop((Collection)AirProductHelper.getVendorFops((Product)relProd), (PaymentType)PaymentType.CREDIT_CARD_TCH);
                }
                relProd = AirProductHelper.findRelatedAirProduct((Product)product, (ProductStatus)ProductStatus.EXCHANGE, (boolean)false);
                if (relProd != null) {
                    return relProd.getNextProduct() != null && (SalesReportHelper.isHasFop((Collection)AirProductHelper.getVendorFops((Product)relProd.getNextProduct()), (PaymentType)PaymentType.CREDIT_CARD) || SalesReportHelper.isHasFop((Collection)AirProductHelper.getVendorFops((Product)relProd.getNextProduct()), (PaymentType)PaymentType.CREDIT_CARD_TCH));
                }
            }
            return false;
        }
        if (productCategory != ProductCategory.AIR) {
            return false;
        }
        if (status == ProductStatus.EXCHANGE) {
            return product.getNextProduct() != null && (SalesReportHelper.isHasFop((Collection)AirProductHelper.getVendorFops((Product)product.getNextProduct()), (PaymentType)PaymentType.CREDIT_CARD) || SalesReportHelper.isHasFop((Collection)AirProductHelper.getVendorFops((Product)product.getNextProduct()), (PaymentType)PaymentType.CREDIT_CARD_TCH));
        }
        return SalesReportHelper.isHasFop((Collection)ticket.getFops(), (PaymentType)PaymentType.CREDIT);
    }

    private void addTicket(Map<String, Object> data, TchTicket ticket, String batchId) {
        ArrayList<ReportBatchData> batchDataList = (ArrayList<ReportBatchData>)data.get("key-batch-data-list");
        if (batchDataList == null) {
            batchDataList = new ArrayList<ReportBatchData>();
            ReportBatchData cashList = new ReportBatchData();
            cashList.setBatchId("CASH");
            batchDataList.add(cashList);
            ReportBatchData ccList = new ReportBatchData();
            ccList.setBatchId("CC");
            batchDataList.add(ccList);
            ReportBatchData pkList = new ReportBatchData();
            pkList.setBatchId("PK");
            batchDataList.add(pkList);
            ReportBatchData packList = new ReportBatchData();
            packList.setBatchId("PACK");
            batchDataList.add(packList);
            ReportBatchData summaryList = new ReportBatchData();
            summaryList.setBatchId("SUMMARY");
            batchDataList.add(summaryList);
            data.put("key-batch-data-list", batchDataList);
        }
        for (ReportBatchData batchData : batchDataList) {
            if (!batchData.getBatchId().equals(batchId)) continue;
            batchData.getTickets().add(ticket);
            return;
        }
    }

    @Override
    protected void validateProductToReport(Product product, Map<String, Object> data, List<Message> messages) throws Exception {
        super.validateProductToReport(product, data, messages);
        DictionaryCache dcache = DictionaryCache.get();
        if (product.getStatus() == ProductStatus.VOID && !product.isEticket() && (product.getScns().isEmpty() || TextUtil.isBlank((String)((String)product.getScns().get(0))))) {
            SystemHelper.addMessage(messages, (String)Messages.TchSalesReportPrepareHandler_productIsVOIDnotHaveScn, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{product.getSystemNumber()});
        }
        if (product.getStatus() == ProductStatus.VOID) {
            return;
        }
        MCOCategory mcoCategory = product.getMcoCategory();
        ProductCategory productCategory = product.getProductCategory();
        if (productCategory == ProductCategory.AIR || productCategory == ProductCategory.EXCESS_BAGAGE || productCategory == ProductCategory.MCO && (mcoCategory == MCOCategory.PENALTY || mcoCategory == MCOCategory.PTA)) {
            List vendorFops;
            if (!this.isGeneralCode(product.getCarrierNumber()) && dcache.resolveReference(product.getCarrier()) == null || TextUtil.isBlank((String)product.getCarrierNumber())) {
                SystemHelper.addMessage(messages, (String)Messages.TchSalesReportPrepareHandler_productCarrierAbsent, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{product.getSystemNumber()});
                this.log.error("Product " + product.getSystemNumber() + ": carrier is absent");
            }
            if (product.getBlankOwnerRef() == null) {
                SystemHelper.addMessage(messages, (String)Messages.TchSalesReportPrepareHandler_productBlankOwnerAbsent, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{product.getSystemNumber()});
                this.log.error("Product " + product.getSystemNumber() + ": blank owner is absent");
            }
            if (!(SalesReportHelper.isHasFop((Collection)(vendorFops = AirProductHelper.getVendorFops((Product)product)), (PaymentType)PaymentType.CASH) || SalesReportHelper.isHasFop((Collection)vendorFops, (PaymentType)PaymentType.INVOICE) || SalesReportHelper.isHasFop((Collection)vendorFops, (PaymentType)PaymentType.PTA) || SalesReportHelper.isHasFop((Collection)vendorFops, (PaymentType)PaymentType.TICKET) || SalesReportHelper.isHasFop((Collection)vendorFops, (PaymentType)PaymentType.CREDIT) || SalesReportHelper.isHasFop((Collection)vendorFops, (PaymentType)PaymentType.CREDIT_CARD) || SalesReportHelper.isHasFop((Collection)vendorFops, (PaymentType)PaymentType.CREDIT_CARD_TCH) || SalesReportHelper.isHasFop((Collection)vendorFops, (PaymentType)PaymentType.MTD))) {
                SystemHelper.addMessage(messages, (String)Messages.TchSalesReportPrepareHandler_productNoAppropriateFop, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{product.getSystemNumber()});
                this.log.error("Product " + product.getSystemNumber() + ": has no appropriate fop");
            }
            if (vendorFops.size() > 1 && SalesReportHelper.isHasFop((Collection)AirProductHelper.getVendorContractRelation((Product)product).getFops(), (PaymentType)PaymentType.PTA)) {
                SystemHelper.addMessage(messages, (String)Messages.TchSalesReportPrepareHandler_productPTAFOP, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{product.getSystemNumber(), vendorFops.size()});
            }
            for (ProductFop fop : vendorFops) {
                if (fop.getType() != null) continue;
                SystemHelper.addMessage(messages, (String)Messages.TchSalesReportPrepareHandler_productFopTypeError, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{product.getSystemNumber()});
                break;
            }
            for (SegmentTariff st : product.getSegmentTariffs()) {
                for (Segment seg : st.getSegments()) {
                    String arrCode;
                    GeoLocation arr;
                    String depCode;
                    GeoLocation dep;
                    DictionaryReference acref = seg.getAirline();
                    Airline ac = (Airline)dcache.resolveReference(acref);
                    if (ac == null) {
                        SystemHelper.addMessage(messages, (String)Messages.TchSalesReportPrepareHandler_productResolveSegmentCarrier, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{product.getSystemNumber(), acref != null ? acref.getCode() : "no code"});
                    }
                    if ((dep = DictHelper.findCityByAirport((String)(depCode = seg.getDepartureLocation() != null ? seg.getDepartureLocation().getCode() : null))) == null) {
                        SystemHelper.addMessage(messages, (String)Messages.TchSalesReportPrepareHandler_productResolveDepartureCity, null, (MessageType)MessageType.WARNING, (Object[])new Object[]{product.getSystemNumber(), depCode != null ? depCode : "no code"});
                    }
                    if ((arr = DictHelper.findCityByAirport((String)(arrCode = seg.getArriveLocation() != null ? seg.getArriveLocation().getCode() : null))) != null) continue;
                    SystemHelper.addMessage(messages, (String)Messages.TchSalesReportPrepareHandler_productResolveArrivalCity, null, (MessageType)MessageType.WARNING, (Object[])new Object[]{product.getSystemNumber(), arrCode != null ? arrCode : "no code"});
                }
            }
        }
    }

    private boolean isGeneralCode(String carrierNumber) {
        if (TextUtil.isBlank((String)carrierNumber)) {
            return false;
        }
        return carrierNumber.matches("(99A)|(99\u0410)|([0-9]{1}[1-9]{1}[C-T]{1})|([0-9]{1}[1-9]{1}[\u0421,\u0414,\u0415,\u0416,\u0417,\u041a,\u041b,\u041c,\u041d,\u041e,\u041f,\u0420,\u0421,\u0422]{1})");
    }

    @Override
    public String getId() {
        return "tch-sales-report";
    }

    @Override
    protected Set<Product> getData(Map<String, Object> data, List<Message> messages) throws Exception {
        ReportParameters params;
        ReportParameters correctedParams = params = (ReportParameters)data.get("key-report-params");
        boolean includePrintedTicketsInReport = TchTicket.isIncludePrintedTicketsInReport((ReportParameters)params);
        if (includePrintedTicketsInReport) {
            correctedParams = new ReportParameters();
            XCloneModelHelper.copy((BaseEntity)params, (BaseEntity)correctedParams);
            Date periodBegin = correctedParams.getPeriodBegin();
            Calendar cal = Calendar.getInstance();
            cal.setTime(periodBegin);
            cal.add(5, -1);
            int date = cal.get(5);
            if (date <= 31 && date > 20) {
                cal.set(5, 21);
            } else if (date <= 21 && date > 10) {
                cal.set(5, 11);
            } else {
                cal.set(5, 1);
            }
            periodBegin = MiscUtil.clearTime((Date)cal.getTime());
            correctedParams.setPeriodBegin(periodBegin);
        }
        Set<Product> products = SalesReportPrepareHelper.getProducts(SalesReportPrepareHelper.createQuery(correctedParams, false, params.getDatePropertyName()), messages);
        Iterator<Product> it = products.iterator();
        while (it.hasNext()) {
            Product prod = it.next();
            if (!ProductStatusHandler.getAllVoidStatuses().contains(prod.getStatus()) || !prod.isEticket()) continue;
            it.remove();
        }
        if (includePrintedTicketsInReport) {
            it = products.iterator();
            while (it.hasNext()) {
                Product product = it.next();
                Date date = this.getReportDate(product);
                if (!product.isEticket() || MiscUtil.compare((Date)params.getPeriodBegin(), (Date)date) <= 0) continue;
                it.remove();
            }
        }
        HashSet<Product> result = new HashSet<Product>();
        for (Product prod : products) {
            result.add(prod);
            if (!"99A".equals(prod.getCarrierNumber()) && !"99\u0410".equals(prod.getCarrierNumber()) || prod.getSegmentTariffs().size() <= 1) continue;
            ArrayList lst = new ArrayList();
            TchRulesHelper.virtualize((Product)prod, lst);
            boolean first = true;
            for (Product product : lst) {
                if (prod == product) continue;
                AirProductHelper.clearCommissions((Product)product);
                DictionaryReference airlineRef = null;
                block4: for (SegmentTariff st : product.getSegmentTariffs()) {
                    for (Segment seg : st.getSegments()) {
                        DictionaryReference airline = seg.getAirline();
                        if (airline == null) continue;
                        airlineRef = airline;
                        break block4;
                    }
                }
                if (airlineRef == null) {
                    SystemHelper.addMessage(messages, (String)Messages.TchSalesReportPrepareHandler_ticketCantGetSegmentAir, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{product.getSystemNumber()});
                }
                TchSalesReportPrepareHandler.copyCommissions(product, prod, airlineRef, first, messages);
                result.add(product);
                first = false;
            }
        }
        if (result.isEmpty()) {
            SystemHelper.addMessage(messages, (String)Messages.reportNoTicket, null, (MessageType)MessageType.WARNING, (Object[])new Object[0]);
            this.log.warn("There are no tickets in the report");
        }
        return result;
    }

    private Date getReportDate(Product product) {
        for (ProductFop item : AirProductHelper.getVendorFops((Product)product)) {
            if (item.getOperationDate() == null) continue;
            return item.getOperationDate();
        }
        return product.getIssueDate();
    }

    public static void copyCommissions(Product target, Product source, DictionaryReference<Airline> airlineRef, boolean first, List<Message> messages) {
        for (AirProductContractRelationData relation : AirProductHelper.getContractRelations((Product)target)) {
            relation.getCommissions().clear();
            AirProductContractRelationData sourceRelation = AirProductHelper.findContractRelation((List)AirProductHelper.getContractRelations((Product)source), (EntityReference)relation.getDescription());
            if (sourceRelation == null) continue;
            block1: for (Commission comm : sourceRelation.getCommissions()) {
                if (comm.getSegmentTariff() == null) {
                    SystemHelper.addMessage(messages, (String)Messages.TchSalesReportPrepareHandler_ticketCantFindCommittee, null, (MessageType)MessageType.WARNING, (Object[])new Object[]{source.getSystemNumber(), airlineRef});
                    if (!first) continue;
                    relation.getCommissions().add(comm);
                    continue;
                }
                for (Segment seg : comm.getSegmentTariff().getSegments()) {
                    if (!airlineRef.equals((Object)seg.getAirline())) continue;
                    relation.getCommissions().add(comm);
                    continue block1;
                }
            }
        }
    }

    @Override
    protected MetadataKey getAgencyReportCode(BaseReportParameters params) {
        return MetadataKey.KEY_TCH_AGENCY_CODE;
    }

    @Override
    protected void putGlobalData(Map<String, Object> data, List<Message> messages) throws Exception {
        super.putGlobalData(data, messages);
        EntityContainer ctr = EntityStorage.get().resolve(((ReportParameters)data.get("key-report-params")).getAgency());
        if (ctr != null) {
            String tchAgencyCode = SystemHelper.findMetadataAsString((Collection)((Organization)ctr.getEntity()).getMetadata(), (MetadataKey)MetadataKey.KEY_TCH_AGENCY_CODE);
            data.put("key-tch-agency-code", tchAgencyCode);
            EntityReference agencyReference = ctr.toReference();
            List employees = ProfileDao.getEmployees((EntityReference)agencyReference, (ManagerType[])new ManagerType[0], (Date)new Date());
            for (Person employee : employees) {
                String fullName = ProfileHelper.getFullName((Person)employee, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false, (boolean)true);
                Set standardPositions = ProfileHelper.getStandardPositions((List)employee.getEmployments(), (EntityReference)agencyReference);
                for (ManagerType standardPosition : standardPositions) {
                    if (standardPosition == ManagerType.DIRECTOR) {
                        data.put("AGENCY_DIRECTOR", fullName);
                        continue;
                    }
                    if (standardPosition != ManagerType.CHIEF_ACCOUNTANT) continue;
                    data.put("AGENCY_ACCOUNTANT", fullName);
                }
            }
        }
    }

    @Override
    public void prepareData(Map<String, Object> data) throws Exception {
        super.prepareData(data);
        List<TchSubsidizedTariffRegistryTicketsBatch> batches = new TchSubsidizedTariffsReportPrepareHandler().prepareBatches(new TchSubsidizedTariffsReportPrepareHandler.TchSubsidizedReportParameters((ReportParameters)data.get("key-report-params"), (String)data.get("AGENCY_DIRECTOR"), (String)data.get("AGENCY_PHONE"), (String)data.get("key-tch-agency-code")), (List)data.get("key-messages"));
        data.put("key-subsidized-registry-batches", batches);
        if (data.get("key-batch-data-list") == null) {
            SystemHelper.addMessage((Collection)((List)data.get("key-messages")), (String)Messages.reportNoTicket, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
        }
    }

    @Override
    protected Collection<? extends AgencyMemoProduct> getAgencyMemoProductData(Map<String, Object> data, List<Message> messages) throws Exception {
        ReportParameters parameters = (ReportParameters)data.get("key-report-params");
        EntityStorage entityStorage = EntityStorage.get();
        Date periodBegin = parameters.getPeriodBegin();
        Date periodEnd = parameters.getPeriodEnd();
        EntityReference blankOwnerReference = parameters.getBlankOwner();
        EntityReference supplierReference = parameters.getSupplier();
        EntityReference agencyReference = parameters.getAgency();
        SearchQuery query = new SearchQuery();
        if (periodBegin != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.ge((String)AgencyMemoProductIndex.Property.targetReportDate.name(), (Object)MiscUtil.clearTime((Date)periodBegin)));
        }
        if (periodEnd != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.le((String)AgencyMemoProductIndex.Property.targetReportDate.name(), (Object)MiscUtil.setDayEndTime((Date)periodEnd)));
        }
        if (blankOwnerReference != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)AgencyMemoProductIndex.Property.blankOwner.name(), (Object)blankOwnerReference));
        }
        if (supplierReference != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)AgencyMemoProductIndex.Property.supplier.name(), (Object)supplierReference));
        }
        if (agencyReference != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)AgencyMemoProductIndex.Property.agency.name(), (Object)agencyReference));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)AgencyMemoProductIndex.Property.includeToReport.name(), (Object)Boolean.TRUE));
        List agencyMemoProductIndexes = entityStorage.search(AgencyMemoProductIndex.class, query).getData();
        HashMap<EntityReference, ArrayList<String>> agencyMemoProductUids = new HashMap<EntityReference, ArrayList<String>>();
        for (AgencyMemoProductIndex agencyMemoProductIndex : agencyMemoProductIndexes) {
            EntityReference bookingFileReference = agencyMemoProductIndex.getSource();
            ArrayList<String> uids = (ArrayList<String>)agencyMemoProductUids.get(bookingFileReference);
            if (uids == null) {
                uids = new ArrayList<String>();
                agencyMemoProductUids.put(bookingFileReference, uids);
            }
            uids.add(agencyMemoProductIndex.getNavigationKey());
        }
        HashSet<AgencyMemoProduct> agencyMemoProducts = new HashSet<AgencyMemoProduct>();
        for (Map.Entry entry : agencyMemoProductUids.entrySet()) {
            EntityReference bookingFileReference = (EntityReference)entry.getKey();
            List uids = (List)entry.getValue();
            EntityContainer bookingFileContainer = entityStorage.resolve(bookingFileReference);
            if (bookingFileContainer == null) {
                SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_FailedLoadingEntity", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{"null"});
                this.log.debug("Unable to load booking file container " + bookingFileReference.getUid() + ". All agency memo products will be excluded from report.");
                continue;
            }
            for (String uid : uids) {
                AgencyMemoProduct agencyMemoProduct = (AgencyMemoProduct)BookingHelper.findProductByUid((String)uid, (BookingFile)((BookingFile)bookingFileContainer.getEntity()), AgencyMemoProduct.class);
                if (agencyMemoProduct == null) continue;
                agencyMemoProducts.add(agencyMemoProduct);
            }
        }
        return agencyMemoProducts;
    }

    @Override
    protected void addAgencyMemoProductProxyTicket(AgencyMemoProduct agencyMemo, Map<String, Object> data, List<Message> messages) throws Exception {
        TchTicket ticket = new TchTicket(agencyMemo, messages);
        this.addTicket(data, ticket, "CASH");
    }

    @Override
    protected void checkReportParameters(Map<String, Object> data, List<Message> messages) throws Exception {
        super.checkReportParameters(data, messages);
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        if (params.getPeriodBegin() == null || params.getPeriodEnd() == null) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u0430 \u0434\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u043b\u0438\u0431\u043e \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u043e\u0442\u0447\u0435\u0442\u043d\u043e\u0433\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430", (Object[])new Object[0]));
            return;
        }
        if (MiscUtil.compare((Date)params.getPeriodEnd(), (Date)params.getPeriodBegin()) <= 0) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u043d\u0435 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u043e\u0442\u0447\u0435\u0442\u043d\u043e\u0433\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430 \u043c\u0435\u043d\u044c\u0448\u0435 \u0434\u0430\u0442\u044b \u043d\u0430\u0447\u0430\u043b\u0430 \u043e\u0442\u0447\u0435\u0442\u043d\u043e\u0433\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430", (Object[])new Object[0]));
            return;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(params.getPeriodBegin());
        int startYear = cal.get(1);
        cal.setTime(params.getPeriodEnd());
        int endYear = cal.get(1);
        if (startYear >= 2015 && endYear < 2015) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0422\u041a\u041f \u043d\u0435 \u043f\u043e\u0437\u0432\u043e\u043b\u044f\u0435\u0442 \u0441\u043e\u0437\u0434\u0430\u0432\u0430\u0442\u044c \u043e\u0442\u0447\u0435\u0442\u044b, \u0432 \u043a\u043e\u0442\u043e\u0440\u043e\u043c \u0434\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u043e\u0442\u0447\u0435\u0442\u043d\u043e\u0433\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430 \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u0432 {0} \u0433 \u0430 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f - \u0432 {1} \u0433", (Object[])new Object[]{startYear, endYear}));
            return;
        }
        if (startYear >= 2015) {
            cal.setTime(params.getPeriodBegin());
            int startDay = cal.get(5);
            if (startDay != 1 && startDay != 11 && startDay != 21) {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0434\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u043e\u0442\u0447\u0435\u0442\u043d\u043e\u0433\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u0434\u043d\u0435\u043c \u043d\u0430\u0447\u0430\u043b\u0430 \u0434\u0435\u043a\u0430\u0434\u044b", (Object[])new Object[0]));
                return;
            }
        }
    }
}

