/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.salesreports.tch;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.PassengerTypeValue;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.ReportHelper;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.TchSubsidizedTariffRegistryTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.TchSubsidizedTariffRegistryTicketsBatch;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.reports.prepare.BaseReportPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.salesreports.SalesReportPrepareHelper;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class TchSubsidizedTariffsReportPrepareHandler {
    public List<TchSubsidizedTariffRegistryTicketsBatch> prepareBatches(TchSubsidizedReportParameters params, List<Message> messages) throws Exception {
        List<Product> products = this.getData(params.reportParameters, messages);
        if (ReportHelper.isHasErrors(messages)) {
            return null;
        }
        DecimalFormat df = new DecimalFormat("00");
        Calendar cal = Calendar.getInstance();
        cal.setTime(params.reportParameters.getPeriodBegin());
        String reportPeriodStr = String.format("\u0441 %s.%s", df.format(cal.get(5)), df.format(cal.get(2) + 1));
        cal.setTime(params.reportParameters.getPeriodEnd());
        reportPeriodStr = reportPeriodStr + String.format(" \u043f\u043e %s.%s", df.format(cal.get(5)), df.format(cal.get(2) + 1));
        this.sortProducts(products);
        ArrayList<TchSubsidizedTariffRegistryTicketsBatch> result = new ArrayList<TchSubsidizedTariffRegistryTicketsBatch>();
        for (Product prod : products) {
            BaseReportPrepareHandler.baseValidateProductToReport((BaseProduct)prod, messages);
            List<Product> vPproducts = this.virtualize(prod, messages);
            for (Product vProd : vPproducts) {
                this.addProductProxyTicket(vProd, result, params, reportPeriodStr, messages);
            }
        }
        return result;
    }

    private List<Product> virtualize(Product prod, List<Message> messages) {
        return Collections.singletonList(prod);
    }

    private List<Product> getData(ReportParameters params, List<Message> messages) throws Exception {
        EntityContainer ctr = EntityStorage.get().resolve(params.getBlankOwner());
        EntityReference tchRef = null;
        if (ctr != null) {
            if ("\u04281".equals(((Organization)ctr.getEntity()).getCode())) {
                tchRef = ctr.toReference();
            }
            if (tchRef == null && ((Organization)ctr.getEntity()).getAirline() != null && "\u04281".equals(((Organization)ctr.getEntity()).getAirline().getCode())) {
                tchRef = ctr.toReference();
            }
        }
        if (tchRef == null) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.TchSubsidizedTariffsReportPrepareHandler_blankOwner, (Object[])new Object[0]));
            return Collections.emptyList();
        }
        SearchQuery query = SalesReportPrepareHelper.createQuery(params);
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.subsidizedTariff.name(), (Object)Boolean.TRUE));
        return new ArrayList<Product>(SalesReportPrepareHelper.getProducts(query, messages));
    }

    private void addProductProxyTicket(Product product, List<TchSubsidizedTariffRegistryTicketsBatch> batches, TchSubsidizedReportParameters params, String reportPeriodStr, List<Message> messages) throws Exception {
        ArrayList tkts;
        Airline carrier;
        ArrayList<Object> tickets = new ArrayList<Object>();
        String ticketDescription = null;
        if (!TextUtil.isBlank((String)product.getSystemNumber())) {
            ticketDescription = AirProductHelper.getTicketNumber((Product)product);
        } else {
            ticketDescription = CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)product.getReservation());
            if (product.getTraveller() != null) {
                ticketDescription = ticketDescription + " " + product.getTraveller().getName();
            }
        }
        ticketDescription = ticketDescription + " " + DictHelper.getProductCategoryShortName((ProductCategory)product.getProductCategory());
        if (TextUtil.isBlank((String)product.getSystemNumber())) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.TchSubsidizedTariffsReportPrepareHandler_noTicketNumber, (Object[])new Object[]{ticketDescription}));
        }
        Date birthDate = null;
        Gender gender = null;
        String passengerFullName = null;
        String passengerPassportNumber = null;
        if (product.getTraveller() != null) {
            birthDate = product.getTraveller().getBirthday();
            if (birthDate == null) {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.TchSubsidizedTariffsReportPrepareHandler_toBirthDate, (Object[])new Object[]{ticketDescription}));
            }
            if ((gender = product.getTraveller().getGender()) == null) {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.TchSubsidizedTariffsReportPrepareHandler_noGender, (Object[])new Object[]{ticketDescription}));
            }
            if (TextUtil.isBlank((String)(passengerFullName = product.getTraveller().getName()))) {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.TchSubsidizedTariffsReportPrepareHandler_noFullName, (Object[])new Object[]{ticketDescription}));
            }
            if (product.getTraveller().getPassport() != null) {
                passengerPassportNumber = product.getTraveller().getPassport().getNumber();
                if (TextUtil.isBlank((String)passengerPassportNumber)) {
                    messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.TchSubsidizedTariffsReportPrepareHandler_noPassportNumber, (Object[])new Object[]{ticketDescription}));
                }
            } else {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.TchSubsidizedTariffsReportPrepareHandler_noPassport, (Object[])new Object[]{ticketDescription}));
            }
        } else {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.TchSubsidizedTariffsReportPrepareHandler_noPassenger, (Object[])new Object[]{ticketDescription}));
        }
        DictionaryReference issueCity = null;
        EntityContainer salesPointCtr = EntityStorage.get().resolve(product.getSalesPoint());
        if (salesPointCtr != null) {
            for (Address address : ((SalesPoint)salesPointCtr.getEntity()).getAddresses()) {
                if (address.getCity() == null) continue;
                issueCity = address.getCity();
                break;
            }
        }
        if (issueCity == null) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.TchSubsidizedTariffsReportPrepareHandler_noPointSales, (Object[])new Object[]{ticketDescription}));
        }
        TchSubsidizedTariffRegistryTicket.TchPassengerCategory passengerCategory = null;
        PassengerTypeValue ptv = DictHelper.getPassengerTypeValue((DictionaryReference)product.getPassengerType());
        if (ptv != null) {
            switch (ptv) {
                case INFANT: {
                    passengerCategory = TchSubsidizedTariffRegistryTicket.TchPassengerCategory.CHILD_WITHOUT_SEAT;
                    break;
                }
                case CHILD_UNACCOMPANIED: 
                case CHILD: 
                case INFANT_WITH_SITE: {
                    passengerCategory = TchSubsidizedTariffRegistryTicket.TchPassengerCategory.CHILD_WITHOUT_SEAT;
                    break;
                }
                default: {
                    passengerCategory = TchSubsidizedTariffRegistryTicket.TchPassengerCategory.ADULT;
                }
            }
        }
        if ((carrier = (Airline)DictionaryCache.get().resolveReference(product.getCarrier())) == null) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.TchSubsidizedTariffsReportPrepareHandler_noChargeCarrier, (Object[])new Object[]{ticketDescription}));
        }
        boolean hasKaliningrad = false;
        ArrayList segmentTariffs = new ArrayList();
        boolean refund = false;
        if (product.getMcoCategory() == MCOCategory.PENALTY) {
            Object relProd = AirProductHelper.findRelatedAirProduct((Product)product, (ProductStatus)ProductStatus.REFUND, (boolean)true);
            if (relProd == null) {
                relProd = AirProductHelper.findRelatedAirProduct((Product)product, (ProductStatus)ProductStatus.EXCHANGE, (boolean)true);
            }
            if (relProd != null) {
                segmentTariffs.addAll(relProd.getSegmentTariffs());
                refund = relProd.getStatus() == ProductStatus.REFUND;
            }
        } else {
            segmentTariffs.addAll(product.getSegmentTariffs());
            refund = product.getStatus() == ProductStatus.REFUND;
        }
        for (SegmentTariff st : segmentTariffs) {
            for (Segment seg : st.getSegments()) {
                DictionaryReference<GeoLocation> arrivalLoc;
                DictionaryReference<GeoLocation> departureLoc = this.findCity((DictionaryReference<GeoLocation>)seg.getDepartureLocation());
                if (departureLoc == null) {
                    messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.TchSubsidizedTariffsReportPrepareHandler_noOointDeparture, (Object[])new Object[]{ticketDescription, Integer.toString(seg.getRecordNumber())}));
                }
                if (departureLoc != null && departureLoc.getCode().equals("KGD")) {
                    hasKaliningrad = true;
                }
                if ((arrivalLoc = this.findCity((DictionaryReference<GeoLocation>)seg.getArriveLocation())) == null) {
                    messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.TchSubsidizedTariffsReportPrepareHandler_noArrivalPoint, (Object[])new Object[]{ticketDescription, Integer.toString(seg.getRecordNumber())}));
                }
                if (arrivalLoc == null || !arrivalLoc.getCode().equals("KGD")) continue;
                hasKaliningrad = true;
            }
        }
        TchSubsidizedTariffRegistryTicketsBatch.FlightType flightType = hasKaliningrad ? TchSubsidizedTariffRegistryTicketsBatch.FlightType.KALININGRAD : TchSubsidizedTariffRegistryTicketsBatch.FlightType.FAR_EAST;
        Date issueDate = product.getIssueDate();
        if (issueDate == null) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.TchSubsidizedTariffsReportPrepareHandler_noDateExtract, (Object[])new Object[]{ticketDescription}));
        }
        if (product.getMcoCategory() == MCOCategory.PENALTY) {
            TchSubsidizedTariffRegistryTicket ticket = new TchSubsidizedTariffRegistryTicket();
            ticket.setPassportNumber(passengerPassportNumber);
            ticket.setAgencyCode(params.agencyCode);
            ticket.setBirthDate(birthDate);
            ticket.setGender(gender);
            ticket.setIssueCity(issueCity);
            ticket.setIssueDate(issueDate);
            ticket.setPassengerFullName(passengerFullName);
            ticket.setPassengerCategory(passengerCategory);
            ticket.setSegmentEquivalentFare(AirProductHelper.getEquivalentFare((Product)product));
            ticket.setSystemNumber(product.getSystemNumber());
            ticket.setSegmentNumber(1);
            tickets.add(ticket);
        } else {
            for (Object st : product.getSegmentTariffs()) {
                boolean firstSegment = true;
                for (Segment seg : st.getSegments()) {
                    TchSubsidizedTariffRegistryTicket ticket = new TchSubsidizedTariffRegistryTicket();
                    ticket.setPassportNumber(passengerPassportNumber);
                    ticket.setAgencyCode(params.agencyCode);
                    ticket.setArrivalLocation(this.findCity((DictionaryReference<GeoLocation>)seg.getArriveLocation()));
                    ticket.setBirthDate(birthDate);
                    ticket.setDepartureLocation(this.findCity((DictionaryReference<GeoLocation>)seg.getDepartureLocation()));
                    ticket.setFareBasis(seg.getFareBasis());
                    if (TextUtil.isBlank((String)seg.getFareBasis())) {
                        messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.TchSubsidizedTariffsReportPrepareHandler_noTariffCode, (Object[])new Object[]{ticketDescription, Integer.toString(seg.getRecordNumber())}));
                    }
                    ticket.setFlightDate(seg.getStartDate());
                    if (seg.getStartDate() == null) {
                        messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.TchSubsidizedTariffsReportPrepareHandler_noDateDeparture, (Object[])new Object[]{ticketDescription, Integer.toString(seg.getRecordNumber())}));
                    }
                    ticket.setFlightNo(seg.getFlightNo());
                    if (TextUtil.isBlank((String)seg.getFlightNo())) {
                        messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.TchSubsidizedTariffsReportPrepareHandler_noFlightNumber, (Object[])new Object[]{ticketDescription, Integer.toString(seg.getRecordNumber())}));
                    }
                    ticket.setGender(gender);
                    ticket.setIssueCity(issueCity);
                    ticket.setIssueDate(issueDate);
                    ticket.setPassengerFullName(passengerFullName);
                    ticket.setPassengerCategory(passengerCategory);
                    BigDecimal segmentEquivalentFare = AirProductHelper.getSegmentEquivalentFare((Product)product, (SegmentTariff)st);
                    ticket.setSegmentEquivalentFare(firstSegment && segmentEquivalentFare != null ? segmentEquivalentFare : BigDecimal.valueOf(0L));
                    if (product.getStatus() == ProductStatus.EXCHANGE && segmentEquivalentFare != null) {
                        ticket.setSegmentEquivalentFare(ticket.getSegmentEquivalentFare().negate());
                    }
                    ticket.setSystemNumber(product.getSystemNumber());
                    ticket.setSegmentNumber(seg.getRecordNumber());
                    tickets.add(ticket);
                    firstSegment = false;
                }
            }
        }
        TchSubsidizedTariffRegistryTicketsBatch batch = null;
        for (TchSubsidizedTariffRegistryTicketsBatch item : batches) {
            if (item.isRefund() != refund || item.getFlightType() != flightType) continue;
            batch = item;
            break;
        }
        if (batch == null) {
            batch = new TchSubsidizedTariffRegistryTicketsBatch();
            batch.setRefund(refund);
            batch.setFlightType(flightType);
            batch.setDirector(params.director);
            batch.setPhone(params.phone);
            batch.setReportPeriod(reportPeriodStr);
            batches.add(batch);
        }
        if ((tkts = (ArrayList)batch.getSubBatches().get(product.getCarrier())) == null) {
            tkts = new ArrayList();
            batch.getSubBatches().put(product.getCarrier(), tkts);
        }
        tkts.addAll(tickets);
    }

    private DictionaryReference<GeoLocation> findCity(DictionaryReference<GeoLocation> locRef) {
        GeoLocation result = (GeoLocation)DictionaryCache.get().resolveReference(locRef);
        if (result == null) {
            return null;
        }
        if (result.getType() == LocationType.CITY) {
            return result.toReference();
        }
        return this.findCity((DictionaryReference<GeoLocation>)result.getParent());
    }

    private void sortProducts(List<Product> products) {
        Collections.sort(products, new Comparator<Product>(){

            @Override
            public int compare(Product o1, Product o2) {
                int res = this.getStatusIndex(o1) - this.getStatusIndex(o2);
                if (res != 0) {
                    return res;
                }
                res = TextUtil.compare((String)this.getCarrierCode(o1), (String)this.getCarrierCode(o2), (boolean)false, (boolean)false);
                if (res != 0) {
                    return res;
                }
                return TextUtil.compare((String)this.getSortNumber(o1), (String)this.getSortNumber(o2), (boolean)false, (boolean)false);
            }

            private String getCarrierCode(Product o1) {
                DictionaryReference ref = o1.getCarrier();
                if (ref == null) {
                    return null;
                }
                Airline airline = (Airline)DictionaryCache.get().resolveReference(ref);
                if (airline == null || airline.getCodeVariants().isEmpty()) {
                    return ref.getCode();
                }
                String code = (String)airline.getCodeVariants().get(CodeSystem.CRT.name());
                if (!TextUtil.isBlank((String)code)) {
                    return code;
                }
                return (String)airline.getCodeVariants().values().iterator().next();
            }

            private int getStatusIndex(Product o1) {
                if (o1.getMcoCategory() == MCOCategory.PENALTY) {
                    Product relProd = AirProductHelper.findRelatedAirProduct((Product)o1, (ProductStatus)ProductStatus.REFUND, (boolean)true);
                    return relProd != null && relProd.getStatus() == ProductStatus.REFUND ? 2 : 1;
                }
                return o1.getStatus() == ProductStatus.REFUND ? 2 : 1;
            }

            private String getSortNumber(Product prod) {
                if (prod.getMcoCategory() == MCOCategory.PENALTY) {
                    Product relProd = AirProductHelper.findRelatedAirProduct((Product)prod, (ProductStatus)ProductStatus.REFUND, (boolean)true);
                    if (relProd == null) {
                        relProd = AirProductHelper.findRelatedAirProduct((Product)prod, (ProductStatus)ProductStatus.EXCHANGE, (boolean)true);
                    }
                    return (relProd == null ? prod.getSystemNumber() : relProd.getSystemNumber()) + "_1";
                }
                if (prod.getStatus() == ProductStatus.EXCHANGE) {
                    return prod.getNextProduct().getSystemNumber() + "_1";
                }
                if (prod.getStatus() == ProductStatus.SELL && prod.getPreviousProduct() != null && prod.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE) {
                    return prod.getSystemNumber() + "_2";
                }
                return prod.getSystemNumber();
            }
        });
    }

    static final class TchSubsidizedReportParameters {
        final ReportParameters reportParameters;
        final String director;
        final String phone;
        final String agencyCode;

        TchSubsidizedReportParameters(ReportParameters reportParametersValue, String directorValue, String phoneValue, String agencyCodeValue) {
            this.reportParameters = reportParametersValue;
            this.director = directorValue;
            this.phone = phoneValue;
            this.agencyCode = agencyCodeValue;
        }
    }
}

