/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.salesreports.u6;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.ContractCustomerIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.BaseReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportBatchData;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuSalesReportBatchData;
import com.gridnine.xtrip.common.reports.render.salesreports.u6.U6SalesLuggageSummaryReportItem;
import com.gridnine.xtrip.common.reports.render.salesreports.u6.U6SalesReportTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.u6.U6SalesSummaryReportItem;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.reports.prepare.salesreports.su.BaseSuSalesReportPrepareHandler;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class U6SalesReportPrepareHandler
extends BaseSuSalesReportPrepareHandler {
    private ReportBatchData<U6SalesReportTicket> mlvCashSellBatchDataList = null;
    private ReportBatchData<U6SalesReportTicket> mvlRefundBatchDataList = null;
    private ReportBatchData<U6SalesReportTicket> mvlExchangeBatchDataList = null;
    private ReportBatchData<U6SalesReportTicket> mvlPenaltyBatchDataList = null;
    private ReportBatchData<U6SalesReportTicket> vvlCashSellBatchDataList = null;
    private ReportBatchData<U6SalesReportTicket> vvlRefundBatchDataList = null;
    private ReportBatchData<U6SalesReportTicket> vvlExchangeBatchDataList = null;
    private ReportBatchData<U6SalesReportTicket> vvlPenaltyBatchDataList = null;
    private ReportBatchData<U6SalesReportTicket> crimeaCashSellBatchDataList = null;
    private ReportBatchData<U6SalesReportTicket> crimeaRefundBatchDataList = null;
    private ReportBatchData<U6SalesReportTicket> crimeaExchangeBatchDataList = null;
    private ReportBatchData<U6SalesReportTicket> crimeaPenaltyBatchDataList = null;
    private ReportBatchData<U6SalesReportTicket> luggageVvlDataList = null;
    private ReportBatchData<U6SalesReportTicket> luggageCisDataList = null;
    private ReportBatchData<U6SalesReportTicket> luggageMvlDataList = null;
    private Map<String, U6SalesSummaryReportItem> salesSummaryItems = null;
    private Map<String, U6SalesLuggageSummaryReportItem> luggageSummaryItems = null;

    @Override
    public String getId() {
        return "u6-sales-report";
    }

    @Override
    public void prepareData(Map<String, Object> data) throws Exception {
        this.luggageMvlDataList = null;
        this.luggageCisDataList = null;
        this.luggageVvlDataList = null;
        this.crimeaPenaltyBatchDataList = null;
        this.crimeaExchangeBatchDataList = null;
        this.crimeaRefundBatchDataList = null;
        this.crimeaCashSellBatchDataList = null;
        this.vvlPenaltyBatchDataList = null;
        this.vvlExchangeBatchDataList = null;
        this.vvlRefundBatchDataList = null;
        this.vvlCashSellBatchDataList = null;
        this.mvlPenaltyBatchDataList = null;
        this.mvlExchangeBatchDataList = null;
        this.mvlRefundBatchDataList = null;
        this.mlvCashSellBatchDataList = null;
        super.prepareData(data);
    }

    @Override
    protected void addProductProxyTicket(Product product, Map<String, Object> data, List<Message> messages) throws Exception {
        super.addProductProxyTicket(product, data, messages);
        List batchDataList = (List)data.get("key-batch-data-list");
        batchDataList = (List)data.computeIfAbsent("key-batch-data-list", value -> new ArrayList());
        if (this.mlvCashSellBatchDataList == null) {
            this.mlvCashSellBatchDataList = new ReportBatchData();
            this.mlvCashSellBatchDataList.setBatchId("MVL_CASH_SALE");
            batchDataList.add(this.mlvCashSellBatchDataList);
        }
        if (this.mvlRefundBatchDataList == null) {
            this.mvlRefundBatchDataList = new ReportBatchData();
            this.mvlRefundBatchDataList.setBatchId("MVL_REFUND");
            batchDataList.add(this.mvlRefundBatchDataList);
        }
        if (this.mvlExchangeBatchDataList == null) {
            this.mvlExchangeBatchDataList = new ReportBatchData();
            this.mvlExchangeBatchDataList.setBatchId("MVL_EXCHANGE");
            batchDataList.add(this.mvlExchangeBatchDataList);
        }
        if (this.mvlPenaltyBatchDataList == null) {
            this.mvlPenaltyBatchDataList = new ReportBatchData();
            this.mvlPenaltyBatchDataList.setBatchId("MVL_PENALTY");
            batchDataList.add(this.mvlPenaltyBatchDataList);
        }
        if (this.vvlCashSellBatchDataList == null) {
            this.vvlCashSellBatchDataList = new ReportBatchData();
            this.vvlCashSellBatchDataList.setBatchId("VVL_CASH_SALE");
            batchDataList.add(this.vvlCashSellBatchDataList);
        }
        if (this.vvlRefundBatchDataList == null) {
            this.vvlRefundBatchDataList = new ReportBatchData();
            this.vvlRefundBatchDataList.setBatchId("VVL_REFUND");
            batchDataList.add(this.vvlRefundBatchDataList);
        }
        if (this.vvlExchangeBatchDataList == null) {
            this.vvlExchangeBatchDataList = new ReportBatchData();
            this.vvlExchangeBatchDataList.setBatchId("VVL_EXCHANGE");
            batchDataList.add(this.vvlExchangeBatchDataList);
        }
        if (this.vvlPenaltyBatchDataList == null) {
            this.vvlPenaltyBatchDataList = new ReportBatchData();
            this.vvlPenaltyBatchDataList.setBatchId("VVL_PENALTY");
            batchDataList.add(this.vvlPenaltyBatchDataList);
        }
        if (this.crimeaCashSellBatchDataList == null) {
            this.crimeaCashSellBatchDataList = new ReportBatchData();
            this.crimeaCashSellBatchDataList.setBatchId("CRIMEA_CASH_SALE");
            batchDataList.add(this.crimeaCashSellBatchDataList);
        }
        if (this.crimeaRefundBatchDataList == null) {
            this.crimeaRefundBatchDataList = new ReportBatchData();
            this.crimeaRefundBatchDataList.setBatchId("CRIMEA_REFUND");
            batchDataList.add(this.crimeaRefundBatchDataList);
        }
        if (this.crimeaExchangeBatchDataList == null) {
            this.crimeaExchangeBatchDataList = new ReportBatchData();
            this.crimeaExchangeBatchDataList.setBatchId("CRIMEA_EXCHANGE");
            batchDataList.add(this.crimeaExchangeBatchDataList);
        }
        if (this.crimeaPenaltyBatchDataList == null) {
            this.crimeaPenaltyBatchDataList = new ReportBatchData();
            this.crimeaPenaltyBatchDataList.setBatchId("CRIMEA_PENALTY");
            batchDataList.add(this.crimeaPenaltyBatchDataList);
        }
        if (this.luggageVvlDataList == null) {
            this.luggageVvlDataList = new ReportBatchData();
            this.luggageVvlDataList.setBatchId("LUGGAGE_VVL");
            batchDataList.add(this.luggageVvlDataList);
        }
        if (this.luggageMvlDataList == null) {
            this.luggageMvlDataList = new ReportBatchData();
            this.luggageMvlDataList.setBatchId("LUGGAGE_MVL");
            batchDataList.add(this.luggageMvlDataList);
        }
        ReportBatchData summaryInfoBatchDataList = new ReportBatchData();
        summaryInfoBatchDataList.setBatchId("SUMMARY_INFO");
        batchDataList.add(summaryInfoBatchDataList);
        data.computeIfAbsent("SUMMARY_INFO", value -> {
            this.salesSummaryItems = new HashMap<String, U6SalesSummaryReportItem>();
            for (U6SalesSummaryReportItem.Definition item : U6SalesSummaryReportItem.Definition.values()) {
                this.salesSummaryItems.put(item.name(), new U6SalesSummaryReportItem());
            }
            return this.salesSummaryItems;
        });
        data.computeIfAbsent("LUGGAGE_SUMMARY", value -> {
            this.luggageSummaryItems = new HashMap<String, U6SalesLuggageSummaryReportItem>();
            for (U6SalesLuggageSummaryReportItem.Definition item : U6SalesLuggageSummaryReportItem.Definition.values()) {
                this.luggageSummaryItems.put(item.name(), new U6SalesLuggageSummaryReportItem());
            }
            return this.luggageSummaryItems;
        });
        U6SalesReportTicket ticket = new U6SalesReportTicket(product, messages);
        switch (product.getProductCategory()) {
            case AIR: {
                if (ticket.isSellTicket() || ticket.isVoidTicket()) {
                    if (ticket.isRouteContainCrimea()) {
                        this.crimeaCashSellBatchDataList.getTickets().add(ticket);
                        break;
                    }
                    if (ticket.isMVL()) {
                        this.mlvCashSellBatchDataList.getTickets().add(ticket);
                        break;
                    }
                    if (!ticket.isVVL()) break;
                    this.vvlCashSellBatchDataList.getTickets().add(ticket);
                    break;
                }
                if (ticket.isRefundTicket()) {
                    if (ticket.isRouteContainCrimea()) {
                        this.crimeaRefundBatchDataList.getTickets().add(ticket);
                        break;
                    }
                    if (ticket.isMVL()) {
                        this.mvlRefundBatchDataList.getTickets().add(ticket);
                        break;
                    }
                    if (!ticket.isVVL()) break;
                    this.vvlRefundBatchDataList.getTickets().add(ticket);
                    break;
                }
                if (!ticket.isExchangeTicket()) break;
                if (ticket.isRouteContainCrimea()) {
                    this.crimeaExchangeBatchDataList.getTickets().add(ticket);
                    break;
                }
                if (ticket.isMVL()) {
                    this.mvlExchangeBatchDataList.getTickets().add(ticket);
                    break;
                }
                if (!ticket.isVVL()) break;
                this.vvlExchangeBatchDataList.getTickets().add(ticket);
                break;
            }
            case MCO: {
                if ((product.getMcoCategory() == MCOCategory.PENALTY || product.getMcoCategory() == MCOCategory.REBOOKING) && (ticket.isSellTicket() || ticket.isVoidTicket())) {
                    if (ticket.isRouteContainCrimea()) {
                        this.crimeaPenaltyBatchDataList.getTickets().add(ticket);
                        break;
                    }
                    if (ticket.isMVL()) {
                        this.mvlPenaltyBatchDataList.getTickets().add(ticket);
                        break;
                    }
                    if (!ticket.isVVL()) break;
                    this.vvlPenaltyBatchDataList.getTickets().add(ticket);
                    break;
                }
                if (product.getMcoCategory() == MCOCategory.EXCESS_LUGGAGE) {
                    if (ticket.isVVL()) {
                        this.luggageVvlDataList.getTickets().add(ticket);
                        break;
                    }
                    this.luggageMvlDataList.getTickets().add(ticket);
                    break;
                }
                if (product.getMcoCategory() != MCOCategory.POSTAGE_FEE) break;
                if (ticket.isRouteContainCrimea()) {
                    this.crimeaCashSellBatchDataList.getTickets().add(ticket);
                    break;
                }
                if (ticket.isMVL()) {
                    this.mlvCashSellBatchDataList.getTickets().add(ticket);
                    break;
                }
                this.vvlCashSellBatchDataList.getTickets().add(ticket);
                break;
            }
            case EXCESS_BAGAGE: {
                if (ticket.isVVL()) {
                    this.luggageVvlDataList.getTickets().add(ticket);
                    break;
                }
                this.luggageMvlDataList.getTickets().add(ticket);
                break;
            }
        }
        this.calculateSummaryInfo(data, ticket, messages);
    }

    @Override
    protected Set<Product> getData(Map<String, Object> data, List<Message> messages) throws Exception {
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ProductIndex.Property.productCategory.name(), (Object)ProductCategory.AIR), SearchCriterion.eq((String)ProductIndex.Property.productCategory.name(), (Object)ProductCategory.MCO), SearchCriterion.eq((String)ProductIndex.Property.productCategory.name(), (Object)ProductCategory.EXCESS_BAGAGE)}));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ProductIndex.Property.ticketType.name(), (Object)TicketType.OWN), SearchCriterion.eq((String)ProductIndex.Property.ticketType.name(), (Object)TicketType.NOT_OWN)}));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ProductIndex.Property.status.name(), (Object)ProductStatus.SELL), SearchCriterion.eq((String)ProductIndex.Property.status.name(), (Object)ProductStatus.VOID), SearchCriterion.eq((String)ProductIndex.Property.status.name(), (Object)ProductStatus.REFUND)}));
        query.getCriteria().getCriterions().add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)ProductIndex.Property.issueDate.name(), (Object)params.getPeriodBegin()), SearchCriterion.le((String)ProductIndex.Property.issueDate.name(), (Object)params.getPeriodEnd())}));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.supplier.name(), (Object)params.getSupplier()));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.agency.name(), (Object)params.getAgency()));
        EntityStorage es = EntityStorage.get();
        HashSet<Product> result = new HashSet<Product>();
        EntityContainer ctr = null;
        for (ProductIndex productIndex : es.search(ProductIndex.class, query).getData()) {
            ctr = es.resolve(productIndex.getSource());
            result.add((Product)BookingHelper.findProduct((BookingFile)((BookingFile)ctr.getEntity()), (String)productIndex.getNavigationKey()));
        }
        if (result.isEmpty()) {
            SystemHelper.addMessage(messages, (String)Messages.reportNoTicket, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            this.log.warn("There are no tickets in the report");
        }
        return result;
    }

    @Override
    protected void putGlobalData(Map<String, Object> data, List<Message> messages) throws Exception {
        DictionaryReference airlineRef;
        this.putCreditBankTransferOrderInfo(data, messages);
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        U6SalesReportPrepareHandler.putStandardReportParameters(params.getPeriodBegin(), params.getPeriodEnd(), data, messages);
        U6SalesReportPrepareHandler.putStandardAgencyData((EntityReference<Organization>)params.getAgency(), data, messages);
        String supplierName = L10nStringHelper.getValue((L10nString)((Organization)EntityStorage.get().resolve(params.getSupplier()).getEntity()).getFullName(), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false);
        data.put("AIRLINE_NAME", supplierName);
        Organization agency = (Organization)EntityStorage.get().resolve(params.getAgency()).getEntity();
        String agencyReportCode = SystemHelper.findMetadataAsString((Collection)agency.getMetadata(), (MetadataKey)this.getAgencyReportCode((BaseReportParameters)((ReportParameters)data.get("key-report-params"))));
        data.put("AGENCY_IATA_CODE", agencyReportCode);
        if (params.getSupplier() != null && (airlineRef = ((Organization)EntityStorage.get().resolve(params.getSupplier()).getEntity()).getAirline()) != null) {
            data.put("AIRLINE_IATA_CODE", ((Airline)DictionaryCache.get().resolveReference(airlineRef)).getAirlineNumber());
        }
        for (Communication communication : agency.getCommunications()) {
            if (!communication.getType().equals((Object)CommunicationType.WORK_PHONE)) continue;
            data.put("AGENCY_PHONE", communication.getSense());
        }
        EntityStorage es = EntityStorage.get();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.contractType.name(), (Object)ContractType.VENDOR), SearchCriterion.eq((String)ContractCustomerIndex.Property.vendor.name(), (Object)params.getSupplier()), SearchCriterion.eq((String)ContractCustomerIndex.Property.supplier.name(), (Object)params.getSupplier()), SearchCriterion.eq((String)ContractCustomerIndex.Property.customer.name(), (Object)params.getAgency())}));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.endDate.name(), null), SearchCriterion.ge((String)ContractCustomerIndex.Property.endDate.name(), (Object)params.getPeriodBegin())}));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.startDate.name(), null), SearchCriterion.le((String)ContractCustomerIndex.Property.startDate.name(), (Object)params.getPeriodEnd())}));
        List contractCustomerIndexes = es.search(ContractCustomerIndex.class, query).getData();
        if (contractCustomerIndexes.isEmpty()) {
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_NoContracts", null, (MessageType)MessageType.WARNING, (Object[])new Object[0]);
            this.log.debug("No contracts found for the report parameters");
            return;
        }
        Collections.sort(contractCustomerIndexes, new Comparator<ContractCustomerIndex>(){

            @Override
            public int compare(ContractCustomerIndex o1, ContractCustomerIndex o2) {
                return MiscUtil.compare((Date)o1.getIssueDate(), (Date)o2.getIssueDate(), (boolean)true);
            }
        });
        data.put("CONTRACT_NO", ((ContractCustomerIndex)contractCustomerIndexes.get(0)).getNumber());
        data.put("CONTRACT_ISSUE_DATE", ((ContractCustomerIndex)contractCustomerIndexes.get(0)).getIssueDate());
    }

    @Override
    protected void checkReportParameters(Map<String, Object> data, List<Message> messages) throws Exception {
        super.checkReportParameters(data, messages);
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        if (params.getPeriodBegin() == null) {
            SystemHelper.addMessage(messages, (String)Messages.HySalesReportPrepareHandler_noStartDate, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            this.log.warn("Start date is empty");
        }
        if (params.getPeriodEnd() == null) {
            SystemHelper.addMessage(messages, (String)Messages.U6SalesReportPrepareHandler_noDatePeriodEnd, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            this.log.warn("End date is empty");
        }
        if (params.getSupplier() == null) {
            SystemHelper.addMessage(messages, (String)Messages.HySalesReportPrepareHandler_noSupplier, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            this.log.warn("Supplier is empty");
        }
        params.setBlankOwner(params.getSupplier());
        if (params.getAgency() == null) {
            SystemHelper.addMessage(messages, (String)Messages.BaseSsodDivergenceReportPrepareHandler_noAgency, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            this.log.warn("Agency is empty");
        }
    }

    @Override
    protected void afterFillDataLists(Map<String, Object> data, List<Message> messages) throws Exception {
        HashMap<String, Object> xmlParameters = new HashMap<String, Object>(data);
        List batchDataList = (List)data.get("key-batch-data-list");
        ArrayList<SuSalesReportBatchData> xmlList = new ArrayList<SuSalesReportBatchData>();
        for (Object batch : batchDataList) {
            if (!(batch instanceof SuSalesReportBatchData)) continue;
            xmlList.add((SuSalesReportBatchData)batch);
        }
        xmlParameters.put("key-batch-data-list", xmlList);
        super.afterFillDataLists(xmlParameters, messages);
        Collections.sort(this.mlvCashSellBatchDataList.getTickets());
        Collections.sort(this.mvlRefundBatchDataList.getTickets());
        Collections.sort(this.mvlExchangeBatchDataList.getTickets());
        Collections.sort(this.mvlPenaltyBatchDataList.getTickets());
        Collections.sort(this.vvlCashSellBatchDataList.getTickets());
        Collections.sort(this.vvlRefundBatchDataList.getTickets());
        Collections.sort(this.vvlExchangeBatchDataList.getTickets());
        Collections.sort(this.vvlPenaltyBatchDataList.getTickets());
        Collections.sort(this.crimeaCashSellBatchDataList.getTickets());
        Collections.sort(this.crimeaRefundBatchDataList.getTickets());
        Collections.sort(this.crimeaExchangeBatchDataList.getTickets());
        Collections.sort(this.crimeaPenaltyBatchDataList.getTickets());
    }

    private void calculateSummaryInfo(Map<String, Object> data, U6SalesReportTicket ticket, List<Message> messages) throws Exception {
        if (ticket.isDuplicate()) {
            return;
        }
        U6SalesSummaryReportItem item = null;
        U6SalesLuggageSummaryReportItem itemLuggage = null;
        switch (ticket.getProductCategory()) {
            case AIR: {
                if (ticket.isSellTicket() || ticket.isExchangeTicket()) {
                    if (ticket.isRouteContainCrimea() || ticket.isRouteContainsKaliningrad() || ticket.isRouteContainsDVFO() || ticket.isMVL() || ticket.isRouteContainsCIS()) {
                        item = this.salesSummaryItems.get(U6SalesSummaryReportItem.Definition.VAT_ABSENT_SELL.name());
                        break;
                    }
                    if (!ticket.isVVL()) break;
                    item = this.salesSummaryItems.get(U6SalesSummaryReportItem.Definition.VAT_PRESENT_SELL.name());
                    break;
                }
                if (!ticket.isRefundTicket()) break;
                if (ticket.isRouteContainCrimea() || ticket.isRouteContainsKaliningrad() || ticket.isRouteContainsDVFO() || ticket.isMVL() || ticket.isRouteContainsCIS()) {
                    item = this.salesSummaryItems.get(U6SalesSummaryReportItem.Definition.VAT_ABSENT_REFUND.name());
                    break;
                }
                if (!ticket.isVVL()) break;
                item = this.salesSummaryItems.get(U6SalesSummaryReportItem.Definition.VAT_PRESENT_REFUND.name());
                break;
            }
            case MCO: {
                if (ticket.getMcoCategory() == MCOCategory.POSTAGE_FEE || ticket.getMcoCategory() == MCOCategory.PENALTY || ticket.getMcoCategory() == MCOCategory.REBOOKING) {
                    if (ticket.isRouteContainCrimea() || ticket.isRouteContainsKaliningrad() || ticket.isRouteContainsDVFO() || ticket.isMVL() || ticket.isRouteContainsCIS()) {
                        item = this.salesSummaryItems.get(U6SalesSummaryReportItem.Definition.VAT_ABSENT_SELL.name());
                        break;
                    }
                    if (!ticket.isVVL()) break;
                    item = this.salesSummaryItems.get(U6SalesSummaryReportItem.Definition.VAT_PRESENT_SELL.name());
                    break;
                }
                if (ticket.getMcoCategory() != MCOCategory.EXCESS_LUGGAGE) break;
                if (ticket.isMVL()) {
                    itemLuggage = this.luggageSummaryItems.get(U6SalesLuggageSummaryReportItem.Definition.MVL_TOTAL.name());
                    break;
                }
                itemLuggage = this.luggageSummaryItems.get(U6SalesLuggageSummaryReportItem.Definition.VVL_TOTAL.name());
                break;
            }
            case EXCESS_BAGAGE: {
                if (ticket.isMVL()) {
                    itemLuggage = this.luggageSummaryItems.get(U6SalesLuggageSummaryReportItem.Definition.MVL_TOTAL.name());
                    break;
                }
                itemLuggage = this.luggageSummaryItems.get(U6SalesLuggageSummaryReportItem.Definition.VVL_TOTAL.name());
                break;
            }
        }
        if (item != null) {
            this.calculateItemSummaryInfo(item, ticket, messages);
            if (ticket.isExchangeTicket()) {
                U6SalesReportTicket exchangedTicket = new U6SalesReportTicket(ticket.getSourceProduct().getPreviousProduct(), messages);
                if (ticket.isRouteContainCrimea() || ticket.isRouteContainsKaliningrad() || ticket.isRouteContainsDVFO() || ticket.isMVL() || ticket.isRouteContainsCIS()) {
                    item = this.salesSummaryItems.get(U6SalesSummaryReportItem.Definition.VAT_ABSENT_SELL.name());
                } else if (ticket.isVVL()) {
                    item = this.salesSummaryItems.get(U6SalesSummaryReportItem.Definition.VAT_PRESENT_SELL.name());
                }
                this.calculateItemSummaryInfo(item, exchangedTicket, messages);
            }
        }
        if (itemLuggage != null) {
            this.calculateItemLuggageSummaryInfo(itemLuggage, ticket, messages);
        }
    }

    private void calculateItemSummaryInfo(U6SalesSummaryReportItem item, U6SalesReportTicket ticket, List<Message> messages) {
        if (!ticket.isMtd()) {
            if (ticket.getEquivalentFare() != null) {
                if (ticket.getMcoCategory() == MCOCategory.POSTAGE_FEE) {
                    item.addPostageFee(ticket.getStatus() == ProductStatus.EXCHANGE ? -ticket.getEquivalentFare().doubleValue() : ticket.getEquivalentFare().doubleValue());
                } else if (ticket.getMcoCategory() == MCOCategory.PENALTY || ticket.getMcoCategory() == MCOCategory.REBOOKING) {
                    item.addPenalty(ticket.getStatus() == ProductStatus.EXCHANGE ? -ticket.getEquivalentFare().doubleValue() : ticket.getEquivalentFare().doubleValue());
                } else {
                    item.addTariff(ticket.getStatus() == ProductStatus.EXCHANGE ? -ticket.getEquivalentFare().doubleValue() : ticket.getEquivalentFare().doubleValue());
                }
            } else {
                SystemHelper.addMessage(messages, (String)Messages.BaseSalesReportPrepareHandler_Message_NoEquivalentFare, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{ticket.getTicketNumber()});
                this.log.warn("Equivalent fare is null for ticket: " + ticket.getTicketNumber());
            }
            if (ticket.getFee() != null) {
                item.addFee(ticket.getStatus() == ProductStatus.EXCHANGE ? -ticket.getFee().doubleValue() : ticket.getFee().doubleValue());
            }
            if (ticket.getFuelFee() != null) {
                item.addFuelFee(ticket.getStatus() == ProductStatus.EXCHANGE ? -ticket.getFuelFee().doubleValue() : ticket.getFuelFee().doubleValue());
            }
            if (ticket.getCommission() != null && ticket.getCommission().getEquivalentAmount() != null) {
                item.addCommission(ticket.getStatus() == ProductStatus.EXCHANGE ? -ticket.getCommission().getEquivalentAmount().doubleValue() : ticket.getCommission().getEquivalentAmount().doubleValue());
            }
            if ((ticket.isRefundTicket() || ticket.isExchangeTicket()) && ticket.getPenalty() != null) {
                item.addPenalty(ticket.getStatus() == ProductStatus.EXCHANGE ? -ticket.getPenalty().doubleValue() : ticket.getPenalty().doubleValue());
            }
            if ((ticket.getMcoCategory() == MCOCategory.PENALTY || ticket.getMcoCategory() == MCOCategory.REBOOKING) && ticket.getPenalty() != null) {
                item.addPenalty(ticket.getStatus() == ProductStatus.EXCHANGE ? -ticket.getPenalty().doubleValue() : ticket.getPenalty().doubleValue());
            }
        } else {
            BigDecimal mtdValue = MiscUtil.sum((BigDecimal[])new BigDecimal[]{ticket.getEquivalentFare(), ticket.getFee(), ticket.getFuelFee(), ticket.getPenalty()});
            if (mtdValue != null) {
                item.addMtdValue(ticket.getStatus() == ProductStatus.EXCHANGE ? -mtdValue.doubleValue() : mtdValue.doubleValue());
            }
            if (ticket.getCommission() != null && ticket.getCommission().getEquivalentAmount() != null) {
                item.addMtdCommission(ticket.getStatus() == ProductStatus.EXCHANGE ? -ticket.getCommission().getEquivalentAmount().doubleValue() : ticket.getCommission().getEquivalentAmount().doubleValue());
            }
        }
    }

    private void calculateItemLuggageSummaryInfo(U6SalesLuggageSummaryReportItem item, U6SalesReportTicket ticket, List<Message> messages) {
        if (ticket.getEquivalentFare() != null) {
            item.addTariff(ticket.getEquivalentFare().doubleValue());
        } else {
            SystemHelper.addMessage(messages, (String)Messages.BaseSalesReportPrepareHandler_Message_NoEquivalentFare, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{ticket.getTicketNumber()});
            this.log.warn("Equivalent fare is null for luggage: " + ticket.getTicketNumber());
        }
        if (ticket.getCommission() != null && ticket.getCommission().getEquivalentAmount() != null) {
            item.addCommission(ticket.getCommission().getEquivalentAmount().doubleValue());
        }
    }

    @Override
    protected MetadataKey getAgencyReportCode(BaseReportParameters params) {
        return MetadataKey.KEY_U6_AGENCY_CODE;
    }
}

