/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.salesreports.un;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.BaseReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportBatchData;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.salesreports.SalesReportHelper;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuSalesReportBatchData;
import com.gridnine.xtrip.common.reports.render.salesreports.tch.TchTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.un.xls.UNReportData;
import com.gridnine.xtrip.common.reports.render.salesreports.un.xls.UNReportTicket;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MoneyUtil;
import com.gridnine.xtrip.server.model.handlers.rules.TchRulesHelper;
import com.gridnine.xtrip.server.reports.prepare.salesreports.BaseSalesReportPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.salesreports.SalesReportPrepareHelper;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class UNXlsSalesReportPrepareHandler
extends BaseSalesReportPrepareHandler<TchTicket> {
    @Override
    protected void addProductProxyTicket(Product product, Map<String, Object> data, List<Message> messages) throws Exception {
        ProductStatus status;
        UNReportTicket ticket = new UNReportTicket(product, data);
        if (product.getPreviousProduct() != null && ProductStatus.EXCHANGE.equals((Object)product.getPreviousProduct().getStatus())) {
            Product exchangeProduct = product.getPreviousProduct();
            Money baseFare = AirProductHelper.getBaseFare((Product)product);
            Money baseFareExch = AirProductHelper.getBaseFare((Product)exchangeProduct);
            if (baseFare != null && baseFare.getValue() != null && baseFareExch != null && baseFareExch.getValue() != null) {
                baseFare.setValue(baseFare.getValue().subtract(baseFareExch.getValue()));
            }
            AirProductHelper.setBaseFare((Product)product, (Money)baseFare);
            BigDecimal eqFare = AirProductHelper.getEquivalentFare((Product)product);
            BigDecimal eqFareExch = AirProductHelper.getEquivalentFare((Product)exchangeProduct);
            if (eqFare != null && eqFareExch != null) {
                AirProductHelper.setEquivalentFare((Product)product, (BigDecimal)eqFare.subtract(eqFareExch));
            }
            List newTaxes = SalesReportHelper.calculateTaxesDifference((Collection)product.getTaxes(), (Collection)exchangeProduct.getTaxes());
            product.getTaxes().clear();
            product.getTaxes().addAll(newTaxes);
            ticket = new UNReportTicket(product, data);
        }
        if ((status = ticket.getStatus()) == null) {
            SystemHelper.addMessage(messages, (String)Messages.AgentReportAirPrepareHandler_ticketCantLoadCommittee, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{product.getSystemNumber()});
            return;
        }
        ArrayList<ReportBatchData> batchDataList = (ArrayList<ReportBatchData>)data.get("key-batch-data-list");
        boolean needToAdd = true;
        if (batchDataList != null) {
            for (ReportBatchData obj : (List)data.get("key-batch-data-list")) {
                if (obj instanceof SuSalesReportBatchData) continue;
                needToAdd = false;
                break;
            }
        }
        if (needToAdd) {
            if (batchDataList == null) {
                batchDataList = new ArrayList<ReportBatchData>();
                data.put("key-batch-data-list", batchDataList);
            }
            ReportBatchData sellRegistryList = new ReportBatchData();
            sellRegistryList.setBatchId("RegistrySell");
            batchDataList.add(sellRegistryList);
            ReportBatchData refundRegistryList = new ReportBatchData();
            refundRegistryList.setBatchId("RegistryRefund");
            batchDataList.add(refundRegistryList);
            ReportBatchData voidRegistryList = new ReportBatchData();
            voidRegistryList.setBatchId("Void");
            batchDataList.add(voidRegistryList);
        }
        for (ReportBatchData unReportTicket : batchDataList) {
            if ("RegistrySell".equals(unReportTicket.getBatchId()) && ticket.getStatus() == ProductStatus.SELL) {
                unReportTicket.getTickets().add(ticket);
                break;
            }
            if ("RegistryRefund".equals(unReportTicket.getBatchId()) && ticket.getStatus() == ProductStatus.REFUND) {
                unReportTicket.getTickets().add(ticket);
                break;
            }
            if (!"Void".equals(unReportTicket.getBatchId()) || ticket.getStatus() != ProductStatus.VOID) continue;
            unReportTicket.getTickets().add(ticket);
            break;
        }
        if (ticket.getProductCategory() == ProductCategory.MCO && ticket.getMcoCategory() == MCOCategory.INFORMATION) {
            return;
        }
        UNReportData repData = (UNReportData)data.get("KEY_UN_BSP_REPORT_DATA");
        this.updateReportData(repData, ticket.getStatus(), ticket.isVatIncluded(), PaymentType.CASH, ticket.getFareCash(), ticket.getTaxCA(), ticket.getPenaltyCA(), ticket.getCommissionCA());
        this.updateReportData(repData, ticket.getStatus(), ticket.isVatIncluded(), PaymentType.CREDIT_CARD, ticket.getFareCC(), ticket.getTaxCC(), ticket.getPenaltyCC(), BigDecimal.ZERO);
    }

    private void updateReportData(UNReportData repData, ProductStatus status, boolean vatIncluded, PaymentType paymentType, BigDecimal fare, BigDecimal tax, BigDecimal penalty, BigDecimal commission) {
        if (status == ProductStatus.EXCHANGE || BigDecimal.ZERO.compareTo(fare) == 0 && BigDecimal.ZERO.compareTo(tax) == 0 && BigDecimal.ZERO.compareTo(penalty) == 0 && BigDecimal.ZERO.compareTo(commission) == 0) {
            return;
        }
        UNReportData.UNSubBatchKey key = new UNReportData.UNSubBatchKey();
        key.setMvl(!vatIncluded);
        key.setPaymentType(paymentType);
        key.setRefund(status == ProductStatus.REFUND);
        UNReportData.UNSubBatchData batchData = (UNReportData.UNSubBatchData)repData.getBatches().get(key);
        if (batchData == null) {
            batchData = new UNReportData.UNSubBatchData();
            repData.getBatches().put(key, batchData);
        }
        batchData.setPenalty(batchData.getPenalty().add(penalty));
        batchData.setFare(batchData.getFare().add(fare));
        batchData.setTax(batchData.getTax().add(tax));
        batchData.setCommission(batchData.getCommission().add(commission));
    }

    @Override
    public String getId() {
        return "un-sales-report-xls";
    }

    @Override
    protected Set<Product> getData(Map<String, Object> data, List<Message> messages) throws Exception {
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        SearchQuery query = SalesReportPrepareHelper.createQuery(params);
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.carrier.name(), (Object)new AirlineReference("UN")));
        Set<Product> products = SalesReportPrepareHelper.getProducts(query, messages);
        if (products.isEmpty()) {
            SystemHelper.addMessage(messages, (String)Messages.reportNoTicket, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
        }
        for (Product prod : products) {
            TchRulesHelper.correctFops((Product)prod);
        }
        return products;
    }

    @Override
    protected MetadataKey getAgencyReportCode(BaseReportParameters params) {
        return MetadataKey.KEY_UN_AGENCY_CODE;
    }

    @Override
    protected void putGlobalData(Map<String, Object> data, List<Message> messages) throws Exception {
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        super.putGlobalData(data, messages);
        EntityContainer ctr = EntityStorage.get().resolve(params.getTemplate());
        if (ctr == null || ((TemplateDocument)ctr.getEntity()).getContent() == null) {
            SystemHelper.addMessage(messages, (String)Messages.UNBSPSalesReportPrepareHandler_templateReportTransair, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            return;
        }
        data.put("KEY_TEMPLATE_DATA", ((TemplateDocument)ctr.getEntity()).getContent());
        UNReportData reportData = new UNReportData();
        data.put("KEY_UN_BSP_REPORT_DATA", reportData);
        reportData.setAgencyAccounantName((String)data.get("AGENCY_ACCOUNTANT"));
        reportData.setAgencyDirectorName((String)data.get("AGENCY_DIRECTOR"));
        reportData.setAgencyName((String)data.get("AGENCY_NAME"));
        reportData.setAgencyReportCode((String)data.get("AGENCY_IATA_CODE"));
        reportData.setAgencyPhone((String)data.get("AGENCY_PHONE"));
        reportData.setAgentName((String)data.get("AGENT_NAME"));
        reportData.setContractNumber((String)data.get("CONTRACT_NO"));
        Date contractIssueDate = (Date)data.get("CONTRACT_ISSUE_DATE");
        reportData.setContractIssueDateStr(this.formatDate(contractIssueDate));
        String startDateStr = "???";
        DecimalFormat df = new DecimalFormat("00");
        if (params.getPeriodBegin() != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(params.getPeriodBegin());
            startDateStr = df.format(cal.get(5));
        }
        String endDateStr = this.formatDate(params.getPeriodEnd());
        reportData.setReportPeriodStr(String.format("\u0441 %s \u043f\u043e %s.", startDateStr, endDateStr));
    }

    private String formatDate(Date date) {
        if (date == null) {
            return "???";
        }
        return new SimpleDateFormat("dd'.'MM'.'yyyy'\u0433'").format(date);
    }

    @Override
    protected void afterFillDataLists(Map<String, Object> data, List<Message> messages) throws Exception {
        ReportBatchData batchTemp;
        super.afterFillDataLists(data, messages);
        UNReportData reportData = (UNReportData)data.get("KEY_UN_BSP_REPORT_DATA");
        BigDecimal total = BigDecimal.ZERO;
        BigDecimal totalCommission = BigDecimal.ZERO;
        int pos = 0;
        Iterator iterator = ((List)data.get("key-batch-data-list")).iterator();
        while (iterator.hasNext() && (batchTemp = (ReportBatchData)iterator.next()) instanceof SuSalesReportBatchData) {
            ++pos;
        }
        for (UNReportTicket ticket : ((ReportBatchData)((List)data.get("key-batch-data-list")).get(pos)).getTickets()) {
            total = total.add(ticket.getTotal());
            totalCommission = totalCommission.add(ticket.getCommissionCA());
        }
        Locale loc = new Locale("ru");
        String currency = "RUB";
        reportData.setTotalCommissionStr(totalCommission.toString());
        reportData.setTotalStr(MoneyUtil.money2str((Locale)loc, (String)currency, (double)total.doubleValue(), (boolean)true));
    }
}

