/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.salesreports.un;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.helpers.PaymentCardHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.BaseReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.salesreports.SalesReportHelper;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuSalesReportBatchData;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuTicket;
import com.gridnine.xtrip.server.reports.prepare.PrepareHandlersRegistry;
import com.gridnine.xtrip.server.reports.prepare.salesreports.su.BaseSuSalesReportPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.salesreports.su.SUBCReportPrepareHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class UNXmlSalesReportPrepareHandler
extends BaseSuSalesReportPrepareHandler {
    @Override
    protected String getVendorCode() {
        return "UN";
    }

    @Override
    public String getId() {
        return "un-sales-report-xml";
    }

    @Override
    protected MetadataKey getAgencyReportCode(BaseReportParameters params) {
        return MetadataKey.KEY_UN_AGENCY_CODE;
    }

    @Override
    protected void addProductProxyTicket(Product prod, Map<String, Object> data, List<Message> messages) throws Exception {
        SuTicket ticket = null;
        if (prod.getProductCategory() == ProductCategory.MCO && prod.getMcoCategory() == MCOCategory.ADDITIONAL_SERVICES) {
            return;
        }
        try {
            if (prod.getMcoCategory() == MCOCategory.GROUP_PENALTY) {
                ticket = this.getTicketInstance(this.copyAsMcoGroupPenalty(prod), messages);
            } else {
                if (ProductStatus.EXCHANGE.equals((Object)prod.getStatus())) {
                    return;
                }
                if (prod.getPreviousProduct() != null && ProductStatus.EXCHANGE.equals((Object)prod.getPreviousProduct().getStatus())) {
                    BigDecimal baseFare;
                    Product exchangeProduct = prod.getPreviousProduct();
                    SuTicket exchangeTicket = this.getTicketInstance(exchangeProduct, messages);
                    ticket = this.getTicketInstance(prod, messages);
                    if (ticket.getBaseFare() != null && ticket.getBaseFare().getValue() != null && exchangeTicket.getBaseFare() != null && exchangeTicket.getBaseFare().getValue() != null) {
                        baseFare = ticket.getBaseFare().getValue().subtract(exchangeTicket.getBaseFare().getValue());
                        ticket.getBaseFare().setValue(baseFare);
                    }
                    if (ticket.getEquivalentFare() != null && exchangeTicket.getBaseFare() != null) {
                        BigDecimal eqFare = ticket.getEquivalentFare().subtract(exchangeTicket.getEquivalentFare());
                        ticket.setEquivalentFare(eqFare);
                    }
                    if (ticket.getVendorEquivalentCommission() != null && exchangeTicket.getVendorEquivalentCommission() != null) {
                        baseFare = ticket.getVendorEquivalentCommission().subtract(exchangeTicket.getVendorEquivalentCommission());
                        ticket.setVendorEquivalentCommission(baseFare);
                    }
                    List newTaxes = SalesReportHelper.calculateTaxesDifference((Collection)ticket.getTaxes(), (Collection)exchangeTicket.getTaxes());
                    ticket.getTaxes().clear();
                    ticket.getTaxes().addAll(newTaxes);
                    BigDecimal fopAmountEq = BigDecimal.ZERO;
                    fopAmountEq = fopAmountEq.add(ticket.getEquivalentFare());
                    for (Tax t : ticket.getTaxes()) {
                        if (t == null || t.getEquivalentAmount() == null) continue;
                        fopAmountEq = fopAmountEq.add(t.getEquivalentAmount());
                    }
                    if (ticket.getPenalty() != null) {
                        fopAmountEq = fopAmountEq.add(ticket.getPenalty());
                    }
                    boolean fopSet = false;
                    Iterator iter = ticket.getFops().iterator();
                    while (iter.hasNext()) {
                        ProductFop f = (ProductFop)iter.next();
                        if (!PaymentType.TICKET.equals((Object)f.getType()) && !PaymentType.MCO.equals((Object)f.getType())) {
                            if (!fopSet && f.getAmount() != null) {
                                f.getAmount().setValue(fopAmountEq);
                                fopSet = true;
                                continue;
                            }
                            iter.remove();
                            continue;
                        }
                        if (PaymentType.MCO.equals((Object)f.getType())) continue;
                        iter.remove();
                    }
                } else {
                    ticket = this.getTicketInstance(prod, messages);
                }
            }
        }
        catch (Exception e) {
            this.log.error("Can't create SuTicket for product \"" + prod.getSystemNumber() + "\"", (Throwable)e);
            return;
        }
        if (ticket.getStatus() != ProductStatus.VOID && !this.checkFopTypes(ticket)) {
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_FopTypeIsNotSet", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{ticket.getTicketNumber()});
            this.log.error("Fop type is not set for ticket " + ticket.getTicketNumber());
            return;
        }
        if (ticket.getStatus() != ProductStatus.VOID && this.isCreditCardUsed(ticket) && PaymentCardHelper.isPaymentCardMasked((Collection)ticket.getFops())) {
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_PaymentCardNumberIsMasked", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{ticket.getTicketNumber()});
            this.log.error("Payment card number is masked for " + ticket.getTicketNumber());
            return;
        }
        this.setSpecificTicketData(ticket, prod, data, messages);
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        EntityReference agencyReference = params.getAgency();
        ArrayList<SuSalesReportBatchData<SuTicket>> batchDataList = (ArrayList<SuSalesReportBatchData<SuTicket>>)data.get("key-batch-data-list");
        if (batchDataList == null) {
            batchDataList = new ArrayList<SuSalesReportBatchData<SuTicket>>();
            data.put("key-batch-data-list", batchDataList);
        }
        if (!(ticket.getTariffType() != TariffType.BLOCKCHARTER && ticket.getTariffType() != TariffType.CHARTER || MCOCategory.NOT_SOLD_SEATS.equals((Object)ticket.getMcoCategory()))) {
            SUBCReportPrepareHelper.addProductProxyTicket(prod, data, messages);
        }
        SuSalesReportBatchData<SuTicket> batch = null;
        batch = this.selectBatch(ticket.getBatchId(), ticket.getAgencyCode(), batchDataList, agencyReference.getCaption());
        if (batchDataList.isEmpty()) {
            SystemHelper.addMessage(messages, (String)Messages.reportNoTicket, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            return;
        }
        if (batch.getBatchId().equals("SALE")) {
            if (!(prod.getProductCategory() != ProductCategory.MCO || prod.getMcoCategory() != MCOCategory.REBOOKING && prod.getMcoCategory() != MCOCategory.STICKER || prod.getRelatedProducts().isEmpty())) {
                Product relProd = (Product)prod.getRelatedProducts().get(0);
                ticket.setVendorCommissionRate(Double.valueOf(1.0));
                if (ticket.getBaseFare() != null) {
                    ticket.getBaseFare().setValue(BigDecimal.ONE);
                }
                ticket.setEquivalentFare(BigDecimal.ZERO);
                ticket.setVendorEquivalentCommission(BigDecimal.ZERO);
                if (prod.getMcoCategory() == MCOCategory.STICKER && relProd != null && relProd.getStatus() == ProductStatus.SELL) {
                    SuTicket sticker = this.createSticker(prod, messages);
                    batch.getTickets().add(sticker);
                    this.updateTicketRegistryLetterData(sticker, batch.getBatchId(), data);
                }
            }
            if (prod.getProductCategory() == ProductCategory.MCO && prod.getMcoCategory() == MCOCategory.RETURN_FARE_DIFFERENCE && !prod.getRelatedProducts().isEmpty()) {
                SuTicket returnFareDifferenceAsRefund = this.createReturnFareDifferenceAsRefund(prod, messages);
                SuSalesReportBatchData<SuTicket> refundBatch = this.selectBatch("REFUND", ticket.getAgencyCode(), batchDataList, agencyReference.getCaption());
                refundBatch.getTickets().add(returnFareDifferenceAsRefund);
                this.updateTicketRegistryLetterData(returnFareDifferenceAsRefund, refundBatch.getBatchId(), data);
                ticket.setEquivalentFare(BigDecimal.ZERO);
                ticket.setVendorEquivalentCommission(BigDecimal.ZERO);
                for (ProductFop productFop : ticket.getFops()) {
                    productFop.getAmount().setValue(BigDecimal.ZERO);
                }
                ticket.getBaseFare().setValue(BigDecimal.ZERO);
            }
        }
        batch.getTickets().add(ticket);
        if (!MCOCategory.NOT_SOLD_SEATS.equals((Object)ticket.getMcoCategory())) {
            this.updateTicketRegistryLetterData(ticket, batch.getBatchId(), data);
        }
    }

    @Override
    public void prepareData(Map<String, Object> data) throws Exception {
        super.prepareData(data);
        List keyBatchData = (List)data.get("key-batch-data-list");
        List messages = (List)data.get("key-messages");
        if (keyBatchData == null || keyBatchData.size() == 0) {
            SystemHelper.addMessage((Collection)messages, (String)Messages.reportNoTicket, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
        }
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        params.setTemplate(new EntityReference("unReportTemplate", TemplateDocument.class, "unReportTemplate"));
        ((PrepareHandlersRegistry)Environment.getPublished(PrepareHandlersRegistry.class)).get("un-sales-report-xls").prepareData(data);
    }
}

