/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.salesreports.vv;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.reports.model.BaseReportParameters;
import com.gridnine.xtrip.common.reports.render.salesreports.su.base.SuTicket;
import com.gridnine.xtrip.common.reports.render.salesreports.vv.VvRegistryTotalItem;
import com.gridnine.xtrip.server.reports.prepare.salesreports.su.BaseSuSalesReportPrepareHandler;
import java.math.BigDecimal;
import java.util.Map;

public class VvSalesReportPrepareHandler
extends BaseSuSalesReportPrepareHandler {
    @Override
    public String getId() {
        return "vv-sales-report";
    }

    @Override
    protected String getVendorCode() {
        return "VV";
    }

    @Override
    protected MetadataKey getAgencyReportCode(BaseReportParameters params) {
        return MetadataKey.KEY_VV_AGENCY_CODE;
    }

    @Override
    protected String getStockControlReportUid() {
        return "vv-stock-control-report";
    }

    @Override
    protected void updateTicketRegistryLetterData(SuTicket ticket, String batchId, Map<String, Object> data) {
        VvRegistryTotalItem item = this.getRegistryTotalItem(data);
        ProductStatus status = ticket.getStatus();
        boolean isExchangeBatch = ticket.getBatchId().equals("EXC");
        if (ticket.getProductCategory() == ProductCategory.MCO) {
            return;
        }
        switch (status) {
            case SELL: {
                BigDecimal equivalentFare = ticket.getEquivalentFare();
                if (equivalentFare != null) {
                    if (isExchangeBatch) {
                        item.exchangeTotal += equivalentFare.doubleValue();
                        item.exchangeTotal += ticket.getTaxAmount();
                        break;
                    }
                    item.equvalentFareTotal += equivalentFare.doubleValue();
                }
                item.taxTotal += ticket.getTaxAmount();
                ++item.ticketsCount;
                break;
            }
            case EXCHANGE: {
                BigDecimal equivalentFare = ticket.getEquivalentFare();
                double totalTax = ticket.getTaxAmount();
                BigDecimal penaltyBigDec = ticket.getPenalty();
                double penalty = ticket.getTaxEquivAmountByCode("P2");
                totalTax = penaltyBigDec != null ? (totalTax -= penaltyBigDec.doubleValue()) : (totalTax -= penalty);
                if (equivalentFare != null) {
                    item.exchangeTotal += equivalentFare.doubleValue();
                    item.exchangeTotal += totalTax;
                }
                ++item.ticketsCount;
                if (penaltyBigDec != null) {
                    item.penaltyTotal += penaltyBigDec.doubleValue();
                    break;
                }
                item.penaltyTotal += penalty;
                break;
            }
            case REFUND: {
                BigDecimal equivalentFare = ticket.getEquivalentFare();
                double totalTax = ticket.getTaxAmount();
                BigDecimal penaltyBigDec = ticket.getPenalty();
                double penalty = ticket.getTaxEquivAmountByCode("P1");
                totalTax = penaltyBigDec != null ? (totalTax -= penaltyBigDec.doubleValue()) : (totalTax -= penalty);
                if (equivalentFare != null) {
                    item.refundTotal += -equivalentFare.doubleValue();
                    item.refundTotal += -totalTax;
                }
                ++item.ticketsCount;
                if (penaltyBigDec != null) {
                    item.penaltyTotal += penaltyBigDec.doubleValue();
                    break;
                }
                item.penaltyTotal += penalty;
                break;
            }
        }
    }

    private VvRegistryTotalItem getRegistryTotalItem(Map<String, Object> data) {
        VvRegistryTotalItem item = (VvRegistryTotalItem)data.get("key-registry-letters-data");
        if (item == null) {
            item = new VvRegistryTotalItem();
            data.put("key-registry-letters-data", item);
        }
        return item;
    }
}

