/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.salesreports.xf;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.ManagerType;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.BaseReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.salesreports.xf.XFSalesReportBatchData;
import com.gridnine.xtrip.common.reports.render.salesreports.xf.XFSettlementLetter;
import com.gridnine.xtrip.common.reports.render.salesreports.xf.XFTicket;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.helpers.ProfileDao;
import com.gridnine.xtrip.server.reports.prepare.PrepareHandlersRegistry;
import com.gridnine.xtrip.server.reports.prepare.salesreports.BaseSalesReportPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.salesreports.SalesReportPrepareHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.LoggerFactory;

public class XFSalesReportPrepareHandler
extends BaseSalesReportPrepareHandler<XFTicket> {
    @Override
    public String getId() {
        return "xf-sales-report";
    }

    @Override
    protected MetadataKey getAgencyReportCode(BaseReportParameters params) {
        return MetadataKey.KEY_XF_AGENCY_CODE;
    }

    @Override
    public void prepareData(Map<String, Object> data) throws Exception {
        try {
            super.prepareData(data);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("", (Throwable)e);
            throw e;
        }
        this.prepareStockData(data);
    }

    @Override
    protected void addProductProxyTicket(Product product, Map<String, Object> data, List<Message> messages) throws Exception {
        this.log.debug("addProductProxyTicket START");
        this.log.debug(String.format("product system number: %s, category: %s, status: %s", product.getSystemNumber(), product.getProductCategory(), product.getStatus()));
        if (product.getTariffType() == TariffType.BLOCKCHARTER || product.getTariffType() == TariffType.CHARTER) {
            this.log.debug("product tariff type is block charter");
            this.log.debug("addProductProxyTicket END");
            return;
        }
        XFTicket ticket = new XFTicket(product, messages);
        String batchID = ticket.getBatchId();
        if (batchID == null) {
            SystemHelper.addMessage(messages, (String)Messages.XFSalesReportPrepareHandler_ticketNoBatchID, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{ticket.getTicketNumber()});
            this.log.error(String.format("batchID is not defined for ticket %s", ticket.getTicketNumber()));
            return;
        }
        this.log.debug(String.format("ticket batch id: %s", ticket.getBatchId()));
        this.updateSettlementLetterData(ticket, data);
        ArrayList<XFSalesReportBatchData> batchDataList = (ArrayList<XFSalesReportBatchData>)data.get("key-batch-data-list");
        if (batchDataList == null) {
            batchDataList = new ArrayList<XFSalesReportBatchData>();
            data.put("key-batch-data-list", batchDataList);
        }
        if (product.getStatus() == ProductStatus.SELL && product.getProductCategory() == ProductCategory.AIR && product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE) {
            this.log.debug("product is a ticket with sell status and has exchange previous product");
            this.log.debug("addProductProxyTicket END");
            return;
        }
        if (product.getStatus() == ProductStatus.SELL && product.getProductCategory() == ProductCategory.MCO && !product.getRelatedProducts().isEmpty() && product.getRelatedProducts().get(0) != null && ((Product)product.getRelatedProducts().get(0)).getStatus() == ProductStatus.EXCHANGE) {
            this.log.debug("product is an MCO with sell status and has exchange related product");
            this.log.debug("addProductProxyTicket END");
            return;
        }
        ReportParameters parameters = (ReportParameters)data.get("key-report-params");
        EntityReference agencyReference = parameters.getAgency();
        XFSalesReportBatchData batch = this.selectBatch(batchID, ticket.getSubagencyCode(), batchDataList, agencyReference.getCaption());
        batch.getTickets().add(ticket);
        this.log.debug("addProductProxyTicket END");
    }

    protected void updateSettlementLetterData(XFTicket ticket, Map<String, Object> data) {
        String batchId = ticket.getBatchId();
        TreeMap<String, XFSettlementLetter> settlementLetters = (TreeMap<String, XFSettlementLetter>)data.get("key-registry-letters-data");
        if (settlementLetters == null) {
            settlementLetters = new TreeMap<String, XFSettlementLetter>();
            data.put("key-registry-letters-data", settlementLetters);
        }
        String settlementLetterID = null;
        if (batchId.equals("SELL_VVL") || batchId.equals("REFUND_VVL") || batchId.equals("EXCHANGE_VVL")) {
            settlementLetterID = "SETTLEMENT_LETTER_VVL";
        } else if (batchId.equals("SELL_MVL") || batchId.equals("REFUND_MVL") || batchId.equals("EXCHANGE_MVL")) {
            settlementLetterID = "SETTLEMENT_LETTER_MVL";
        }
        if (settlementLetterID == null) {
            return;
        }
        XFSettlementLetter settlementLetter = (XFSettlementLetter)settlementLetters.get(settlementLetterID);
        if (settlementLetter == null) {
            settlementLetter = new XFSettlementLetter();
            settlementLetters.put(settlementLetterID, settlementLetter);
        }
        settlementLetter.update(ticket);
    }

    private XFSalesReportBatchData selectBatch(String batchId, String subagencyCode, List<XFSalesReportBatchData> batchDataList, String agencyCode) {
        boolean multiReportMode = this.getMultiReportMode();
        for (XFSalesReportBatchData batch : batchDataList) {
            if (!(multiReportMode ? batch.getBatchId().equals(batchId) && batch.getSubagencyCode().equals(subagencyCode) : batch.getBatchId().equals(batchId))) continue;
            return batch;
        }
        XFSalesReportBatchData newBatch = new XFSalesReportBatchData();
        newBatch.setBatchId(batchId);
        newBatch.setSubagencyCode(subagencyCode);
        newBatch.setAgencyCode(agencyCode);
        batchDataList.add(newBatch);
        return newBatch;
    }

    @Override
    protected void sortProducts(List<Product> products, Map<String, Object> data) {
        Collections.sort(products, new Comparator<Product>(){

            @Override
            public int compare(Product o1, Product o2) {
                Product product1 = o1;
                Product product2 = o2;
                if (o1.getProductCategory() == ProductCategory.MCO && !o1.getRelatedProducts().isEmpty() && (product1 = (Product)o1.getRelatedProducts().get(0)).getSystemNumber().equals(product2.getSystemNumber())) {
                    return 1;
                }
                if (o2.getProductCategory() == ProductCategory.MCO && !o2.getRelatedProducts().isEmpty() && (product2 = (Product)o2.getRelatedProducts().get(0)).getSystemNumber().equals(product1.getSystemNumber())) {
                    return -1;
                }
                return product1.getSystemNumber().compareTo(product2.getSystemNumber());
            }
        });
    }

    @Override
    protected void afterFillDataLists(Map<String, Object> data, List<Message> messages) throws Exception {
        List batchDataList = (List)data.get("key-batch-data-list");
        if (batchDataList == null || batchDataList.isEmpty()) {
            return;
        }
        if (this.getMultiReportMode()) {
            Collections.sort(batchDataList, new Comparator<XFSalesReportBatchData>(){

                @Override
                public int compare(XFSalesReportBatchData o1, XFSalesReportBatchData o2) {
                    String mainAgencyCode = o1.getAgencyCode();
                    String subagencyCode01 = o1.getSubagencyCode();
                    String subagencyCode02 = o2.getSubagencyCode();
                    if (TextUtil.isBlank((String)subagencyCode01) || TextUtil.isBlank((String)subagencyCode02)) {
                        return 1;
                    }
                    if (subagencyCode01.equals(mainAgencyCode) && subagencyCode02.equals(mainAgencyCode)) {
                        return o1.getSortOrder().compareTo(o2.getSortOrder());
                    }
                    if (subagencyCode01.equals(mainAgencyCode)) {
                        return -1;
                    }
                    if (subagencyCode02.equals(mainAgencyCode)) {
                        return 1;
                    }
                    if (!subagencyCode01.equals(subagencyCode02)) {
                        return subagencyCode01.compareTo(subagencyCode02);
                    }
                    return o1.getSortOrder().compareTo(o2.getSortOrder());
                }
            });
        } else {
            Collections.sort(batchDataList, new Comparator<XFSalesReportBatchData>(){

                @Override
                public int compare(XFSalesReportBatchData o1, XFSalesReportBatchData o2) {
                    return o1.getSortOrder().compareTo(o2.getSortOrder());
                }
            });
        }
        this.sortTicketsOfBatches(data, messages);
    }

    private boolean getMultiReportMode() {
        return "YES".equalsIgnoreCase(DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.XML_REPORT_TICKET_ORDER_FOR_MULTYAGENCY_REPORT, null));
    }

    protected void sortTicketsOfBatches(Map<String, Object> data, List<Message> messages) throws Exception {
        List batchDataList = (List)data.get("key-batch-data-list");
        if (batchDataList != null) {
            int batchNo = 1;
            for (XFSalesReportBatchData batchData : batchDataList) {
                batchData.sortTickets();
                batchNo = batchData.enumerateTickets(batchNo, batchData.getBatchId());
                ++batchNo;
            }
        }
    }

    private String getVendorCode() {
        return "XF";
    }

    protected String getStockControlReportUid() {
        return "xf-stock-control-report";
    }

    protected void prepareStockData(Map<String, Object> data) throws Exception {
        ReportParameters parameters = (ReportParameters)data.get("key-report-params");
        parameters.getAdditionalCriterions().clear();
        List profiles = ProfileDao.getProfileReferenceByCode((String)this.getVendorCode(), OrganizationIndex.class);
        parameters.setBlankOwner(profiles.isEmpty() ? null : (EntityReference)profiles.get(0));
        HashMap<String, Object> stockControlData = new HashMap<String, Object>();
        stockControlData.put("key-report-params", parameters);
        stockControlData.put("KEY_REPORT_FILENAME", data.get("KEY_REPORT_FILENAME"));
        stockControlData.put("AIRLINE_IATA_CODE", data.get("AIRLINE_IATA_CODE"));
        stockControlData.put("AGENCY_IATA_CODE", data.get("AGENCY_IATA_CODE"));
        String stockControlReportUid = this.getStockControlReportUid();
        this.log.debug(String.format("prepareStockData() BEGIN handler: %s", stockControlReportUid));
        ((PrepareHandlersRegistry)Environment.getPublished(PrepareHandlersRegistry.class)).get(stockControlReportUid).prepareData(stockControlData);
        this.log.debug(String.format("prepareStockData() END handler: %s", stockControlReportUid));
        List messages = (List)data.get("key-messages");
        List stockControlMessages = (List)stockControlData.get("key-messages");
        if (messages != null) {
            for (Message stockControlMessage : stockControlMessages) {
                if (messages.contains(stockControlMessage)) continue;
                messages.add(stockControlMessage);
            }
        }
        data.put("key-stock-control-data", stockControlData);
    }

    @Override
    protected void checkReportParameters(Map<String, Object> data, List<Message> messages) throws Exception {
        if (data.get("key-report-params") == null) {
            SystemHelper.addMessage(messages, (String)Messages.XFSalesReportPrepareHandler_reportNoParam, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            this.log.error("report parameters are absent");
            return;
        }
        ReportParameters parameters = (ReportParameters)data.get("key-report-params");
        if (parameters.getBlankOwner() == null) {
            SystemHelper.addMessage(messages, (String)Messages.XFSalesReportPrepareHandler_reportParamNoBlankOwner, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            this.log.error("blank owner profile is not defined in report parameters");
            return;
        }
        if (parameters.getAgency() == null) {
            SystemHelper.addMessage(messages, (String)Messages.XFSalesReportPrepareHandler_reportParamNoAgency, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            this.log.error("agency profile is not defined in report parameters");
            return;
        }
    }

    @Override
    protected void putGlobalData(Map<String, Object> data, List<Message> messages) throws Exception {
        ReportParameters parameters = (ReportParameters)data.get("key-report-params");
        XFSalesReportPrepareHandler.putStandardReportParameters(parameters.getPeriodBegin(), parameters.getPeriodEnd(), data, messages);
        EntityContainer blankOwnerContainer = EntityStorage.get().resolve(parameters.getBlankOwner());
        Airline airline = (Airline)DictionaryCache.get().resolveReference(((Organization)blankOwnerContainer.getEntity()).getAirline());
        if (airline == null) {
            airline = DictHelper.findAirlineByAnyCode((String)((Organization)blankOwnerContainer.getEntity()).getCode(), (Date)parameters.getPeriodBegin());
        }
        if (airline != null) {
            data.put("AIRLINE_IATA_CODE", airline.getAirlineNumber());
        }
        EntityReference agencyReference = parameters.getAgency();
        EntityContainer agencyContainer = EntityStorage.get().resolve(agencyReference);
        Organization agency = (Organization)agencyContainer.getEntity();
        data.put("AGENCY_NAME", ProfileHelper.getFullName((Organization)agency, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
        String agencyCode = SystemHelper.findMetadataAsString((Collection)agency.getMetadata(), (MetadataKey)this.getAgencyReportCode((BaseReportParameters)((ReportParameters)data.get("key-report-params"))));
        data.put("AGENCY_IATA_CODE", agencyCode);
        List employees = com.gridnine.xtrip.common.model.helpers.ProfileDao.getEmployees((EntityReference)agencyReference, (ManagerType[])new ManagerType[0], (Date)new Date());
        for (Person employee : employees) {
            String fullName = ProfileHelper.getFullName((Person)employee, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false);
            Set standardPositions = ProfileHelper.getStandardPositions((List)employee.getEmployments(), (EntityReference)agencyReference);
            for (ManagerType standardPosition : standardPositions) {
                if (standardPosition == ManagerType.DIRECTOR) {
                    data.put("AGENCY_DIRECTOR", fullName);
                    continue;
                }
                if (standardPosition == ManagerType.CHIEF_ACCOUNTANT) {
                    data.put("AGENCY_ACCOUNTANT", fullName);
                    continue;
                }
                if (standardPosition != ManagerType.CHIEF_MUTUAL) continue;
                data.put("AGENCY_CHIEF_MUTUAL", fullName);
            }
        }
    }

    @Override
    protected Set<Product> getData(Map<String, Object> data, List<Message> messages) throws Exception {
        ReportParameters parameters = (ReportParameters)data.get("key-report-params");
        SearchQuery searchQuary = SalesReportPrepareHelper.createQuery(parameters);
        searchQuary.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ProductIndex.Property.tariffType.name(), (Object)TariffType.REGULAR), SearchCriterion.eq((String)ProductIndex.Property.tariffType.name(), (Object)TariffType.GROUP)}));
        Set<Product> products = SalesReportPrepareHelper.getProducts(searchQuary, messages);
        if (products.isEmpty()) {
            SystemHelper.addMessage(messages, (String)Messages.reportNoTicket, null, (MessageType)MessageType.WARNING, (Object[])new Object[0]);
            this.log.warn("no tickets were found for report");
        }
        return products;
    }

    @Override
    protected void validateProductToReport(Product product, Map<String, Object> data, List<Message> messages) throws Exception {
        super.validateProductToReport(product, data, messages);
        if (TextUtil.isBlank((String)product.getValidatorCode())) {
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Message_NoValidator", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{product.getSystemNumber()});
        }
    }
}

