/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.stockcontrol;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ManagerType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileDao;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.ContractCustomerIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.stockcontrol.BlankOrderLogItem;
import com.gridnine.xtrip.common.model.stockcontrol.StockBlank;
import com.gridnine.xtrip.common.model.stockcontrol.StockBlankIndex;
import com.gridnine.xtrip.common.model.stockcontrol.UsageStatus;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.BaseReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.reports.prepare.ReportPrepareHandler;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseStockControlReportPrepareHandler
implements ReportPrepareHandler {
    static String BaseStockControlReportPrepareHandler_parametersAreMissed = "Stock control report parameters are absent";
    static String BaseStockControlReportPrepareHandler_wrongDateParameters = "Stock control report incorrect date parameters";
    static String BaseStockControlReportPrepareHandler_hasNoVendorParameter = "Stock control report has no vendor parameter";
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public void prepareData(Map<String, Object> data) throws Exception {
        ArrayList<Message> messages = new ArrayList<Message>();
        data.put("key-messages", messages);
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        this.checkReportParameters(params, messages);
        if (this.isHashErrors(messages)) {
            return;
        }
        BaseStockControlReportPrepareHandler.putStandardReportParameters(params.getPeriodBegin(), params.getPeriodEnd(), data, messages);
        data.put("key-batch-data-list", this.getData(data, messages));
        EntityReference agencyReference = params.getAgency();
        EntityContainer ac = EntityStorage.get().resolve(agencyReference);
        if (ac != null) {
            Organization agency = (Organization)ac.getEntity();
            List com = agency.getCommunications();
            if (!com.isEmpty()) {
                String phone = "";
                String email = "";
                for (Communication communication : com) {
                    String sense = communication.getSense() != null && !communication.getSense().isEmpty() ? communication.getSense() : "";
                    switch (communication.getType()) {
                        case HOME_PHONE: 
                        case WORK_PHONE: 
                        case MOBILE: {
                            phone = sense;
                            break;
                        }
                        case EMAIL: {
                            email = sense;
                            break;
                        }
                    }
                }
                data.put("AGENCY_PHONE", phone);
                data.put("AGENCY_EMAIL", email);
            } else {
                data.put("AGENCY_PHONE", "-");
                data.put("AGENCY_EMAIL", "-");
            }
            String agencyFullName = this.buildAgencyName(agency);
            data.put("AGENCY_NAME", agencyFullName);
            MetadataKey agencyReportCodeKey = this.getAgencyReportCode((BaseReportParameters)data.get("key-report-params"));
            String agencyCode = SystemHelper.findMetadataAsString((Collection)agency.getMetadata(), (MetadataKey)agencyReportCodeKey);
            String oldSuAgencyCode = null;
            if (agencyReportCodeKey != null && agencyReportCodeKey.equals((Object)MetadataKey.KEY_SU_2013_AGENCY_CODE) && !TextUtil.isBlank((String)agencyCode)) {
                oldSuAgencyCode = SystemHelper.findMetadataAsString((Collection)agency.getMetadata(), (MetadataKey)MetadataKey.KEY_SU_AGENCY_CODE);
                data.put("KEY_SU_2013_AGENCY_CODE", oldSuAgencyCode);
            }
            EntityContainer blankOwner = EntityStorage.get().resolve(params.getBlankOwner());
            String airlineName = "";
            if (blankOwner != null) {
                Object airlineObj = (Airline)DictionaryCache.get().resolveReference(((Organization)blankOwner.getEntity()).getAirline());
                if (airlineObj == null) {
                    airlineObj = DictHelper.findAirlineByAnyCode((String)((Organization)blankOwner.getEntity()).getCode(), (Date)params.getPeriodBegin());
                }
                airlineName = L10nStringHelper.getValue((L10nString)((Organization)blankOwner.getEntity()).getShortName(), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false);
                if (airlineObj != null) {
                    data.put("AIRLINE_IATA_CODE", airlineObj.getAirlineNumber());
                }
                if (!TextUtil.isBlank((String)airlineName)) {
                    data.put("AIRLINE_NAME", airlineName);
                } else {
                    SystemHelper.addMessage(messages, (String)Messages.BaseStockControlReportPrepareHandler_AirlineNameNotFound, null, (MessageType)MessageType.WARNING, (Object[])new Object[]{MiscUtil.toString((Object)airlineName)});
                }
                Organization entBlankOwner = (Organization)blankOwner.getEntity();
                String legalForm = DictHelper.getShortLegalForm((DictionaryReference)entBlankOwner.getLegalForm(), null);
                if (legalForm == null) {
                    legalForm = "";
                }
                StringBuilder sb = new StringBuilder();
                sb.append(legalForm);
                if (entBlankOwner.getFullName() != null) {
                    sb.append(" \"");
                    sb.append(entBlankOwner.getFullName());
                    sb.append("\"");
                }
                data.put("VENDOR_NAME", sb.toString());
            }
            if (TextUtil.isBlank((String)agencyCode)) {
                SystemHelper.addMessage(messages, (String)"BaseStockControlReportPrepareHandler_Message_AgencyCodeIsEmpty", null, (MessageType)MessageType.WARNING, (Object[])new Object[]{agency.getFullName(), MiscUtil.toString((Object)airlineName)});
            }
            data.put("AGENCY_IATA_CODE", agencyCode);
            if (TextUtil.isBlank((String)agencyCode)) {
                SystemHelper.addMessage(messages, (String)"BaseStockControlReportPrepareHandler_Message_AgencyCodeIsEmpty", null, (MessageType)MessageType.WARNING, (Object[])new Object[]{agency.getFullName(), MiscUtil.toString((Object)airlineName)});
            }
            for (Address address : ProfileHelper.getOrganizationAddresses((Organization)agency)) {
                if (address.getAddressType() != AddressType.LEGAL) continue;
                data.put("AGENT_LOCATION", ProfileHelper.buildShortAddress((Address)address, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
                data.put("AGENCY_CITY", address.getCity() != null ? address.getCity().toString() : null);
                break;
            }
            List employees = ProfileDao.getEmployees((EntityReference)agencyReference, (ManagerType[])new ManagerType[0], (Date)new Date());
            for (Person employee : employees) {
                String fullName = ProfileHelper.getFullName((Person)employee, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false);
                Set standardPositions = ProfileHelper.getStandardPositions((List)employee.getEmployments(), (EntityReference)agencyReference);
                for (ManagerType standardPosition : standardPositions) {
                    if (standardPosition == ManagerType.DIRECTOR) {
                        data.put("DIRECTOR", fullName);
                        data.put("AGENCY_DIRECTOR", fullName);
                        continue;
                    }
                    if (standardPosition == ManagerType.CHIEF_ACCOUNTANT) {
                        data.put("AGENCY_ACCOUNTANT", fullName);
                        continue;
                    }
                    if (standardPosition == ManagerType.TRAVEL_MANAGER) {
                        data.put("AGENT_NAME", fullName);
                        continue;
                    }
                    if (standardPosition != ManagerType.CHIEF_MUTUAL) continue;
                    data.put("AGENCY_CHIEF_MUTUAL", fullName);
                }
            }
            this.prepareContractData(data, (EntityContainer<Organization>)blankOwner, messages);
        }
    }

    public static void putStandardReportParameters(Date periodBegin, Date periodEnd, Map<String, Object> data, List<Message> messages) {
        String reportPeriod = "";
        String reportFileName = "";
        SimpleDateFormat df = new SimpleDateFormat("dd", new Locale("ru", "RU"));
        SimpleDateFormat df2 = new SimpleDateFormat("dd.MM.yy", new Locale("ru", "RU"));
        if (periodBegin != null && periodEnd != null) {
            if (periodBegin.getDate() == periodEnd.getDate() && periodBegin.getMonth() == periodEnd.getMonth() && periodBegin.getYear() == periodEnd.getYear()) {
                reportPeriod = df2.format(periodEnd);
                reportFileName = reportFileName + "_" + df2.format(periodEnd);
            } else if (periodBegin.getMonth() == periodEnd.getMonth() && periodBegin.getYear() == periodEnd.getYear()) {
                reportPeriod = df.format(periodBegin) + "-" + df2.format(periodEnd);
                reportFileName = reportFileName + "_" + df2.format(periodBegin) + "-" + df2.format(periodEnd);
            } else {
                reportPeriod = df2.format(periodBegin) + "-" + df2.format(periodEnd);
                reportFileName = reportFileName + "_" + df2.format(periodBegin) + "-" + df2.format(periodEnd);
            }
        }
        data.put("REPORT_PERIOD", reportPeriod);
        data.put("KEY_REPORT_FILENAME", reportFileName);
        data.put("CURRENT_DATE", df2.format(new Date()));
    }

    protected Set<StockBlank> getData(Map<String, Object> data, List<Message> messages) throws Exception {
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        Date beginDate = params.getPeriodBegin();
        Date endDate = params.getPeriodEnd();
        EntityStorage es = EntityStorage.get();
        EntityContainer ownerRefCon = EntityStorage.get().resolve(params.getBlankOwner());
        if (ownerRefCon == null) {
            return Collections.emptySet();
        }
        EntityReference ownerRef = ownerRefCon.toReference();
        EntityReference supplierRef = params.getSupplier();
        EntityReference agencyRef = params.getAgency();
        SearchQuery query = new SearchQuery();
        List criterions = query.getCriteria().getCriterions();
        if (ownerRef != null) {
            criterions.add(SearchCriterion.eq((String)StockBlankIndex.Property.owner.name(), (Object)ownerRef.getUid()));
        }
        if (supplierRef != null) {
            criterions.add(SearchCriterion.eq((String)StockBlankIndex.Property.supplier.name(), (Object)supplierRef.getUid()));
        }
        if (agencyRef != null) {
            criterions.add(SearchCriterion.eq((String)StockBlankIndex.Property.stockHolder.name(), (Object)agencyRef.getUid()));
        }
        SearchCriterion sc1 = SearchCriterion.le((String)StockBlankIndex.Property.registrationDate.name(), (Object)endDate);
        SearchCriterion sc2 = SearchCriterion.eq((String)StockBlankIndex.Property.operationDate.name(), null);
        SearchCriterion sc3 = SearchCriterion.ge((String)StockBlankIndex.Property.operationDate.name(), (Object)beginDate);
        SearchCriterion sc4 = SearchCriterion.ne((String)StockBlankIndex.Property.vendorPaymentDate.name(), null);
        SearchCriterion sc5 = SearchCriterion.ge((String)StockBlankIndex.Property.vendorPaymentDate.name(), (Object)beginDate);
        criterions.add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{sc2, sc3, SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{sc4, sc5})})}));
        criterions.add(SearchCriterion.ne((String)StockBlankIndex.Property.usageStatus.name(), (Object)UsageStatus.LOCKED));
        boolean currentLocationUsed = false;
        SearchCriterion.SimpleCriterion simpleCriterion = null;
        for (SearchCriterion searchCriterion : params.getAdditionalCriterions()) {
            if (!(searchCriterion instanceof SearchCriterion.SimpleCriterion) || !(simpleCriterion = (SearchCriterion.SimpleCriterion)searchCriterion).getProperty().equals(StockBlankIndex.Property.currentLocation.name())) continue;
            currentLocationUsed = true;
            break;
        }
        EntityReference currentLocation = null;
        if (simpleCriterion != null && params.getAdditionalCriterions().contains(simpleCriterion)) {
            params.getAdditionalCriterions().remove(simpleCriterion);
            if (simpleCriterion.getValue() != null && simpleCriterion.getValue() instanceof EntityReference) {
                currentLocation = (EntityReference)simpleCriterion.getValue();
            }
        }
        criterions.addAll(params.getAdditionalCriterions());
        if (simpleCriterion != null) {
            params.getAdditionalCriterions().add(simpleCriterion);
        }
        List allData = es.search(StockBlankIndex.class, query).getData();
        HashSet<StockBlank> blanks = new HashSet<StockBlank>();
        StockBlank stockBlank = null;
        boolean validBlank = true;
        for (StockBlankIndex index : allData) {
            stockBlank = (StockBlank)es.resolve(index.getSource()).getEntity();
            if (currentLocationUsed) {
                validBlank = false;
                for (BlankOrderLogItem blankOrderLogItem : stockBlank.getOrderLogItems()) {
                    if (blankOrderLogItem.getBlankLocation() == null || !blankOrderLogItem.getBlankLocation().equals((Object)currentLocation)) continue;
                    validBlank = true;
                    break;
                }
            }
            if (!validBlank) continue;
            blanks.add(stockBlank);
        }
        return blanks;
    }

    protected boolean isHashErrors(List<Message> messages) {
        if (messages == null || messages.isEmpty()) {
            return false;
        }
        for (Message message : messages) {
            if (message.getType() != MessageType.ERROR) continue;
            return true;
        }
        return false;
    }

    protected void checkReportParameters(ReportParameters params, List<Message> messages) throws Exception {
        if (params == null) {
            SystemHelper.addMessage(messages, (String)BaseStockControlReportPrepareHandler_parametersAreMissed, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            this.log.error("Sales report parameters are absent");
            return;
        }
        if (params.getPeriodBegin() == null || params.getPeriodEnd() == null) {
            SystemHelper.addMessage(messages, (String)BaseStockControlReportPrepareHandler_wrongDateParameters, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            this.log.error("Stock control report incorrect date parameters");
            return;
        }
        if (params.getBlankOwner() == null) {
            SystemHelper.addMessage(messages, (String)BaseStockControlReportPrepareHandler_hasNoVendorParameter, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            this.log.error("Stock control report has no vendor");
            return;
        }
    }

    protected String buildAgencyName(Organization agency) {
        if (agency == null) {
            return "";
        }
        String legalForm = DictHelper.getShortLegalForm((DictionaryReference)agency.getLegalForm(), null);
        if (legalForm == null) {
            legalForm = "";
        }
        String name = agency.getFullName() != null ? "\"" + agency.getFullName() + "\"" : "";
        return legalForm + " " + name;
    }

    protected void prepareContractData(Map<String, Object> data, EntityContainer<Organization> vendor, List<Message> messages) throws Exception {
        List indexes;
        if (vendor == null) {
            return;
        }
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        if (params == null) {
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_Internal_error", null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            this.log.error("internal report handler error: in getAppropriateContracts(...) params is empty");
            return;
        }
        EntityReference agency = params.getAgency();
        if (agency == null) {
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_Internal_error", null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            this.log.error("internal report handler error: in getAppropriateContracts(...) agency is empty");
            return;
        }
        EntityReference supplier = params.getSupplier();
        if (supplier == null) {
            supplier = vendor.toReference();
        }
        if (supplier == null) {
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_Internal_error", null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            this.log.error("internal report handler error: in getAppropriateContracts(...) unable to define supplier");
            return;
        }
        EntityStorage es = EntityStorage.get();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.contractType.name(), (Object)ContractType.VENDOR), SearchCriterion.eq((String)ContractCustomerIndex.Property.vendor.name(), (Object)vendor.getUid()), SearchCriterion.eq((String)ContractCustomerIndex.Property.supplier.name(), (Object)supplier.getUid()), SearchCriterion.eq((String)ContractCustomerIndex.Property.customer.name(), (Object)agency.getUid())}));
        Date startDate = params.getPeriodBegin();
        Date endDate = params.getPeriodEnd();
        if (startDate != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.endDate.name(), null), SearchCriterion.ge((String)ContractCustomerIndex.Property.endDate.name(), (Object)startDate)}));
        }
        if (endDate != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.startDate.name(), null), SearchCriterion.le((String)ContractCustomerIndex.Property.startDate.name(), (Object)endDate)}));
        }
        if ((indexes = es.search(ContractCustomerIndex.class, query).getData()).isEmpty()) {
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_NoContracts", null, (MessageType)MessageType.WARNING, (Object[])new Object[0]);
            this.log.debug("No contracts found for the report parameters");
            return;
        }
        Collections.sort(indexes, new Comparator<ContractCustomerIndex>(){

            @Override
            public int compare(ContractCustomerIndex o1, ContractCustomerIndex o2) {
                return MiscUtil.compare((Date)o1.getIssueDate(), (Date)o2.getIssueDate(), (boolean)true);
            }
        });
        data.put("CONTRACT_NO", ((ContractCustomerIndex)indexes.get(0)).getNumber());
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy", new Locale("ru", "RU"));
        data.put("CONTRACT_ISSUE_DATE", ((ContractCustomerIndex)indexes.get(0)).getIssueDate() != null ? sdf.format(((ContractCustomerIndex)indexes.get(0)).getIssueDate()) : "");
    }

    protected abstract MetadataKey getAgencyReportCode(BaseReportParameters var1);
}

