/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.stockcontrol.universal;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.BaseReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.reports.prepare.stockcontrol.BaseStockControlReportPrepareHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class UniversalStockControlReportPrepareHandler
extends BaseStockControlReportPrepareHandler {
    @Override
    protected MetadataKey getAgencyReportCode(BaseReportParameters params) {
        return null;
    }

    @Override
    public String getId() {
        return "univarsal-stock-control";
    }

    @Override
    public void prepareData(Map<String, Object> data) throws Exception {
        ArrayList<Message> messages = new ArrayList<Message>();
        data.put("key-messages", messages);
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        this.checkReportParameters(params, messages);
        if (this.isHashErrors(messages)) {
            return;
        }
        data.put("key-batch-data-list", this.getData(data, messages));
        EntityContainer ac = EntityStorage.get().resolve(params.getAgency());
        if (ac != null) {
            Organization agency = (Organization)ac.getEntity();
            List com = agency.getCommunications();
            if (!com.isEmpty()) {
                String phone = "";
                String email = "";
                for (Communication communication : com) {
                    String sense = communication.getSense() != null && !communication.getSense().isEmpty() ? communication.getSense() : "";
                    switch (communication.getType()) {
                        case HOME_PHONE: 
                        case WORK_PHONE: 
                        case MOBILE: {
                            phone = sense;
                            break;
                        }
                        case EMAIL: {
                            email = sense;
                            break;
                        }
                    }
                }
                data.put("AGENCY_PHONE", phone);
                data.put("AGENCY_EMAIL", email);
            } else {
                data.put("AGENCY_PHONE", "-");
                data.put("AGENCY_EMAIL", "-");
            }
            EntityContainer blankOwner = EntityStorage.get().resolve(params.getBlankOwner());
            if (blankOwner == null) {
                SystemHelper.addMessage(messages, (String)Messages.UniversalStockControlReportPrepareHandler_blankOwner, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
                return;
            }
            String airlineName = L10nStringHelper.getValue((L10nString)((Organization)blankOwner.getEntity()).getShortName(), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false);
            Airline airlineObj = (Airline)DictionaryCache.get().resolveReference(((Organization)blankOwner.getEntity()).getAirline());
            if (airlineObj != null) {
                data.put("AIRLINE_IATA_CODE", airlineObj.getAirlineNumber());
            }
            if (!TextUtil.isBlank((String)airlineName)) {
                data.put("AIRLINE_NAME", airlineName);
            } else {
                SystemHelper.addMessage(messages, (String)Messages.UniversalStockControlReportPrepareHandler_airlineNameNotFound, null, (MessageType)MessageType.WARNING, (Object[])new Object[]{MiscUtil.toString((Object)airlineName)});
            }
            String agencyFullName = this.buildAgencyName(agency);
            data.put("AGENCY_NAME", agencyFullName);
            String agencyCode = SystemHelper.findMetadataAsString((Collection)agency.getMetadata(), (MetadataKey)this.getAgencyReportCode((DictionaryReference<Airline>)((Organization)blankOwner.getEntity()).getAirline()));
            if (TextUtil.isBlank((String)agencyCode)) {
                SystemHelper.addMessage(messages, (String)"BaseStockControlReportPrepareHandler_Message_AgencyCodeIsEmpty", null, (MessageType)MessageType.WARNING, (Object[])new Object[]{agency.getFullName(), MiscUtil.toString((Object)airlineName)});
            } else {
                data.put("AGENCY_IATA_CODE", agencyCode);
            }
        }
    }

    private MetadataKey getAgencyReportCode(DictionaryReference<Airline> airline) {
        if (airline != null) {
            if ("SU".equals(airline.getCode())) {
                return MetadataKey.KEY_SU_AGENCY_CODE;
            }
            if ("S7".equals(airline.getCode())) {
                return MetadataKey.KEY_S7_AGENCY_CODE;
            }
            if ("FV".equals(airline.getCode())) {
                return MetadataKey.KEY_FV_AGENCY_CODE;
            }
            if ("\u04281".equals(airline.getCode())) {
                return MetadataKey.KEY_TCH_AGENCY_CODE;
            }
            if ("VV".equals(airline.getCode())) {
                return MetadataKey.KEY_VV_AGENCY_CODE;
            }
        }
        return null;
    }
}

