/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.template.agent;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductFopIndex;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.dict.CurrencyInfoReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElement;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementType;
import com.gridnine.xtrip.common.model.finance.DimensionType;
import com.gridnine.xtrip.common.model.finance.Transaction;
import com.gridnine.xtrip.common.model.finance.TransactionSplit;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.AccountingEntryHelper;
import com.gridnine.xtrip.common.model.helpers.BalanceHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.ModelHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.system.AccountingEntry;
import com.gridnine.xtrip.common.model.system.AccountingEntryIndex;
import com.gridnine.xtrip.common.model.system.AccountingEntryType;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.Worklog;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.AgentReportParameters;
import com.gridnine.xtrip.common.reports.model.AgentTemplateReportDescription;
import com.gridnine.xtrip.common.reports.model.AgentTemplateReportDocument;
import com.gridnine.xtrip.common.reports.model.AgentTemplateReportDocumentIndex;
import com.gridnine.xtrip.common.reports.model.AgentTemplateReportParameters;
import com.gridnine.xtrip.common.reports.model.AgentTemplateReportTicket;
import com.gridnine.xtrip.common.reports.model.BaseSingleFileTemplateReportDescription;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportDocument;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportParameters;
import com.gridnine.xtrip.common.reports.model.GeneralAgentTemplateReportPageDescription;
import com.gridnine.xtrip.common.reports.model.ReportHelper;
import com.gridnine.xtrip.common.reports.model.TemplateReportPeriodUse;
import com.gridnine.xtrip.common.reports.render.template.common.CommonTemplateReportHelper;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.reports.prepare.template.agent.AgentTemplateReportTicketPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.template.agent.AgentTemplateReportTicketPrepareHandlersRegistry;
import com.gridnine.xtrip.server.reports.prepare.template.common.BaseGroupedTemplateReportPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.template.common.TemplateReportHelper;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class AgentTemplateReportPrepareHandler
extends BaseGroupedTemplateReportPrepareHandler<BaseProduct, AgentTemplateReportTicket, AgentTemplateReportParameters, AgentTemplateReportDescription, GeneralAgentTemplateReportPageDescription, AgentTemplateReportDocument, BookingFile> {
    private static final String KEY_DEBIT_AMOUNTS = "key-debit-amounts";
    private static final String KEY_CREDIT_AMOUNTS = "key-credit-amounts";
    private static final String KEY_REMAINS_CASH_AMOUNT = "key-remains-cash-amount";
    private static final String KEY_COLLECTIONS_DEBIT_DATA = "key-collections-debit-data";
    private static final String KEY_COLLECTIONS_CREDIT_DATA = "key-collections-credit-data";
    private static final String KEY_COLLECTIONS_DEBIT_AMOUNT = "key-collections-debit-amount";
    private static final String KEY_COLLECTIONS_CREDIT_AMOUNT = "key-collections-credit-amount";

    @Override
    public String getId() {
        return "agent-template-report";
    }

    @Override
    protected void setData(AgentTemplateReportDocument document, AgentTemplateReportParameters params, Map<String, Object> data) {
        Map creditAmounts;
        document.setParameters(params);
        Map debitAmounts = (Map)data.get(KEY_DEBIT_AMOUNTS);
        if (debitAmounts != null) {
            document.getDebitAmounts().clear();
            document.getDebitAmounts().putAll(debitAmounts);
        }
        if ((creditAmounts = (Map)data.get(KEY_CREDIT_AMOUNTS)) != null) {
            document.getCreditAmounts().clear();
            document.getCreditAmounts().putAll(creditAmounts);
        }
    }

    @Override
    protected AgentTemplateReportDocument createDocument() {
        return new AgentTemplateReportDocument();
    }

    @Override
    protected Class<AgentTemplateReportTicket> getItemClass(AgentTemplateReportDescription description) {
        return AgentTemplateReportTicket.class;
    }

    @Override
    protected List<GeneralAgentTemplateReportPageDescription> getPages(AgentTemplateReportDescription entity) {
        return entity.getPages();
    }

    @Override
    protected Map<String, Object> getGlobalParameters(Map<String, Object> data, AgentTemplateReportParameters params, List<Message> messages) throws Exception {
        Map<String, Object> result = TemplateReportHelper.getGlobalParameters(params, messages);
        boolean individualCashRemains = ProfileHelper.isIndividualCashRemains((EntityReference)params.getSalesPoint());
        if (params.isUseNewCashRemains()) {
            Date calculationDate = new Date();
            CurrencyInfoReference currency = new CurrencyInfoReference(DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB"));
            List transactions = individualCashRemains ? BalanceHelper.getTransactions((EntityReference)params.getSubagency(), (Date)params.getPeriodBegin(), (Date)params.getPeriodEnd(), (Date)calculationDate, (ChartOfAccountsElementType)ChartOfAccountsElementType.CASH_REMAINS_AGENT, (DictionaryReference)currency, Collections.singletonMap(DimensionType.AGENT, params.getAgent()), (boolean)true) : BalanceHelper.getTransactions((EntityReference)params.getSubagency(), (Date)params.getPeriodBegin(), (Date)params.getPeriodEnd(), (Date)calculationDate, (ChartOfAccountsElementType)ChartOfAccountsElementType.CASH_REMAINS_AGENT, (DictionaryReference)currency, Collections.singletonMap(DimensionType.CASH_REGISTER_WORKPLACE, params.getCashRegisterWorkplace()), (boolean)true);
            List cashRemainsTransactions = transactions.stream().filter(transaction -> transaction.getSplits().stream().filter(split -> !split.isCredit() && split.getAmount() < 0L).map(split -> EntityStorage.get().resolve(split.getAccount())).anyMatch(chartOfAccountsElement -> chartOfAccountsElement != null && ((ChartOfAccountsElement)chartOfAccountsElement.getEntity()).getType() == ChartOfAccountsElementType.CASH_REMAINS_STASH)).collect(Collectors.toList());
            BigDecimal cashRemainsAmount = cashRemainsTransactions.stream().flatMap(item -> item.getSplits().stream()).filter(item -> item.isCredit()).map(item -> MiscUtil.negate((BigDecimal)ModelHelper.long2BigDecimal((long)item.getAmount()))).reduce((a, b) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{a, b})).orElse(null);
            List cashTransactions = transactions.stream().filter(item -> item.getSplits().stream().filter(split -> !split.isCredit()).map(split -> EntityStorage.get().resolve(split.getAccount())).anyMatch(chartOfAccountsElement -> chartOfAccountsElement != null && ((ChartOfAccountsElement)chartOfAccountsElement.getEntity()).getType() == ChartOfAccountsElementType.CASH_REMAINS_CASH)).collect(Collectors.toList());
            List collectionsDebitData = cashTransactions.stream().flatMap(item -> item.getSplits().stream().map(split -> new MiscUtil.Pair(item, split))).filter(item -> ((TransactionSplit)item.getSecond()).isCredit() && ((TransactionSplit)item.getSecond()).getAmount() < 0L).map(item -> new MiscUtil.Pair((Object)MiscUtil.negate((BigDecimal)ModelHelper.long2BigDecimal((long)((TransactionSplit)item.getSecond()).getAmount())), (Object)((Transaction)item.getFirst()).getDescription())).collect(Collectors.toList());
            List collectionsCreditData = cashTransactions.stream().flatMap(item -> item.getSplits().stream().map(split -> new MiscUtil.Pair(item, split))).filter(item -> ((TransactionSplit)item.getSecond()).isCredit() && ((TransactionSplit)item.getSecond()).getAmount() >= 0L).map(item -> new MiscUtil.Pair((Object)MiscUtil.negate((BigDecimal)ModelHelper.long2BigDecimal((long)((TransactionSplit)item.getSecond()).getAmount())), (Object)((Transaction)item.getFirst()).getDescription())).collect(Collectors.toList());
            BigDecimal collectionsDebitAmount = collectionsDebitData.stream().map(item -> (BigDecimal)item.getFirst()).reduce((a, b) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{a, b})).orElse(null);
            BigDecimal collectionsCreditAmount = collectionsCreditData.stream().map(item -> (BigDecimal)item.getFirst()).reduce((a, b) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{a, b})).orElse(null);
            result.put(KEY_REMAINS_CASH_AMOUNT, cashRemainsAmount);
            result.put(KEY_COLLECTIONS_DEBIT_DATA, collectionsDebitData);
            result.put(KEY_COLLECTIONS_CREDIT_DATA, collectionsCreditData);
            result.put(KEY_COLLECTIONS_DEBIT_AMOUNT, collectionsDebitAmount);
            result.put(KEY_COLLECTIONS_CREDIT_AMOUNT, collectionsCreditAmount);
        } else {
            BigDecimal cashRemainsAmount = params.getPeriodBegin() != null ? (individualCashRemains ? AccountingEntryHelper.calculateAccountingEntriesAmount(null, null, null, (EntityReference)params.getAgent(), null, null, (Date)MiscUtil.getBeforeTime((Date)params.getPeriodBegin())) : AccountingEntryHelper.calculateAccountingEntriesAmount(null, null, (EntityReference)params.getCashRegisterWorkplace(), null, null, null, (Date)MiscUtil.getBeforeTime((Date)params.getPeriodBegin()))) : BigDecimal.ZERO;
            result.put(KEY_REMAINS_CASH_AMOUNT, cashRemainsAmount);
            ArrayList<MiscUtil.Pair> collectionsDebitData = new ArrayList<MiscUtil.Pair>();
            BigDecimal collectionsDebitAmount = null;
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)AccountingEntryIndex.Property.type.name(), (Object)AccountingEntryType.COLLECTION));
            if (individualCashRemains) {
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)AccountingEntryIndex.Property.debitEmployee.name(), (Object)params.getAgent()));
            } else {
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)AccountingEntryIndex.Property.debitCashRegisterWorkplace.name(), (Object)params.getCashRegisterWorkplace()));
            }
            if (params.getPeriodBegin() != null) {
                query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)AccountingEntryIndex.Property.endDate.name(), (Object)params.getPeriodBegin()), SearchCriterion.eq((String)AccountingEntryIndex.Property.endDate.name(), null)}));
            }
            if (params.getPeriodEnd() != null) {
                query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.le((String)AccountingEntryIndex.Property.startDate.name(), (Object)params.getPeriodEnd()), SearchCriterion.eq((String)AccountingEntryIndex.Property.startDate.name(), null)}));
            }
            List accountingEntryIndexes = EntityStorage.get().search(AccountingEntryIndex.class, query).getData();
            for (AccountingEntryIndex accountingEntryIndex : accountingEntryIndexes) {
                EntityContainer accountingEntryContainer = EntityStorage.get().resolve(accountingEntryIndex.getSource());
                if (accountingEntryContainer == null) continue;
                AccountingEntry accountingEntry = (AccountingEntry)accountingEntryContainer.getEntity();
                collectionsDebitData.add(new MiscUtil.Pair((Object)(accountingEntry.getAmount() != null ? accountingEntry.getAmount().getValue() : null), accountingEntry.getCreditContractor() != null ? accountingEntry.getCreditContractor().toString() : null));
                if (accountingEntry.getAmount() == null) continue;
                collectionsDebitAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{collectionsDebitAmount, accountingEntry.getAmount().getValue()});
            }
            ArrayList<MiscUtil.Pair> collectionsCreditData = new ArrayList<MiscUtil.Pair>();
            BigDecimal collectionsCreditAmount = null;
            query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)AccountingEntryIndex.Property.type.name(), (Object)AccountingEntryType.COLLECTION));
            if (individualCashRemains) {
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)AccountingEntryIndex.Property.creditEmployee.name(), (Object)params.getAgent()));
            } else {
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)AccountingEntryIndex.Property.creditCashRegisterWorkplace.name(), (Object)params.getCashRegisterWorkplace()));
            }
            if (params.getPeriodBegin() != null) {
                query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)AccountingEntryIndex.Property.endDate.name(), (Object)params.getPeriodBegin()), SearchCriterion.eq((String)AccountingEntryIndex.Property.endDate.name(), null)}));
            }
            if (params.getPeriodEnd() != null) {
                query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.le((String)AccountingEntryIndex.Property.startDate.name(), (Object)params.getPeriodEnd()), SearchCriterion.eq((String)AccountingEntryIndex.Property.startDate.name(), null)}));
            }
            accountingEntryIndexes = EntityStorage.get().search(AccountingEntryIndex.class, query).getData();
            for (AccountingEntryIndex accountingEntryIndex : accountingEntryIndexes) {
                EntityContainer accountingEntryContainer = EntityStorage.get().resolve(accountingEntryIndex.getSource());
                if (accountingEntryContainer == null) continue;
                AccountingEntry accountingEntry = (AccountingEntry)accountingEntryContainer.getEntity();
                collectionsCreditData.add(new MiscUtil.Pair((Object)(accountingEntry.getAmount() != null ? accountingEntry.getAmount().getValue() : null), accountingEntry.getDebitContractor() != null ? accountingEntry.getDebitContractor().toString() : null));
                if (accountingEntry.getAmount() == null) continue;
                collectionsCreditAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{collectionsCreditAmount, MiscUtil.negate((BigDecimal)accountingEntry.getAmount().getValue())});
            }
            result.put(KEY_COLLECTIONS_DEBIT_DATA, collectionsDebitData);
            result.put(KEY_COLLECTIONS_CREDIT_DATA, collectionsCreditData);
            result.put(KEY_COLLECTIONS_DEBIT_AMOUNT, collectionsDebitAmount);
            result.put(KEY_COLLECTIONS_CREDIT_AMOUNT, collectionsCreditAmount);
        }
        return result;
    }

    @Override
    protected BaseProduct getItem(EntityContainer<BookingFile> ctr, String key) {
        return BookingHelper.findProductByUid((String)key, (BookingFile)((BookingFile)ctr.getEntity()));
    }

    @Override
    protected List<AgentTemplateReportTicket> createRecords(BaseProduct product, Map<String, Object> data, List<Message> messages) throws Exception {
        ArrayList<AgentTemplateReportTicket> records = new ArrayList<AgentTemplateReportTicket>();
        AgentTemplateReportTicketPrepareHandler<?> handler = ((AgentTemplateReportTicketPrepareHandlersRegistry)Environment.getPublished(AgentTemplateReportTicketPrepareHandlersRegistry.class)).getHandler(product.getClass());
        if (handler != null) {
            for (AgentTemplateReportTicket ticket : handler.createTickets(product, data)) {
                this.updateAmounts(ticket, data);
                records.add(ticket);
            }
        }
        return records;
    }

    private void updateAmounts(AgentTemplateReportTicket ticket, Map<String, Object> data) {
        HashMap<PaymentType, BigDecimal> creditAmounts;
        HashMap<PaymentType, BigDecimal> debitAmounts = (HashMap<PaymentType, BigDecimal>)data.get(KEY_DEBIT_AMOUNTS);
        if (debitAmounts == null) {
            debitAmounts = new HashMap<PaymentType, BigDecimal>();
            data.put(KEY_DEBIT_AMOUNTS, debitAmounts);
        }
        if ((creditAmounts = (HashMap<PaymentType, BigDecimal>)data.get(KEY_CREDIT_AMOUNTS)) == null) {
            creditAmounts = new HashMap<PaymentType, BigDecimal>();
            data.put(KEY_CREDIT_AMOUNTS, creditAmounts);
        }
        this.updateAmounts(ticket.getProductPaidBeforeDebitAmounts(), debitAmounts);
        this.updateAmounts(ticket.getProductPaidWithinDebitAmounts(), debitAmounts);
        this.updateAmounts(ticket.getFeesPaidBeforeDebitAmounts(), debitAmounts);
        this.updateAmounts(ticket.getFeesPaidWithinDebitAmounts(), debitAmounts);
        this.updateAmounts(ticket.getProductPaidBeforeCreditAmounts(), creditAmounts);
        this.updateAmounts(ticket.getProductPaidWithinCreditAmounts(), creditAmounts);
        this.updateAmounts(ticket.getFeesPaidBeforeCreditAmounts(), creditAmounts);
        this.updateAmounts(ticket.getFeesPaidWithinCreditAmounts(), creditAmounts);
    }

    private void updateAmounts(Map<PaymentType, BigDecimal> sourceAmounts, Map<PaymentType, BigDecimal> targetAmounts) {
        for (Map.Entry<PaymentType, BigDecimal> entry : sourceAmounts.entrySet()) {
            PaymentType paymentType = entry.getKey();
            BigDecimal value = entry.getValue();
            targetAmounts.put(paymentType, MiscUtil.sum((BigDecimal[])new BigDecimal[]{targetAmounts.get(paymentType), value}));
        }
    }

    @Override
    protected Map<EntityReference<BookingFile>, Set<String>> getGroupedIndexes(AgentTemplateReportParameters parameters, Map<String, Object> data, List<Message> messages, EntityContainer<AgentTemplateReportDescription> descriptionCtr) throws Exception {
        AgentReportParameters standardParameters = this.createStandardReportParameters(parameters, messages);
        data.put("key-report-params", standardParameters);
        if (ReportHelper.isHasErrors(messages)) {
            return Collections.emptyMap();
        }
        return this.getProducts(parameters, messages);
    }

    private AgentReportParameters createStandardReportParameters(AgentTemplateReportParameters parameters, List<Message> messages) {
        AgentReportParameters standardParameters = new AgentReportParameters();
        standardParameters.setAgency(parameters.getAgency());
        standardParameters.setAgent(parameters.getAgent());
        standardParameters.setPeriodBegin(parameters.getPeriodBegin());
        standardParameters.setPeriodEnd(parameters.getPeriodEnd());
        standardParameters.setReportId("agent-template-report");
        return standardParameters;
    }

    @Override
    protected EntityReference<AgentTemplateReportDescription> getDescription(AgentTemplateReportParameters params) {
        return params.getDescription();
    }

    @Override
    protected String getFileName(ContentType contentType, AgentTemplateReportParameters parameters, EntityReference<AgentTemplateReportDescription> description, String fileNameScript) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String title = description.toString();
        String agent = parameters.getAgent() != null ? parameters.getAgent().toString() : "?";
        String periodBegin = parameters.getPeriodBegin() != null ? format.format(parameters.getPeriodBegin()) : "?";
        String periodEnd = parameters.getPeriodEnd() != null ? format.format(parameters.getPeriodEnd()) : "?";
        String extension = TemplateReportHelper.getExtension(contentType);
        String fileName = null;
        if (!TextUtil.isBlank((String)fileNameScript)) {
            fileName = TemplateReportHelper.getFileNameFromScript(parameters, fileNameScript);
        }
        fileName = !TextUtil.isBlank(fileName) ? ReportHelper.cleanUpFileName((String)String.format("%s.%s", fileName, extension)) : ReportHelper.cleanUpFileName((String)String.format("%s_%s_%s-%s.%s", title, agent, periodBegin, periodEnd, extension));
        return fileName;
    }

    @Override
    protected String getReportTitle(AgentTemplateReportParameters parameters, EntityReference<AgentTemplateReportDescription> description, String fileNameScript) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String title = description.toString();
        String agent = parameters.getAgent() != null ? parameters.getAgent().toString() : "null";
        String periodBegin = parameters.getPeriodBegin() != null ? format.format(parameters.getPeriodBegin()) : "?";
        String periodEnd = parameters.getPeriodEnd() != null ? format.format(parameters.getPeriodEnd()) : "?";
        String fileName = null;
        if (!TextUtil.isBlank((String)fileNameScript)) {
            fileName = TemplateReportHelper.getFileNameFromScript(parameters, fileNameScript);
        }
        String res = !TextUtil.isBlank(fileName) ? fileName : L10nResourcesManager.createL10nMessage((String)Messages.AgentTemplateReportPrepareHandler_reportTitle, (Object[])new Object[]{title, agent, periodBegin, periodEnd}).toString();
        return res;
    }

    private Map<EntityReference<BookingFile>, Set<String>> getProducts(AgentTemplateReportParameters parameters, List<Message> messages) {
        EntityContainer descriptionContainer = EntityStorage.get().resolve(parameters.getDescription());
        if (descriptionContainer == null) {
            return Collections.emptyMap();
        }
        HashMap<EntityReference<BookingFile>, Set<String>> batches = new HashMap<EntityReference<BookingFile>, Set<String>>();
        AgentTemplateReportDescription description = (AgentTemplateReportDescription)descriptionContainer.getEntity();
        Map<EntityReference<BookingFile>, Set<String>> batchesByProductIndexes = this.getBatchesByProductIndexes(parameters, description, messages);
        for (Map.Entry<EntityReference<BookingFile>, Set<String>> entry : batchesByProductIndexes.entrySet()) {
            Set productUids = (Set)batches.get(entry.getKey());
            if (productUids == null) {
                batches.put(entry.getKey(), entry.getValue());
                continue;
            }
            productUids.addAll((Collection)entry.getValue());
        }
        Map<EntityReference<BookingFile>, Set<String>> batchesByFopIndexes = this.getBatchesByFopIndexes(parameters, description, messages);
        for (Map.Entry<EntityReference<BookingFile>, Set<String>> entry : batchesByFopIndexes.entrySet()) {
            Set productUids = (Set)batches.get(entry.getKey());
            if (productUids == null) {
                batches.put(entry.getKey(), entry.getValue());
                continue;
            }
            productUids.addAll((Collection)entry.getValue());
        }
        return batches;
    }

    private Map<EntityReference<BookingFile>, Set<String>> getBatchesByProductIndexes(AgentTemplateReportParameters parameters, AgentTemplateReportDescription description, List<Message> messages) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().addAll(CommonTemplateReportHelper.getModifiedCriterions((BaseTemplateReportParameters)parameters, (BaseSingleFileTemplateReportDescription)description, messages));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)CommonProductIndex.Property.ticketType.name(), (Object)TicketType.FAKE));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)CommonProductIndex.Property.ticketType.name(), (Object)TicketType.CORRECTION));
        if (parameters.getPeriodBegin() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.ge((String)CommonProductIndex.Property.issueDate.name(), (Object)parameters.getPeriodBegin()));
        }
        if (parameters.getPeriodEnd() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.le((String)CommonProductIndex.Property.issueDate.name(), (Object)parameters.getPeriodEnd()));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)CommonProductIndex.Property.status.name(), (Object)ProductStatus.BOOKING));
        query.getCriteria().getCriterions().add(SearchQueryHelper.buildAndNeEnumCriterion((String)CommonProductIndex.Property.status.name(), (Collection)ProductStatusHandler.getAllNonIssuedVoidStatuses()));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)CommonProductIndex.Property.status.name(), (Object)ProductStatus.EXCHANGE));
        if (parameters.getSubagency() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.subagency.name(), (Object)parameters.getSubagency()));
        }
        if (parameters.getSalesPoint() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.salesPoint.name(), (Object)parameters.getSalesPoint()));
        }
        if (parameters.getAgent() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.agent.name(), (Object)parameters.getAgent()));
        }
        List indexes = EntityStorage.get().search(CommonProductIndex.class, query).getData();
        HashMap<EntityReference<BookingFile>, Set<String>> batches = new HashMap<EntityReference<BookingFile>, Set<String>>();
        for (CommonProductIndex index : indexes) {
            if (index.getNavigationKey() == null) continue;
            HashSet<String> productUids = (HashSet<String>)batches.get(index.getSource());
            if (productUids == null) {
                productUids = new HashSet<String>();
                batches.put((EntityReference<BookingFile>)index.getSource(), productUids);
            }
            productUids.add(index.getNavigationKey());
            if (!TextUtil.nonBlank((String)index.getProductVoidingUid())) continue;
            productUids.add(index.getProductVoidingUid());
        }
        return batches;
    }

    private Map<EntityReference<BookingFile>, Set<String>> getBatchesByFopIndexes(AgentTemplateReportParameters parameters, AgentTemplateReportDescription description, List<Message> messages) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)CommonProductFopIndex.Property.ticketType.name(), (Object)TicketType.FAKE));
        if (parameters.getPeriodBegin() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.ge((String)CommonProductFopIndex.Property.fopDate.name(), (Object)parameters.getPeriodBegin()));
        }
        if (parameters.getPeriodEnd() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.le((String)CommonProductFopIndex.Property.fopDate.name(), (Object)parameters.getPeriodEnd()));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)CommonProductFopIndex.Property.status.name(), (Object)ProductStatus.BOOKING));
        query.getCriteria().getCriterions().add(SearchQueryHelper.buildAndNeEnumCriterion((String)CommonProductFopIndex.Property.status.name(), (Collection)ProductStatusHandler.getAllNonIssuedVoidStatuses()));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)CommonProductFopIndex.Property.status.name(), (Object)ProductStatus.EXCHANGE));
        if (parameters.getSubagency() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductFopIndex.Property.subagency.name(), (Object)parameters.getSubagency()));
        }
        if (parameters.getAgent() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductFopIndex.Property.fopAgent.name(), (Object)parameters.getAgent()));
        }
        List indexes = EntityStorage.get().search(CommonProductFopIndex.class, query).getData();
        HashMap<EntityReference<BookingFile>, Set<String>> batches = new HashMap<EntityReference<BookingFile>, Set<String>>();
        for (CommonProductFopIndex index : indexes) {
            if (index.getProductUid() == null) continue;
            HashSet<String> productUids = (HashSet<String>)batches.get(index.getSource());
            if (productUids == null) {
                productUids = new HashSet<String>();
                batches.put((EntityReference<BookingFile>)index.getSource(), productUids);
            }
            productUids.add(index.getProductUid());
        }
        return batches;
    }

    @Override
    protected void checkParams(AgentTemplateReportParameters parameters, EntityContainer<AgentTemplateReportDescription> descriptionCtr, List<Message> messages) {
        if (parameters.getWorklog() != null) {
            EntityContainer worklogContainer = EntityStorage.get().resolve(parameters.getWorklog());
            if (worklogContainer != null) {
                Worklog worklog = (Worklog)worklogContainer.getEntity();
                parameters.setPeriodBegin(worklog.getStartDate());
                parameters.setPeriodEnd(worklog.getEndDate() != null ? worklog.getEndDate() : new Date());
                parameters.setSubagency(worklog.getAgency());
                parameters.setSalesPoint(worklog.getSalesPoint());
                parameters.setCash(worklog.getCash());
                parameters.setCashRegister(worklog.getCashRegister());
                parameters.setCashRegisterWorkplace(worklog.getCashRegisterWorkplace());
                parameters.setAgent(worklog.getEmployee());
            }
        } else {
            TemplateReportPeriodUse periodUse = ((AgentTemplateReportDescription)EntityStorage.get().resolve(parameters.getDescription()).getEntity()).getPeriodUse();
            if (periodUse == null || periodUse == TemplateReportPeriodUse.DATE) {
                parameters.setPeriodBegin(MiscUtil.clearTime((Date)parameters.getPeriodBegin(), (boolean)true, (boolean)true, (boolean)true, (boolean)true));
                parameters.setPeriodEnd(MiscUtil.setDayEndTime((Date)parameters.getPeriodEnd(), (boolean)true, (boolean)true, (boolean)true, (boolean)true));
            } else {
                parameters.setPeriodBegin(MiscUtil.clearTime((Date)parameters.getPeriodBegin(), (boolean)false, (boolean)false, (boolean)false, (boolean)true));
                parameters.setPeriodEnd(MiscUtil.setDayEndTime((Date)parameters.getPeriodEnd(), (boolean)false, (boolean)false, (boolean)false, (boolean)true));
            }
        }
    }

    @Override
    public MiscUtil.Pair<EntityIndex<BaseTemplateReportDocument>, String> searchForDuplicate(AgentTemplateReportParameters parametersNewReport, EntityReference<AgentTemplateReportDescription> reportDescription, boolean periodIntersectionDisallowed) {
        EntityContainer logCont;
        MiscUtil.Pair res = new MiscUtil.Pair(null, null);
        Date periodBegin = parametersNewReport.getPeriodBegin();
        Date periodEnd = parametersNewReport.getPeriodEnd();
        EntityReference agentRef = parametersNewReport.getAgent();
        EntityReference cashRegisterRef = parametersNewReport.getCashRegister();
        EntityReference cashRegisterWorkplaceRef = parametersNewReport.getCashRegisterWorkplace();
        EntityReference salesPointRef = parametersNewReport.getSalesPoint();
        EntityReference subagencyRef = parametersNewReport.getSubagency();
        if (parametersNewReport.getWorklog() != null && (logCont = EntityStorage.get().resolve(parametersNewReport.getWorklog())) != null && logCont.getEntity() != null) {
            Worklog log = (Worklog)logCont.getEntity();
            periodBegin = log.getStartDate();
            periodEnd = log.getEndDate();
            agentRef = log.getEmployee();
            cashRegisterRef = log.getCashRegister();
            cashRegisterWorkplaceRef = log.getCashRegisterWorkplace();
            salesPointRef = log.getSalesPoint();
        }
        SearchQuery query = new SearchQuery();
        AgentTemplateReportPrepareHandler.addPeriodCriterions(query, AgentTemplateReportDocumentIndex.Property.periodBegin.name(), AgentTemplateReportDocumentIndex.Property.periodEnd.name(), periodBegin, periodEnd, periodIntersectionDisallowed);
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)AgentTemplateReportDocumentIndex.Property.description.name(), reportDescription));
        if (agentRef != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)AgentTemplateReportDocumentIndex.Property.agent.name(), (Object)agentRef));
        }
        if (cashRegisterRef != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)AgentTemplateReportDocumentIndex.Property.cashRegister.name(), (Object)cashRegisterRef));
        }
        if (cashRegisterWorkplaceRef != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)AgentTemplateReportDocumentIndex.Property.cashRegisterWorkplace.name(), (Object)cashRegisterWorkplaceRef));
        }
        if (salesPointRef != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)AgentTemplateReportDocumentIndex.Property.salesPoint.name(), (Object)salesPointRef));
        }
        if (subagencyRef != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)AgentTemplateReportDocumentIndex.Property.subagency.name(), (Object)subagencyRef));
        }
        List docsInd = EntityStorage.get().search(AgentTemplateReportDocumentIndex.class, query).getData();
        for (AgentTemplateReportDocumentIndex ind : docsInd) {
            AgentTemplateReportDocument repDoc;
            AgentTemplateReportParameters parametersFoundReport;
            EntityContainer repCont = EntityStorage.get().resolve(ind.getSource());
            if (repCont == null || repCont.getEntity() == null || !(repCont.getEntity() instanceof AgentTemplateReportDocument) || !AgentTemplateReportPrepareHandler.compareAgentTemplateReportParams(parametersFoundReport = (repDoc = (AgentTemplateReportDocument)repCont.getEntity()).getParameters(), parametersNewReport)) continue;
            res.setFirst((Object)ind);
            res.setSecond((Object)ind.getTitle());
            return res;
        }
        return res;
    }

    private static boolean compareAgentTemplateReportParams(AgentTemplateReportParameters p1, AgentTemplateReportParameters p2) {
        boolean equalAgency = p1.getAgency() == null && p2.getAgency() == null || p1.getAgency() != null && p1.getAgency().equals((Object)p2.getAgency());
        boolean equalAdditionalCriterions = AgentTemplateReportPrepareHandler.compareAdditionalCriterions(p1.getAdditionalCriterions(), p2.getAdditionalCriterions());
        boolean equalRequestedParam = AgentTemplateReportPrepareHandler.compareRequestedParams(p1.getRequestedParameters(), p2.getRequestedParameters());
        return equalAgency && equalAdditionalCriterions && equalRequestedParam;
    }
}

