/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.template.agent;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.FopType;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.MCOFees;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristic;
import com.gridnine.xtrip.common.model.booking.misc.ProductVoiding;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProduct;
import com.gridnine.xtrip.common.model.booking.transfers.Transfer;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.PersonalNameFormat;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.reports.AgentReportHelper;
import com.gridnine.xtrip.common.reports.model.AgentReportParameters;
import com.gridnine.xtrip.common.reports.model.AgentTemplateReportTicket;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.PersonalName;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.reports.prepare.template.agent.AgentTemplateReportTicketPrepareHandler;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public abstract class BaseProductAgentTemplateReportTicketPrepareHandler<P extends BaseProduct>
implements AgentTemplateReportTicketPrepareHandler<P> {
    private static final Set<MCOCategory> penaltyCategories = new HashSet<MCOCategory>(Arrays.asList(MCOCategory.PENALTY, MCOCategory.REBOOKING, MCOCategory.GROUP_PENALTY));

    @Override
    public List<AgentTemplateReportTicket> createTickets(P product, Map<String, Object> data) {
        List systemNumbers;
        ArrayList<AgentTemplateReportTicket> tickets = new ArrayList<AgentTemplateReportTicket>();
        ProductHandler handler = HandlersRegistry.get().findProductHandler(product.getClass());
        if (handler == null) {
            return tickets;
        }
        ProductVoiding productVoiding = BookingHelper.getProductVoiding(product);
        ProductStatus status = handler.getStatus(product);
        if (ProductStatusHandler.getAllVoidStatuses().contains(status) && productVoiding != null) {
            return tickets;
        }
        AgentTemplateReportTicket ticket = new AgentTemplateReportTicket();
        ticket.setOperationBatch(BookingHelper.getOperationBatch(product));
        ticket.setSortingTicketNumber(BookingHelper.getSortingTicketNumber(product));
        ticket.setGroupName(this.buildGroupName(product));
        ticket.setProductType(handler.getProductType(product));
        ticket.setClient(product.getReservation().getBookingFile().getCustomerProfile());
        ticket.setBlankOwner(handler.getBlankOwner(product));
        ticket.setStatus(handler.getStatus(product));
        ticket.setPassengerStatus(handler.getPassengerStatus(product));
        ticket.setIssueDate(handler.findIssueDate(product));
        ticket.getTravellerNames().clear();
        PersonalNameFormat format = new PersonalNameFormat("L F");
        for (Traveller traveller : handler.getTravellers(product)) {
            String travellerName;
            if (traveller == null) continue;
            String string = travellerName = traveller.getPassport() != null ? format.format((PersonalName)traveller.getPassport()) : null;
            if (TextUtil.isBlank((String)travellerName)) {
                travellerName = traveller.getName();
            }
            if (TextUtil.isBlank((String)travellerName)) {
                travellerName = traveller.getCyrillicName();
            }
            ticket.getTravellerNames().add(travellerName);
        }
        BlankType blankType = (BlankType)DictionaryCache.get().resolveReference(handler.getBlankType(product));
        if (blankType != null) {
            ticket.setTicketSeries(blankType.getName());
        }
        if ((systemNumbers = handler.getProductNumbers(product)).size() > 0) {
            ticket.setSystemNumber((String)systemNumbers.get(0));
        }
        ticket.setConjunction(handler.getConjunction(product));
        ticket.setRouteLine(handler.getRouteLine(product));
        String relatedProductSystemNumber = null;
        ProductType relatedProductType = null;
        ProductStatus relatedProductStatus = null;
        String relatedProductRouteLine = null;
        List relatedProducts = handler.getRelatedProducts(product);
        if (relatedProducts.size() > 0) {
            BaseProduct relatedProduct = (BaseProduct)relatedProducts.get(0);
            ProductHandler relatedProductHandler = HandlersRegistry.get().findProductHandler(relatedProduct.getClass());
            if (relatedProductHandler != null) {
                List relatedProductProductNumbers = relatedProductHandler.getProductNumbers(relatedProduct);
                if (relatedProductProductNumbers.size() > 0) {
                    relatedProductSystemNumber = (String)relatedProductProductNumbers.get(0);
                }
                relatedProductType = relatedProductHandler.getProductType(relatedProduct);
                relatedProductStatus = relatedProductHandler.getStatus(relatedProduct);
                relatedProductRouteLine = relatedProductHandler.getRouteLine(relatedProduct);
            }
        }
        ticket.setRelatedSystemNumber(relatedProductSystemNumber);
        ticket.setRelatedProductType(relatedProductType);
        ticket.setRelatedRouteLine(relatedProductRouteLine);
        if (ticket.getRelatedProductType() == null && product instanceof InsuranceTouristic) {
            InsuranceTouristic insuranceTouristic = (InsuranceTouristic)product;
            ticket.setRelatedProductType(insuranceTouristic.getRelatedProductType());
        }
        if (product instanceof UniversalProduct) {
            UniversalProduct universalProduct = (UniversalProduct)product;
            ticket.setUniversalProductDescription(universalProduct.getDescription());
        }
        ticket.setComments(this.buildComments(product));
        if (product instanceof ProductVoiding) {
            BigDecimal feesEquivalentAmount = GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)GeneralProductHelper.getUnmodifiableCommissions(product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.feePropertyTypes, null, null));
            ticket.setFeesEquivalentAmount(feesEquivalentAmount);
            this.updateAmountsFields(ticket, handler.findIssueDate(product), (EntityReference<Person>)handler.findIssuingAgent(product), handler.getStatus(product), relatedProductStatus, handler.getProductCategory(product), handler.getMCOCategory(product), GeneralProductHelper.getUnmodifiableFops(product, (ContractType)ContractType.CLIENT), data);
            tickets.add(ticket);
            return tickets;
        }
        if (!ProductStatusHandler.getAllVoidStatuses().contains(status)) {
            BigDecimal agentPenaltyForFees;
            BigDecimal agentPenaltyForProduct;
            ProductHandler exchangeProductHandler;
            BaseProduct exchangeProduct;
            MCOCategory mcoCategory;
            BigDecimal tariffEquivalentAmount = handler.getEquivalentFare(product);
            List taxes = handler.getTaxes(product);
            BigDecimal taxesCarrierEquivalentAmount = GeneralProductHelper.calculateTaxesEquivalentValue((Collection)GeneralProductHelper.filterTaxes((Collection)taxes, Collections.singleton("RU")));
            BigDecimal taxesOthersEquivalentAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{GeneralProductHelper.calculateTaxesEquivalentValue((Collection)taxes), MiscUtil.negate((BigDecimal)taxesCarrierEquivalentAmount)});
            BigDecimal penaltyEquivalentAmount = handler.getPenalty(product);
            ProductCategory productCategory = handler.getProductCategory(product);
            if (productCategory == ProductCategory.MCO && penaltyCategories.contains(mcoCategory = handler.getMCOCategory(product))) {
                penaltyEquivalentAmount = handler.getEquivalentFare(product);
                tariffEquivalentAmount = null;
            }
            BigDecimal feesEquivalentAmount = GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)GeneralProductHelper.getUnmodifiableCommissions(product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.feePropertyTypes, null, null));
            BigDecimal additionalServicesEquivalentAmount = handler.getAdditionalFeeEquivalentAmount(product);
            if (status == ProductStatus.SELL && (exchangeProduct = BookingHelper.getPreviousProduct(product, (ProductStatus)ProductStatus.EXCHANGE)) != null && (exchangeProductHandler = HandlersRegistry.get().findProductHandler(exchangeProduct.getClass())) != null) {
                MCOCategory mcoCategory2;
                BigDecimal exchangeProductTariffEquivalentAmount = exchangeProductHandler.getEquivalentFare(exchangeProduct);
                List exchangeProductTaxes = exchangeProductHandler.getTaxes(exchangeProduct);
                BigDecimal exchangeProductTaxesCarrierEquivalentAmount = GeneralProductHelper.calculateTaxesEquivalentValue((Collection)GeneralProductHelper.filterTaxes((Collection)exchangeProductTaxes, Collections.singleton("RU")));
                BigDecimal exchangeProductTaxesOthersEquivalentAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{GeneralProductHelper.calculateTaxesEquivalentValue((Collection)exchangeProductTaxes), MiscUtil.negate((BigDecimal)exchangeProductTaxesCarrierEquivalentAmount)});
                BigDecimal exchangeProductPenaltyEquivalentAmount = exchangeProductHandler.getPenalty(exchangeProduct);
                ProductCategory exchangeProductProductCategory = exchangeProductHandler.getProductCategory(exchangeProduct);
                if (exchangeProductProductCategory == ProductCategory.MCO && penaltyCategories.contains(mcoCategory2 = exchangeProductHandler.getMCOCategory(exchangeProduct))) {
                    exchangeProductPenaltyEquivalentAmount = exchangeProductHandler.getEquivalentFare(exchangeProduct);
                    exchangeProductTariffEquivalentAmount = null;
                }
                BigDecimal exchangeProductFeesEquivalentAmount = GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)GeneralProductHelper.getUnmodifiableCommissions((BaseProduct)exchangeProduct, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.feePropertyTypes, null, null));
                BigDecimal exchangeProductAdditionalServicesEquivalentAmount = exchangeProductHandler.getAdditionalFeeEquivalentAmount(exchangeProduct);
                tariffEquivalentAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{tariffEquivalentAmount, MiscUtil.negate((BigDecimal)exchangeProductTariffEquivalentAmount)});
                taxesCarrierEquivalentAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{taxesCarrierEquivalentAmount, MiscUtil.negate((BigDecimal)exchangeProductTaxesCarrierEquivalentAmount)});
                taxesOthersEquivalentAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{taxesOthersEquivalentAmount, MiscUtil.negate((BigDecimal)exchangeProductTaxesOthersEquivalentAmount)});
                penaltyEquivalentAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{penaltyEquivalentAmount, exchangeProductPenaltyEquivalentAmount});
                feesEquivalentAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{feesEquivalentAmount, MiscUtil.negate((BigDecimal)exchangeProductFeesEquivalentAmount)});
                additionalServicesEquivalentAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{additionalServicesEquivalentAmount, MiscUtil.negate((BigDecimal)exchangeProductAdditionalServicesEquivalentAmount)});
            }
            BigDecimal relatedPaymentAmount = null;
            PaymentType relatedPaymentType = null;
            if (product instanceof MCOFees) {
                MCOFees mcoFees = (MCOFees)product;
                relatedPaymentAmount = mcoFees.getTotal();
                relatedPaymentType = mcoFees.getPaymentType();
            }
            if (status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE) {
                tariffEquivalentAmount = MiscUtil.negate((BigDecimal)tariffEquivalentAmount);
                taxesCarrierEquivalentAmount = MiscUtil.negate((BigDecimal)taxesCarrierEquivalentAmount);
                taxesOthersEquivalentAmount = MiscUtil.negate((BigDecimal)taxesOthersEquivalentAmount);
                feesEquivalentAmount = MiscUtil.negate((BigDecimal)feesEquivalentAmount);
                relatedPaymentAmount = MiscUtil.negate((BigDecimal)relatedPaymentAmount);
                additionalServicesEquivalentAmount = MiscUtil.negate((BigDecimal)additionalServicesEquivalentAmount);
            }
            ticket.setTariffEquivalentAmount(tariffEquivalentAmount);
            ticket.setTaxesCarrierEquivalentAmount(taxesCarrierEquivalentAmount);
            ticket.setTaxesOthersEquivalentAmount(taxesOthersEquivalentAmount);
            ticket.setPenaltyEquivalentAmount(penaltyEquivalentAmount);
            ticket.setFeesEquivalentAmount(feesEquivalentAmount);
            ticket.setRelatedPaymentAmount(relatedPaymentAmount);
            ticket.setRelatedPaymentType(relatedPaymentType);
            if (product instanceof HotelProduct || product instanceof Transfer) {
                ticket.setAdditionalServicesEquivalentAmount(additionalServicesEquivalentAmount);
            }
            if ((agentPenaltyForProduct = BookingHelper.calculateAgentPenaltyForProduct(product)) != null) {
                if (agentPenaltyForProduct.compareTo(BigDecimal.ZERO) > 0) {
                    ticket.setProductAgentDebitPenaltyEquivalentAmount(agentPenaltyForProduct);
                } else if (agentPenaltyForProduct.compareTo(BigDecimal.ZERO) < 0) {
                    ticket.setProductAgentCreditPenaltyEquivalentAmount(agentPenaltyForProduct);
                }
            }
            if ((agentPenaltyForFees = BookingHelper.calculateAgentPenaltyForFees(product)) != null) {
                if (agentPenaltyForFees.compareTo(BigDecimal.ZERO) > 0) {
                    ticket.setFeesAgentDebitPenaltyEquivalentAmount(agentPenaltyForFees);
                } else if (agentPenaltyForFees.compareTo(BigDecimal.ZERO) < 0) {
                    ticket.setFeesAgentCreditPenaltyEquivalentAmount(agentPenaltyForFees);
                }
            }
            this.updateAmountsFields(ticket, handler.findIssueDate(product), (EntityReference<Person>)handler.findIssuingAgent(product), handler.getStatus(product), relatedProductStatus, handler.getProductCategory(product), handler.getMCOCategory(product), GeneralProductHelper.getUnmodifiableFops(product, (ContractType)ContractType.CLIENT), data);
        }
        tickets.add(ticket);
        return tickets;
    }

    private void updateAmountsFields(AgentTemplateReportTicket ticket, Date issueDate, EntityReference<Person> issueAgent, ProductStatus productStatus, ProductStatus relatedProductStatus, ProductCategory productCategory, MCOCategory mcoCategory, Collection<GeneralProductFop> fops, Map<String, Object> data) {
        AgentReportParameters parameters = (AgentReportParameters)data.get("key-report-params");
        Date startDate = parameters.getPeriodBegin();
        Date endDate = parameters.getPeriodEnd();
        EntityReference agent = parameters.getAgent();
        for (GeneralProductFop fop : fops) {
            if (fop.getType() == null || fop.getEquivalentAmount() == null || fop.getType() == PaymentType.TICKET) continue;
            FopType fopType = GeneralProductHelper.getFopType((GeneralProductFop)fop);
            AgentReportHelper.FopStatus fopStatus = AgentReportHelper.getFopStatus((GeneralProductFop)fop, (Date)issueDate, issueAgent, (Date)startDate, (Date)endDate, (EntityReference)agent);
            AgentReportHelper.FopPeriod fopPeriod = AgentReportHelper.getFopPeriod((Date)issueDate, issueAgent, (Date)startDate, (Date)endDate, (EntityReference)agent);
            AgentReportHelper.FopCategory fopCategory = AgentReportHelper.getFopCategory((GeneralProductFop)fop, (ProductStatus)(relatedProductStatus != null && productCategory == ProductCategory.MCO && penaltyCategories.contains(mcoCategory) ? relatedProductStatus : productStatus));
            Map amounts = null;
            if (GeneralProductHelper.productFopTypes.contains(fopType)) {
                if (fopStatus == AgentReportHelper.FopStatus.PAID) {
                    if (fopPeriod == AgentReportHelper.FopPeriod.BEFORE) {
                        if (fopCategory == AgentReportHelper.FopCategory.DEBIT) {
                            amounts = ticket.getProductPaidBeforeDebitAmounts();
                        } else if (fopCategory == AgentReportHelper.FopCategory.CREDIT) {
                            amounts = ticket.getProductPaidBeforeCreditAmounts();
                        }
                    } else if (fopPeriod == AgentReportHelper.FopPeriod.WITHIN) {
                        if (fopCategory == AgentReportHelper.FopCategory.DEBIT) {
                            amounts = ticket.getProductPaidWithinDebitAmounts();
                        } else if (fopCategory == AgentReportHelper.FopCategory.CREDIT) {
                            amounts = ticket.getProductPaidWithinCreditAmounts();
                        }
                    }
                } else if (fopStatus == AgentReportHelper.FopStatus.REFUSED) {
                    if (fopPeriod == AgentReportHelper.FopPeriod.BEFORE) {
                        if (fopCategory == AgentReportHelper.FopCategory.DEBIT) {
                            amounts = ticket.getProductRefusedBeforeDebitAmounts();
                        } else if (fopCategory == AgentReportHelper.FopCategory.CREDIT) {
                            amounts = ticket.getProductRefusedBeforeCreditAmounts();
                        }
                    } else if (fopPeriod == AgentReportHelper.FopPeriod.WITHIN) {
                        if (fopCategory == AgentReportHelper.FopCategory.DEBIT) {
                            amounts = ticket.getProductRefusedWithinDebitAmounts();
                        } else if (fopCategory == AgentReportHelper.FopCategory.CREDIT) {
                            amounts = ticket.getProductRefusedWithinCreditAmounts();
                        }
                    }
                } else if (fopStatus == AgentReportHelper.FopStatus.UNPAID) {
                    if (fopPeriod == AgentReportHelper.FopPeriod.BEFORE) {
                        if (fopCategory == AgentReportHelper.FopCategory.DEBIT) {
                            amounts = ticket.getProductUnpaidBeforeDebitAmounts();
                        } else if (fopCategory == AgentReportHelper.FopCategory.CREDIT) {
                            amounts = ticket.getProductUnpaidBeforeCreditAmounts();
                        }
                    } else if (fopPeriod == AgentReportHelper.FopPeriod.WITHIN) {
                        if (fopCategory == AgentReportHelper.FopCategory.DEBIT) {
                            amounts = ticket.getProductUnpaidWithinDebitAmounts();
                        } else if (fopCategory == AgentReportHelper.FopCategory.CREDIT) {
                            amounts = ticket.getProductUnpaidWithinCreditAmounts();
                        }
                    }
                }
            } else if (GeneralProductHelper.feeFopTypes.contains(fopType)) {
                if (fopStatus == AgentReportHelper.FopStatus.PAID) {
                    if (fopPeriod == AgentReportHelper.FopPeriod.BEFORE) {
                        if (fopCategory == AgentReportHelper.FopCategory.DEBIT) {
                            amounts = ticket.getFeesPaidBeforeDebitAmounts();
                        } else if (fopCategory == AgentReportHelper.FopCategory.CREDIT) {
                            amounts = ticket.getFeesPaidBeforeCreditAmounts();
                        }
                    } else if (fopPeriod == AgentReportHelper.FopPeriod.WITHIN) {
                        if (fopCategory == AgentReportHelper.FopCategory.DEBIT) {
                            amounts = ticket.getFeesPaidWithinDebitAmounts();
                        } else if (fopCategory == AgentReportHelper.FopCategory.CREDIT) {
                            amounts = ticket.getFeesPaidWithinCreditAmounts();
                        }
                    }
                } else if (fopStatus == AgentReportHelper.FopStatus.REFUSED) {
                    if (fopPeriod == AgentReportHelper.FopPeriod.BEFORE) {
                        if (fopCategory == AgentReportHelper.FopCategory.DEBIT) {
                            amounts = ticket.getFeesRefusedBeforeDebitAmounts();
                        } else if (fopCategory == AgentReportHelper.FopCategory.CREDIT) {
                            amounts = ticket.getFeesRefusedBeforeCreditAmounts();
                        }
                    } else if (fopPeriod == AgentReportHelper.FopPeriod.WITHIN) {
                        if (fopCategory == AgentReportHelper.FopCategory.DEBIT) {
                            amounts = ticket.getFeesRefusedWithinDebitAmounts();
                        } else if (fopCategory == AgentReportHelper.FopCategory.CREDIT) {
                            amounts = ticket.getFeesRefusedWithinCreditAmounts();
                        }
                    }
                } else if (fopStatus == AgentReportHelper.FopStatus.UNPAID) {
                    if (fopPeriod == AgentReportHelper.FopPeriod.BEFORE) {
                        if (fopCategory == AgentReportHelper.FopCategory.DEBIT) {
                            amounts = ticket.getFeesUnpaidBeforeDebitAmounts();
                        } else if (fopCategory == AgentReportHelper.FopCategory.CREDIT) {
                            amounts = ticket.getFeesUnpaidBeforeCreditAmounts();
                        }
                    } else if (fopPeriod == AgentReportHelper.FopPeriod.WITHIN) {
                        if (fopCategory == AgentReportHelper.FopCategory.DEBIT) {
                            amounts = ticket.getFeesUnpaidWithinDebitAmounts();
                        } else if (fopCategory == AgentReportHelper.FopCategory.CREDIT) {
                            amounts = ticket.getFeesUnpaidWithinCreditAmounts();
                        }
                    }
                }
            } else if (GeneralProductHelper.discountFopTypes.contains(fopType)) {
                if (fopStatus == AgentReportHelper.FopStatus.PAID) {
                    if (fopPeriod == AgentReportHelper.FopPeriod.BEFORE) {
                        if (fopCategory == AgentReportHelper.FopCategory.DEBIT) {
                            amounts = ticket.getDiscountsPaidBeforeDebitAmounts();
                        } else if (fopCategory == AgentReportHelper.FopCategory.CREDIT) {
                            amounts = ticket.getDiscountsPaidBeforeCreditAmounts();
                        }
                    } else if (fopPeriod == AgentReportHelper.FopPeriod.WITHIN) {
                        if (fopCategory == AgentReportHelper.FopCategory.DEBIT) {
                            amounts = ticket.getDiscountsPaidWithinDebitAmounts();
                        } else if (fopCategory == AgentReportHelper.FopCategory.CREDIT) {
                            amounts = ticket.getDiscountsPaidWithinCreditAmounts();
                        }
                    }
                } else if (fopStatus == AgentReportHelper.FopStatus.REFUSED) {
                    if (fopPeriod == AgentReportHelper.FopPeriod.BEFORE) {
                        if (fopCategory == AgentReportHelper.FopCategory.DEBIT) {
                            amounts = ticket.getDiscountsRefusedBeforeDebitAmounts();
                        } else if (fopCategory == AgentReportHelper.FopCategory.CREDIT) {
                            amounts = ticket.getDiscountsRefusedBeforeCreditAmounts();
                        }
                    } else if (fopPeriod == AgentReportHelper.FopPeriod.WITHIN) {
                        if (fopCategory == AgentReportHelper.FopCategory.DEBIT) {
                            amounts = ticket.getDiscountsRefusedWithinDebitAmounts();
                        } else if (fopCategory == AgentReportHelper.FopCategory.CREDIT) {
                            amounts = ticket.getDiscountsRefusedWithinCreditAmounts();
                        }
                    }
                } else if (fopStatus == AgentReportHelper.FopStatus.UNPAID) {
                    if (fopPeriod == AgentReportHelper.FopPeriod.BEFORE) {
                        if (fopCategory == AgentReportHelper.FopCategory.DEBIT) {
                            amounts = ticket.getDiscountsUnpaidBeforeDebitAmounts();
                        } else if (fopCategory == AgentReportHelper.FopCategory.CREDIT) {
                            amounts = ticket.getDiscountsUnpaidBeforeCreditAmounts();
                        }
                    } else if (fopPeriod == AgentReportHelper.FopPeriod.WITHIN) {
                        if (fopCategory == AgentReportHelper.FopCategory.DEBIT) {
                            amounts = ticket.getDiscountsUnpaidWithinDebitAmounts();
                        } else if (fopCategory == AgentReportHelper.FopCategory.CREDIT) {
                            amounts = ticket.getDiscountsUnpaidWithinCreditAmounts();
                        }
                    }
                }
            }
            if (amounts == null) continue;
            BigDecimal fopAmount = fop.getEquivalentAmount();
            if (productStatus == ProductStatus.REFUND || productStatus == ProductStatus.EXCHANGE || fopType == FopType.DISCOUNT) {
                fopAmount = fopAmount.negate();
            }
            amounts.put(fop.getType(), MiscUtil.sum((BigDecimal[])new BigDecimal[]{(BigDecimal)amounts.get(fop.getType()), fopAmount}));
        }
    }

    private String buildGroupName(P product) {
        StringBuilder groupName = new StringBuilder();
        ProductHandler handler = HandlersRegistry.get().findProductHandler(product.getClass());
        if (handler != null) {
            String groupNameSuffix;
            EntityReference supplier;
            EntityReference blankOwner = handler.getBlankOwner(product);
            if (blankOwner != null) {
                groupName.append(blankOwner);
            }
            if (!((supplier = GeneralProductHelper.getSupplier(product)) == null || blankOwner != null && blankOwner.equals((Object)supplier))) {
                if (groupName.length() > 0) {
                    groupName.append(" / ");
                }
                groupName.append(supplier);
            }
            if (!TextUtil.isBlank((String)(groupNameSuffix = this.getGroupNameProductsType(product)))) {
                if (groupName.length() > 0) {
                    groupName.append(" ");
                }
                groupName.append(String.format("(%s)", groupNameSuffix.trim()));
            }
        }
        return groupName.length() > 0 ? groupName.toString() : null;
    }

    private String buildComments(P product) {
        List exchangeSystemNumbers;
        ProductHandler exchangeProductHandler;
        BaseProduct exchangeProduct;
        StringBuilder comments = new StringBuilder();
        EntityContainer clientContainer = EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile());
        if (clientContainer != null && !ProfileHelper.isRetailProfile((EntityContainer)clientContainer)) {
            if (comments.length() > 0) {
                comments.append(", ");
            }
            comments.append(L10nStringHelper.getValue((L10nString)((Organization)clientContainer.getEntity()).getShortName(), (Locale)LocaleHelper.RU_LOCALE, (boolean)false));
        }
        ProductHandler handler = ProductHandler.of(product);
        ProductStatus status = null;
        if (handler != null) {
            status = handler.getStatus(product);
        }
        if (status == ProductStatus.SELL && (exchangeProduct = BookingHelper.getPreviousProduct(product, (ProductStatus)ProductStatus.EXCHANGE)) != null && (exchangeProductHandler = ProductHandler.of((BaseProduct)exchangeProduct)) != null && (exchangeSystemNumbers = exchangeProductHandler.getProductNumbers(exchangeProduct)).size() > 0) {
            if (comments.length() > 0) {
                comments.append(", ");
            }
            comments.append(String.format("\u0432 \u043e\u0431\u043c\u0435\u043d \u043d\u0430 %s", exchangeSystemNumbers.get(0)));
        }
        return comments.length() > 0 ? TextUtil.capitalize((String)comments.toString()) : null;
    }

    protected abstract String getGroupNameProductsType(P var1);
}

