/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.template.airtickets;

import com.gridnine.xtrip.common.model.ClientFop;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.OperationBatch;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.SimpleTax;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProduct;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductEntry;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductEntryAssociationType;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductEntryType;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductIndex;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductItemGroup;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.BlankCategory;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductTaxHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.reports.model.AirTicketsTemplateReportDescription;
import com.gridnine.xtrip.common.reports.model.AirTicketsTemplateReportDocument;
import com.gridnine.xtrip.common.reports.model.AirTicketsTemplateReportParameters;
import com.gridnine.xtrip.common.reports.model.AirTicketsTemplateReportSegment;
import com.gridnine.xtrip.common.reports.model.AirTicketsTemplateReportSegmentTariff;
import com.gridnine.xtrip.common.reports.model.AirTicketsTemplateReportTicket;
import com.gridnine.xtrip.common.reports.model.AirTicketsTemplateReportTicketType;
import com.gridnine.xtrip.common.reports.model.BaseGeneralProductsTemplateReportParameters;
import com.gridnine.xtrip.common.reports.model.BaseSingleFileTemplateReportDescription;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportDocument;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportParameters;
import com.gridnine.xtrip.common.reports.model.GeneralProductsTemplateReportFilteringParameters;
import com.gridnine.xtrip.common.reports.model.GeneralProductsTemplateReportPageDescription;
import com.gridnine.xtrip.common.reports.model.ReportCategory;
import com.gridnine.xtrip.common.reports.model.TemplateReportPeriodUse;
import com.gridnine.xtrip.common.reports.render.template.common.CommonTemplateReportHelper;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import com.gridnine.xtrip.common.util.FormattedNumberUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.PersonalName;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.reports.prepare.BaseReportPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.template.common.BaseGroupedTemplateReportPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.template.common.TemplateReportHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AirTicketsTemplateReportPrepareHandler
extends BaseGroupedTemplateReportPrepareHandler<Product, AirTicketsTemplateReportTicket, AirTicketsTemplateReportParameters, AirTicketsTemplateReportDescription, GeneralProductsTemplateReportPageDescription, AirTicketsTemplateReportDocument, BookingFile> {
    private static final Logger log = LoggerFactory.getLogger(AirTicketsTemplateReportPrepareHandler.class);

    @Override
    public String getId() {
        return "air-tickets-template-report";
    }

    @Override
    protected void setData(AirTicketsTemplateReportDocument doc, AirTicketsTemplateReportParameters params, Map<String, Object> data) {
        doc.setParameters(params);
    }

    @Override
    protected AirTicketsTemplateReportDocument createDocument() {
        return new AirTicketsTemplateReportDocument();
    }

    @Override
    protected Class<AirTicketsTemplateReportTicket> getItemClass(AirTicketsTemplateReportDescription description) {
        return AirTicketsTemplateReportTicket.class;
    }

    @Override
    protected List<GeneralProductsTemplateReportPageDescription> getPages(AirTicketsTemplateReportDescription entity) {
        return entity.getPages();
    }

    @Override
    protected Map<String, Object> getGlobalParameters(Map<String, Object> data, AirTicketsTemplateReportParameters params, List<Message> messages) {
        Map<String, Object> result = TemplateReportHelper.getGlobalParameters(params, messages);
        result.put(GeneralProductsTemplateReportFilteringParameters.AGENCY.name(), MiscUtil.toString((Object)params.getAgency()));
        result.put(GeneralProductsTemplateReportFilteringParameters.AGENT.name(), MiscUtil.toString((Object)params.getAgent()));
        result.put(GeneralProductsTemplateReportFilteringParameters.BLANK_OWNER.name(), MiscUtil.toString((Object)params.getBlankOwner()));
        result.put(GeneralProductsTemplateReportFilteringParameters.CLIENT.name(), MiscUtil.toString((Object)params.getClient()));
        result.put(GeneralProductsTemplateReportFilteringParameters.SALES_POINT.name(), MiscUtil.toString((Object)params.getSalesPoint()));
        result.put(GeneralProductsTemplateReportFilteringParameters.SUBAGENCY.name(), MiscUtil.toString((Object)params.getSubagency()));
        result.put(GeneralProductsTemplateReportFilteringParameters.SUPPLIER.name(), MiscUtil.toString((Object)params.getSupplier()));
        return result;
    }

    @Override
    protected List<AirTicketsTemplateReportTicket> createRecords(Product product, Map<String, Object> data, List<Message> messages) throws Exception {
        BigDecimal vendorCommissionsValue;
        BigDecimal vendorCommissionsRate;
        BigDecimal subagentCommissionsValue;
        BigDecimal subagentCommissionsRate;
        Segment lastSegment;
        AirTicketsTemplateReportTicket item = new AirTicketsTemplateReportTicket();
        List clientFops = AirProductHelper.getClientFops((Product)product);
        item.getClientProductFops().addAll(clientFops);
        List vendorFops = AirProductHelper.getVendorFops((Product)product);
        clientFops.forEach(fop -> {
            ClientFop clientFop = new ClientFop();
            clientFop.setPayer(fop.getPayer());
            clientFop.setType(fop.getType());
            clientFop.setAmount(fop.getAmount());
            clientFop.setUid(fop.getUid());
            clientFop.getCommissions().addAll(fop.getCommissions());
            clientFop.setPassengerStatus(fop.getPassengerStatus());
            item.getClientFops().add(clientFop);
        });
        vendorFops.forEach(fop -> {
            ProductFop vendorFop = new ProductFop();
            vendorFop.setPayer(fop.getPayer());
            vendorFop.setAmount(fop.getAmount());
            vendorFop.setUid(fop.getUid());
            vendorFop.setType(fop.getType());
            vendorFop.getCommissions().addAll(fop.getCommissions());
            vendorFop.setPassengerStatus(fop.getPassengerStatus());
            item.getVendorFops().add(vendorFop);
        });
        item.setTariffCodes(product.getSegmentTariffs().stream().map(SegmentTariff::getSegments).flatMap(Collection::stream).map(Segment::getFareBasis).filter(TextUtil::nonBlank).distinct().collect(Collectors.joining(",")));
        if (product.getLuggageWeight() != null) {
            item.setLuggageWeight(product.getLuggageWeight());
        }
        item.setReportParameters((AirTicketsTemplateReportParameters)data.get("key-report-params"));
        item.setGds(CommonReservationGdsNameInfoHelper.getDisplayedGdsName((Reservation)product.getReservation()));
        item.setPcc(product.getPcc());
        item.setComments(product.getComments());
        item.setTicketType(product.getTicketType());
        item.setMainProductNumber(product.getMainProductNumber());
        item.setPreviousProductStatus(product.getPreviousProductStatus());
        BigDecimal previousProductTotalEquivalentFare = BigDecimal.ZERO;
        if (product.getPreviousProduct() != null) {
            item.setHasPreviousProduct(true);
            item.setPreviousProductEquivalentFare(AirProductHelper.getEquivalentFare((Product)product.getPreviousProduct()));
            if (product.getPreviousProduct().getTaxes() != null) {
                item.getPreviousProductTaxes().addAll(product.getPreviousProduct().getTaxes());
            }
            if (product.getPreviousProduct().getSegmentTariffs() != null && !product.getPreviousProduct().getSegmentTariffs().isEmpty()) {
                List renderNumbers = product.getPreviousProduct().getSegmentTariffs().stream().flatMap(segmentTariff -> segmentTariff.getSegments().stream()).map(Segment::getRecordNumber).collect(Collectors.toList());
                item.getAllRecorderNumbersSegmentsPreviousProduct().addAll(renderNumbers);
            }
            if (product.getPreviousProduct().getPreviousProduct() != null) {
                item.setHasPreviousPreviousProduct(true);
                item.setSystemNumberPreviousPreviousProduct(product.getPreviousProduct().getPreviousProduct().getSystemNumber());
                item.setTicketTypePreviousPreviousProduct(product.getPreviousProduct().getPreviousProduct().getTicketType());
                item.setBlankOwnerNumberPreviousPreviousProduct(product.getPreviousProduct().getPreviousProduct().getBlankOwnerNumber());
                item.getConjunctionsPreviousPreviousProduct().addAll(Arrays.asList(AirProductHelper.getConjunctions((Product)product.getPreviousProduct().getPreviousProduct())));
                item.setBlankTypePreviousPreviousProduct(product.getPreviousProduct().getPreviousProduct().getBlankType());
            }
        }
        item.setPreviousProductTotalEquivalentFare(previousProductTotalEquivalentFare);
        item.getCommissions().addAll(AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR));
        if (!product.getRelatedProducts().isEmpty()) {
            item.setRelatedFirstProductStatus(((Product)product.getRelatedProducts().get(0)).getStatus());
        }
        item.getScns().addAll(product.getScns());
        BigDecimal baseFare = BigDecimal.ZERO;
        if (AirProductHelper.calculateFareRate((Product)product) != null) {
            baseFare = AirProductHelper.calculateFareRate((Product)product);
        }
        item.setFareRate(baseFare);
        item.setHasNeighbourETicketMcoSticker(this.hasNeighbourETicketMcoSticker(product));
        item.setLuggageUnits(product.getLuggageUnits());
        BigDecimal tariffEquivalentVat = BigDecimal.ZERO;
        if (AirProductHelper.calculateTariffEquivalentVat((Product)product) != null) {
            tariffEquivalentVat = AirProductHelper.calculateTariffEquivalentVat((Product)product);
        }
        item.setTariffEquivalentVat(tariffEquivalentVat);
        Collection clientDiscounts = GeneralProductHelper.filterCommissions((Collection)GeneralProductHelper.getUnmodifiableCommissions((BaseProduct)product, (ContractType)ContractType.CLIENT), null);
        BigDecimal clientDiscount = BigDecimal.ZERO;
        if (GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)clientDiscounts) != null) {
            clientDiscount = GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)clientDiscounts);
        }
        item.setClientDiscount(clientDiscount);
        item.setSettlementAccount(AirProductHelper.getSettlementAccount((Product)product));
        if (product.getReservation() != null) {
            CommonReservationGdsNameInfoHelper.getRecordLocatorOptional((Reservation)product.getReservation(), (GdsName)GdsName.SIRENA, (RecordLocatorType)RecordLocatorType.SIRENA_LATIN).ifPresent(arg_0 -> ((AirTicketsTemplateReportTicket)item).setReservationRecordLocatorLatin(arg_0));
            if (product.getReservation().getBookingAgent() != null) {
                item.setReservationBookingAgent(CommonReservationGdsNameInfoHelper.getDisplayedBookingAgentDutyCode((Reservation)product.getReservation()));
            }
        }
        item.setClassOfService(AirProductHelper.calculateClassOfService((Product)product));
        item.setMainProductCode(product.getMainProductCode());
        if (product.getRelatedProducts() != null && !product.getRelatedProducts().isEmpty()) {
            item.setHasRelatedProducts(true);
            item.setCarrierNumberFirstRelatedProduct(((Product)product.getRelatedProducts().get(0)).getCarrierNumber());
        }
        item.setTourCode(product.getTourCode());
        item.getConjunctions().addAll(Arrays.asList(AirProductHelper.getConjunctions((Product)product)));
        item.getConjunctionScns().addAll(Arrays.asList(AirProductHelper.getConjunctionsScns((Product)product)));
        item.setEndorsement(product.getEndorsement());
        item.setFareCalculationData(product.getFareCalculationData());
        item.setCarrierNumber(product.getCarrierNumber());
        item.setTelexNumber(product.getTelexNumber());
        item.setDuplicate(product.isDuplicate());
        item.setType(AirTicketsTemplateReportTicketType.PRODUCT);
        item.setTotalFare(AirProductHelper.calculateTotalEquivalentFare((Product)product));
        item.setAgent(product.getCashier());
        item.setAgentCode(product.getCashierCode());
        EntityContainer agent = EntityStorage.get().resolve(product.getCashier());
        if (agent != null) {
            ((Person)agent.getEntity()).getGdsReferences().stream().filter(ref -> TextUtil.nonBlank((String)ref.getReference()) && MiscUtil.isBetween((Date)ref.getOpened(), (Date)ref.getClosed(), (Date)product.getIssueDate()) && CommonReservationGdsNameInfoHelper.containsGds((Reservation)product.getReservation(), (GdsName)ref.getGdsName())).findFirst().ifPresent(ref -> item.setAgentGdsReference(ref.getReference()));
        }
        item.setStatus(product.getStatus());
        item.setMcoCategory(product.getMcoCategory());
        item.setProductCategory(product.getProductCategory());
        item.setUid(product.getUid());
        item.setBlankOwner(product.getBlankOwnerRef());
        item.setBlankOwnerNumber(product.getBlankOwnerNumber());
        item.setSupplier(AirProductHelper.getSupplier((Product)product));
        item.setAgency(AirProductHelper.getAgency((Product)product));
        item.setSalesPoint(product.getSalesPoint());
        item.setEquivalentFare(MiscUtil.nonNull((BigDecimal)(product.getStatus() != ProductStatus.VOID ? AirProductHelper.getEquivalentFare((Product)product) : BigDecimal.ZERO)));
        item.setBaseFare(AirProductHelper.getBaseFare((Product)product));
        item.setPrice(AirProductHelper.calculateTotalEquivalentFare((Product)product));
        item.setTicketSeries(AirProductHelper.getTicketSeries((Product)product));
        item.setIssueDate(product.getIssueDate());
        item.setValidatingCarrier(product.getCarrier());
        item.setValidatingCarrierNumber(product.getCarrierNumber());
        SortingNumberData stn = AirTicketsTemplateReportPrepareHandler.getSortingNumberData(product);
        item.setSortingTicketNumber(stn.sortingNumber);
        item.setLocalizedRouteLine(AirProductHelper.getLocalizedRouteLine((Product)product));
        BlankType blankType = (BlankType)DictionaryCache.get().resolveReference(product.getBlankType());
        item.setEticket(blankType != null && blankType.getBlankCategory() != null && blankType.getBlankCategory() == BlankCategory.ETICKET);
        item.setBlankType(product.getBlankType());
        item.setOperationBatch(stn.batch);
        item.setTransportationType(AirTicketsTemplateReportPrepareHandler.getTransportationType(product));
        item.setTariffType(product.getTariffType());
        item.setInterline(AirProductHelper.isProductInterline((Product)product));
        item.setMilitaryClaimNumber(GeneralProductHelper.getMilitaryClaimNumber((BaseProduct)product));
        item.setSubsidizedTariff(product.isSubsidizedTariff());
        item.setTicketNumber(AirTicketsTemplateReportPrepareHandler.getTicketNumber(product));
        item.setConjCount(product.getConjCount());
        if (product.getRelatedProducts().size() > 0 && product.getRelatedProducts().get(0) != null) {
            Product relatedProduct = (Product)product.getRelatedProducts().get(0);
            item.setRelatedTicketNumber(relatedProduct.getSystemNumber());
            item.setRelatedTicketValidatingCarrierNumber(relatedProduct.getCarrierNumber());
            BlankType relatedTicketBlankType = (BlankType)DictionaryCache.get().resolveReference(product.getBlankType());
            item.setRelatedEticket(relatedTicketBlankType != null && relatedTicketBlankType.getBlankCategory() == BlankCategory.ETICKET);
        }
        item.setValidator(product.getValidatorCode());
        item.setCustomerProfile(product.getReservation().getBookingFile().getCustomerProfile());
        item.setRouteLine(AirProductHelper.getRouteLine((Product)product, null, (boolean)true, (CodeSystem)CodeSystem.IATA));
        item.setCrtRouteLine(AirProductHelper.getRouteLine((Product)product, null, (boolean)true, (CodeSystem)CodeSystem.CRT));
        item.setRouteLineWithFlightNum(AirProductHelper.getRouteLineWithFlightNum((Product)product, null, (boolean)true, (CodeSystem)CodeSystem.IATA));
        HashSet<String> airlines = new HashSet<String>();
        LinkedHashSet<String> fareBasises = new LinkedHashSet<String>();
        Date depDate = null;
        int segmentTariffsCount = product.getSegmentTariffs().size();
        boolean first = true;
        for (SegmentTariff st : product.getSegmentTariffs()) {
            BigDecimal segmentEquivalentFare;
            AirTicketsTemplateReportSegmentTariff reportSt = new AirTicketsTemplateReportSegmentTariff();
            item.getSegmentTariffs().add(reportSt);
            BigDecimal bigDecimal = segmentEquivalentFare = segmentTariffsCount == 1 ? AirProductHelper.getEquivalentFare((Product)product) : AirProductHelper.getSegmentEquivalentFare((Product)product, (SegmentTariff)st);
            if (segmentEquivalentFare == null) {
                item.setHaseUndistributedFares(true);
                if (first) {
                    segmentEquivalentFare = AirProductHelper.getEquivalentFare((Product)product);
                }
            }
            for (Tax tax : product.getTaxes()) {
                if (tax.getSegmentTariff() == null && segmentTariffsCount > 1) {
                    item.setHaseUndistributedTaxes(true);
                }
                if (!st.equals((Object)tax.getSegmentTariff()) && (tax.getSegmentTariff() != null || !first)) continue;
                SimpleTax reportTax = new SimpleTax();
                reportTax.setCode(tax.getCode());
                reportTax.setAmount(tax.getEquivalentAmount());
                reportSt.getTaxes().add(reportTax);
            }
            Object commission = BigDecimal.ZERO;
            Double commissionRate = null;
            for (Commission comm : AirProductHelper.getVendorContractRelation((Product)product).getCommissions()) {
                if (comm.getSegmentTariff() == null && segmentTariffsCount > 1) {
                    item.setHaseUndistributedCommissions(true);
                }
                if (!st.equals((Object)comm.getSegmentTariff()) && (comm.getSegmentTariff() != null || !first)) continue;
                commission = MiscUtil.sum((BigDecimal[])new BigDecimal[]{comm.getEquivalentAmount(), commission});
                if (commissionRate != null) continue;
                commissionRate = comm.getRate();
            }
            reportSt.setVendorCommissionValue((BigDecimal)commission);
            reportSt.setVendorCommissionRate(commissionRate);
            BigDecimal subagentCommission = BigDecimal.ZERO;
            Double subagentCommissionRate = null;
            for (Commission comm : AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.SUBAGENCY)) {
                if (comm.getSegmentTariff() == null && segmentTariffsCount > 1) {
                    item.setHaseUndistributedSubagentCommissions(true);
                }
                if (!st.equals((Object)comm.getSegmentTariff()) && (comm.getSegmentTariff() != null || !first)) continue;
                subagentCommission = MiscUtil.sum((BigDecimal[])new BigDecimal[]{comm.getEquivalentAmount(), subagentCommission});
                if (subagentCommissionRate != null) continue;
                subagentCommissionRate = comm.getRate();
            }
            reportSt.setSubagentCommissionValue(subagentCommission);
            reportSt.setSubagentCommissionRate(subagentCommissionRate);
            reportSt.setTariff(segmentEquivalentFare);
            for (Object seg : st.getSegments()) {
                AirTicketsTemplateReportSegment reportSeg = new AirTicketsTemplateReportSegment();
                reportSt.getSegments().add(reportSeg);
                if (seg.getAirline() != null) {
                    reportSeg.setAirLineCode(seg.getAirline().getCode());
                }
                reportSeg.setStartDate(seg.getStartDate());
                reportSeg.setClassOfService(seg.getClassOfService());
                reportSeg.setRecordNumber(seg.getRecordNumber());
                reportSeg.setDepartCityCode(seg.getDepartCityCode());
                reportSeg.setArriveCityCode(seg.getArriveCityCode());
                reportSeg.setArrivalLocation(seg.getArriveLocation());
                reportSeg.setDepartureDate(seg.getStartDate());
                reportSeg.setDepartureLocation(seg.getDepartureLocation());
                reportSeg.setFlightNumber(seg.getFlightNo());
                reportSeg.setFareBasis(seg.getFareBasis());
                reportSeg.setRouteLine(AirProductHelper.getRouteLineBySegment((Segment)seg, null, (boolean)true, (CodeSystem)CodeSystem.CRT));
                if (depDate == null) {
                    depDate = seg.getStartDate();
                }
                if (seg.getAirline() != null) {
                    airlines.add(seg.getAirline().getCode());
                }
                if (!TextUtil.isBlank((String)seg.getFareBasis())) {
                    fareBasises.add(seg.getFareBasis());
                }
                if (!TextUtil.isBlank((String)seg.getFlightNo())) {
                    item.getFlightNumbers().add(seg.getFlightNo());
                }
                Object relatedTicketNumber = "";
                if (product.getRelatedProducts().size() > 0 && product.getRelatedProducts().get(0) != null) {
                    relatedTicketNumber = ((Product)product.getRelatedProducts().get(0)).getSystemNumber();
                } else if (product.getStatus() == ProductStatus.REFUND && product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.SELL) {
                    relatedTicketNumber = product.getPreviousProduct().getSystemNumber();
                } else if (product.getStatus() == ProductStatus.SELL && product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE) {
                    relatedTicketNumber = product.getPreviousProduct().getPreviousProduct().getSystemNumber();
                }
                reportSeg.setEmrcCode(this.getEmrcCode(product, (Segment)seg, 0, (String)relatedTicketNumber));
            }
            first = false;
        }
        item.setDepartureDate(depDate);
        Segment firstSegment = AirProductHelper.getFirstSegment((Product)product);
        if (firstSegment != null) {
            item.setDepartureGeoLocation(firstSegment.getDepartureLocation());
            item.setDepartureCityCode(firstSegment.getDepartCityCode());
            GeoLocation departureLocation = (GeoLocation)DictionaryCache.get().resolveReference(firstSegment.getDepartureLocation());
            if (departureLocation != null) {
                item.getDepartureLocationCodes().clear();
                item.getDepartureLocationCodes().putAll(departureLocation.getCodeVariants());
            }
        }
        if ((lastSegment = AirProductHelper.getLastSegment((Product)product)) != null) {
            item.setArriveGeoLocation(lastSegment.getArriveLocation());
            item.setArriveCityCode(lastSegment.getArriveCityCode());
            GeoLocation arriveLocation = (GeoLocation)DictionaryCache.get().resolveReference(lastSegment.getArriveLocation());
            if (arriveLocation != null) {
                item.getArriveLocationCodes().clear();
                item.getArriveLocationCodes().putAll(arriveLocation.getCodeVariants());
            }
        }
        StringBuilder carriersSB = new StringBuilder();
        StringBuilder fareBasisesSB = new StringBuilder();
        for (String s : airlines) {
            carriersSB.append(carriersSB.length() > 0 ? "/" : "").append(s);
        }
        for (String s : fareBasises) {
            fareBasisesSB.append(fareBasisesSB.length() > 0 ? "/" : "").append(s);
        }
        item.setCarriersLine(carriersSB.toString());
        item.setFareBasisLine(fareBasisesSB.toString());
        if (product.getStatus() == ProductStatus.VOID || product.getStatus() == ProductStatus.VOID_BOOKING) {
            item.setRouteLine("VOID");
            AirTicketsTemplateReportPrepareHandler.resetFinanceFields(item);
            return Collections.singletonList(item);
        }
        if (AirProductHelper.isBSPTicket((Product)product)) {
            Double bspSubagentCommissionRate = product.getBspSubagentCommissionRate();
            item.setGdsBspSubagentCommissionPercent(bspSubagentCommissionRate == null ? null : BigDecimal.valueOf(bspSubagentCommissionRate));
            item.setGdsBspSubagentCommissionEquivalentAmount(product.getBspSubagentCommissionValue() != null ? product.getBspSubagentCommissionValue().getValue() : null);
            BigDecimal subagentBSPCommissionsRate = AirProductHelper.calculateCommissionsRate((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bspCommissionTypes, null), (boolean)true);
            BigDecimal subagentBSPCommissionsValue = AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bspCommissionTypes, null));
            item.setBspSubagentCommissionPercent(subagentBSPCommissionsRate);
            item.setBspSubagentCommissionEquivalentAmount(subagentBSPCommissionsValue);
            if (product.getBlankOwnerRef() != null && product.getBlankOwnerRef().equals((Object)AirProductHelper.getSupplier((Product)product))) {
                item.setSubagentCommissionRate(subagentBSPCommissionsRate);
                item.setSubagentCommissionValue(subagentBSPCommissionsValue);
            } else {
                BigDecimal subagentCommissionsRate2 = AirProductHelper.calculateCommissionsRate((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null), (boolean)true);
                BigDecimal subagentCommissionsValue2 = AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null));
                item.setSubagentCommissionRate(subagentCommissionsRate2);
                item.setSubagentCommissionValue(subagentCommissionsValue2);
            }
        } else if (product.getBlankOwnerRef() != null && product.getBlankOwnerRef().equals((Object)AirProductHelper.getSupplier((Product)product))) {
            subagentCommissionsRate = AirProductHelper.calculateCommissionsRate((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, null, null), (boolean)true);
            subagentCommissionsValue = AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, null, null));
            item.setSubagentCommissionRate(subagentCommissionsRate);
            item.setSubagentCommissionValue(subagentCommissionsValue);
        } else {
            subagentCommissionsRate = AirProductHelper.calculateCommissionsRate((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.subagentCommissionTypes, null), (boolean)true);
            subagentCommissionsValue = AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.subagentCommissionTypes, null));
            item.setSubagentCommissionRate(subagentCommissionsRate);
            item.setSubagentCommissionValue(subagentCommissionsValue);
        }
        if (AirProductHelper.isBSPTicket((Product)product)) {
            Double bspCommissionRate = product.getBspCommissionRate();
            item.setGdsBspCommissionPercent(bspCommissionRate == null ? null : BigDecimal.valueOf(bspCommissionRate));
            item.setGdsBspCommissionEquivalentAmount(product.getBspCommissionValue() != null ? product.getBspCommissionValue().getValue() : null);
            BigDecimal vendorBSPCommissionsRate = AirProductHelper.calculateCommissionsRate((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bspCommissionTypes, null), (boolean)true);
            BigDecimal vendorBSPCommissionsValue = AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bspCommissionTypes, null));
            item.setBspCommissionPercent(vendorBSPCommissionsRate);
            item.setBspCommissionEquivalentAmount(vendorBSPCommissionsValue);
            if (product.getBlankOwnerRef() != null && product.getBlankOwnerRef().equals((Object)AirProductHelper.getSupplier((Product)product))) {
                item.setVendorCommissionRate(vendorBSPCommissionsRate);
                item.setVendorCommissionValue(vendorBSPCommissionsValue);
            } else {
                BigDecimal vendorCommissionsRate2 = AirProductHelper.calculateCommissionsRate((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null), (boolean)true);
                BigDecimal vendorCommissionsValue2 = AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null));
                item.setVendorCommissionRate(vendorCommissionsRate2);
                item.setVendorCommissionValue(vendorCommissionsValue2);
            }
        } else if (product.getBlankOwnerRef() != null && product.getBlankOwnerRef().equals((Object)AirProductHelper.getSupplier((Product)product))) {
            vendorCommissionsRate = AirProductHelper.calculateCommissionsRate((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, null, null), (boolean)true);
            vendorCommissionsValue = AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, null, null));
            item.setVendorCommissionRate(vendorCommissionsRate);
            item.setVendorCommissionValue(vendorCommissionsValue);
        } else {
            vendorCommissionsRate = AirProductHelper.calculateCommissionsRate((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.subagentCommissionTypes, null), (boolean)true);
            vendorCommissionsValue = AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.subagentCommissionTypes, null));
            item.setVendorCommissionRate(vendorCommissionsRate);
            item.setVendorCommissionValue(vendorCommissionsValue);
        }
        item.setLastFlightDate(AirProductHelper.getLastDepartureDate((Product)product));
        List fees = (List)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.feePropertyTypes, null, null);
        item.setClientFeeValue(AirProductHelper.calculateCommissionsEquivalentValue((Collection)fees));
        if (fees != null && fees.size() > 0 && fees.get(0) != null && ((Commission)fees.get(0)).getRate() != null) {
            item.setClientFeeRate(BigDecimal.valueOf(((Commission)fees.get(0)).getRate()));
        }
        item.getTaxes().clear();
        item.getTaxes().addAll(product.getTaxes());
        item.setRuTaxAmount(AirProductTaxHelper.getTaxesForBlankEquivalentAmount((Product)product));
        item.setFuelChargeAmount(AirProductTaxHelper.getFuelTaxesEquivalentAmount((Product)product));
        item.setTaxesSum(AirProductTaxHelper.getEquivalentTaxesAmount((Product)product));
        if (product.getMcoCategory() == MCOCategory.PENALTY) {
            item.setPenalty(MiscUtil.nonNull((BigDecimal)AirProductHelper.getEquivalentFare((Product)product)));
            item.setEquivalentFare(BigDecimal.ZERO);
            if (!product.getRelatedProducts().isEmpty() && (AirProductHelper.getClientFops((Product)((Product)product.getRelatedProducts().get(0))).stream().anyMatch(fop -> fop.getType() == PaymentType.MTD) || AirProductHelper.getVendorFops((Product)((Product)product.getRelatedProducts().get(0))).stream().anyMatch(fop -> fop.getType() == PaymentType.MTD))) {
                item.setPenaltyVPD(MiscUtil.nonNull((BigDecimal)AirProductHelper.getEquivalentFare((Product)product)));
            }
        } else {
            item.setEquivalentFare(MiscUtil.nonNull((BigDecimal)AirProductHelper.getEquivalentFare((Product)product)));
            item.setPenalty(MiscUtil.nonNull((BigDecimal)product.getPenalty()));
            if (product.getStatus() == ProductStatus.REFUND) {
                BookingHelper.getProductsStream((BookingFile)product.getReservation().getBookingFile(), Product.class).filter(p -> p.getMcoCategory() == MCOCategory.PENALTY && p.getRelatedProducts().contains(product)).findFirst().ifPresent(p -> {
                    item.setPenaltyMCO(MiscUtil.nonNull((BigDecimal)AirProductHelper.getEquivalentFare((Product)p)));
                    item.setPenaltyMCONumber(p.getSystemNumber());
                });
            } else if (product.getStatus() == ProductStatus.SELL && product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE) {
                BookingHelper.getProductsStream((BookingFile)product.getReservation().getBookingFile(), Product.class).filter(p -> p.getMcoCategory() == MCOCategory.REBOOKING && p.getRelatedProducts().contains(product)).findFirst().ifPresent(p -> {
                    item.setPenaltyMCO(MiscUtil.nonNull((BigDecimal)AirProductHelper.getEquivalentFare((Product)p)));
                    item.setPenaltyMCONumber(p.getSystemNumber());
                });
            }
        }
        AirTicketsTemplateReportParameters params = (AirTicketsTemplateReportParameters)data.get("key-report-params");
        if (((AirTicketsTemplateReportDescription)EntityStorage.get().resolve(params.getDescription()).getEntity()).isHideExchanges() && product.getStatus() == ProductStatus.SELL && product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE) {
            AirTicketsTemplateReportTicket ep = this.createRecords(product.getPreviousProduct(), data, messages).get(0);
            item.setEquivalentFareBeforeExchange(ep.getEquivalentFare());
            item.setPreviousPrice(ep.getPrice());
            item.getPreviousTaxes().addAll(ep.getTaxes());
            item.setPreviousTariffCodes(product.getPreviousProduct().getSegmentTariffs().stream().map(SegmentTariff::getSegments).flatMap(Collection::stream).map(Segment::getFareBasis).filter(TextUtil::nonBlank).distinct().collect(Collectors.joining(",")));
            item.setEquivalentFareAfterExchange(item.getEquivalentFare());
            item.setEquivalentFare(item.getEquivalentFare().subtract(ep.getEquivalentFare()));
            item.setTaxesSum(item.getTaxesSum().subtract(ep.getTaxesSum()));
            item.setBspCommissionEquivalentAmount(MiscUtil.sum((BigDecimal[])new BigDecimal[]{item.getBspCommissionEquivalentAmount(), MiscUtil.negate((BigDecimal)ep.getBspCommissionEquivalentAmount())}));
            item.setRuTaxAmount(item.getRuTaxAmount().subtract(ep.getRuTaxAmount()));
            item.setFuelChargeAmount(item.getFuelChargeAmount().subtract(ep.getFuelChargeAmount()));
            item.setPrice(MiscUtil.sub((BigDecimal)item.getPrice(), (BigDecimal[])new BigDecimal[]{ep.getPrice()}));
            HashMap<String, BigDecimal> prevTaxesMap = new HashMap<String, BigDecimal>();
            HashMap currentTaxesMap = new HashMap();
            for (Tax t : ep.getTaxes()) {
                if (!prevTaxesMap.containsKey(t.getCode()) || prevTaxesMap.get(t.getCode()) == null) {
                    prevTaxesMap.put(t.getCode(), t.getEquivalentAmount());
                    continue;
                }
                prevTaxesMap.put(t.getCode(), ((BigDecimal)prevTaxesMap.get(t.getCode())).add(t.getEquivalentAmount()));
            }
            for (Tax t : item.getTaxes()) {
                if (!currentTaxesMap.containsKey(t.getCode()) || currentTaxesMap.get(t.getCode()) == null) {
                    currentTaxesMap.put(t.getCode(), t.getEquivalentAmount());
                    continue;
                }
                currentTaxesMap.put(t.getCode(), ((BigDecimal)currentTaxesMap.get(t.getCode())).add(t.getEquivalentAmount()));
            }
            item.getTaxes().clear();
            currentTaxesMap.forEach((taxCode, eqAmount) -> {
                if (prevTaxesMap.containsKey(taxCode)) {
                    eqAmount = MiscUtil.sub((BigDecimal)eqAmount, (BigDecimal[])new BigDecimal[]{(BigDecimal)prevTaxesMap.get(taxCode)});
                }
                Tax tax = new Tax();
                tax.setCode(taxCode);
                tax.setEquivalentAmount(eqAmount);
                item.getTaxes().add(tax);
            });
            item.setRelatedTicketNumber(ep.getTicketNumber());
            item.setRelatedTicketValidatingCarrierNumber(ep.getValidatingCarrierNumber());
            item.setRelatedEticket(ep.isEticket());
            item.setRelatedTicketRouteLine(ep.getRouteLine());
            item.setRelatedTicketFareBasisLine(ep.getFareBasisLine());
            item.setRelatedTicketDepartureDate(AirProductHelper.getLastDepartureDate((Product)product.getPreviousProduct().getPreviousProduct()));
            item.setRelatedTicketIssueDate(product.getPreviousProduct().getPreviousProduct().getIssueDate());
            Map<String, AirTicketsTemplateReportSegmentTariff> prevTariffsMap = this.createTariffsMap(ep);
            Map<String, AirTicketsTemplateReportSegmentTariff> tariffsMap = this.createTariffsMap(item);
            for (Map.Entry entry : prevTariffsMap.entrySet()) {
                AirTicketsTemplateReportSegmentTariff segmentTariff2 = (AirTicketsTemplateReportSegmentTariff)tariffsMap.get(entry.getKey());
                if (segmentTariff2 == null) {
                    item.setHaseUmatchedExchangeSegments(true);
                    AirTicketsTemplateReportSegmentTariff fakeSt = new AirTicketsTemplateReportSegmentTariff();
                    item.getSegmentTariffs().add(fakeSt);
                    AirTicketsTemplateReportSegmentTariff prevSt = (AirTicketsTemplateReportSegmentTariff)entry.getValue();
                    fakeSt.setTariff(MiscUtil.negate((BigDecimal)prevSt.getTariff()));
                    fakeSt.setVendorCommissionRate(prevSt.getVendorCommissionRate());
                    fakeSt.setVendorCommissionValue(MiscUtil.negate((BigDecimal)prevSt.getVendorCommissionValue()));
                    fakeSt.getSegments().addAll(prevSt.getSegments());
                    for (SimpleTax simpleTax : prevSt.getTaxes()) {
                        SimpleTax fakeTax = new SimpleTax();
                        fakeTax.setAmount(MiscUtil.negate((BigDecimal)simpleTax.getAmount()));
                        fakeTax.setCode(simpleTax.getCode());
                        fakeSt.getTaxes().add(fakeTax);
                    }
                    continue;
                }
                segmentTariff2.setTariff(MiscUtil.sub((BigDecimal)segmentTariff2.getTariff(), (BigDecimal[])new BigDecimal[]{((AirTicketsTemplateReportSegmentTariff)entry.getValue()).getTariff()}));
                segmentTariff2.setVendorCommissionValue(MiscUtil.sub((BigDecimal)segmentTariff2.getVendorCommissionValue(), (BigDecimal[])new BigDecimal[]{((AirTicketsTemplateReportSegmentTariff)entry.getValue()).getVendorCommissionValue()}));
                Map<String, BigDecimal> taxes = this.createTaxesMap(segmentTariff2.getTaxes());
                Map<String, BigDecimal> prevTaxes = this.createTaxesMap(((AirTicketsTemplateReportSegmentTariff)entry.getValue()).getTaxes());
                for (Map.Entry entry2 : prevTaxes.entrySet()) {
                    BigDecimal taxValue = taxes.get(entry2.getKey());
                    if (taxValue == null) {
                        SimpleTax fakeTax = new SimpleTax();
                        fakeTax.setAmount(MiscUtil.negate((BigDecimal)((BigDecimal)entry2.getValue())));
                        fakeTax.setCode((String)entry2.getKey());
                        segmentTariff2.getTaxes().add(fakeTax);
                        continue;
                    }
                    taxes.put((String)entry2.getKey(), MiscUtil.sum((BigDecimal[])new BigDecimal[]{(BigDecimal)entry2.getValue(), taxValue}));
                }
            }
        }
        if (product.getStatus() == ProductStatus.REFUND && product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.SELL) {
            item.setRelatedTicketNumber(product.getPreviousProduct().getSystemNumber());
            item.setRelatedTicketValidatingCarrierNumber(product.getPreviousProduct().getCarrierNumber());
            item.setRelatedTicketIssueDate(product.getPreviousProduct().getIssueDate());
            BlankType previousTicketBlankType = (BlankType)DictionaryCache.get().resolveReference(product.getBlankType());
            item.setRelatedEticket(previousTicketBlankType != null && previousTicketBlankType.getBlankCategory() == BlankCategory.ETICKET);
        }
        item.setTravellerType(product.getPassengerType());
        if (product.getTraveller() != null) {
            Traveller traveller = product.getTraveller();
            if (traveller.getPassport() != null) {
                Passport passport = traveller.getPassport();
                item.setNameInGDS(traveller.getName());
                item.setRealNameInGDS(traveller.getNameInGds());
                item.setTravellerName(TextUtil.buildFullName((PersonalName)passport));
                item.setTravellerPassportType(passport.getType());
                item.setTravellerPassportNumber(passport.getNumber());
                item.setTravellerBirthday(passport.getBirthday());
                if (passport.getGender() != null) {
                    item.setTravellerGender(passport.getGender().toString());
                }
            }
            item.setCyrillicName(traveller.getCyrillicName());
            item.setTravellerProfile(traveller.getPassenger());
            if (TextUtil.isBlank((String)item.getTravellerName())) {
                item.setTravellerName(traveller.getName());
            }
            if (item.getTravellerBirthday() == null) {
                item.setTravellerBirthday(traveller.getBirthday());
            }
        }
        ArrayList<PaymentType> clientPaymentTypes = new ArrayList<PaymentType>();
        HashMap<PaymentType, Money> clientPaymentsInfo = new HashMap<PaymentType, Money>();
        for (ProductFop clientFop : AirProductHelper.getClientFops((Product)product)) {
            if (clientFop.getType() == null || clientPaymentTypes.contains(clientFop.getType())) continue;
            clientPaymentTypes.add(clientFop.getType());
            clientPaymentsInfo.put(clientFop.getType(), clientFop.getAmount());
        }
        Collections.sort(clientPaymentTypes);
        item.getClientPaymentTypes().clear();
        item.getClientPaymentTypes().addAll(clientPaymentTypes);
        ArrayList<PaymentType> subagentPaymentTypes = new ArrayList<PaymentType>();
        HashMap<PaymentType, Money> subagentPaymentsInfo = new HashMap<PaymentType, Money>();
        for (ProductFop subagentFop : AirProductHelper.getSubagentFops((Product)product, (boolean)true)) {
            if (subagentFop.getType() == null || subagentPaymentTypes.contains(subagentFop.getType())) continue;
            subagentPaymentTypes.add(subagentFop.getType());
            subagentPaymentsInfo.put(subagentFop.getType(), subagentFop.getAmount());
        }
        Collections.sort(subagentPaymentTypes);
        item.getSubagentPaymentTypes().clear();
        item.getSubagentPaymentTypes().addAll(subagentPaymentTypes);
        ArrayList<PaymentType> paymentTypes = new ArrayList<PaymentType>();
        HashMap<PaymentType, Money> paymentsInfo = new HashMap<PaymentType, Money>();
        for (ProductFop vendorFop : AirProductHelper.getVendorContractRelation((Product)product).getFops()) {
            if (vendorFop.getType() != null && !paymentTypes.contains(vendorFop.getType())) {
                paymentTypes.add(vendorFop.getType());
                paymentsInfo.put(vendorFop.getType(), vendorFop.getAmount());
            }
            if (item.getRelatedDocumentNumber() == null && vendorFop.getRelatedTicketNumber() != null) {
                item.setRelatedDocumentNumber(vendorFop.getRelatedTicketNumber());
            }
            if (item.getPassengerStatus() != null || vendorFop.getPassengerStatus() == null) continue;
            item.setPassengerStatus(vendorFop.getPassengerStatus());
        }
        Collections.sort(paymentTypes);
        item.getPaymentTypes().clear();
        item.getPaymentTypes().addAll(paymentTypes);
        item.getPaymentsInfo().clear();
        item.getPaymentsInfo().putAll(paymentsInfo);
        Map map = AirProductHelper.getFaresByCarriersMap((Product)product);
        for (Map.Entry entry : map.entrySet()) {
            item.getFaresByCarriers().put(entry.getKey(), entry.getValue());
        }
        if (product.getPreviousProduct() != null) {
            item.setPreviousTicketNumber(product.getPreviousProduct().getSystemNumber());
        }
        if (product.getNextProduct() != null) {
            item.setNextTicketNumber(product.getNextProduct().getSystemNumber());
        }
        item.setRouteContainsCrimea(this.isRouteContainsCrimea(product));
        item.setRouteContainsKaliningrad(this.isRouteContainsKaliningrad(product));
        item.setRouteContainsDVFO(this.isRouteContainsDVFO(product));
        item.setRouteContainsCIS(this.isRouteContainsCIS(product));
        item.setRouteContainsCISWithoutDomestic(AirProductHelper.isRouteContainsCISWithoutDomestic((Product)product));
        item.setPnr(CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)product.getReservation()));
        return Collections.singletonList(item);
    }

    private Map<String, BigDecimal> createTaxesMap(List<SimpleTax> taxes) {
        LinkedHashMap<String, BigDecimal> result = new LinkedHashMap<String, BigDecimal>();
        for (SimpleTax tax : taxes) {
            BigDecimal val = (BigDecimal)result.get(tax.getCode());
            result.put(tax.getCode(), MiscUtil.sub((BigDecimal)val, (BigDecimal[])new BigDecimal[]{tax.getAmount()}));
        }
        return result;
    }

    private Map<String, AirTicketsTemplateReportSegmentTariff> createTariffsMap(AirTicketsTemplateReportTicket ep) {
        LinkedHashMap<String, AirTicketsTemplateReportSegmentTariff> result = new LinkedHashMap<String, AirTicketsTemplateReportSegmentTariff>();
        for (AirTicketsTemplateReportSegmentTariff st : ep.getSegmentTariffs()) {
            StringBuilder sb = new StringBuilder();
            for (AirTicketsTemplateReportSegment seg : st.getSegments()) {
                GeoLocation departureCity = DictHelper.findCity((DictionaryReference)seg.getDepartureLocation());
                sb.append(departureCity == null ? null : departureCity.getCode());
                GeoLocation arrivalCity = DictHelper.findCity((DictionaryReference)seg.getArrivalLocation());
                sb.append(arrivalCity == null ? null : arrivalCity.getCode());
            }
            result.put(sb.toString(), st);
        }
        return result;
    }

    private boolean isRouteContainsCIS(Product product) {
        if (product.getProductCategory() == ProductCategory.AIR || product.getMcoCategory() == MCOCategory.PTA) {
            return AirProductHelper.isRouteContainsCIS((Product)product);
        }
        Product relatedProduct = AirProductHelper.findRelatedAirProduct((Product)product, null, (boolean)false);
        return AirProductHelper.isRouteContainsCIS((Product)(relatedProduct != null ? relatedProduct : product));
    }

    private boolean isRouteContainsDVFO(Product product) {
        if (product.getProductCategory() == ProductCategory.AIR || product.getMcoCategory() == MCOCategory.PTA) {
            return AirProductHelper.isRouteContainsDVFO((Product)product);
        }
        Product relatedProduct = AirProductHelper.findRelatedAirProduct((Product)product, null, (boolean)false);
        return AirProductHelper.isRouteContainsDVFO((Product)(relatedProduct != null ? relatedProduct : product));
    }

    private boolean isRouteContainsCrimea(Product product) {
        if (product.getProductCategory() == ProductCategory.AIR || product.getMcoCategory() == MCOCategory.PTA) {
            return AirProductHelper.isRouteContainCrimea((Product)product);
        }
        Product relatedProduct = AirProductHelper.findRelatedAirProduct((Product)product, null, (boolean)false);
        return AirProductHelper.isRouteContainCrimea((Product)(relatedProduct != null ? relatedProduct : product));
    }

    private boolean isRouteContainsKaliningrad(Product product) {
        if (product.getProductCategory() == ProductCategory.AIR || product.getMcoCategory() == MCOCategory.PTA) {
            return AirProductHelper.isRouteContainsKaliningrad((Product)product);
        }
        Product relatedProduct = AirProductHelper.findRelatedAirProduct((Product)product, null, (boolean)false);
        return AirProductHelper.isRouteContainsKaliningrad((Product)(relatedProduct != null ? relatedProduct : product));
    }

    @Override
    protected Map<EntityReference<BookingFile>, Set<String>> getGroupedIndexes(AirTicketsTemplateReportParameters params, Map<String, Object> data, List<Message> messages, EntityContainer<AirTicketsTemplateReportDescription> descriptionCtr) throws Exception {
        SearchQuery result = new SearchQuery();
        if (((AirTicketsTemplateReportDescription)descriptionCtr.getEntity()).getReportCategory() == ReportCategory.INTERNAL) {
            result.getCriteria().getCriterions().add(SearchCriterion.ne((String)ProductIndex.Property.ticketType.name(), (Object)TicketType.FAKE));
            result.getCriteria().getCriterions().add(SearchCriterion.ne((String)ProductIndex.Property.ticketType.name(), (Object)TicketType.CORRECTION));
        } else {
            result.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ProductIndex.Property.ticketType.name(), (Object)TicketType.OWN), SearchCriterion.eq((String)ProductIndex.Property.ticketType.name(), (Object)TicketType.NOT_OWN), SearchCriterion.eq((String)ProductIndex.Property.ticketType.name(), null)}));
        }
        AirTicketsTemplateReportDescription description = (AirTicketsTemplateReportDescription)EntityStorage.get().resolve(params.getDescription()).getEntity();
        Date beginDate = params.getPeriodBegin();
        Date endDate = params.getPeriodEnd();
        if (description.getPeriodUse() == null || description.getPeriodUse() == TemplateReportPeriodUse.DATE) {
            beginDate = MiscUtil.clearTime((Date)beginDate);
            endDate = MiscUtil.setDayEndTime((Date)endDate);
        }
        if (beginDate != null || endDate != null) {
            ArrayList<SearchCriterion> vendorCriterions = new ArrayList<SearchCriterion>();
            ArrayList<SearchCriterion> issueCriterions = new ArrayList<SearchCriterion>();
            issueCriterions.add(SearchCriterion.eq((String)ProductIndex.Property.dateOfVendorPayment.name(), null));
            if (beginDate != null) {
                vendorCriterions.add(SearchCriterion.ge((String)ProductIndex.Property.dateOfVendorPayment.name(), (Object)beginDate));
                issueCriterions.add(SearchCriterion.ge((String)ProductIndex.Property.issueDate.name(), (Object)beginDate));
            }
            if (endDate != null) {
                vendorCriterions.add(SearchCriterion.le((String)ProductIndex.Property.dateOfVendorPayment.name(), (Object)endDate));
                issueCriterions.add(SearchCriterion.le((String)ProductIndex.Property.issueDate.name(), (Object)endDate));
            }
            result.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{vendorCriterions.size() == 1 ? (SearchCriterion)vendorCriterions.get(0) : SearchCriterion.and((SearchCriterion[])vendorCriterions.toArray(new SearchCriterion[vendorCriterions.size()])), SearchCriterion.and((SearchCriterion[])issueCriterions.toArray(new SearchCriterion[issueCriterions.size()]))}));
        }
        result.getCriteria().getCriterions().add(SearchCriterion.ne((String)ProductIndex.Property.status.name(), (Object)ProductStatus.BOOKING));
        result.getCriteria().getCriterions().add(SearchQueryHelper.buildAndNeEnumCriterion((String)ProductIndex.Property.status.name(), (Collection)ProductStatusHandler.getAllNonIssuedVoidStatuses()));
        result.getCriteria().getCriterions().addAll(CommonTemplateReportHelper.getModifiedCriterions((BaseTemplateReportParameters)params, (BaseSingleFileTemplateReportDescription)((BaseSingleFileTemplateReportDescription)EntityStorage.get().resolve(params.getDescription()).getEntity()), messages));
        if (params.getBlankOwner() != null) {
            result.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.blankOwner.name(), (Object)params.getBlankOwner()));
            result.getPreferredProperties().add(ProductIndex.Property.blankOwner.name());
        }
        if (params.getAgency() != null) {
            result.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.agency.name(), (Object)params.getAgency()));
            result.getPreferredProperties().add(ProductIndex.Property.agency.name());
        }
        if (params.getSalesPoint() != null) {
            result.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.salesPoint.name(), (Object)params.getSalesPoint()));
            result.getPreferredProperties().add(ProductIndex.Property.salesPoint.name());
        }
        if (params.getSubagency() != null) {
            result.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.subagency.name(), (Object)params.getSubagency()));
            result.getPreferredProperties().add(ProductIndex.Property.subagency.name());
        }
        if (params.getSupplier() != null) {
            result.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.supplier.name(), (Object)params.getSupplier()));
            result.getPreferredProperties().add(ProductIndex.Property.supplier.name());
        }
        if (params.getClient() != null) {
            result.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.client.name(), (Object)params.getClient()));
            result.getPreferredProperties().add(ProductIndex.Property.client.name());
        }
        if (description.isHideExchanges()) {
            result.getCriteria().getCriterions().add(SearchCriterion.ne((String)ProductIndex.Property.status.name(), (Object)ProductStatus.EXCHANGE));
        }
        if (params.isHideVoidEtickets()) {
            result.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ProductIndex.Property.eticket.name(), (Object)Boolean.FALSE), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ProductIndex.Property.eticket.name(), (Object)Boolean.TRUE), SearchCriterion.ne((String)ProductIndex.Property.status.name(), (Object)ProductStatus.VOID)})}));
        }
        if (result.getPreferredProperties().isEmpty()) {
            result.getPreferredProperties().add("uid");
        }
        return EntityStorage.get().search(ProductIndex.class, result).getData().stream().collect(Collectors.groupingBy(ProductIndex::getSource, Collectors.mapping(ProductIndex::getNavigationKey, Collectors.toSet())));
    }

    @Override
    protected List<AirTicketsTemplateReportTicket> createAdditionalRecords(AirTicketsTemplateReportParameters parameters, Map<String, Object> data, List<Message> messages) throws Exception {
        ArrayList<AirTicketsTemplateReportTicket> tickets = new ArrayList<AirTicketsTemplateReportTicket>();
        Collection<AgencyMemoProduct> agencyMemoProducts = this.getAgencyMemoProducts(parameters, data, messages);
        for (AgencyMemoProduct agencyMemoProduct : agencyMemoProducts) {
            tickets.addAll(this.createAgencyMemoProductRecords(agencyMemoProduct, data, messages));
        }
        return tickets;
    }

    protected Collection<AgencyMemoProduct> getAgencyMemoProducts(AirTicketsTemplateReportParameters parameters, Map<String, Object> data, List<Message> messages) throws Exception {
        EntityStorage entityStorage = EntityStorage.get();
        Date periodBegin = parameters.getPeriodBegin();
        Date periodEnd = parameters.getPeriodEnd();
        EntityReference blankOwnerReference = parameters.getBlankOwner();
        EntityReference supplierReference = parameters.getSupplier();
        EntityReference agencyReference = parameters.getAgency();
        SearchQuery query = new SearchQuery();
        if (periodBegin != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.ge((String)AgencyMemoProductIndex.Property.targetReportDate.name(), (Object)MiscUtil.clearTime((Date)periodBegin)));
        }
        if (periodEnd != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.le((String)AgencyMemoProductIndex.Property.targetReportDate.name(), (Object)MiscUtil.setDayEndTime((Date)periodEnd)));
        }
        if (blankOwnerReference != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)AgencyMemoProductIndex.Property.blankOwner.name(), (Object)blankOwnerReference));
        }
        if (supplierReference != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)AgencyMemoProductIndex.Property.supplier.name(), (Object)supplierReference));
        }
        if (agencyReference != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)AgencyMemoProductIndex.Property.agency.name(), (Object)agencyReference));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)AgencyMemoProductIndex.Property.includeToReport.name(), (Object)Boolean.TRUE));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)AgencyMemoProductIndex.Property.ticketType.name(), (Object)TicketType.CORRECTION));
        List agencyMemoProductIndexes = entityStorage.search(AgencyMemoProductIndex.class, query).getData();
        HashMap<EntityReference, ArrayList<String>> agencyMemoProductUids = new HashMap<EntityReference, ArrayList<String>>();
        for (AgencyMemoProductIndex agencyMemoProductIndex : agencyMemoProductIndexes) {
            EntityReference bookingFileReference = agencyMemoProductIndex.getSource();
            ArrayList<String> uids = (ArrayList<String>)agencyMemoProductUids.get(bookingFileReference);
            if (uids == null) {
                uids = new ArrayList<String>();
                agencyMemoProductUids.put(bookingFileReference, uids);
            }
            uids.add(agencyMemoProductIndex.getNavigationKey());
        }
        HashSet<AgencyMemoProduct> agencyMemoProducts = new HashSet<AgencyMemoProduct>();
        for (Map.Entry entry : agencyMemoProductUids.entrySet()) {
            EntityReference bookingFileReference = (EntityReference)entry.getKey();
            List uids = (List)entry.getValue();
            EntityContainer bookingFileContainer = entityStorage.resolve(bookingFileReference);
            if (bookingFileContainer == null) {
                SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_FailedLoadingEntity", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{"null"});
                log.debug("Unable to load booking file container " + bookingFileReference.getUid() + ". All agency memo products will be excluded from report.");
                continue;
            }
            for (String uid : uids) {
                AgencyMemoProduct agencyMemoProduct = (AgencyMemoProduct)BookingHelper.findProductByUid((String)uid, (BookingFile)((BookingFile)bookingFileContainer.getEntity()), AgencyMemoProduct.class);
                if (agencyMemoProduct == null) continue;
                agencyMemoProducts.add(agencyMemoProduct);
            }
        }
        return agencyMemoProducts;
    }

    protected List<AirTicketsTemplateReportTicket> createAgencyMemoProductRecords(AgencyMemoProduct product, Map<String, Object> data, List<Message> messages) throws Exception {
        AirTicketsTemplateReportTicket item = new AirTicketsTemplateReportTicket();
        item.setType(AirTicketsTemplateReportTicketType.MEMO);
        SortingNumberData sortingNumberData = AirTicketsTemplateReportPrepareHandler.getSortingNumberData(product);
        item.setSortingTicketNumber(sortingNumberData.sortingNumber);
        item.setOperationBatch(sortingNumberData.batch);
        item.setValidatingCarrierNumber(product.getAirlineCode());
        item.setTicketNumber(product.getSystemNumber());
        item.setIssueDate(product.getIssueDate());
        item.setAgencyMemoProductType(product.getType());
        item.getAgencyMemoProductItemGroup().addAll(product.getItemGroups());
        HashMap<AgencyMemoProductEntryType, BigDecimal> agencyMemoProductEquivalentAmounts = new HashMap<AgencyMemoProductEntryType, BigDecimal>();
        for (AgencyMemoProductItemGroup itemGroup : product.getItemGroups()) {
            AgencyMemoProductEntryType agencyMemoProductEntryType;
            for (AgencyMemoProductEntry entry : itemGroup.getEntries()) {
                if (entry.getAssociationType() != AgencyMemoProductEntryAssociationType.PRODUCT || TextUtil.isBlank((String)entry.getRelatedProductNumber()) || item.getAgencyMemoProductRelatedTicketNumbers().contains(entry.getRelatedProductNumber().trim())) continue;
                item.getAgencyMemoProductRelatedTicketNumbers().add(entry.getRelatedProductNumber().trim());
            }
            if (itemGroup.getEquivalentAmount() == null) continue;
            BigDecimal agencyMemoProductEquivalentAmount = (BigDecimal)agencyMemoProductEquivalentAmounts.get(agencyMemoProductEntryType = itemGroup.getType());
            agencyMemoProductEquivalentAmounts.put(agencyMemoProductEntryType, agencyMemoProductEquivalentAmount != null ? agencyMemoProductEquivalentAmount.add(itemGroup.getEquivalentAmount()) : itemGroup.getEquivalentAmount());
        }
        Collections.sort(item.getAgencyMemoProductRelatedTicketNumbers());
        item.setAgencyMemoProductTariffEquivalentAmount((BigDecimal)agencyMemoProductEquivalentAmounts.get(AgencyMemoProductEntryType.TARIFF));
        item.setAgencyMemoProductTaxesCarrierEquivalentAmount((BigDecimal)agencyMemoProductEquivalentAmounts.get(AgencyMemoProductEntryType.TAX_CARRIER));
        item.setAgencyMemoProductTaxesFuelEquivalentAmount((BigDecimal)agencyMemoProductEquivalentAmounts.get(AgencyMemoProductEntryType.TAX_FUEL));
        item.setAgencyMemoProductTaxesStateEquivalentAmount((BigDecimal)agencyMemoProductEquivalentAmounts.get(AgencyMemoProductEntryType.TAX_STATE));
        item.setAgencyMemoProductTaxesOthersEquivalentAmount((BigDecimal)agencyMemoProductEquivalentAmounts.get(AgencyMemoProductEntryType.TAX_OTHERS));
        item.setAgencyMemoProductPenaltyEquivalentAmount((BigDecimal)agencyMemoProductEquivalentAmounts.get(AgencyMemoProductEntryType.PENALTY));
        item.setAgencyMemoProductContractPenaltyEquivalentAmount((BigDecimal)agencyMemoProductEquivalentAmounts.get(AgencyMemoProductEntryType.CONTRACT_PENALTY));
        item.setAgencyMemoProductCommissionEquivalentAmount((BigDecimal)agencyMemoProductEquivalentAmounts.get(AgencyMemoProductEntryType.COMMISSION));
        item.setAgencyMemoProductBonusEquivalentAmount((BigDecimal)agencyMemoProductEquivalentAmounts.get(AgencyMemoProductEntryType.BONUS));
        item.setAgencyMemoProductFeeEquivalentAmount((BigDecimal)agencyMemoProductEquivalentAmounts.get(AgencyMemoProductEntryType.FEE));
        List<Object> paymentTypes = product.getFops().stream().map(Fop::getType).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (paymentTypes.isEmpty()) {
            paymentTypes = Collections.singletonList(PaymentType.CASH);
        }
        item.getPaymentTypes().clear();
        item.getPaymentTypes().addAll(paymentTypes);
        return Collections.singletonList(item);
    }

    @Override
    protected EntityReference<AirTicketsTemplateReportDescription> getDescription(AirTicketsTemplateReportParameters params) {
        return params.getDescription();
    }

    @Override
    public MiscUtil.Pair<EntityIndex<BaseTemplateReportDocument>, String> searchForDuplicate(AirTicketsTemplateReportParameters parametersNewReport, EntityReference<AirTicketsTemplateReportDescription> reportDescription, boolean periodIntersectionDisallowed) {
        return AirTicketsTemplateReportPrepareHandler.searchForDuplicateGeneralProductsTemplateReport((BaseGeneralProductsTemplateReportParameters)parametersNewReport, reportDescription, periodIntersectionDisallowed);
    }

    @Override
    protected Product getItem(EntityContainer<BookingFile> ctr, String key) {
        for (Reservation res : ((BookingFile)ctr.getEntity()).getReservations()) {
            for (BaseProduct prod : res.getProducts()) {
                if (!(prod instanceof Product) || !key.equals(prod.getUid())) continue;
                return (Product)prod;
            }
        }
        throw Xeption.forDeveloper((String)"product with navigation key {0} not found in booking file {1}", (Object[])new Object[]{key, ctr.getUid()});
    }

    @Override
    protected void validateItem(Product item, List<Message> messages) throws Exception {
        BaseReportPrepareHandler.baseValidateProductToReport((BaseProduct)item, messages);
    }

    private static SortingNumberData getSortingNumberData(Product product) {
        ProductCategory productCategory = product.getProductCategory();
        String sortingTicketNumber = product.getSystemNumber();
        if (product.getStatus() == null) {
            return new SortingNumberData(sortingTicketNumber, OperationBatch.SELL);
        }
        switch (product.getStatus()) {
            case BOOKING: 
            case VOID: 
            case VOID_BOOKING: {
                return new SortingNumberData(sortingTicketNumber, OperationBatch.VOID);
            }
            case REFUND: {
                return new SortingNumberData(sortingTicketNumber, OperationBatch.REFUND);
            }
            case SELL: {
                if (productCategory == ProductCategory.AIR && product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE) {
                    return new SortingNumberData(sortingTicketNumber, OperationBatch.EXCHANGE);
                }
                if (productCategory == ProductCategory.MCO && (product.getMcoCategory() == MCOCategory.PENALTY || product.getMcoCategory() == MCOCategory.INFORMATION)) {
                    Product prod = AirProductHelper.findRelatedAirProduct((Product)product, null, (boolean)false);
                    if (prod != null && prod.getStatus() == ProductStatus.REFUND) {
                        sortingTicketNumber = prod.getSystemNumber();
                        return new SortingNumberData(sortingTicketNumber, OperationBatch.REFUND);
                    }
                    if (prod != null && prod.getStatus() == ProductStatus.EXCHANGE && prod.getNextProduct() != null) {
                        prod = prod.getNextProduct();
                        sortingTicketNumber = prod.getSystemNumber();
                        return new SortingNumberData(sortingTicketNumber, OperationBatch.EXCHANGE);
                    }
                }
                return new SortingNumberData(sortingTicketNumber, OperationBatch.SELL);
            }
            case EXCHANGE: {
                if (product.getNextProduct() != null && product.getNextProduct().getStatus() == ProductStatus.SELL) {
                    sortingTicketNumber = product.getNextProduct().getSystemNumber();
                }
                return new SortingNumberData(sortingTicketNumber, OperationBatch.EXCHANGE);
            }
        }
        return new SortingNumberData(sortingTicketNumber, OperationBatch.SELL);
    }

    private static SortingNumberData getSortingNumberData(AgencyMemoProduct product) {
        return new SortingNumberData(product.getSystemNumber(), OperationBatch.SELL);
    }

    private static TransportationType getTransportationType(Product product) {
        if (product.getProductCategory() == ProductCategory.AIR || product.getMcoCategory() == MCOCategory.PTA) {
            return AirTicketsTemplateReportPrepareHandler.getSimpleTransportationType(product);
        }
        return AirTicketsTemplateReportPrepareHandler.getSimpleTransportationType(AirProductHelper.findRelatedAirProduct((Product)product, null, (boolean)false));
    }

    private static TransportationType getSimpleTransportationType(Product product) {
        if (product == null) {
            return TransportationType.DOMESTIC;
        }
        TransportationType result = AirProductHelper.calculateTransportationType((Product)product);
        return result == TransportationType.COMBINED || result == TransportationType.INTERNATIONAL ? TransportationType.INTERNATIONAL : TransportationType.DOMESTIC;
    }

    private static String getTicketNumber(Product product) {
        if (product.getConjCount() == 0 || TextUtil.isBlank((String)product.getSystemNumber())) {
            return product.getSystemNumber();
        }
        ArrayList<String> ticketNumbers = new ArrayList<String>();
        ticketNumbers.add(product.getSystemNumber());
        for (int n = 0; n < product.getConjCount(); ++n) {
            try {
                ticketNumbers.add(FormattedNumberUtil.add((String)product.getSystemNumber(), (long)(n + 1)));
                continue;
            }
            catch (Exception e) {
                log.error("unable to parse ticket number " + product.getSystemNumber(), (Throwable)e);
            }
        }
        StringBuilder sb = new StringBuilder();
        for (String number : ticketNumbers) {
            if (TextUtil.isBlank((String)number)) continue;
            if (sb.length() == 0) {
                sb.append(number.trim());
                continue;
            }
            sb.append("/").append(number.trim().substring(number.trim().length() - 1));
        }
        return sb.length() > 0 ? sb.toString() : null;
    }

    private static void resetFinanceFields(AirTicketsTemplateReportTicket item) {
        item.setEquivalentFare(BigDecimal.ZERO);
        item.setTaxesSum(BigDecimal.ZERO);
        item.setPenalty(BigDecimal.ZERO);
        item.setBspCommissionPercent(BigDecimal.ZERO);
        item.setBspCommissionEquivalentAmount(BigDecimal.ZERO);
        item.setBspSubagentCommissionPercent(BigDecimal.ZERO);
        item.setBspSubagentCommissionEquivalentAmount(BigDecimal.ZERO);
        item.setRuTaxAmount(BigDecimal.ZERO);
        item.setFuelChargeAmount(BigDecimal.ZERO);
        item.setVendorCommissionRate(BigDecimal.ZERO);
    }

    private boolean hasNeighbourETicketMcoSticker(Product product) {
        boolean result = false;
        if (product.getReservation() != null) {
            String sellProductNumber = product.getSystemNumber();
            for (BaseProduct p : product.getReservation().getProducts()) {
                if (!(p instanceof Product) || !MCOCategory.STICKER.equals((Object)((Product)p).getMcoCategory()) || !((Product)p).isEticket()) continue;
                boolean mcoForThatSell = false;
                for (Product p2 : ((Product)p).getRelatedProducts()) {
                    if (!TextUtil.isSame((String)p2.getSystemNumber(), (String)sellProductNumber)) continue;
                    mcoForThatSell = true;
                    break;
                }
                if (!mcoForThatSell) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private String getEmrcCode(Product product, Segment seg, int conjIndex, String relatedTicketNumber) {
        Segment segment = this.getSegment(seg);
        BlankType blankType = (BlankType)DictionaryCache.get().resolveReference(product.getBlankType());
        if (segment.getRecordNumber() <= blankType.getCouponsCount() * conjIndex && TextUtil.isSame((String)product.getSystemNumber(), (String)relatedTicketNumber) && segment.getDepartureLocation() != null && segment.getDepartureLocation().equals((Object)segment.getDepartureLocation()) && segment.getArriveLocation() != null && segment.getArriveLocation().equals((Object)segment.getArriveLocation())) {
            return String.valueOf(segment.getRecordNumber());
        }
        return "";
    }

    private Segment getSegment(Segment segment) {
        if (segment.getDepartCityCode() == null && segment.getDepartureLocation() != null) {
            segment.setDepartCityCode(this.getCityCode(segment.getDepartureLocation().getCode()));
        }
        if (segment.getArriveCityCode() == null && segment.getArriveLocation().getCode() != null) {
            segment.setArriveCityCode(this.getCityCode(segment.getArriveLocation().getCode()));
        }
        return segment;
    }

    private String getCityCode(String airportCode) {
        GeoLocation city = DictHelper.findCityByAirport((String)airportCode);
        return city != null ? city.getCode() : null;
    }

    static final class SortingNumberData {
        final String sortingNumber;
        final OperationBatch batch;

        public SortingNumberData(String sn, OperationBatch btch) {
            this.sortingNumber = sn;
            this.batch = btch;
        }
    }
}

