/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.template.allproducts;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableName;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableNameUtil;
import com.gridnine.xtrip.common.meta.XSerializableMap;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSearchParameters;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.AgentReportParameters;
import com.gridnine.xtrip.common.reports.model.AllProductsTemplateReportDescription;
import com.gridnine.xtrip.common.reports.model.AllProductsTemplateReportDocument;
import com.gridnine.xtrip.common.reports.model.AllProductsTemplateReportParameters;
import com.gridnine.xtrip.common.reports.model.AllProductsTemplateReportTicket;
import com.gridnine.xtrip.common.reports.model.BaseGeneralProductsTemplateReportParameters;
import com.gridnine.xtrip.common.reports.model.BaseSingleFileTemplateReportDescription;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportDocument;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportParameters;
import com.gridnine.xtrip.common.reports.model.GeneralProductsTemplateReportFilteringParameters;
import com.gridnine.xtrip.common.reports.model.GeneralProductsTemplateReportPageDescription;
import com.gridnine.xtrip.common.reports.model.ReportHelper;
import com.gridnine.xtrip.common.reports.model.TemplateReportPeriodUse;
import com.gridnine.xtrip.common.reports.render.agentreport.AgentReportTicket;
import com.gridnine.xtrip.common.reports.render.template.allproducts.AllProductsTemplateReportGlobalParameter;
import com.gridnine.xtrip.common.reports.render.template.common.CommonTemplateReportHelper;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.reports.prepare.agentreports.AgentReportProductPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.agentreports.AgentReportProductPrepareHandlersRegistry;
import com.gridnine.xtrip.server.reports.prepare.template.common.BaseTemplateReportPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.template.common.TemplateReportHelper;
import com.gridnine.xtrip.server.reports.prepare.template.common.renderer.AdditionalPropertiesProvider;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class AllProductsTemplateReportPrepareHandler
extends BaseTemplateReportPrepareHandler<BaseProduct, AllProductsTemplateReportTicket, AllProductsTemplateReportParameters, AllProductsTemplateReportDescription, GeneralProductsTemplateReportPageDescription, AllProductsTemplateReportDocument> {
    @Override
    public String getId() {
        return "all-products-template-report";
    }

    @Override
    protected void setData(AllProductsTemplateReportDocument doc, AllProductsTemplateReportParameters params, Map<String, Object> data) {
        doc.setParameters(params);
    }

    @Override
    protected AllProductsTemplateReportDocument createDocument() {
        return new AllProductsTemplateReportDocument();
    }

    @Override
    protected Class<AllProductsTemplateReportTicket> getItemClass(AllProductsTemplateReportDescription description) {
        return AllProductsTemplateReportTicket.class;
    }

    @Override
    protected List<GeneralProductsTemplateReportPageDescription> getPages(AllProductsTemplateReportDescription entity) {
        return entity.getPages();
    }

    @Override
    protected Map<String, Object> getGlobalParameters(Map<String, Object> data, AllProductsTemplateReportParameters params, List<Message> messages) throws Exception {
        Map<String, Object> result = TemplateReportHelper.getGlobalParameters(params, messages);
        result.put(GeneralProductsTemplateReportFilteringParameters.AGENCY.name(), MiscUtil.toString((Object)params.getAgency()));
        result.put(GeneralProductsTemplateReportFilteringParameters.AGENT.name(), MiscUtil.toString((Object)params.getAgent()));
        result.put(GeneralProductsTemplateReportFilteringParameters.BLANK_OWNER.name(), MiscUtil.toString((Object)params.getBlankOwner()));
        result.put(GeneralProductsTemplateReportFilteringParameters.CLIENT.name(), MiscUtil.toString((Object)params.getClient()));
        result.put(GeneralProductsTemplateReportFilteringParameters.SALES_POINT.name(), MiscUtil.toString((Object)params.getSalesPoint()));
        result.put(GeneralProductsTemplateReportFilteringParameters.SUBAGENCY.name(), MiscUtil.toString((Object)params.getSubagency()));
        result.put(GeneralProductsTemplateReportFilteringParameters.SUPPLIER.name(), MiscUtil.toString((Object)params.getSupplier()));
        EntityContainer agentCtr = EntityStorage.get().resolve(params.getAgent());
        if (agentCtr != null) {
            result.put(AllProductsTemplateReportGlobalParameter.AGENT_NAME.name(), PersonalLocalizableNameUtil.buildFullName((PersonalLocalizableName)((PersonalLocalizableName)agentCtr.getEntity()), (boolean)true, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
        }
        data.get(AllProductsTemplateReportGlobalParameter.SALES_POINTS.name());
        result.put(AllProductsTemplateReportGlobalParameter.SALES_POINTS.name(), this.generateNames((Set)data.get(AllProductsTemplateReportGlobalParameter.SALES_POINTS.name())));
        return result;
    }

    private String generateNames(Set<EntityReference<SalesPoint>> actualSalesPoints) throws Exception {
        StringBuilder sb = new StringBuilder();
        for (EntityReference<SalesPoint> spRef : actualSalesPoints) {
            EntityContainer spCtr = EntityStorage.get().resolve(spRef);
            if (spCtr == null) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(ProfileHelper.getFullName((SalesPoint)((SalesPoint)spCtr.getEntity())));
        }
        return sb.toString();
    }

    @Override
    protected List<AllProductsTemplateReportTicket> createRecords(BaseProduct product, Map<String, Object> data, List<Message> messages) throws Exception {
        AgentReportProductPrepareHandler<?> handler = ((AgentReportProductPrepareHandlersRegistry)Environment.getPublished(AgentReportProductPrepareHandlersRegistry.class)).findHandler(product.getClass());
        ArrayList<AllProductsTemplateReportTicket> result = new ArrayList<AllProductsTemplateReportTicket>();
        for (AgentReportTicket item : handler.createTickets(product, data)) {
            AllProductsTemplateReportTicket ticket = new AllProductsTemplateReportTicket();
            ticket.setAirTicketNumbers(item.getAirTicketNumbers());
            ticket.setBlankOwner(item.getBlankOwner());
            ticket.setConjunction(item.isConjunction());
            ticket.setEquivalentFare(item.getEquivalentFare());
            ticket.setExchangePenaltyMCO(item.isExchangePenaltyMCO());
            ticket.setGroupName(item.getGroupName());
            ticket.setIssueDate(item.getIssueDate());
            ticket.setMcoCategory(item.getMcoCategory());
            ticket.setOtherTaxesAmount(item.getOtherTaxesAmount());
            ticket.setPayedInReportPeriod(item.isPayedInReportPeriod());
            ticket.setPenaltyAmount(item.getPenaltyAmount());
            ticket.setProductCategory(item.getProductCategory());
            ticket.setRefundPenaltyMCO(item.isRefundPenaltyMCO());
            ticket.setRefusedInReportPeriod(item.isRefusedInReportPeriod());
            ticket.setRelatedSellNumber(item.getRelatedSellNumber());
            ticket.setRemarks(item.getRemarks());
            ticket.setRouteLine(item.getRouteLine());
            ticket.setRuTaxAmount(item.getRuTaxAmount());
            ticket.setIssuedInReportPeriod(item.isIssuedInReportPeriod());
            ticket.setSellIssueDate(item.getSellIssueDate());
            ticket.setSortingTicketNumber(item.getSortingTicketNumber());
            ticket.setStatus(item.getStatus());
            ticket.setRefundReceiptMCO(item.isRefundReceiptMCO());
            ticket.setTicketNumber(item.getTicketNumber());
            ticket.setTicketSeries(item.getTicketSeries());
            ticket.setUid(item.getUid());
            this.updateFops((XSerializableMap<String, BigDecimal>)ticket.getPayedFees(), item.getFees(), true);
            this.updateFops((XSerializableMap<String, BigDecimal>)ticket.getPayedFeesForRefund(), item.getFeesForRefund(), true);
            this.updateFops((XSerializableMap<String, BigDecimal>)ticket.getPayedTotals(), item.getTotals(), true);
            this.updateFops((XSerializableMap<String, BigDecimal>)ticket.getUnpayedFees(), item.getFees(), false);
            this.updateFops((XSerializableMap<String, BigDecimal>)ticket.getUnpayedFeesForRefund(), item.getFeesForRefund(), false);
            this.updateFops((XSerializableMap<String, BigDecimal>)ticket.getUnpayedTotals(), item.getTotals(), false);
            result.add(ticket);
        }
        return result;
    }

    private void updateFops(XSerializableMap<String, BigDecimal> coll, Map<AgentReportTicket.PaymentTypeInfo, BigDecimal> fees, boolean payed) {
        for (Map.Entry<AgentReportTicket.PaymentTypeInfo, BigDecimal> item : fees.entrySet()) {
            if (item.getKey().isPayed() != payed) continue;
            coll.put((Object)item.getKey().getPaymentType().name(), (Object)item.getValue());
        }
    }

    @Override
    protected List<BaseProduct> getItems(AllProductsTemplateReportParameters params, Map<String, Object> data, List<Message> messages, EntityContainer<AllProductsTemplateReportDescription> descriptionCtr) throws Exception {
        AgentReportParameters standardParams = this.createStandardReportParameters(params, messages);
        data.put("key-report-params", standardParams);
        if (ReportHelper.isHasErrors(messages)) {
            return Collections.emptyList();
        }
        ArrayList<BaseProduct> result = new ArrayList<BaseProduct>();
        Set<String> uids = this.getFilteredProductUids(params, messages);
        HashSet<EntityReference> actualSalesPoints = new HashSet<EntityReference>();
        for (AgentReportProductPrepareHandler<BaseProduct> handler : ((AgentReportProductPrepareHandlersRegistry)Environment.getPublished(AgentReportProductPrepareHandlersRegistry.class)).getAllHandlers()) {
            AgentReportProductPrepareHandler.ProductsListProxy<BaseProduct> proxy = handler.getProducts(standardParams, messages);
            List<BaseProduct> products = this.filterProducts(proxy.getProducts(), uids);
            if (products.isEmpty()) continue;
            result.addAll(products);
            for (BaseProduct bp : products) {
                ProductHandler productHandler = HandlersRegistry.get().findProductHandler(bp.getClass());
                EntityReference sp = productHandler.findSalesPoint(bp);
                if (sp == null) continue;
                actualSalesPoints.add(sp);
            }
        }
        data.put(AllProductsTemplateReportGlobalParameter.SALES_POINTS.name(), actualSalesPoints);
        if (result.isEmpty()) {
            SystemHelper.addMessage(messages, (String)Messages.reportNoTicket, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
        }
        return result;
    }

    private List<BaseProduct> filterProducts(List<BaseProduct> products, Set<String> uids) {
        ArrayList<BaseProduct> result = new ArrayList<BaseProduct>();
        for (BaseProduct bp : products) {
            if (!uids.contains(bp.getUid())) continue;
            result.add(bp);
        }
        return result;
    }

    private Set<String> getFilteredProductUids(AllProductsTemplateReportParameters params, List<Message> messages) {
        SearchQuery query = new SearchQuery();
        EntityContainer descriptionCtr = EntityStorage.get().resolve(params.getDescription());
        query.getCriteria().getCriterions().addAll(CommonTemplateReportHelper.getModifiedCriterions((BaseTemplateReportParameters)params, (BaseSingleFileTemplateReportDescription)((BaseSingleFileTemplateReportDescription)EntityStorage.get().resolve(params.getDescription()).getEntity()), messages));
        if (((AllProductsTemplateReportDescription)descriptionCtr.getEntity()).isFilterByIssueDate()) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)CommonProductIndex.Property.issueDate.name(), (Object)MiscUtil.clearTime((Date)params.getPeriodBegin())), SearchCriterion.ge((String)CommonProductIndex.Property.dateOfVendorPayment.name(), (Object)MiscUtil.clearTime((Date)params.getPeriodBegin()))}));
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.le((String)CommonProductIndex.Property.dateOfVendorPayment.name(), (Object)MiscUtil.setDayEndTime((Date)params.getPeriodEnd())), SearchCriterion.le((String)CommonProductIndex.Property.issueDate.name(), (Object)MiscUtil.setDayEndTime((Date)params.getPeriodEnd()))}));
        } else {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)CommonProductIndex.Property.issueDate.name(), (Object)params.getPeriodBegin()), SearchCriterion.le((String)CommonProductIndex.Property.issueDate.name(), (Object)params.getPeriodEnd())}), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)CommonProductIndex.Property.dateOfClientPayment.name(), (Object)params.getPeriodBegin()), SearchCriterion.le((String)CommonProductIndex.Property.dateOfClientPayment.name(), (Object)params.getPeriodEnd())}), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ne((String)CommonProductIndex.Property.cancellationDate.name(), null), SearchCriterion.ge((String)CommonProductIndex.Property.cancellationDate.name(), (Object)params.getPeriodBegin()), SearchCriterion.le((String)CommonProductIndex.Property.cancellationDate.name(), (Object)params.getPeriodEnd())})}));
        }
        if (params.getClient() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.client.name(), (Object)params.getClient()));
        }
        if (params.getSalesPoint() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.salesPoint.name(), (Object)params.getSalesPoint()));
        }
        if (params.getSubagency() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.subagency.name(), (Object)params.getSubagency()));
        }
        if (params.getSupplier() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.supplier.name(), (Object)params.getSupplier()));
        }
        if (params.getAgency() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)CommonProductIndex.Property.agency.name(), (Object)params.getAgency()));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)CommonProductIndex.Property.ticketType.name(), (Object)TicketType.CORRECTION));
        query.getPreferredProperties().add("navigationKey");
        query.getPreferredProperties().add(CommonProductIndex.Property.systemNumbers.name());
        HashSet<String> productsUids = new HashSet<String>();
        for (CommonProductIndex idx : EntityStorage.get().search(CommonProductIndex.class, query, (EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(true)).getData()) {
            productsUids.add(idx.getNavigationKey());
        }
        return productsUids;
    }

    private AgentReportParameters createStandardReportParameters(AllProductsTemplateReportParameters params, List<Message> messages) {
        AgentReportParameters result = new AgentReportParameters();
        result.setAgency(params.getSubagency());
        result.setAgent(params.getAgent());
        Date periodBegin = params.getPeriodBegin();
        Date periodEnd = params.getPeriodEnd();
        TemplateReportPeriodUse periodUse = ((AllProductsTemplateReportDescription)EntityStorage.get().resolve(params.getDescription()).getEntity()).getPeriodUse();
        if (periodUse == null || periodUse == TemplateReportPeriodUse.DATE) {
            periodBegin = MiscUtil.clearTime((Date)periodBegin);
            periodEnd = MiscUtil.setDayEndTime((Date)periodEnd);
        }
        result.setPeriodBegin(periodBegin);
        result.setPeriodEnd(periodEnd);
        if (params.getBlankOwner() != null) {
            result.getVendors().add(params.getBlankOwner());
        }
        result.setReportId("all-products-template-report");
        return result;
    }

    @Override
    protected EntityReference<AllProductsTemplateReportDescription> getDescription(AllProductsTemplateReportParameters params) {
        return params.getDescription();
    }

    @Override
    public MiscUtil.Pair<EntityIndex<BaseTemplateReportDocument>, String> searchForDuplicate(AllProductsTemplateReportParameters parametersNewReport, EntityReference<AllProductsTemplateReportDescription> reportDescription, boolean periodIntersectionDisallowed) {
        return AllProductsTemplateReportPrepareHandler.searchForDuplicateGeneralProductsTemplateReport((BaseGeneralProductsTemplateReportParameters)parametersNewReport, reportDescription, periodIntersectionDisallowed);
    }

    @Override
    protected AdditionalPropertiesProvider<AllProductsTemplateReportTicket> getAdditionalPropertiesProvider() {
        return new AdditionalPropertiesProvider<AllProductsTemplateReportTicket>(){

            @Override
            public Map<String, Object> getAdditionalProperties(AllProductsTemplateReportTicket item) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                this.addFops(result, "totals", (Map<String, BigDecimal>)item.getPayedTotals(), true);
                this.addFops(result, "totals", (Map<String, BigDecimal>)item.getUnpayedTotals(), false);
                this.addFops(result, "fees", (Map<String, BigDecimal>)item.getPayedFees(), true);
                this.addFops(result, "fees", (Map<String, BigDecimal>)item.getUnpayedFees(), false);
                this.addFops(result, "feesForRefund", (Map<String, BigDecimal>)item.getPayedFeesForRefund(), true);
                this.addFops(result, "feesForRefund", (Map<String, BigDecimal>)item.getUnpayedFeesForRefund(), false);
                return result;
            }

            private void addFops(Map<String, Object> result, String key, Map<String, BigDecimal> fops, boolean payed) {
                String subKey = payed ? "payed" : "unpayed";
                result.put(String.format("%s.%s", key, subKey), this.calculateFopAmount(fops, null));
                for (PaymentType paymentType : PaymentType.values()) {
                    result.put(String.format("%s.%s.%s", key, subKey, paymentType.name()), this.calculateFopAmount(fops, paymentType.name()));
                }
            }

            private BigDecimal calculateFopAmount(Map<String, BigDecimal> fops, String paymentType) {
                BigDecimal result = BigDecimal.ZERO;
                for (Map.Entry<String, BigDecimal> entry : fops.entrySet()) {
                    if (entry.getValue() == null || paymentType != null && paymentType != entry.getKey()) continue;
                    result = result.add(entry.getValue());
                }
                return result;
            }
        };
    }
}

