/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.template.common;

import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.FinanceDocument;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.BaseSingleFileTemplateReportDescription;
import com.gridnine.xtrip.common.reports.model.BaseSingleFileTemplateReportDocument;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportPageDescription;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportParameters;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.reports.prepare.template.common.BaseGroupedTemplateReportPrepareHandler;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseFinanceDocumentsTemplateReportPrepareHandler<R, P extends BaseTemplateReportParameters, D extends BaseSingleFileTemplateReportDescription, F extends BaseTemplateReportPageDescription, L extends BaseSingleFileTemplateReportDocument>
extends BaseGroupedTemplateReportPrepareHandler<FinanceDocument, R, P, D, F, L, BookingFile> {
    private static final Logger log = LoggerFactory.getLogger(BaseFinanceDocumentsTemplateReportPrepareHandler.class);

    @Override
    protected void validateItem(FinanceDocument document, List<Message> messages) throws Exception {
        String number = TextUtil.buildFullNumber((CompositeNumber)document);
        if (TextUtil.isBlank((String)number)) {
            number = document.getUid();
        }
        if (TextUtil.isBlank((String)document.getNumber())) {
            SystemHelper.addMessage(messages, (String)Messages.BaseFinanceDocumentsTemplateReportPrepareHandler_documentNumberNotSpecified, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{number});
            log.error(String.format("finance document %s: number is not specified", number));
        }
        if (document.getDate() == null) {
            SystemHelper.addMessage(messages, (String)Messages.BaseFinanceDocumentsTemplateReportPrepareHandler_documentDateNotSpecified, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{number});
            log.error(String.format("finance document %s: date is not specified", number));
        }
        if (document.getType() == null) {
            SystemHelper.addMessage(messages, (String)Messages.BaseFinanceDocumentsTemplateReportPrepareHandler_documentTypeNotSpecified, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{number});
            log.error(String.format("finance document %s: type is not specified", number));
        }
        if (document.getBillingItems().isEmpty()) {
            SystemHelper.addMessage(messages, (String)Messages.BaseFinanceDocumentsTemplateReportPrepareHandler_documentBillingItemsIsEmpty, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{number});
            log.error(String.format("finance document %s: billing items is empty", number));
        }
    }
}

