/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.template.common;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.RequestedParameterValue;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.BaseGeneralProductsTemplateReportParameters;
import com.gridnine.xtrip.common.reports.model.BaseSingleFileTemplateReportDescription;
import com.gridnine.xtrip.common.reports.model.BaseSingleFileTemplateReportDocument;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportDescription;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportDocument;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportPageDescription;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.model.ReportHelper;
import com.gridnine.xtrip.common.reports.model.TemplateReportDocumentIndex;
import com.gridnine.xtrip.common.reports.model.TemplateReportPeriodUse;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.reports.prepare.ReportPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.ServerReportHelper;
import com.gridnine.xtrip.server.reports.prepare.template.common.TemplateReportHelper;
import com.gridnine.xtrip.server.reports.prepare.template.common.renderer.AdditionalPropertiesProvider;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Deprecated
public abstract class BaseTemplateReportPrepareHandler<I, R, P extends BaseTemplateReportParameters, D extends BaseSingleFileTemplateReportDescription, F extends BaseTemplateReportPageDescription, L extends BaseSingleFileTemplateReportDocument>
implements ReportPrepareHandler {
    @Override
    public void prepareData(Map<String, Object> data) throws Exception {
        Object doc;
        MiscUtil.Pair<EntityIndex<BaseTemplateReportDocument>, String> reportIndexData;
        EntityIndex reportIndex;
        boolean relaunch;
        ArrayList<Message> messages = (ArrayList<Message>)data.get("key-messages");
        if (messages == null) {
            messages = new ArrayList<Message>();
            data.put("key-messages", messages);
        }
        BaseTemplateReportParameters params = (BaseTemplateReportParameters)data.get("key-report-params");
        EntityReference<D> description = this.getDescription(params);
        EntityContainer descriptionCtr = EntityStorage.get().resolve(description);
        boolean bl = relaunch = data.get("KEY_REPORT_DOCUMENT") != null;
        if (!relaunch && ((BaseSingleFileTemplateReportDescription)descriptionCtr.getEntity()).isDuplicateDisallowed() && (reportIndex = (EntityIndex)(reportIndexData = this.searchForDuplicate(params, descriptionCtr.toReference(), ((BaseSingleFileTemplateReportDescription)descriptionCtr.getEntity()).isPeriodIntersectionDisallowed())).getFirst()) != null) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.AllProductsTemplateReportPrepareHandler_reportDuplicate, (Object[])new Object[]{reportIndexData.getSecond()}));
            return;
        }
        this.checkParams(params, descriptionCtr, messages);
        if (ReportHelper.isHasErrors(messages)) {
            return;
        }
        if (ServerReportHelper.isToBeStopped(data)) {
            return;
        }
        ServerReportHelper.getCallback(data).updateProgress((byte)10, "\u043f\u043e\u043b\u0443\u0447\u0430\u0435\u043c \u0434\u0430\u043d\u043d\u044b\u0435 \u0438\u0437 \u0431\u0430\u0437\u044b");
        List<I> items = this.getItems(params, data, messages, descriptionCtr);
        if (ReportHelper.isHasErrors(messages)) {
            return;
        }
        if (ServerReportHelper.isToBeStopped(data)) {
            return;
        }
        ServerReportHelper.getCallback(data).updateProgress((byte)51, "\u0432\u0430\u043b\u0438\u0434\u0438\u0440\u0443\u0435\u043c \u0434\u0430\u043d\u043d\u044b\u0435");
        this.validateItems(items, messages);
        if (ReportHelper.isHasErrors(messages)) {
            return;
        }
        if (ServerReportHelper.isToBeStopped(data)) {
            return;
        }
        ServerReportHelper.getCallback(data).updateProgress((byte)52, "\u0433\u043e\u0442\u043e\u0432\u0438\u043c \u0434\u0430\u043d\u043d\u044b\u0435 \u0434\u043b\u044f \u043e\u0442\u0447\u0435\u0442\u0430");
        ArrayList<R> tickets = new ArrayList<R>();
        for (Object product : items) {
            tickets.addAll(this.createRecords(product, data, messages));
        }
        tickets.addAll(this.createAdditionalRecords(params, data, messages));
        if (tickets.isEmpty() && !((BaseSingleFileTemplateReportDescription)descriptionCtr.getEntity()).isAllowEmpty()) {
            SystemHelper.addMessage(messages, (String)Messages.reportNoTicket, null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            return;
        }
        if (ReportHelper.isHasErrors(messages)) {
            return;
        }
        if (ServerReportHelper.isToBeStopped(data)) {
            return;
        }
        ServerReportHelper.getCallback(data).updateProgress((byte)55, "\u0437\u0430\u043f\u043e\u043b\u043d\u044f\u0435\u043c \u043e\u0442\u0447\u0435\u0442");
        Map<String, Object> globalParameters = this.getGlobalParameters(data, params, messages);
        globalParameters.put("KEY_PREPARE_REPORT_CALLBACK", ServerReportHelper.getCallback(data));
        byte[] content = TemplateReportHelper.createReport(globalParameters, (BaseSingleFileTemplateReportDescription)descriptionCtr.getEntity(), this.getPages((BaseSingleFileTemplateReportDescription)descriptionCtr.getEntity()), tickets, this.getAdditionalPropertiesProvider(), this.getItemClass((BaseSingleFileTemplateReportDescription)descriptionCtr.getEntity()), messages, ((BaseSingleFileTemplateReportDescription)descriptionCtr.getEntity()).isAllowEmpty());
        if (ReportHelper.isHasErrors(messages)) {
            return;
        }
        EntityContainer ctr = (EntityContainer)data.get("KEY_REPORT_DOCUMENT");
        try {
            doc = (BaseSingleFileTemplateReportDocument)ctr.getEntity();
        }
        catch (Exception e) {
            doc = this.createDocument();
            ctr = EntityContainer.create((BaseEntity)doc);
        }
        Date date = new Date();
        ctr.setCreated(date);
        doc.setCreated(date);
        doc.setReportType(((BaseSingleFileTemplateReportDescription)descriptionCtr.getEntity()).getReportType());
        this.setData(doc, params, data);
        doc.getMessages().addAll(messages);
        ReportFile file = new ReportFile();
        ContentType contentType = ((BaseSingleFileTemplateReportDescription)descriptionCtr.getEntity()).getContentType();
        if (contentType == null) {
            contentType = ContentType.JASPERPRINT;
        }
        file.setContentType(contentType);
        file.setContent(content);
        file.setName(this.getFileName(contentType, params, this.getDescription(params), ((BaseSingleFileTemplateReportDescription)descriptionCtr.getEntity()).getFileNameScript()));
        file.setTitle(this.getReportTitle(params, this.getDescription(params), ((BaseSingleFileTemplateReportDescription)descriptionCtr.getEntity()).getFileNameScript()));
        doc.setFile(file);
        data.put("KEY_REPORT_DOCUMENT", ctr);
        ServerReportHelper.getCallback(data).updateProgress((byte)100, "\u043e\u0442\u0447\u0435\u0442 \u043f\u043e\u0434\u0433\u043e\u0442\u043e\u0432\u043b\u0435\u043d, \u043f\u0435\u0440\u0435\u0434\u0430\u0435\u043c \u0434\u0430\u043d\u043d\u044b\u0435");
    }

    protected String getFileName(ContentType contentType, P parameters, EntityReference<D> description, String fileNameScript) {
        return TemplateReportHelper.getFileName(contentType, parameters, this.getDescription(parameters), fileNameScript);
    }

    protected String getReportTitle(P parameters, EntityReference<D> description, String fileNameScript) {
        return TemplateReportHelper.getReportTitle(parameters, this.getDescription(parameters), fileNameScript);
    }

    protected List<R> createAdditionalRecords(P params, Map<String, Object> data, List<Message> messages) throws Exception {
        return Collections.emptyList();
    }

    protected abstract void setData(L var1, P var2, Map<String, Object> var3);

    protected abstract L createDocument();

    protected AdditionalPropertiesProvider<R> getAdditionalPropertiesProvider() {
        return new AdditionalPropertiesProvider<R>(){

            @Override
            public Map<String, Object> getAdditionalProperties(R item) {
                return Collections.emptyMap();
            }
        };
    }

    protected abstract Class<R> getItemClass(D var1);

    protected abstract List<F> getPages(D var1);

    protected abstract Map<String, Object> getGlobalParameters(Map<String, Object> var1, P var2, List<Message> var3) throws Exception;

    protected abstract List<R> createRecords(I var1, Map<String, Object> var2, List<Message> var3) throws Exception;

    protected void validateItems(Collection<I> items, List<Message> messages) throws Exception {
    }

    protected abstract List<I> getItems(P var1, Map<String, Object> var2, List<Message> var3, EntityContainer<D> var4) throws Exception;

    protected abstract EntityReference<D> getDescription(P var1);

    protected void checkParams(P params, EntityContainer<D> descriptionCtr, List<Message> messages) {
        if (descriptionCtr == null) {
            throw new IllegalStateException(L10nResourcesManager.getStr((String)Messages.AirTicketsTemplateReportPrepareHandler_reportNoTemptale, (Object[])new Object[0]));
        }
        TemplateReportPeriodUse periodUse = ((BaseSingleFileTemplateReportDescription)descriptionCtr.getEntity()).getPeriodUse();
        if (periodUse != TemplateReportPeriodUse.IGNORE) {
            if (params.getPeriodBegin() == null) {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.AllProductsTemplateReportPrepareHandler_reportPramsNoPeriodStart, (Object[])new Object[0]));
            }
            if (params.getPeriodEnd() == null) {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.AllProductsTemplateReportPrepareHandler_reportPramsNoPeriodEnd, (Object[])new Object[0]));
            }
            this.checkReportPeriod(descriptionCtr, params);
        }
    }

    private void checkReportPeriod(EntityContainer<D> descriptionCtr, P parameters) {
        if (((BaseSingleFileTemplateReportDescription)descriptionCtr.getEntity()).getPeriodUse() == TemplateReportPeriodUse.IGNORE || ((BaseSingleFileTemplateReportDescription)descriptionCtr.getEntity()).getMaxPeriodInDays() == null) {
            return;
        }
        if (parameters.getPeriodBegin() != null) {
            Date periodEndValue = MiscUtil.setDayEndTime((Date)parameters.getPeriodEnd());
            if (periodEndValue == null) {
                periodEndValue = MiscUtil.setDayEndTime((Date)new Date());
            }
            Date periodBeginValue = MiscUtil.clearTime((Date)parameters.getPeriodBegin());
            if ((long)(((BaseSingleFileTemplateReportDescription)descriptionCtr.getEntity()).getMaxPeriodInDays() * 1000) * 3600L * 24L >= periodEndValue.getTime() - periodBeginValue.getTime()) {
                return;
            }
        }
        throw Xeption.forEndUser((String)Messages.TemplateReportHelper_maxPeriodExceeded, (Object[])new Object[]{((BaseSingleFileTemplateReportDescription)descriptionCtr.getEntity()).getMaxPeriodInDays()});
    }

    public abstract MiscUtil.Pair<EntityIndex<BaseTemplateReportDocument>, String> searchForDuplicate(P var1, EntityReference<D> var2, boolean var3);

    protected static void addPeriodCriterions(SearchQuery query, String dateName1, String dateName2, Date d1, Date d2, boolean periodIntersectionDisallowed) {
        if (!periodIntersectionDisallowed) {
            if (d1 != null) {
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)dateName1, (Object)d1));
            }
            if (d2 != null) {
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)dateName2, (Object)d2));
            }
        } else if (d1 != null && d2 != null) {
            SearchCriterion leftEndNull = SearchCriterion.eq((String)dateName1, null);
            SearchCriterion rightEndNull = SearchCriterion.eq((String)dateName2, null);
            SearchCriterion leftEndNotNull = SearchCriterion.ne((String)dateName1, null);
            SearchCriterion rightEndNotNull = SearchCriterion.ne((String)dateName2, null);
            SearchCriterion sc1 = SearchCriterion.le((String)dateName1, (Object)d1);
            SearchCriterion sc2 = SearchCriterion.ge((String)dateName2, (Object)d1);
            SearchCriterion sc3 = SearchCriterion.le((String)dateName1, (Object)d2);
            SearchCriterion sc4 = SearchCriterion.ge((String)dateName2, (Object)d2);
            SearchCriterion sc5 = SearchCriterion.ge((String)dateName1, (Object)d1);
            SearchCriterion sc6 = SearchCriterion.le((String)dateName2, (Object)d2);
            SearchCriterion bothEndNullCase = SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{leftEndNull, rightEndNull});
            SearchCriterion leftEndNullCase = SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{leftEndNull, sc2});
            SearchCriterion rightEndNullCase = SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{rightEndNull, sc3});
            SearchCriterion endsNotNullCase = SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{leftEndNotNull, rightEndNotNull, SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{sc1, sc2}), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{sc3, sc4}), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{sc5, sc6})})});
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{bothEndNullCase, leftEndNullCase, rightEndNullCase, endsNotNullCase}));
        } else if (d1 != null) {
            SearchCriterion sc1 = SearchCriterion.ne((String)dateName2, null);
            SearchCriterion sc2 = SearchCriterion.ge((String)dateName2, (Object)d1);
            SearchCriterion sc3 = SearchCriterion.eq((String)dateName2, null);
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{sc1, sc2}), sc3}));
        } else if (d2 != null) {
            SearchCriterion sc1 = SearchCriterion.ne((String)dateName1, null);
            SearchCriterion sc2 = SearchCriterion.le((String)dateName1, (Object)d2);
            SearchCriterion sc3 = SearchCriterion.eq((String)dateName1, null);
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{sc1, sc2}), sc3}));
        }
    }

    protected static MiscUtil.Pair<EntityIndex<BaseTemplateReportDocument>, String> searchForDuplicateGeneralProductsTemplateReport(BaseGeneralProductsTemplateReportParameters parametersNewReport, EntityReference<? extends BaseTemplateReportDescription> reportDescription, boolean periodIntersectionDisallowed) {
        MiscUtil.Pair res = new MiscUtil.Pair(null, null);
        SearchQuery query = BaseTemplateReportPrepareHandler.createBaseSearchQuery((BaseTemplateReportParameters)parametersNewReport, reportDescription, periodIntersectionDisallowed);
        if (parametersNewReport.getAgent() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TemplateReportDocumentIndex.Property.agent.name(), (Object)parametersNewReport.getAgent()));
        }
        if (parametersNewReport.getClient() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TemplateReportDocumentIndex.Property.client.name(), (Object)parametersNewReport.getClient()));
        }
        if (parametersNewReport.getSalesPoint() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TemplateReportDocumentIndex.Property.salesPoint.name(), (Object)parametersNewReport.getSalesPoint()));
        }
        if (parametersNewReport.getSubagency() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TemplateReportDocumentIndex.Property.subagency.name(), (Object)parametersNewReport.getSubagency()));
        }
        if (parametersNewReport.getSupplier() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TemplateReportDocumentIndex.Property.supplier.name(), (Object)parametersNewReport.getSupplier()));
        }
        List docsInd = EntityStorage.get().search(TemplateReportDocumentIndex.class, query).getData();
        for (TemplateReportDocumentIndex ind : docsInd) {
            EntityContainer repCont = EntityStorage.get().resolve(ind.getSource());
            if (repCont == null || repCont.getEntity() == null) continue;
            BaseTemplateReportDocument repDoc = (BaseTemplateReportDocument)repCont.getEntity();
            BaseTemplateReportParameters parametersFoundReport = null;
            Method getParametersMethod = null;
            try {
                getParametersMethod = repDoc.getClass().getMethod("getParameters", new Class[0]);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (getParametersMethod != null) {
                try {
                    parametersFoundReport = (BaseTemplateReportParameters)getParametersMethod.invoke((Object)repDoc, new Object[0]);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
            boolean hasEqualParams = false;
            if (parametersFoundReport == null || !(parametersFoundReport instanceof BaseGeneralProductsTemplateReportParameters) || !(hasEqualParams = BaseTemplateReportPrepareHandler.compareGeneralProductsParams((BaseGeneralProductsTemplateReportParameters)parametersFoundReport, parametersNewReport))) continue;
            res.setFirst((Object)ind);
            res.setSecond((Object)ind.getTitle());
            return res;
        }
        return res;
    }

    protected static SearchQuery createBaseSearchQuery(BaseTemplateReportParameters params, EntityReference<? extends BaseTemplateReportDescription> reportDescription, boolean periodIntersectionDisallowed) {
        SearchQuery query = new SearchQuery();
        BaseTemplateReportPrepareHandler.addPeriodCriterions(query, TemplateReportDocumentIndex.Property.periodBegin.name(), TemplateReportDocumentIndex.Property.periodEnd.name(), params.getPeriodBegin(), params.getPeriodEnd(), periodIntersectionDisallowed);
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TemplateReportDocumentIndex.Property.description.name(), reportDescription));
        if (params.getAgency() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TemplateReportDocumentIndex.Property.agency.name(), (Object)params.getAgency()));
        }
        return query;
    }

    protected static boolean compareGeneralProductsParams(BaseGeneralProductsTemplateReportParameters p1, BaseGeneralProductsTemplateReportParameters p2) {
        boolean equalAgency = p1.getAgency() == null && p2.getAgency() == null || p1.getAgency() != null && p1.getAgency().equals((Object)p2.getAgency());
        boolean equalAgent = p1.getAgent() == null && p2.getAgent() == null || p1.getAgent() != null && p1.getAgent().equals((Object)p2.getAgent());
        boolean equalBlankOwner = p1.getBlankOwner() == null && p2.getBlankOwner() == null || p1.getBlankOwner() != null && p1.getBlankOwner().equals((Object)p2.getBlankOwner());
        boolean equalClient = p1.getClient() == null && p2.getClient() == null || p1.getClient() != null && p1.getClient().equals((Object)p2.getClient());
        boolean equalSalesPoint = p1.getSalesPoint() == null && p2.getSalesPoint() == null || p1.getSalesPoint() != null && p1.getSalesPoint().equals((Object)p2.getSalesPoint());
        boolean equalSubagency = p1.getSubagency() == null && p2.getSubagency() == null || p1.getSubagency() != null && p1.getSubagency().equals((Object)p2.getSubagency());
        boolean equalSupplier = p1.getSupplier() == null && p2.getSupplier() == null || p1.getSupplier() != null && p1.getSupplier().equals((Object)p2.getSupplier());
        boolean equalAdditionalCriterions = BaseTemplateReportPrepareHandler.compareAdditionalCriterions(p1.getAdditionalCriterions(), p2.getAdditionalCriterions());
        boolean equalRequestedParam = BaseTemplateReportPrepareHandler.compareRequestedParams(p1.getRequestedParameters(), p2.getRequestedParameters());
        return equalAgency && equalAgent && equalBlankOwner && equalClient && equalSalesPoint && equalSubagency && equalSupplier && equalAdditionalCriterions && equalRequestedParam;
    }

    protected static boolean compareAdditionalCriterions(Set<SearchCriterion> set1, Set<SearchCriterion> set2) {
        boolean equals;
        block2: {
            SearchCriterion sc;
            equals = true;
            Iterator<SearchCriterion> iterator = set1.iterator();
            while (iterator.hasNext() && (equals = (sc = iterator.next()) != null && set2.contains(sc))) {
            }
            if (!equals) break block2;
            iterator = set2.iterator();
            while (iterator.hasNext() && (equals = (sc = iterator.next()) != null && set1.contains(sc))) {
            }
        }
        return equals;
    }

    protected static boolean compareRequestedParams(List<RequestedParameterValue> list1, List<RequestedParameterValue> list2) {
        Object value;
        String key;
        boolean equalRequestedParam = true;
        HashMap<String, Object> m1 = new HashMap<String, Object>();
        HashMap<String, Object> m2 = new HashMap<String, Object>();
        for (RequestedParameterValue requestedParameterValue : list1) {
            if (TextUtil.isBlank((String)requestedParameterValue.getKey())) continue;
            m1.put(requestedParameterValue.getKey(), requestedParameterValue.getValue());
        }
        for (RequestedParameterValue requestedParameterValue : list2) {
            if (TextUtil.isBlank((String)requestedParameterValue.getKey())) continue;
            m2.put(requestedParameterValue.getKey(), requestedParameterValue.getValue());
        }
        for (Map.Entry entry : m1.entrySet()) {
            key = (String)entry.getKey();
            value = entry.getValue();
            equalRequestedParam = value == null && m2.get(key) == null || value != null && value.equals(m2.get(key));
            if (equalRequestedParam) continue;
            break;
        }
        if (equalRequestedParam) {
            for (Map.Entry entry : m2.entrySet()) {
                key = (String)entry.getKey();
                value = entry.getValue();
                equalRequestedParam = m1.get(key) == null && value == null || m1.get(key) != null && m1.get(key).equals(value);
                if (equalRequestedParam) continue;
                break;
            }
        }
        return equalRequestedParam;
    }
}

