/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.template.common;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableName;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableNameUtil;
import com.gridnine.xtrip.common.meta.BaseType;
import com.gridnine.xtrip.common.meta.EntityCollection;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.IndexCollection;
import com.gridnine.xtrip.common.meta.IndexProperty;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.meta.Property;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSearchParameters;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.ContractCustomerIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.RequestedParameterValue;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.BaseGeneralProductsTemplateReportParameters;
import com.gridnine.xtrip.common.reports.model.BaseSingleFileTemplateReportDescription;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportDescription;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportPageDescription;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportHelper;
import com.gridnine.xtrip.common.reports.model.TemplateReportPageCustomParameterValue;
import com.gridnine.xtrip.common.reports.model.TemplateReportPeriodUse;
import com.gridnine.xtrip.common.reports.render.template.common.CommonTemplateReportGlobalParameter;
import com.gridnine.xtrip.common.reports.render.template.common.QueryBuilder;
import com.gridnine.xtrip.common.reports.render.template.common.TemplateReportFieldType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.search.utils.QueryComparisonHelper;
import com.gridnine.xtrip.common.system.model.SortOrderData;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.ReflectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.reports.prepare.BaseReportPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.template.common.renderer.AdditionalPropertiesProvider;
import com.gridnine.xtrip.server.reports.prepare.template.common.renderer.TemplateReportRenderer;
import com.gridnine.xtrip.server.reports.prepare.template.common.renderer.dbf.DbfTemplateReportRenderer;
import com.gridnine.xtrip.server.reports.prepare.template.common.renderer.excel.Excel2007TemplateReportRenderer;
import com.gridnine.xtrip.server.reports.prepare.template.common.renderer.excel.ExcelTemplateReportRenderer;
import com.gridnine.xtrip.server.reports.prepare.template.common.renderer.jasper.JasperTemplateReportRenderer;
import com.gridnine.xtrip.server.reports.prepare.template.common.renderer.xml.XmlTemplateReportRenderer;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyShell;
import java.io.File;
import java.math.BigDecimal;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.runtime.MethodClosure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TemplateReportHelper {
    private static final String SHORT_REPORT_PARAMS_KEY = "params";
    private static final String FOLDER_NAME = "/tmp/";
    private static final Logger logger = LoggerFactory.getLogger((String)"template-report");
    private static Map<ContentType, TemplateReportRenderer<?>> renderers = new HashMap();

    private static <T, D extends BaseTemplateReportPageDescription> List<T> filterTickets(List<SearchCriterion> pageCriterions, List<T> tickets, final Class<T> cls, List<Message> messages) {
        final BaseType type = TemplateReportHelper.getType(cls);
        QueryComparisonHelper.FieldValuesProvider provider = new QueryComparisonHelper.FieldValuesProvider<T>(){

            public Class<?> getFieldClass(String property) {
                return TemplateReportHelper.getFieldType(type, property).getQueryType();
            }

            public Object getFieldValue(T object, String property) {
                return TemplateReportHelper.getFieldType(type, property).getQueryValue(ReflectionUtil.getValue((Class)cls, object, (String)property));
            }
        };
        ArrayList<T> result = new ArrayList<T>();
        for (T ticket : tickets) {
            if (!QueryComparisonHelper.matchCriterions(ticket, pageCriterions, (QueryComparisonHelper.FieldValuesProvider)provider)) continue;
            result.add(ticket);
        }
        return result;
    }

    public static BaseType getType(Class<?> cls) {
        EntityType entityType = (EntityType)MetaRegistry.get().getEntities().get(cls.getName());
        if (entityType != null) {
            return entityType;
        }
        IndexType indexType = (IndexType)MetaRegistry.get().getIndexes().get(cls.getName());
        if (indexType != null) {
            return indexType;
        }
        throw new IllegalArgumentException("unsupported type " + cls);
    }

    public static TemplateReportFieldType getFieldType(BaseType type, String propertyName) {
        if (type instanceof EntityType) {
            Property property = (Property)((EntityType)type).getProperties().get(propertyName);
            if (property != null) {
                return TemplateReportHelper.getFieldType(property);
            }
            EntityCollection coll = (EntityCollection)((EntityType)type).getCollections().get(propertyName);
            if (coll != null) {
                return TemplateReportHelper.getType(coll.getType());
            }
            throw new IllegalArgumentException(String.format("property or collection %s does not exist in type %s", propertyName, type.getId()));
        }
        IndexProperty property = (IndexProperty)((IndexType)type).getProperties().get(propertyName);
        if (property != null) {
            return TemplateReportHelper.getFieldType(property);
        }
        IndexCollection coll = (IndexCollection)((IndexType)type).getCollections().get(propertyName);
        if (coll != null) {
            return TemplateReportHelper.getType(coll.getType());
        }
        throw new IllegalArgumentException(String.format("property or collection %s does not exist in type %s", propertyName, type.getId()));
    }

    static TemplateReportFieldType getFieldType(Property property) {
        return TemplateReportHelper.getType(property.getType());
    }

    private static TemplateReportFieldType getType(String type) {
        if (type.contains("String") || type.equals("text")) {
            return TemplateReportFieldType.STRING;
        }
        if (BigDecimal.class.getName().equals(type)) {
            return TemplateReportFieldType.BIG_DECIMAL;
        }
        if (type.toLowerCase().contains("boolean")) {
            return TemplateReportFieldType.BOOLEAN;
        }
        if (Integer.class.getName().equals(type) || "int".equals(type)) {
            return TemplateReportFieldType.INTEGER;
        }
        if (Date.class.getName().equals(type)) {
            return TemplateReportFieldType.DATE;
        }
        if (Double.class.getName().equals(type) || "double".equals(type)) {
            return TemplateReportFieldType.DOUBLE;
        }
        MetaRegistry mr = MetaRegistry.get();
        if (mr.getDictionaries().containsKey(type)) {
            return TemplateReportFieldType.DICT_REFERENCE;
        }
        if (mr.getEntities().containsKey(type)) {
            return TemplateReportFieldType.ENTITY_REFERENCE;
        }
        if (mr.getEnums().containsKey(type)) {
            return TemplateReportFieldType.ENUM;
        }
        if (HashSet.class.getName().equals(type) || LinkedHashSet.class.getName().equals(type) || Set.class.getName().equals(type)) {
            return TemplateReportFieldType.SET;
        }
        if (ArrayList.class.getName().equals(type) || ArrayList.class.getName().equals(type) || List.class.getName().equals(type)) {
            return TemplateReportFieldType.LIST;
        }
        throw new IllegalArgumentException("unsupported type " + type);
    }

    static TemplateReportFieldType getFieldType(IndexProperty property) {
        return TemplateReportHelper.getType(property.getType());
    }

    private static <T, D extends BaseTemplateReportPageDescription> void sortTickets(List<T> filteredTickets, final List<SortOrderData> sortOrders, D pageDescription, Map<String, Object> globalParameters, final Class<T> cls, List<Message> messages) throws Exception {
        if (pageDescription.getSortOrderScript() != null && !pageDescription.getSortOrderScript().isEmpty()) {
            TemplateReportHelper.sortWithScript(filteredTickets, pageDescription.getSortOrderScript(), globalParameters);
            return;
        }
        final BaseType type = TemplateReportHelper.getType(cls);
        Collections.sort(filteredTickets, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                for (SortOrderData order : sortOrders) {
                    Object value1 = TemplateReportHelper.getFieldType(type, order.getPropertyName()).getQueryValue(ReflectionUtil.getValue((Class)cls, o1, (String)order.getPropertyName()));
                    Object value2 = TemplateReportHelper.getFieldType(type, order.getPropertyName()).getQueryValue(ReflectionUtil.getValue((Class)cls, o2, (String)order.getPropertyName()));
                    int res = 0;
                    if (value1 == null) {
                        res = value2 == null ? 0 : -1;
                    } else if (value2 == null) {
                        res = 1;
                    } else if (value1 instanceof Comparable && value2 instanceof Comparable) {
                        res = ((Comparable)value1).compareTo(value2);
                    }
                    if (res == 0) continue;
                    return order.getOrder() == SortOrder.ASC ? res : -res;
                }
                return 0;
            }
        });
    }

    private static <T> void sortWithScript(List<T> filteredTickets, String script, Map<String, Object> globalParameters) throws Exception {
        Binding binding = new Binding();
        GroovyShell shell = new GroovyShell(binding);
        binding.setVariable("tickets", filteredTickets);
        for (Map.Entry<String, Object> item : globalParameters.entrySet()) {
            if (item.getKey() == null) continue;
            binding.setProperty(item.getKey(), item.getValue());
        }
        shell.evaluate(String.format(IoUtil.readFileToString((File)IoUtil.url2file((URL)TemplateReportHelper.class.getResource("sorting-script.groovy.template"))), script));
    }

    public static <T, RD extends BaseSingleFileTemplateReportDescription, P extends BaseTemplateReportPageDescription> byte[] createReport(Map<String, Object> globalParameters, RD description, List<P> pages, List<T> items, AdditionalPropertiesProvider<T> descProv, Class<T> itemCls, List<Message> messages, boolean allowEmpty) throws Exception {
        TemplateReportRenderer<?> renderer = renderers.get(description.getContentType() == null ? ContentType.JASPERPRINT : description.getContentType());
        Object result = null;
        boolean firstPage = true;
        for (BaseTemplateReportPageDescription pageDescription : pages) {
            Date iterationTime = new Date();
            logger.info(String.format("Page %s iteration started", pageDescription.getName()));
            List<T> filteredTickets = TemplateReportHelper.filterTickets(pageDescription.getPageCriterions(), items, itemCls, messages);
            TemplateReportHelper.sortTickets(filteredTickets, pageDescription.getSortOrders(), pageDescription, globalParameters, itemCls, messages);
            HashMap<String, Object> parameters = new HashMap<String, Object>(globalParameters);
            parameters.put("allow-empty-report", allowEmpty);
            for (TemplateReportPageCustomParameterValue parameter : pageDescription.getCustomParameters()) {
                parameters.put(parameter.getKey(), parameter.getValue());
            }
            if (firstPage) {
                result = renderer.createEmptyReport(description);
                firstPage = false;
            }
            logger.info(String.format("Page %s render started", pageDescription.getName()));
            result = renderer.addPage(result, pageDescription.getTemplate().getContent().getData(), filteredTickets, parameters, itemCls, descProv, messages);
            byte[] reportContent = (byte[])parameters.get("report-content");
            logger.info(String.format("Page %s iteration ended. Total ms: %s", pageDescription.getName(), new Date().getTime() - iterationTime.getTime()));
            if (reportContent == null) continue;
            return reportContent;
        }
        if (result == null) {
            return null;
        }
        return renderer.getData(result);
    }

    public static <P extends BaseTemplateReportParameters, D extends BaseTemplateReportDescription> String getReportTitle(P params, EntityReference<D> descriptionRef, String fileNameScript) {
        SimpleDateFormat frmt;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdfWithTime = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String fileName = null;
        if (!TextUtil.isBlank((String)fileNameScript)) {
            fileName = TemplateReportHelper.getFileNameFromScript(params, fileNameScript);
        }
        String res = "";
        SimpleDateFormat simpleDateFormat = frmt = ((BaseTemplateReportDescription)EntityStorage.get().resolve(descriptionRef).getEntity()).getPeriodUse() == TemplateReportPeriodUse.DATE_TIME ? sdfWithTime : sdf;
        res = !TextUtil.isBlank((String)fileName) ? fileName : L10nResourcesManager.createL10nMessage((String)Messages.TemplateReportHelper_overPeriod, (Object[])new Object[]{descriptionRef, params.getPeriodBegin() != null ? frmt.format(params.getPeriodBegin()) : "?", params.getPeriodEnd() != null ? frmt.format(params.getPeriodEnd()) : "?"}).toString();
        return res;
    }

    public static <P extends BaseTemplateReportParameters, D extends BaseTemplateReportDescription> String getFileName(ContentType contentType, P params, EntityReference<D> descriptionRef, String fileNameScript) {
        String res = "";
        String extension = TemplateReportHelper.getExtension(contentType);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = null;
        if (!TextUtil.isBlank((String)fileNameScript)) {
            fileName = TemplateReportHelper.getFileNameFromScript(params, fileNameScript);
        }
        res = !TextUtil.isBlank(fileName) ? ReportHelper.cleanUpFileName((String)String.format("%s.%s", fileName, extension)) : ReportHelper.cleanUpFileName((String)String.format("%s%s-%s.%s", descriptionRef, params.getPeriodBegin() != null ? sdf.format(params.getPeriodBegin()) : "?", params.getPeriodEnd() != null ? sdf.format(params.getPeriodEnd()) : "?", extension));
        if (FOLDER_NAME.length() + res.length() > 255) {
            res = TemplateReportHelper.reducingFileNameByCountChars(res, FOLDER_NAME, extension);
        }
        if (res.getBytes().length + FOLDER_NAME.getBytes().length > 255) {
            res = TemplateReportHelper.reducingFileNameByCountBytes(res, FOLDER_NAME.getBytes().length);
        }
        return res;
    }

    private static String reducingFileNameByCountChars(String fileName, String folderName, String extension) {
        return fileName.length() > 255 ? fileName.substring(0, 254 - extension.length() - folderName.length()) + "." + extension : fileName;
    }

    private static String reducingFileNameByCountBytes(String fileName, int bytesOfFolderName) {
        int size = fileName.getBytes().length + bytesOfFolderName;
        while (size > 255) {
            int lastDotPosition = fileName.lastIndexOf(".");
            String mainPart = fileName.substring(0, lastDotPosition);
            String extensionPart = fileName.substring(lastDotPosition);
            int countCharsForDelete = (size - 255) / 2 + 1;
            fileName = mainPart.substring(0, mainPart.length() - countCharsForDelete) + extensionPart;
            size = fileName.getBytes().length + bytesOfFolderName;
        }
        return fileName;
    }

    public static <P extends BaseTemplateReportParameters> String getFileNameFromScript(P params, String script) {
        Binding binding = new Binding();
        GroovyShell shell = new GroovyShell(binding);
        QueryBuilder builder = new QueryBuilder();
        ArrayList<Message> messages = new ArrayList<Message>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String periodName = String.format("%s-%s", params.getPeriodBegin() != null ? sdf.format(params.getPeriodBegin()) : "?", params.getPeriodEnd() != null ? sdf.format(params.getPeriodEnd()) : "?");
        binding.setProperty("periodName", (Object)periodName);
        binding.setProperty("query", (Object)new MethodClosure((Object)new QueryClosure(builder), "doAction"));
        binding.setProperty("error", (Object)new MethodClosure((Object)new ErrorClosure(messages), "doAction"));
        binding.setProperty("parameters", params);
        Object resObj = shell.evaluate(script);
        String res = "";
        if (resObj != null) {
            res = resObj.toString();
        }
        return res;
    }

    public static String getExtension(ContentType contentType) {
        switch (contentType) {
            case JASPERPRINT: {
                return "jrprint";
            }
            case EXCEL: {
                return "xls";
            }
            case EXCEL_2007: {
                return "xlsx";
            }
            case XML: {
                return "xml";
            }
            case DBF: {
                return "dbf";
            }
            case HTML: {
                return "html";
            }
            case PDF: {
                return "pdf";
            }
            case JPEG: {
                return "jpg";
            }
            case GIF: {
                return "gif";
            }
            case PNG: {
                return "png";
            }
            case WORD_2007: {
                return "docx";
            }
            case WORD: {
                return "doc";
            }
            case TEXT: {
                return "txt";
            }
        }
        return "txt";
    }

    public static <P extends BaseTemplateReportParameters> Map<String, Object> getGlobalParameters(P params, List<Message> messages) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (RequestedParameterValue item : params.getRequestedParameters()) {
            if (item.getKey() == null) continue;
            result.put(item.getKey(), item.getValue());
        }
        result.put("key-report-params", params);
        result.put(SHORT_REPORT_PARAMS_KEY, params);
        BaseReportPrepareHandler.putStandardReportParameters(params.getPeriodBegin(), params.getPeriodEnd(), result, messages);
        result.put(CommonTemplateReportGlobalParameter.REPORT_DATE.name(), new SimpleDateFormat("dd.MM.yyyy hh:mm:ss").format(new Date()));
        if (params instanceof BaseGeneralProductsTemplateReportParameters) {
            BaseGeneralProductsTemplateReportParameters gpParams = (BaseGeneralProductsTemplateReportParameters)params;
            if (gpParams.getAgent() != null) {
                EntityContainer ctr = EntityStorage.get().resolve(gpParams.getAgent());
                if (ctr != null) {
                    result.put(CommonTemplateReportGlobalParameter.AGENT_NAME.name(), PersonalLocalizableNameUtil.buildFullName((PersonalLocalizableName)((PersonalLocalizableName)ctr.getEntity()), (boolean)true, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
                } else {
                    SystemHelper.addMessage(messages, (String)Messages.TemplateReportHelper_couldtLoadProfileOrgAgent, null, (MessageType)MessageType.WARNING, (Object[])new Object[]{gpParams.getAgent()});
                }
            }
            result.put(CommonTemplateReportGlobalParameter.AGENCY_NAME.name(), TemplateReportHelper.getOrganizationName((EntityReference<Organization>)params.getAgency(), messages));
            result.put(CommonTemplateReportGlobalParameter.SUBAGENCY_NAME.name(), TemplateReportHelper.getOrganizationName((EntityReference<Organization>)gpParams.getSubagency(), messages));
            result.put(CommonTemplateReportGlobalParameter.SUPPLIER_NAME.name(), TemplateReportHelper.getOrganizationName((EntityReference<Organization>)gpParams.getSupplier(), messages));
            ContractInfo contractInfoSubagency = TemplateReportHelper.getContractInfo(ContractType.SUBAGENCY, gpParams, messages);
            ContractInfo contractInfoVendor = TemplateReportHelper.getContractInfo(ContractType.VENDOR, gpParams, messages);
            if (contractInfoSubagency != null) {
                result.put(CommonTemplateReportGlobalParameter.SUBAGENT_CONTRACT_NUMBER.name(), contractInfoSubagency.getNumber());
            }
            if (contractInfoVendor != null) {
                result.put(CommonTemplateReportGlobalParameter.SUPPLIER_CONTRACT_NUMBER.name(), contractInfoVendor.getNumber());
                result.put(CommonTemplateReportGlobalParameter.SUPPLIER_CONTRACT_ISSUE_DATE.name(), contractInfoVendor.getIssueDate());
                result.put(CommonTemplateReportGlobalParameter.SUPPLIER_CONTRACT_NAME.name(), contractInfoVendor.getName());
            }
            result.put(CommonTemplateReportGlobalParameter.REPORT_CREATOR.name(), TemplateReportHelper.getCreatorLogin());
        }
        return result;
    }

    private static String getCreatorLogin() {
        String creatorLogin = LogicalStorage.get().getUser();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonIndex.Property.loginName.name(), (Object)creatorLogin));
        List perInds = EntityStorage.get().search(PersonIndex.class, query, (EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(true)).getData();
        EntityReference creatorRef = null;
        if (perInds != null && perInds.size() > 0) {
            creatorRef = ((PersonIndex)perInds.iterator().next()).getSource();
        }
        if (creatorRef != null) {
            return creatorRef.getCaption();
        }
        return creatorLogin;
    }

    private static <P extends BaseGeneralProductsTemplateReportParameters> ContractInfo getContractInfo(ContractType contractType, P params, Collection<Message> messages) {
        EntityReference agent = null;
        EntityReference contragent = null;
        switch (contractType) {
            case VENDOR: {
                agent = params.getSupplier();
                contragent = params.getAgency();
                break;
            }
            case SUBAGENCY: {
                agent = params.getAgency();
                contragent = params.getSubagency();
                break;
            }
        }
        if (agent != null && contragent != null) {
            List data;
            SearchQuery query = new SearchQuery();
            if (params.getBlankOwner() != null) {
                query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.vendor.name(), null), SearchCriterion.eq((String)ContractCustomerIndex.Property.vendor.name(), (Object)params.getBlankOwner())}));
            }
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.supplier.name(), (Object)agent));
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.customer.name(), (Object)contragent));
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.contractType.name(), (Object)contractType));
            if (params.getPeriodBegin() != null) {
                query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.endDate.name(), null), SearchCriterion.ge((String)ContractCustomerIndex.Property.endDate.name(), (Object)params.getPeriodBegin())}));
            }
            if (params.getPeriodEnd() != null) {
                query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.startDate.name(), null), SearchCriterion.le((String)ContractCustomerIndex.Property.startDate.name(), (Object)params.getPeriodEnd())}));
            }
            if (!(data = EntityStorage.get().search(ContractCustomerIndex.class, query).getData()).isEmpty()) {
                if (data.size() > 1) {
                    messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.TemplateReportHelper_findedFewContract, (Object[])new Object[]{params.getAgency(), params.getSubagency(), contractType, ((ContractCustomerIndex)data.get(0)).getNumber()}));
                }
                ContractInfo info = new ContractInfo();
                info.setName(((ContractCustomerIndex)data.get(0)).getName());
                info.setNumber(((ContractCustomerIndex)data.get(0)).getNumber());
                info.setIssueDate(((ContractCustomerIndex)data.get(0)).getIssueDate());
                info.setStartDate(((ContractCustomerIndex)data.get(0)).getStartDate());
                info.setEndDate(((ContractCustomerIndex)data.get(0)).getEndDate());
                return info;
            }
        }
        return null;
    }

    public static String getOrganizationName(EntityReference<Organization> agency, Collection<Message> messages) {
        if (agency != null) {
            EntityContainer ctr = EntityStorage.get().resolve(agency);
            if (ctr != null) {
                Organization entity = (Organization)ctr.getEntity();
                return ProfileHelper.getFullName((Organization)entity, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false);
            }
            messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.TemplateReportHelper_couldtLoadProfileOrg, (Object[])new Object[]{agency}));
        }
        return null;
    }

    private TemplateReportHelper() {
    }

    static {
        renderers.put(ContentType.JASPERPRINT, new JasperTemplateReportRenderer());
        renderers.put(ContentType.EXCEL, new ExcelTemplateReportRenderer());
        renderers.put(ContentType.EXCEL_2007, new Excel2007TemplateReportRenderer());
        renderers.put(ContentType.XML, new XmlTemplateReportRenderer());
        renderers.put(ContentType.DBF, new DbfTemplateReportRenderer());
    }

    static class ErrorClosure {
        private final List<Message> messages;

        ErrorClosure(List<Message> msgs) {
            this.messages = msgs;
        }

        public void doAction(String msg) {
            this.messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)msg, (Object[])new Object[0]));
        }
    }

    static class QueryClosure {
        private final QueryBuilder builder;

        QueryClosure(QueryBuilder bld) {
            this.builder = bld;
        }

        public void doAction(Closure<?> cl) {
            cl.setDelegate((Object)this.builder);
            cl.call();
        }
    }

    private static class ContractInfo {
        private String name;
        private String number;
        private Date issueDate;
        private Date startDate;
        private Date endDate;

        private ContractInfo() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public Date getIssueDate() {
            return this.issueDate;
        }

        public void setIssueDate(Date issueDate) {
            this.issueDate = issueDate;
        }

        public Date getStartDate() {
            return this.startDate;
        }

        public void setStartDate(Date startDate) {
            this.startDate = startDate;
        }

        public Date getEndDate() {
            return this.endDate;
        }

        public void setEndDate(Date endDate) {
            this.endDate = endDate;
        }
    }
}

