/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.template.common.renderer;

import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.ValueHolder;
import groovy.lang.Closure;
import groovy.lang.GroovyShell;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class GroovyRenderersHelper {
    private GroovyRenderersHelper() {
    }

    public static class MessageClosure {
        private final List<Message> messages;

        public MessageClosure(List<Message> msgs) {
            this.messages = msgs;
        }

        public void doAction(Message msg) {
            this.messages.add(msg);
        }
    }

    public static class ErrorClosure {
        private final MessageType type;
        private final List<Message> messages;

        public ErrorClosure(MessageType type, List<Message> msgs) {
            this.type = type;
            this.messages = msgs;
        }

        public void doAction(String msg) {
            this.messages.add(SystemHelper.createMessage((MessageType)this.type, (String)msg, (Object[])new Object[0]));
        }

        public void doAction(Message msg) {
            Message msg2 = SystemHelper.createMessage((MessageType)this.type, (String)msg.getMessage().toString(), (Object[])new Object[0]);
            msg2.setDetails(msg.getDetails());
            this.messages.add(msg2);
        }

        public void doAction(String msg, Throwable t) {
            this.messages.add(SystemHelper.createMessage((MessageType)this.type, (String)msg, (Throwable)t, (Object[])new Object[0]));
        }

        public void doAction(Object msg, Object ... parameters) {
            this.messages.add(SystemHelper.createMessage((MessageType)this.type, (String)msg.toString(), (Object[])parameters));
        }

        public void doAction(Object msg, Throwable t, Object ... parameters) {
            this.messages.add(SystemHelper.createMessage((MessageType)this.type, (String)msg.toString(), (Throwable)t, (Object[])parameters));
        }
    }

    public static class GroupClosure<T>
    extends BaseGroupClosure<T> {
        public GroupClosure(ValueHolder<List<T>> ticketsHolder, GroovyShell shell) {
            super(ticketsHolder, shell, false);
        }
    }

    public static abstract class BaseGroupClosure<T> {
        private final Object delegate;
        private final ValueHolder<List<T>> holder;
        private final boolean allowEmptyReport;

        public BaseGroupClosure(ValueHolder<List<T>> ticketsHolder, GroovyShell shell, boolean allowEmptyReport) {
            this.holder = ticketsHolder;
            this.delegate = shell;
            this.allowEmptyReport = allowEmptyReport;
        }

        void doAction(Closure<?> cl) {
            this.doAction(null, cl);
        }

        void doAction(Closure<String> triggerCl, Closure<?> cl) {
            cl.setDelegate(this.delegate);
            LinkedHashMap batches = new LinkedHashMap();
            String lastValue = null;
            ArrayList lastColl = null;
            List originalItems = (List)this.holder.getValue();
            if (originalItems.size() == 0 && this.allowEmptyReport) {
                Object[] n = new Object[]{null};
                String string = triggerCl == null ? "default" : (String)triggerCl.call(n);
                this.beforeSectionStarted(string, null);
                cl.call(n);
                return;
            }
            for (Object e : originalItems) {
                String value;
                String string = value = triggerCl == null ? "default" : (String)triggerCl.call(e);
                if (value == null) {
                    value = "";
                }
                if (lastColl == null || !value.equals(lastValue)) {
                    lastValue = value;
                    lastColl = new ArrayList();
                    batches.put(lastColl, value);
                }
                lastColl.add(e);
            }
            for (Map.Entry entry : batches.entrySet()) {
                this.holder.setValue(entry.getKey());
                this.beforeSectionStarted((String)entry.getValue(), (List)entry.getKey());
                cl.call(entry.getValue());
            }
            this.holder.setValue((Object)originalItems);
        }

        protected void beforeSectionStarted(String value, List<T> key) {
        }
    }

    public static class CountClosure<T> {
        private final ValueHolder<List<T>> items;

        public CountClosure(ValueHolder<List<T>> ticketsHolder) {
            this.items = ticketsHolder;
        }

        int doAction(Closure<?> cl) {
            return ((List)this.items.getValue()).size();
        }
    }

    public static class TicketsClosure<T> {
        private final ValueHolder<List<T>> items;
        private final Object delegate;

        public TicketsClosure(ValueHolder<List<T>> ticketsHolder, GroovyShell shell) {
            this.items = ticketsHolder;
            this.delegate = shell;
        }

        void doAction(Closure<?> cl) {
            cl.setDelegate(this.delegate);
            for (Object item : (List)this.items.getValue()) {
                cl.call(item);
            }
        }
    }
}

