/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.template.common.renderer.dbf;

import com.gridnine.xtrip.common.model.dbf.DbfFile;
import com.gridnine.xtrip.common.model.dbf.DbfTypeHandler;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportPageDescription;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.server.reports.prepare.template.common.renderer.GroovyRenderersHelper;
import com.gridnine.xtrip.server.reports.prepare.template.common.renderer.dbf.DbfBuilder;
import com.linuxense.javadbf.DBFField;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.runtime.MethodClosure;

public class DbfGroovyScriptExecutor {
    public <T, D extends BaseTemplateReportPageDescription> DbfFile execute(DbfFile report, byte[] template, List<T> tickets, Map<String, Object> parameters, List<Message> messages) throws Exception {
        report.getRows().clear();
        Binding binding = new Binding();
        GroovyShell shell = new GroovyShell(binding);
        DbfBuilder builder = new DbfBuilder(report);
        this.fillBinding(binding, builder, tickets, parameters, shell, messages);
        shell.evaluate(new String(template, "utf-8"));
        return report;
    }

    private <T, D extends BaseTemplateReportPageDescription> void fillBinding(Binding binding, DbfBuilder builder, List<T> tickets, Map<String, Object> parameters, GroovyShell shell, List<Message> messages) throws Exception {
        ValueHolder ticketsHolder = new ValueHolder(tickets);
        binding.setVariable("tickets", (Object)new MethodClosure(new GroovyRenderersHelper.TicketsClosure(ticketsHolder, shell), "doAction"));
        binding.setVariable("count", (Object)new MethodClosure(new GroovyRenderersHelper.CountClosure(ticketsHolder), "doAction"));
        binding.setVariable("groups", (Object)new MethodClosure(new GroovyRenderersHelper.GroupClosure(ticketsHolder, shell), "doAction"));
        binding.setVariable("error", (Object)new MethodClosure((Object)new GroovyRenderersHelper.ErrorClosure(MessageType.ERROR, messages), "doAction"));
        binding.setVariable("info", (Object)new MethodClosure((Object)new GroovyRenderersHelper.ErrorClosure(MessageType.MESSAGE, messages), "doAction"));
        binding.setVariable("warn", (Object)new MethodClosure((Object)new GroovyRenderersHelper.ErrorClosure(MessageType.WARNING, messages), "doAction"));
        binding.setVariable("message", (Object)new MethodClosure((Object)new GroovyRenderersHelper.MessageClosure(messages), "doAction"));
        binding.setVariable("parameters", new HashMap<String, Object>(parameters));
        binding.setProperty("allTickets", tickets);
        binding.setVariable("textColumn", (Object)new MethodClosure(new ColumnClosure(builder.getFile(), DbfTypeHandler.CHARACTER), "doAction"));
        binding.setVariable("dateColumn", (Object)new MethodClosure(new ColumnClosure(builder.getFile(), DbfTypeHandler.DATE), "doAction"));
        binding.setVariable("numberColumn", (Object)new MethodClosure(new ColumnClosure(builder.getFile(), DbfTypeHandler.NUMBER), "doAction"));
        binding.setVariable("text", (Object)new MethodClosure((Object)new ValueClosure(builder), "doAction"));
        binding.setVariable("number", (Object)new MethodClosure((Object)new ValueClosure(builder), "doAction"));
        binding.setVariable("date", (Object)new MethodClosure((Object)new ValueClosure(builder), "doAction"));
        binding.setVariable("booleanValue", (Object)new MethodClosure((Object)new ValueClosure(builder), "doAction"));
        binding.setVariable("nextRow", (Object)new MethodClosure((Object)new ValueClosure(builder), "doAction"));
    }

    static class ColumnClosure<T> {
        private final DbfFile file;
        private final DbfTypeHandler<T> handler;

        ColumnClosure(DbfFile dbfFile, DbfTypeHandler<T> typeHandler) {
            this.file = dbfFile;
            this.handler = typeHandler;
        }

        void doAction(String fieldName, int length, int decimalCount) {
            DBFField field = new DBFField();
            field.setName(fieldName);
            field.setDataType(this.handler.getDbfType());
            field.setDecimalCount(decimalCount);
            field.setFieldLength(length);
            this.file.getFields().add(field);
        }

        void doAction(String fieldName, int length) {
            this.doAction(fieldName, length, 0);
        }
    }

    static class ValueClosure {
        private final DbfBuilder builder;

        ValueClosure(DbfBuilder dbfFile) {
            this.builder = dbfFile;
        }

        void doAction(String fieldName, Object value) {
            DBFField field = null;
            for (DBFField item : this.builder.getFile().getFields()) {
                if (!fieldName.equals(item.getName())) continue;
                field = item;
            }
            Object correctedValue = null;
            if (value instanceof Number) {
                Number number = (Number)value;
                correctedValue = number.doubleValue();
            } else if (value instanceof String) {
                correctedValue = value;
            } else if (value instanceof Boolean) {
                correctedValue = value;
            } else if (value instanceof Date) {
                correctedValue = value;
            } else if (value != null) {
                throw new IllegalArgumentException("unsupported data type " + value);
            }
            this.builder.getRow().setValue(field, correctedValue);
        }
    }

    static class NextRowClosure {
        private final DbfBuilder builder;

        NextRowClosure(DbfBuilder dbfFile) {
            this.builder = dbfFile;
        }

        void doAction() {
            this.builder.nextRow();
        }
    }
}

