/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.template.common.renderer.excel;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.reports.prepare.template.common.renderer.excel.Excel2007CellStyle;
import com.gridnine.xtrip.server.reports.prepare.template.common.renderer.excel.ExcelCursorPosition;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.DataConsolidateFunction;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.AreaReference;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFCreationHelper;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFName;
import org.apache.poi.xssf.usermodel.XSSFPicture;
import org.apache.poi.xssf.usermodel.XSSFPivotTable;
import org.apache.poi.xssf.usermodel.XSSFPrintSetup;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTTwoCellAnchor;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTColFields;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPivotField;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPivotFields;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPivotTableDefinition;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRowFields;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetProtection;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STAxis;

public class Excel2007Builder {
    private static final String KEY_PARENT_STYLE = "parent";
    private static final String KEY_HORIZONTAL_ALIGNMENT = "h_alignment";
    private static final String KEY_VERTICAL_ALIGNMENT = "v_alignment";
    private static final String KEY_BORDER_LEFT = "leftBorder";
    private static final String KEY_BORDER_RIGHT = "rightBorder";
    private static final String KEY_BORDER_BOTTOM = "bottomBorder";
    private static final String KEY_BORDER_TOP = "topBorder";
    private static final String KEY_FONT_FAMILY = "fontFamily";
    private static final String KEY_FONT_HEIGHT = "fontHeight";
    private static final String KEY_FONT_ITALIC = "fontItalic";
    private static final String KEY_FONT_COLOR = "fontColor";
    private static final String KEY_FONT_BOLD = "fontBold";
    private static final String KEY_FONT_UNDERLINE = "fontUnderline";
    private static final String KEY_WRAP_TEXT = "wrapText";
    private static final String KEY_HORIZONTAL_SPAN = "h_span";
    private static final String KEY_VERTICAL_SPAN = "v_span";
    private static final String KEY_FORMAT = "format";
    private static final String KEY_FOREGROUND = "foreground";
    private static final String KEY_LOCKED = "locked";
    private static final String NORMAL_STYLE_NAME = "normal";
    private static final List<String> keys = new ArrayList<String>();
    private static final Map<String, XSSFColor> colors = new HashMap<String, XSSFColor>();
    private static final float defaultRowHeight = 12.5f;
    private final XSSFWorkbook book;
    private XSSFSheet sheet;
    private final ExcelCursorPosition currentPosition = new ExcelCursorPosition();
    private Excel2007CellStyle currentStyle;
    private final Map<String, Excel2007CellStyle> styles = new HashMap<String, Excel2007CellStyle>();
    private final Map<String, Map<String, Object>> styleProperties = new HashMap<String, Map<String, Object>>();
    private boolean pageAdded;
    private float lastRowHeight = 12.5f;
    private boolean preserve = true;
    private final Map<String, XSSFPivotTable> pivotTables = new HashMap<String, XSSFPivotTable>();
    private final List<PictureStruct> pictures = new ArrayList<PictureStruct>();

    public Excel2007Builder(XSSFWorkbook workbook) {
        this.book = workbook;
        this.currentStyle = new Excel2007CellStyle(this.book);
        this.styles.put(NORMAL_STYLE_NAME, this.currentStyle);
    }

    public void moveTo(int rowIndex, int columnIndex) {
        XSSFRow row = this.getSheet().getRow(rowIndex);
        if (row == null) {
            row = this.getSheet().createRow(rowIndex);
        }
        row.getCell(columnIndex, Row.CREATE_NULL_AS_BLANK);
        this.currentPosition.setRow(rowIndex);
        this.currentPosition.setColumn(columnIndex);
    }

    public void moveTo(CellCoordinate coordinate) {
        this.moveTo(coordinate.getRow(), coordinate.getColumn());
    }

    public int getRowIndex() {
        return this.currentPosition.getRow();
    }

    public int getColumnIndex() {
        return this.currentPosition.getColumn();
    }

    public void nextColumn() {
        this.currentPosition.setColumn(this.currentPosition.getColumn() + this.currentStyle.getHorizontalSpan());
    }

    public void nextRow() {
        this.currentPosition.setColumn(0);
        this.currentPosition.setRow(this.currentPosition.getRow() + 1);
        XSSFRow row = this.getSheet().getRow(this.currentPosition.getRow());
        if (row == null) {
            row = this.getSheet().createRow(this.currentPosition.getRow());
        }
        if (this.preserve) {
            row.setHeightInPoints(this.lastRowHeight);
        }
    }

    public void setStyle(String styleName) {
        this.currentStyle = this.styles.get(styleName);
        if (this.currentStyle == null) {
            this.currentStyle = this.styles.get(NORMAL_STYLE_NAME);
        }
    }

    public void setCurrentColumnWidth(int width) {
        this.getSheet().setColumnWidth(this.currentPosition.getColumn(), 256 * width);
    }

    public void setCurrentRowHeight(float height, boolean preserve) {
        XSSFRow row = this.getSheet().getRow(this.currentPosition.getRow());
        if (row == null) {
            row = this.getSheet().createRow(this.currentPosition.getRow());
        }
        row.setHeightInPoints(height);
        if (preserve) {
            this.lastRowHeight = height;
        }
    }

    public void text(String value, String style, int hspan, int vspan) {
        if (value == null) {
            return;
        }
        String textToInsert = value.substring(0, Math.min(value.length(), Short.MAX_VALUE));
        XSSFCell cell = this.getCurrentCell(style, hspan, vspan);
        if (TextUtil.isBlank((String)textToInsert)) {
            cell.setCellType(3);
            return;
        }
        cell.setCellValue((RichTextString)new XSSFRichTextString(textToInsert));
    }

    public void textnc(String value, String style, int hspan, int vspan) {
        XSSFCell cell = this.getCurrentCell(style, hspan, vspan);
        if (TextUtil.isBlank((String)value)) {
            cell.setCellType(3);
        } else {
            cell.setCellValue((RichTextString)new XSSFRichTextString(value));
        }
        this.currentPosition.setColumn(this.currentPosition.getColumn() + this.currentStyle.getHorizontalSpan());
    }

    public void number(BigDecimal value, String style, int hspan, int vspan) {
        XSSFCell cell = this.getCurrentCell(style, hspan, vspan);
        if (value == null) {
            cell.setCellType(3);
            return;
        }
        cell.setCellValue(value.doubleValue());
    }

    public void numbernc(BigDecimal value, String style, int hspan, int vspan) {
        XSSFCell cell = this.getCurrentCell(style, hspan, vspan);
        if (value == null) {
            cell.setCellType(3);
        } else {
            cell.setCellValue(value.doubleValue());
            cell.setCellType(0);
        }
        this.currentPosition.setColumn(this.currentPosition.getColumn() + this.currentStyle.getHorizontalSpan());
    }

    public void date(Date value, String style, int hspan, int vspan) {
        XSSFCell cell = this.getCurrentCell(style, hspan, vspan);
        if (value == null) {
            cell.setCellType(3);
            return;
        }
        cell.setCellValue(value);
    }

    public void bool(Boolean value, String style, int hspan, int vspan) {
        XSSFCell cell = this.getCurrentCell(style, hspan, vspan);
        if (value == null) {
            cell.setCellType(3);
            return;
        }
        cell.setCellValue(value.booleanValue());
    }

    public void formula(String value, String style, int hspan, int vspan) {
        XSSFCell cell = this.getCurrentCell(style, hspan, vspan);
        if (TextUtil.isBlank((String)value)) {
            cell.setCellType(3);
            return;
        }
        cell.setCellFormula(value);
    }

    public void picture(int col1, int col2, int row1, int row2, byte[] picture, int pictureType, double xScale, double yScale) {
        XSSFCreationHelper helper = this.book.getCreationHelper();
        XSSFDrawing drawing = this.sheet.createDrawingPatriarch();
        ClientAnchor anchor = helper.createClientAnchor();
        anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_AND_RESIZE);
        int pictureIndex = this.book.addPicture(picture, pictureType);
        anchor.setCol1(col1);
        anchor.setRow1(row1);
        anchor.setRow2(row2);
        anchor.setCol2(col2);
        Picture pict = drawing.createPicture(anchor, pictureIndex);
        pict.resize(xScale, yScale);
    }

    private XSSFCell getCurrentCell(String style, int hspan, int vspan) {
        if (style != null) {
            String compositeStyle;
            this.currentStyle = this.styles.get(style);
            if (this.currentStyle == null && (compositeStyle = this.createCompositeStyle(TextUtil.split((String)style, (String)"\\|", (boolean)true, (boolean)true))) != null) {
                this.currentStyle = this.styles.get(compositeStyle);
            }
        }
        if (this.currentStyle == null) {
            this.currentStyle = this.styles.get(NORMAL_STYLE_NAME);
        }
        if (this.sheet == null) {
            this.createSheet();
        }
        int horizontalSpan = hspan > 0 ? hspan : (int)this.currentStyle.getHorizontalSpan();
        int verticalSpan = vspan > 0 ? vspan : (int)this.currentStyle.getVerticalSpan();
        XSSFCell firstCell = null;
        for (int n = 0; n < verticalSpan; ++n) {
            for (int m = 0; m < horizontalSpan; ++m) {
                XSSFCell cell;
                XSSFRow row = this.getSheet().getRow(this.currentPosition.getRow() + n);
                if (row == null) {
                    row = this.getSheet().createRow(this.currentPosition.getRow() + n);
                }
                if ((cell = row.getCell(this.currentPosition.getColumn() + m)) == null) {
                    cell = row.createCell(this.currentPosition.getColumn() + m);
                }
                if (firstCell == null) {
                    firstCell = cell;
                }
                cell.setCellStyle((CellStyle)this.currentStyle.getStyle());
            }
        }
        if (horizontalSpan > 1 || verticalSpan > 1) {
            this.sheet.addMergedRegion(new CellRangeAddress(this.currentPosition.getRow(), this.currentPosition.getRow() + verticalSpan - 1, this.currentPosition.getColumn(), this.currentPosition.getColumn() + horizontalSpan - 1));
        }
        return firstCell;
    }

    public String cellIndex(int rowShift, int columnShift) {
        int row = this.currentPosition.getRow() + rowShift;
        int column = this.currentPosition.getColumn() + columnShift;
        return String.format("%s%s", ExcelUtils.indexToString((int)column), Integer.toString(row + 1));
    }

    public void createStyle(String styleName, Map<String, Object> properties) {
        Boolean locked;
        String foreground;
        Boolean wrapText;
        String fontUnderline;
        String fontColor;
        Boolean fontItalic;
        Boolean fontBold;
        Integer v_span;
        Integer h_span;
        Integer fontHeight;
        String dataFormat;
        String fontFamily;
        String topBorder;
        String bottomBorder;
        String rightBorder;
        String leftBorder;
        String v_alignment;
        String h_alignment;
        Excel2007CellStyle style = new Excel2007CellStyle(this.book);
        style.setLocked(false);
        String parentStyleName = (String)properties.get(KEY_PARENT_STYLE);
        if (!TextUtil.isBlank((String)parentStyleName)) {
            Excel2007CellStyle parentStyle = this.styles.get(parentStyleName);
            style.setParentStyle(parentStyle);
        }
        if (!TextUtil.isBlank((String)(h_alignment = (String)properties.get(KEY_HORIZONTAL_ALIGNMENT)))) {
            style.setHorizontalAlignment(h_alignment);
        }
        if (!TextUtil.isBlank((String)(v_alignment = (String)properties.get(KEY_VERTICAL_ALIGNMENT)))) {
            style.setVerticalAlignment(v_alignment);
        }
        if (!TextUtil.isBlank((String)(leftBorder = (String)properties.get(KEY_BORDER_LEFT)))) {
            style.setBorderLeft(leftBorder);
        }
        if (!TextUtil.isBlank((String)(rightBorder = (String)properties.get(KEY_BORDER_RIGHT)))) {
            style.setBorderRight(rightBorder);
        }
        if (!TextUtil.isBlank((String)(bottomBorder = (String)properties.get(KEY_BORDER_BOTTOM)))) {
            style.setBorderBottom(bottomBorder);
        }
        if (!TextUtil.isBlank((String)(topBorder = (String)properties.get(KEY_BORDER_TOP)))) {
            style.setBorderTop(topBorder);
        }
        if (!TextUtil.isBlank((String)(fontFamily = (String)properties.get(KEY_FONT_FAMILY)))) {
            style.setFontFamily(fontFamily);
        }
        if (!TextUtil.isBlank((String)(dataFormat = (String)properties.get(KEY_FORMAT)))) {
            style.setFormat(dataFormat);
        }
        if ((fontHeight = (Integer)properties.get(KEY_FONT_HEIGHT)) != null) {
            style.setFontHeight(fontHeight.shortValue());
        }
        if ((h_span = (Integer)properties.get(KEY_HORIZONTAL_SPAN)) != null) {
            style.setHorizontalSpan(h_span.shortValue());
        }
        if ((v_span = (Integer)properties.get(KEY_VERTICAL_SPAN)) != null) {
            style.setVerticalSpan(v_span.shortValue());
        }
        if ((fontBold = (Boolean)properties.get(KEY_FONT_BOLD)) != null) {
            style.setFontBold(fontBold);
        }
        if ((fontItalic = (Boolean)properties.get(KEY_FONT_ITALIC)) != null) {
            style.setFontItalic(fontItalic);
        }
        if (!TextUtil.isBlank((String)(fontColor = (String)properties.get(KEY_FONT_COLOR)))) {
            style.setFontColor(colors.get(fontColor) != null ? colors.get(fontColor) : new XSSFColor(new Color(Integer.decode(fontColor))));
        }
        if (!TextUtil.isBlank((String)fontColor) && colors.get(fontColor) != null) {
            style.setFontColor(colors.get(fontColor));
        }
        if (!TextUtil.isBlank((String)(fontUnderline = (String)properties.get(KEY_FONT_UNDERLINE)))) {
            style.setFontUnderline(fontUnderline);
        }
        if ((wrapText = (Boolean)properties.get(KEY_WRAP_TEXT)) != null) {
            style.setWrapText(wrapText);
        }
        if (!TextUtil.isBlank((String)(foreground = (String)properties.get(KEY_FOREGROUND)))) {
            style.getStyle().setFillPattern((short)1);
            style.getStyle().setFillForegroundColor(colors.get(foreground) != null ? colors.get(foreground) : new XSSFColor(new Color(Integer.decode(foreground))));
        }
        if ((locked = (Boolean)properties.get(KEY_LOCKED)) != null) {
            style.setLocked(locked);
        }
        this.styles.put(styleName, style);
        this.styleProperties.put(styleName, properties);
    }

    public String createCompositeStyle(List<String> names) {
        String styleName = TextUtil.join((String)"|", names, (boolean)true);
        if (TextUtil.isBlank((String)styleName) || this.styles.get(styleName) != null) {
            return null;
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (String name : names) {
            if (TextUtil.isBlank((String)name)) continue;
            properties.putAll(this.getProperties(name));
        }
        this.createStyle(styleName, properties);
        return styleName;
    }

    private Map<String, Object> getProperties(String style) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (String key : keys) {
            Object property = this.getProperty(style, key);
            if (property == null) continue;
            properties.put(key, property);
        }
        return properties;
    }

    private Object getProperty(String style, String property) {
        Map<String, Object> parentProperties;
        String parent = style;
        while (parent != null && (parentProperties = this.styleProperties.get(parent)) != null) {
            if (parentProperties.containsKey(property)) {
                return parentProperties.get(property);
            }
            parent = (String)parentProperties.get(KEY_PARENT_STYLE);
        }
        return null;
    }

    public XSSFSheet createSheet(String name) {
        this.sheet = name == null ? this.book.createSheet() : this.book.createSheet(this.prepareSheetName(name));
        this.currentPosition.setRow(0);
        this.currentPosition.setColumn(0);
        this.pageAdded = true;
        this.sheet.setFitToPage(true);
        XSSFPrintSetup ps = this.sheet.getPrintSetup();
        ps.setFitWidth((short)1);
        ps.setFitHeight((short)0);
        ps.setLandscape(true);
        ps.setPaperSize((short)9);
        return this.sheet;
    }

    public XSSFSheet navigateToSheet(String name) {
        this.sheet = this.book.getSheet(name);
        if (this.sheet == null) {
            throw Xeption.forDeveloper((String)"sheet {0} is absent in workbook", (Object[])new Object[]{name});
        }
        this.currentPosition.setRow(0);
        this.currentPosition.setColumn(0);
        this.pageAdded = true;
        return this.sheet;
    }

    public void setAutoFilter(String name, String range) {
        this.sheet = this.book.getSheet(name);
        if (this.sheet == null) {
            throw Xeption.forDeveloper((String)"sheet {0} is absent in workbook", (Object[])new Object[]{name});
        }
        this.sheet.setAutoFilter(CellRangeAddress.valueOf((String)range));
    }

    public void preserve(boolean preserve) {
        this.preserve = preserve;
    }

    public void freeze(int colSplit, int rowSplit) {
        this.getSheet().createFreezePane(colSplit, rowSplit);
    }

    public void rowBreak() {
        this.getSheet().setRowBreak(this.currentPosition.getRow());
    }

    public void columnBreak() {
        this.getSheet().setColumnBreak(this.currentPosition.getColumn());
    }

    public void landscape(boolean landscape) {
        this.getSheet().getPrintSetup().setLandscape(landscape);
    }

    public void fitWidth(int fitWidth) {
        this.getSheet().getPrintSetup().setFitWidth((short)fitWidth);
    }

    public void fitHeight(int fitHeight) {
        this.getSheet().getPrintSetup().setFitHeight((short)fitHeight);
    }

    public void scale(int scale) {
        this.getSheet().getPrintSetup().setScale((short)scale);
    }

    public void margin(double left, double right, double top, double bottom) {
        this.getSheet().setMargin((short)0, left);
        this.getSheet().setMargin((short)1, right);
        this.getSheet().setMargin((short)2, top);
        this.getSheet().setMargin((short)3, bottom);
    }

    public void marginLeft(double size) {
        this.getSheet().setMargin((short)0, size);
    }

    public void marginRight(double size) {
        this.getSheet().setMargin((short)1, size);
    }

    public void marginTop(double size) {
        this.getSheet().setMargin((short)2, size);
    }

    public void marginBottom(double size) {
        this.getSheet().setMargin((short)3, size);
    }

    public void protect(String password) {
        if (password == null) {
            return;
        }
        this.getSheet().protectSheet(password);
        CTSheetProtection protection = this.getSheet().getCTWorksheet().getSheetProtection();
        protection.setDeleteRows(false);
        protection.setSelectLockedCells(false);
        protection.setSelectUnlockedCells(false);
        protection.setFormatCells(false);
        protection.setFormatColumns(false);
        protection.setFormatRows(false);
        protection.setInsertColumns(true);
        protection.setInsertRows(true);
        protection.setInsertHyperlinks(true);
        protection.setDeleteColumns(true);
        protection.setDeleteRows(true);
        protection.setSort(true);
        protection.setAutoFilter(true);
        protection.setPivotTables(true);
        protection.setObjects(true);
        protection.setScenarios(true);
        this.getSheet().enableLocking();
    }

    public boolean isPageAdded() {
        return this.pageAdded;
    }

    public XSSFSheet createSheet() {
        return this.createSheet(null);
    }

    public XSSFSheet getSheet() {
        return this.sheet == null ? this.createSheet() : this.sheet;
    }

    public XSSFWorkbook getBook() {
        return this.book;
    }

    private static XSSFColor getColor(HSSFColor color) {
        return new XSSFColor(new byte[]{(byte)color.getTriplet()[0], (byte)color.getTriplet()[1], (byte)color.getTriplet()[2]});
    }

    public void createPivotTable(String sourceSheetName, CellArea sourceArea, String id) {
        XSSFSheet sourceSheet = this.getBook().getSheet(sourceSheetName);
        if (sourceSheet == null) {
            throw new IllegalArgumentException("sheet with name [" + sourceSheetName + "] not found");
        }
        XSSFSheet currentSheet = this.getSheet();
        CellReference distination = new CellReference(this.currentPosition.getRow(), this.currentPosition.getColumn());
        XSSFPivotTable pivotTable = currentSheet.createPivotTable(this.transformCellArea(sourceArea), distination, (Sheet)sourceSheet);
        this.pivotTables.put(id, pivotTable);
    }

    public void setPivotTableDataCaption(String pivotTableId, String dataCaption) {
        XSSFPivotTable pivotTable = this.pivotTables.get(pivotTableId);
        if (pivotTable == null) {
            throw new IllegalArgumentException("pivotTable not found");
        }
        pivotTable.getCTPivotTableDefinition().setDataCaption(dataCaption);
    }

    public void addPivotTableFilter(String pivotTableId, int index) {
        XSSFPivotTable pivotTable = this.pivotTables.get(pivotTableId);
        if (pivotTable == null) {
            throw new IllegalArgumentException("pivotTable not found");
        }
        pivotTable.addReportFilter(index);
    }

    public void addPivotTableColumn(String pivotTableId, int index) {
        XSSFPivotTable pivotTable = this.pivotTables.get(pivotTableId);
        if (pivotTable == null) {
            throw new IllegalArgumentException("pivotTable not found");
        }
        pivotTable.addRowLabel(index);
        CTPivotTableDefinition pivotTableDefinition = pivotTable.getCTPivotTableDefinition();
        CTPivotFields pivotFields = pivotTableDefinition.getPivotFields();
        pivotFields.getPivotFieldArray(index).setAxis(STAxis.AXIS_COL);
        CTColFields colFields = pivotTableDefinition.getColFields();
        if (colFields == null) {
            colFields = pivotTableDefinition.addNewColFields();
        }
        colFields.addNewField().setX(index);
        colFields.setCount((long)colFields.sizeOfFieldArray());
        CTRowFields rowFields = pivotTableDefinition.getRowFields();
        rowFields.removeField(rowFields.sizeOfFieldArray() - 1);
        rowFields.setCount((long)rowFields.sizeOfFieldArray());
    }

    public void addPivotTableSumColumn(String pivotTableId, int index, String fieldName) {
        XSSFPivotTable pivotTable = this.pivotTables.get(pivotTableId);
        if (pivotTable == null) {
            throw new IllegalArgumentException("pivotTable not found");
        }
        if (fieldName == null) {
            pivotTable.addColumnLabel(DataConsolidateFunction.SUM, index);
        } else {
            pivotTable.addColumnLabel(DataConsolidateFunction.SUM, index, fieldName);
        }
    }

    public void addPivotTableAverageColumn(String pivotTableId, int index, String fieldName) {
        XSSFPivotTable pivotTable = this.pivotTables.get(pivotTableId);
        if (pivotTable == null) {
            throw new IllegalArgumentException("pivotTable not found");
        }
        if (fieldName == null) {
            pivotTable.addColumnLabel(DataConsolidateFunction.AVERAGE, index);
        } else {
            pivotTable.addColumnLabel(DataConsolidateFunction.AVERAGE, index, fieldName);
        }
    }

    public void addPivotTableRow(String pivotTableId, int index, PivotTableRowConfig config) {
        XSSFPivotTable pivotTable = this.pivotTables.get(pivotTableId);
        if (pivotTable == null) {
            throw new IllegalArgumentException("pivotTable not found");
        }
        pivotTable.addRowLabel(index);
        if (config != null) {
            Boolean outlineForm;
            CTPivotTableDefinition pivotTableDefinition = pivotTable.getCTPivotTableDefinition();
            CTPivotFields pivotFields = pivotTableDefinition.getPivotFields();
            CTPivotField pivotField = pivotFields.getPivotFieldArray(index);
            Boolean compactForm = config.getCompactForm();
            if (compactForm != null) {
                pivotField.setCompact(compactForm.booleanValue());
            }
            if ((outlineForm = config.getOutlineForm()) != null) {
                pivotField.setOutline(outlineForm.booleanValue());
            }
        }
    }

    private CellReference transformCellCoordinate(CellCoordinate coordinate) {
        return new CellReference(coordinate.row, coordinate.column);
    }

    private AreaReference transformCellArea(CellArea area) {
        return new AreaReference(this.transformCellCoordinate(area.leftTop), this.transformCellCoordinate(area.rightBottom));
    }

    private String prepareSheetName(String name) {
        return name.replaceAll("[\\[\\]*?:/\\\\]*", "");
    }

    public void redefineNamedRange(String rangeName, String referenceFormula) {
        XSSFName name = this.getBook().getName(rangeName);
        if (name == null) {
            name = this.getBook().createName();
            name.setNameName(rangeName);
        }
        name.setRefersToFormula(referenceFormula);
    }

    public void shiftChart(int chartIndex, int leftTopRow, int leftTopColumn) {
        XSSFDrawing drawing = (XSSFDrawing)this.getSheet().getRelations().get(chartIndex);
        CTTwoCellAnchor anchor = drawing.getCTDrawing().getTwoCellAnchorArray(0);
        int deltaRow = anchor.getTo().getRow() - anchor.getFrom().getRow();
        int deltaColumn = anchor.getTo().getCol() - anchor.getFrom().getCol();
        anchor.getFrom().setRow(leftTopRow);
        anchor.getFrom().setCol(leftTopColumn);
        anchor.getTo().setRow(leftTopRow + deltaRow);
        anchor.getTo().setCol(leftTopColumn + deltaColumn);
    }

    public void setDefaultSheet(String sheetName) {
        XSSFWorkbook book = this.getBook();
        int sheetIndex = book.getSheetIndex(sheetName);
        if (sheetIndex == -1) {
            throw Xeption.forDeveloper((String)("sheet with name [" + sheetName + "] not found"), (Object[])new Object[0]);
        }
        book.setActiveSheet(sheetIndex);
        book.setSelectedTab(sheetIndex);
    }

    public int addPicture(byte[] content, PictureFormatType format) {
        int poiPictureFormat;
        switch (format) {
            case PNG: {
                poiPictureFormat = 6;
                break;
            }
            case JPEG: {
                poiPictureFormat = 5;
                break;
            }
            default: {
                throw Xeption.forDeveloper((String)("invalid image format: " + (Object)((Object)format)), (Object[])new Object[0]);
            }
        }
        XSSFWorkbook book = this.getBook();
        int poiPictureId = book.addPicture(content, poiPictureFormat);
        XSSFSheet sheet = this.getSheet();
        XSSFDrawing drawing = sheet.createDrawingPatriarch();
        XSSFClientAnchor anchor = book.getCreationHelper().createClientAnchor();
        anchor.setCol1(this.getColumnIndex());
        anchor.setRow1(this.getRowIndex());
        XSSFPicture picture = drawing.createPicture(anchor, poiPictureId);
        picture.resize();
        int result = this.pictures.size();
        PictureStruct pictureStruct = new PictureStruct();
        pictureStruct.picture = picture;
        pictureStruct.poiPictureId = poiPictureId;
        this.pictures.add(pictureStruct);
        return result;
    }

    public CellCoordinate getPictureRightBottom(int pictureId) {
        if (pictureId < 0 || pictureId >= this.pictures.size()) {
            throw Xeption.forDeveloper((String)("invalid pictureId: [" + pictureId + "]. pictures.size: " + this.pictures.size()), (Object[])new Object[0]);
        }
        PictureStruct pictureStruct = this.pictures.get(pictureId);
        XSSFClientAnchor anchor = (XSSFClientAnchor)pictureStruct.picture.getAnchor();
        int row = anchor.getRow2();
        short column = anchor.getCol2();
        return new CellCoordinate(row, column);
    }

    public void rowAutoHeight() {
        XSSFRow row = this.getSheet().getRow(this.currentPosition.getRow());
        if (row == null) {
            row = this.getSheet().createRow(this.currentPosition.getRow());
        }
        row.setHeight((short)-1);
    }

    public void columnAutoWidth() {
        this.getSheet().autoSizeColumn(this.currentPosition.getColumn());
    }

    public void columnAutoWidth(boolean useMergedCells) {
        this.getSheet().autoSizeColumn(this.currentPosition.getColumn(), useMergedCells);
    }

    public void removeSheet(String sheetName) {
        XSSFWorkbook book = this.getBook();
        int sheetIndex = book.getSheetIndex(sheetName);
        if (sheetIndex == -1) {
            throw Xeption.forDeveloper((String)("sheet with name [" + sheetName + "] not found"), (Object[])new Object[0]);
        }
        book.removeSheetAt(sheetIndex);
    }

    static {
        keys.add(KEY_HORIZONTAL_ALIGNMENT);
        keys.add(KEY_VERTICAL_ALIGNMENT);
        keys.add(KEY_BORDER_LEFT);
        keys.add(KEY_BORDER_RIGHT);
        keys.add(KEY_BORDER_BOTTOM);
        keys.add(KEY_BORDER_TOP);
        keys.add(KEY_FONT_FAMILY);
        keys.add(KEY_FONT_HEIGHT);
        keys.add(KEY_FONT_ITALIC);
        keys.add(KEY_FONT_COLOR);
        keys.add(KEY_FONT_BOLD);
        keys.add(KEY_FONT_UNDERLINE);
        keys.add(KEY_WRAP_TEXT);
        keys.add(KEY_HORIZONTAL_SPAN);
        keys.add(KEY_VERTICAL_SPAN);
        keys.add(KEY_FORMAT);
        keys.add(KEY_FOREGROUND);
        keys.add(KEY_LOCKED);
        colors.put("BLACK", Excel2007Builder.getColor((HSSFColor)new HSSFColor.BLACK()));
        colors.put("BROWN", Excel2007Builder.getColor((HSSFColor)new HSSFColor.BROWN()));
        colors.put("OLIVE_GREEN", Excel2007Builder.getColor((HSSFColor)new HSSFColor.OLIVE_GREEN()));
        colors.put("DARK_GREEN", Excel2007Builder.getColor((HSSFColor)new HSSFColor.DARK_GREEN()));
        colors.put("DARK_TEAL", Excel2007Builder.getColor((HSSFColor)new HSSFColor.DARK_TEAL()));
        colors.put("DARK_BLUE", Excel2007Builder.getColor((HSSFColor)new HSSFColor.DARK_BLUE()));
        colors.put("INDIGO", Excel2007Builder.getColor((HSSFColor)new HSSFColor.INDIGO()));
        colors.put("GREY_80_PERCENT", Excel2007Builder.getColor((HSSFColor)new HSSFColor.GREY_80_PERCENT()));
        colors.put("ORANGE", Excel2007Builder.getColor((HSSFColor)new HSSFColor.ORANGE()));
        colors.put("DARK_YELLOW", Excel2007Builder.getColor((HSSFColor)new HSSFColor.DARK_YELLOW()));
        colors.put("GREEN", Excel2007Builder.getColor((HSSFColor)new HSSFColor.GREEN()));
        colors.put("TEAL", Excel2007Builder.getColor((HSSFColor)new HSSFColor.TEAL()));
        colors.put("BLUE", Excel2007Builder.getColor((HSSFColor)new HSSFColor.BLUE()));
        colors.put("BLUE_GREY", Excel2007Builder.getColor((HSSFColor)new HSSFColor.BLUE_GREY()));
        colors.put("GREY_50_PERCENT", Excel2007Builder.getColor((HSSFColor)new HSSFColor.GREY_50_PERCENT()));
        colors.put("RED", Excel2007Builder.getColor((HSSFColor)new HSSFColor.RED()));
        colors.put("LIGHT_ORANGE", Excel2007Builder.getColor((HSSFColor)new HSSFColor.LIGHT_ORANGE()));
        colors.put("LIME", Excel2007Builder.getColor((HSSFColor)new HSSFColor.LIME()));
        colors.put("SEA_GREEN", Excel2007Builder.getColor((HSSFColor)new HSSFColor.SEA_GREEN()));
        colors.put("AQUA", Excel2007Builder.getColor((HSSFColor)new HSSFColor.AQUA()));
        colors.put("LIGHT_BLUE", Excel2007Builder.getColor((HSSFColor)new HSSFColor.LIGHT_BLUE()));
        colors.put("VIOLET", Excel2007Builder.getColor((HSSFColor)new HSSFColor.VIOLET()));
        colors.put("GREY_40_PERCENT", Excel2007Builder.getColor((HSSFColor)new HSSFColor.GREY_40_PERCENT()));
        colors.put("PINK", Excel2007Builder.getColor((HSSFColor)new HSSFColor.PINK()));
        colors.put("GOLD", Excel2007Builder.getColor((HSSFColor)new HSSFColor.GOLD()));
        colors.put("YELLOW", Excel2007Builder.getColor((HSSFColor)new HSSFColor.YELLOW()));
        colors.put("BRIGHT_GREEN", Excel2007Builder.getColor((HSSFColor)new HSSFColor.BRIGHT_GREEN()));
        colors.put("TURQUOISE", Excel2007Builder.getColor((HSSFColor)new HSSFColor.TURQUOISE()));
        colors.put("DARK_RED", Excel2007Builder.getColor((HSSFColor)new HSSFColor.DARK_RED()));
        colors.put("SKY_BLUE", Excel2007Builder.getColor((HSSFColor)new HSSFColor.SKY_BLUE()));
        colors.put("PLUM", Excel2007Builder.getColor((HSSFColor)new HSSFColor.PLUM()));
        colors.put("GREY_25_PERCENT", Excel2007Builder.getColor((HSSFColor)new HSSFColor.GREY_25_PERCENT()));
        colors.put("ROSE", Excel2007Builder.getColor((HSSFColor)new HSSFColor.ROSE()));
        colors.put("LIGHT_YELLOW", Excel2007Builder.getColor((HSSFColor)new HSSFColor.LIGHT_YELLOW()));
        colors.put("LIGHT_GREEN", Excel2007Builder.getColor((HSSFColor)new HSSFColor.LIGHT_GREEN()));
        colors.put("LIGHT_TURQUOISE", Excel2007Builder.getColor((HSSFColor)new HSSFColor.LIGHT_TURQUOISE()));
        colors.put("PALE_BLUE", Excel2007Builder.getColor((HSSFColor)new HSSFColor.PALE_BLUE()));
        colors.put("LAVENDER", Excel2007Builder.getColor((HSSFColor)new HSSFColor.LAVENDER()));
        colors.put("WHITE", Excel2007Builder.getColor((HSSFColor)new HSSFColor.WHITE()));
        colors.put("CORNFLOWER_BLUE", Excel2007Builder.getColor((HSSFColor)new HSSFColor.CORNFLOWER_BLUE()));
        colors.put("LEMON_CHIFFON", Excel2007Builder.getColor((HSSFColor)new HSSFColor.LEMON_CHIFFON()));
        colors.put("MAROON", Excel2007Builder.getColor((HSSFColor)new HSSFColor.MAROON()));
        colors.put("ORCHID", Excel2007Builder.getColor((HSSFColor)new HSSFColor.ORCHID()));
        colors.put("CORAL", Excel2007Builder.getColor((HSSFColor)new HSSFColor.CORAL()));
        colors.put("ROYAL_BLUE", Excel2007Builder.getColor((HSSFColor)new HSSFColor.ROYAL_BLUE()));
        colors.put("LIGHT_CORNFLOWER_BLUE", Excel2007Builder.getColor((HSSFColor)new HSSFColor.LIGHT_CORNFLOWER_BLUE()));
        colors.put("TAN", Excel2007Builder.getColor((HSSFColor)new HSSFColor.TAN()));
    }

    private static class PictureStruct {
        private XSSFPicture picture;
        private int poiPictureId;

        private PictureStruct() {
        }
    }

    public static enum PictureFormatType {
        PNG,
        JPEG;

    }

    public static class PivotTableRowConfig {
        private Boolean compactForm;
        private Boolean outlineForm;

        public Boolean getCompactForm() {
            return this.compactForm;
        }

        public void setCompactForm(Boolean compactForm) {
            this.compactForm = compactForm;
        }

        public Boolean getOutlineForm() {
            return this.outlineForm;
        }

        public void setOutlineForm(Boolean outlineForm) {
            this.outlineForm = outlineForm;
        }
    }

    public static class CellArea {
        final CellCoordinate leftTop;
        final CellCoordinate rightBottom;

        public CellArea(CellCoordinate leftTop, CellCoordinate rightBottom) {
            if (leftTop == null) {
                throw new IllegalArgumentException("leftTop cannot be null");
            }
            if (rightBottom == null) {
                throw new IllegalArgumentException("rightBottom cannot be null");
            }
            if (leftTop.row > rightBottom.row) {
                throw new IllegalArgumentException("leftTop.row cannot be greater that rightBottom.row");
            }
            if (leftTop.column > rightBottom.column) {
                throw new IllegalArgumentException("leftTop.column cannot be greater that rightBottom.column");
            }
            this.leftTop = leftTop;
            this.rightBottom = rightBottom;
        }
    }

    public static class CellCoordinate {
        final int row;
        final int column;

        public CellCoordinate(int row, int column) {
            if (row < 0) {
                throw new IllegalArgumentException("row cannot be less than 0");
            }
            if (column < 0) {
                throw new IllegalArgumentException("column cannot be less than 0");
            }
            this.row = row;
            this.column = column;
        }

        public int getRow() {
            return this.row;
        }

        public int getColumn() {
            return this.column;
        }
    }
}

