/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.template.common.renderer.excel;

import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.server.reports.prepare.template.common.renderer.excel.Excel2007Builder;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Chart;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.DataConsolidateFunction;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.charts.AxisCrosses;
import org.apache.poi.ss.usermodel.charts.AxisPosition;
import org.apache.poi.ss.usermodel.charts.ChartAxis;
import org.apache.poi.ss.usermodel.charts.ChartData;
import org.apache.poi.ss.usermodel.charts.ChartDataSource;
import org.apache.poi.ss.usermodel.charts.ChartLegend;
import org.apache.poi.ss.usermodel.charts.DataSources;
import org.apache.poi.ss.usermodel.charts.LegendPosition;
import org.apache.poi.ss.usermodel.charts.LineChartData;
import org.apache.poi.ss.usermodel.charts.ValueAxis;
import org.apache.poi.ss.util.AreaReference;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFName;
import org.apache.poi.xssf.usermodel.XSSFPivotTable;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.junit.Assert;
import org.junit.Test;

public class Excel2007BuilderTest {
    @Test
    public void testPivotTable() throws FileNotFoundException, IOException {
        XSSFWorkbook workbook = new XSSFWorkbook();
        Excel2007Builder builder = new Excel2007Builder(workbook);
        XSSFSheet sourceSheet = builder.createSheet("sourceSheet");
        Excel2007BuilderTest.setCellDataOriginal(sourceSheet);
        Excel2007Builder.CellCoordinate sourceLeftTop = new Excel2007Builder.CellCoordinate(0, 0);
        Excel2007Builder.CellCoordinate sourceRightBottom = new Excel2007Builder.CellCoordinate(4, 3);
        Excel2007Builder.CellArea sourceArea = new Excel2007Builder.CellArea(sourceLeftTop, sourceRightBottom);
        builder.createSheet("destinationSheet");
        String pivotTableId = "pivotTable";
        builder.createPivotTable("sourceSheet", sourceArea, pivotTableId);
        builder.addPivotTableFilter(pivotTableId, 3);
        builder.addPivotTableRow(pivotTableId, 0, null);
        builder.addPivotTableSumColumn(pivotTableId, 1, null);
        Excel2007Builder.CellArea chartArea = new Excel2007Builder.CellArea(new Excel2007Builder.CellCoordinate(20, 20), new Excel2007Builder.CellCoordinate(30, 30));
        Excel2007Builder.CellArea chartSourceArea = new Excel2007Builder.CellArea(new Excel2007Builder.CellCoordinate(1, 1), new Excel2007Builder.CellCoordinate(4, 1));
        FileOutputStream stream = new FileOutputStream("testPivotTable.xlsx");
        workbook.write((OutputStream)stream);
        ((OutputStream)stream).close();
    }

    private static void setCellDataOriginal(XSSFSheet sheet) {
        XSSFRow row1 = sheet.createRow(0);
        XSSFCell cell11 = row1.createCell(0);
        cell11.setCellValue("Names");
        XSSFCell cell12 = row1.createCell(1);
        cell12.setCellValue("#");
        XSSFCell cell13 = row1.createCell(2);
        cell13.setCellValue("%");
        XSSFCell cell14 = row1.createCell(3);
        cell14.setCellValue("Human");
        XSSFRow row2 = sheet.createRow(1);
        XSSFCell cell21 = row2.createCell(0);
        cell21.setCellValue("Jane");
        XSSFCell cell22 = row2.createCell(1);
        cell22.setCellValue(10.0);
        XSSFCell cell23 = row2.createCell(2);
        cell23.setCellValue(100.0);
        XSSFCell cell24 = row2.createCell(3);
        cell24.setCellValue("Yes");
        XSSFRow row3 = sheet.createRow(2);
        XSSFCell cell31 = row3.createCell(0);
        cell31.setCellValue("Tarzan");
        XSSFCell cell32 = row3.createCell(1);
        cell32.setCellValue(5.0);
        XSSFCell cell33 = row3.createCell(2);
        cell33.setCellValue(90.0);
        XSSFCell cell34 = row3.createCell(3);
        cell34.setCellValue("Yes");
        XSSFRow row4 = sheet.createRow(3);
        XSSFCell cell41 = row4.createCell(0);
        cell41.setCellValue("Terk");
        XSSFCell cell42 = row4.createCell(1);
        cell42.setCellValue(10.0);
        XSSFCell cell43 = row4.createCell(2);
        cell43.setCellValue(90.0);
        XSSFCell cell44 = row4.createCell(3);
        cell44.setCellValue("No");
        XSSFRow row5 = sheet.createRow(4);
        XSSFCell cell51 = row5.createCell(0);
        cell51.setCellValue("Tarzan");
        XSSFCell cell52 = row5.createCell(1);
        cell52.setCellValue(11.0);
        XSSFCell cell53 = row5.createCell(2);
        cell53.setCellValue(91.0);
        XSSFCell cell54 = row5.createCell(3);
        cell54.setCellValue("No");
    }

    @Test
    public void exampleTest() throws Exception {
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet("linechart");
        int NUM_OF_ROWS = 3;
        int NUM_OF_COLUMNS = 10;
        for (int rowIndex = 0; rowIndex < 3; ++rowIndex) {
            XSSFRow row = sheet.createRow((int)((short)rowIndex));
            for (int colIndex = 0; colIndex < 10; ++colIndex) {
                Cell cell = row.createCell((int)((short)colIndex));
                cell.setCellValue((double)(colIndex * (rowIndex + 1)));
            }
        }
        XSSFDrawing drawing = sheet.createDrawingPatriarch();
        ClientAnchor anchor = drawing.createAnchor(0, 0, 0, 0, 0, 5, 10, 15);
        Chart chart = drawing.createChart(anchor);
        ChartLegend legend = chart.getOrCreateLegend();
        legend.setPosition(LegendPosition.TOP_RIGHT);
        LineChartData data = chart.getChartDataFactory().createLineChartData();
        ChartAxis bottomAxis = chart.getChartAxisFactory().createCategoryAxis(AxisPosition.BOTTOM);
        ValueAxis leftAxis = chart.getChartAxisFactory().createValueAxis(AxisPosition.LEFT);
        leftAxis.setCrosses(AxisCrosses.AUTO_ZERO);
        ChartDataSource xs = DataSources.fromNumericCellRange((Sheet)sheet, (CellRangeAddress)new CellRangeAddress(0, 0, 0, 9));
        ChartDataSource ys1 = DataSources.fromNumericCellRange((Sheet)sheet, (CellRangeAddress)new CellRangeAddress(1, 1, 0, 9));
        ChartDataSource ys2 = DataSources.fromNumericCellRange((Sheet)sheet, (CellRangeAddress)new CellRangeAddress(2, 2, 0, 9));
        data.addSeries(xs, ys1);
        data.addSeries(xs, ys2);
        chart.plot((ChartData)data, new ChartAxis[]{bottomAxis, leftAxis});
        FileOutputStream fileOut = new FileOutputStream("ooxml-line-chart.xlsx");
        wb.write((OutputStream)fileOut);
        fileOut.close();
    }

    @Test
    public void testPivotTableOrig() throws FileNotFoundException, IOException, InvalidFormatException {
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet();
        Excel2007BuilderTest.setCellData(sheet);
        XSSFPivotTable pivotTable = sheet.createPivotTable(new AreaReference("A1:D4"), new CellReference("H5"));
        pivotTable.addRowLabel(0);
        pivotTable.addColumnLabel(DataConsolidateFunction.SUM, 1);
        pivotTable.addColumnLabel(DataConsolidateFunction.AVERAGE, 2);
        pivotTable.addReportFilter(3);
        FileOutputStream fileOut = new FileOutputStream("ooxml-pivottable.xlsx");
        wb.write((OutputStream)fileOut);
        fileOut.close();
    }

    public static void setCellData(XSSFSheet sheet) {
        XSSFRow row1 = sheet.createRow(0);
        Cell cell11 = row1.createCell(0);
        cell11.setCellValue("Names");
        Cell cell12 = row1.createCell(1);
        cell12.setCellValue("#");
        Cell cell13 = row1.createCell(2);
        cell13.setCellValue("%");
        Cell cell14 = row1.createCell(3);
        cell14.setCellValue("Human");
        XSSFRow row2 = sheet.createRow(1);
        Cell cell21 = row2.createCell(0);
        cell21.setCellValue("Jane");
        Cell cell22 = row2.createCell(1);
        cell22.setCellValue(10.0);
        Cell cell23 = row2.createCell(2);
        cell23.setCellValue(100.0);
        Cell cell24 = row2.createCell(3);
        cell24.setCellValue("Yes");
        XSSFRow row3 = sheet.createRow(2);
        Cell cell31 = row3.createCell(0);
        cell31.setCellValue("Tarzan");
        Cell cell32 = row3.createCell(1);
        cell32.setCellValue(5.0);
        Cell cell33 = row3.createCell(2);
        cell33.setCellValue(90.0);
        Cell cell34 = row3.createCell(3);
        cell34.setCellValue("Yes");
        XSSFRow row4 = sheet.createRow(3);
        Cell cell41 = row4.createCell(0);
        cell41.setCellValue("Terk");
        Cell cell42 = row4.createCell(1);
        cell42.setCellValue(10.0);
        Cell cell43 = row4.createCell(2);
        cell43.setCellValue(90.0);
        Cell cell44 = row4.createCell(3);
        cell44.setCellValue("No");
    }

    @Test
    public void testReadTemplate() throws FileNotFoundException, IOException {
        byte[] content = FileUtils.readFileToByteArray((File)IoUtil.url2file((URL)this.getClass().getResource("testTemplate.xlsx")));
        XSSFWorkbook workbook = new XSSFWorkbook((InputStream)new ByteArrayInputStream(content));
        XSSFSheet sheet = workbook.getSheet("Sheet1");
        int valueCount = 50;
        for (int i = 1; i <= valueCount; ++i) {
            XSSFRow row = sheet.createRow(i - 1);
            row.getCell(0, Row.CREATE_NULL_AS_BLANK).setCellValue((double)i);
            row.getCell(2, Row.CREATE_NULL_AS_BLANK).setCellValue(Character.toString((char)(65 + (i - 1))));
        }
        XSSFName name = workbook.getName("sourceValues");
        name.setRefersToFormula("Sheet1!$A$1:$A$" + valueCount);
        name = workbook.getName("sourceNames");
        name.setRefersToFormula("Sheet1!$C$1:$C$" + valueCount);
        XSSFDrawing drawing = (XSSFDrawing)sheet.getRelations().get(1);
        System.out.println(drawing.getCTDrawing().xmlText());
        int chartRowHeight = 16;
        int chartRowOffset = 1;
        drawing.getCTDrawing().getTwoCellAnchorArray(0).getFrom().setRow(valueCount + chartRowOffset);
        drawing.getCTDrawing().getTwoCellAnchorArray(0).getTo().setRow(valueCount + chartRowOffset + chartRowHeight);
        FileOutputStream stream = new FileOutputStream(new File("temp/testTemplateModified.xlsx"));
        workbook.write((OutputStream)stream);
        ((OutputStream)stream).close();
    }

    @Test
    public void textDoesntThrowExceptionIfValueIsTooLong() {
        this.textDoesntThrowExceptionIfValueIsTooLongLogic(Short.MAX_VALUE);
        this.textDoesntThrowExceptionIfValueIsTooLongLogic(32768);
        this.textDoesntThrowExceptionIfValueIsTooLongLogic(32769);
    }

    @Test
    public void textDefaultScenario() {
        XSSFWorkbook wb = new XSSFWorkbook();
        Excel2007Builder builder = new Excel2007Builder(wb);
        builder.text("Hello", "text", 1, 1);
        Assert.assertEquals((Object)"Hello", (Object)wb.getSheetAt(0).getRow(0).getCell(0).getStringCellValue());
    }

    @Test
    public void textDoesntThrowExceptionIfValueIsNull() {
        XSSFWorkbook wb = new XSSFWorkbook();
        Excel2007Builder builder = new Excel2007Builder(wb);
        builder.text(null, "text", 1, 1);
    }

    protected void textDoesntThrowExceptionIfValueIsTooLongLogic(int length) {
        XSSFWorkbook wb = new XSSFWorkbook();
        Excel2007Builder builder = new Excel2007Builder(wb);
        builder.text(RandomStringUtils.random((int)length), "text", 1, 1);
    }
}

