/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.template.common.renderer.excel;

import com.gridnine.xtrip.common.util.TextUtil;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.FontUnderline;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class Excel2007CellStyle {
    private final XSSFCellStyle style;
    private final XSSFWorkbook wb;
    private short horizontalSpan = 1;
    private short verticalSpan = 1;
    private final XSSFFont font;

    public XSSFCellStyle getStyle() {
        return this.style;
    }

    public Excel2007CellStyle(XSSFWorkbook workbook) {
        this.wb = workbook;
        this.style = workbook.createCellStyle();
        this.font = workbook.createFont();
        this.style.setFont((Font)this.font);
    }

    public void setParentStyle(Excel2007CellStyle parentStyle) {
        this.style.cloneStyleFrom((CellStyle)parentStyle.getStyle());
        this.font.setCharSet(parentStyle.font.getCharSet());
        this.font.setColor(parentStyle.font.getColor());
        this.font.setFontHeightInPoints(parentStyle.font.getFontHeightInPoints());
        this.font.setFontName(parentStyle.font.getFontName());
        this.font.setItalic(parentStyle.font.getItalic());
        this.font.setStrikeout(parentStyle.font.getStrikeout());
        this.font.setTypeOffset(parentStyle.font.getTypeOffset());
        this.font.setUnderline(parentStyle.font.getUnderline());
        this.font.setBoldweight(parentStyle.font.getBoldweight());
        this.style.setFont((Font)this.font);
        this.horizontalSpan = parentStyle.horizontalSpan;
        this.verticalSpan = parentStyle.verticalSpan;
    }

    public void setHorizontalAlignment(String value) {
        this.style.setAlignment(Excel2007CellStyle.findEnum(HorizontalAlignment.GENERAL, value).getHorizontalAlignment());
    }

    public void setVerticalAlignment(String value) {
        this.style.setVerticalAlignment(Excel2007CellStyle.findEnum(VerticalAlignment.CENTER, value).getVerticalAlignment());
    }

    public void setBorderLeft(String value) {
        this.style.setBorderLeft(Excel2007CellStyle.findEnum(BorderWidth.NONE, value).getBorderWidth());
    }

    public void setWrapText(boolean value) {
        this.style.setWrapText(value);
    }

    public void setBorderRight(String value) {
        this.style.setBorderRight(Excel2007CellStyle.findEnum(BorderWidth.NONE, value).getBorderWidth());
    }

    public void setBorderBottom(String value) {
        this.style.setBorderBottom(Excel2007CellStyle.findEnum(BorderWidth.NONE, value).getBorderWidth());
    }

    public void setBorderTop(String value) {
        this.style.setBorderTop(Excel2007CellStyle.findEnum(BorderWidth.NONE, value).getBorderWidth());
    }

    public void setFontFamily(String value) {
        this.font.setFontName(value);
    }

    public void setFontHeight(short value) {
        this.font.setFontHeightInPoints(value);
    }

    public void setFontBold(boolean value) {
        this.font.setBoldweight(value ? (short)700 : 400);
    }

    public void setFontItalic(boolean value) {
        this.font.setItalic(value);
    }

    public void setFontColor(XSSFColor color) {
        this.font.setColor(color);
    }

    public void setFontUnderline(String value) {
        this.font.setUnderline(Excel2007CellStyle.findEnum(FontUnderline.NONE, value));
    }

    public void setHorizontalSpan(short value) {
        this.horizontalSpan = value;
    }

    public short getHorizontalSpan() {
        return this.horizontalSpan;
    }

    public void setVerticalSpan(short value) {
        this.verticalSpan = value;
    }

    public short getVerticalSpan() {
        return this.verticalSpan;
    }

    public void setFormat(String format) {
        this.style.setDataFormat(this.wb.createDataFormat().getFormat(TextUtil.isBlank((String)format) ? "General" : format));
    }

    public void setLocked(boolean locked) {
        this.style.setLocked(locked);
    }

    private static <E extends Enum<E>> E findEnum(E defaultValue, String value) {
        for (Enum item : (Enum[])defaultValue.getDeclaringClass().getEnumConstants()) {
            if (!item.name().equals(value)) continue;
            return (E)item;
        }
        return defaultValue;
    }

    static enum BorderWidth {
        NONE{

            @Override
            short getBorderWidth() {
                return 0;
            }
        }
        ,
        THIN{

            @Override
            short getBorderWidth() {
                return 1;
            }
        }
        ,
        MEDIUM{

            @Override
            short getBorderWidth() {
                return 2;
            }
        }
        ,
        DASHED{

            @Override
            short getBorderWidth() {
                return 3;
            }
        }
        ,
        DOTTED{

            @Override
            short getBorderWidth() {
                return 4;
            }
        }
        ,
        THICK{

            @Override
            short getBorderWidth() {
                return 5;
            }
        }
        ,
        DOUBLE{

            @Override
            short getBorderWidth() {
                return 6;
            }
        }
        ,
        HAIR{

            @Override
            short getBorderWidth() {
                return 7;
            }
        }
        ,
        MEDIUM_DASHED{

            @Override
            short getBorderWidth() {
                return 8;
            }
        }
        ,
        DASH_DOT{

            @Override
            short getBorderWidth() {
                return 9;
            }
        }
        ,
        MEDIUM_DASH_DOT{

            @Override
            short getBorderWidth() {
                return 10;
            }
        }
        ,
        DASH_DOT_DOT{

            @Override
            short getBorderWidth() {
                return 11;
            }
        }
        ,
        MEDIUM_DASH_DOT_DOT{

            @Override
            short getBorderWidth() {
                return 11;
            }
        }
        ,
        SLANTED_DASH_DOT{

            @Override
            short getBorderWidth() {
                return 13;
            }
        };


        abstract short getBorderWidth();
    }

    static enum VerticalAlignment {
        TOP{

            @Override
            short getVerticalAlignment() {
                return 0;
            }
        }
        ,
        CENTER{

            @Override
            short getVerticalAlignment() {
                return 1;
            }
        }
        ,
        BOTTOM{

            @Override
            short getVerticalAlignment() {
                return 2;
            }
        }
        ,
        VERTICAL_JUSTIFY{

            @Override
            short getVerticalAlignment() {
                return 3;
            }
        };


        abstract short getVerticalAlignment();
    }

    static enum HorizontalAlignment {
        GENERAL{

            @Override
            short getHorizontalAlignment() {
                return 0;
            }
        }
        ,
        LEFT{

            @Override
            short getHorizontalAlignment() {
                return 1;
            }
        }
        ,
        CENTER{

            @Override
            short getHorizontalAlignment() {
                return 2;
            }
        }
        ,
        RIGHT{

            @Override
            short getHorizontalAlignment() {
                return 3;
            }
        }
        ,
        FILL{

            @Override
            short getHorizontalAlignment() {
                return 4;
            }
        }
        ,
        ALIGN_JUSTIFY{

            @Override
            short getHorizontalAlignment() {
                return 5;
            }
        };


        abstract short getHorizontalAlignment();
    }

    static enum FontBoldWeight {
        NORMAL{

            @Override
            short getBoldweight() {
                return 400;
            }
        }
        ,
        BOLD{

            @Override
            short getBoldweight() {
                return 700;
            }
        };


        abstract short getBoldweight();
    }
}

