/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.template.common.renderer.excel;

import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.RequestedParameterValue;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportPageDescription;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportParameters;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.server.model.helpers.GroovyShellHelper;
import com.gridnine.xtrip.server.reports.prepare.template.common.renderer.excel.Excel2007Builder;
import com.gridnine.xtrip.server.reports.prepare.template.common.renderer.excel.PivotTableHelper;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyShell;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.codehaus.groovy.runtime.MethodClosure;

public class Excel2007GroovyScriptExecutor {
    public <T, D extends BaseTemplateReportPageDescription> XSSFWorkbook execute(XSSFWorkbook report, byte[] template, List<T> tickets, Map<String, Object> parameters, List<Message> messages) throws Exception {
        Binding binding = new Binding();
        GroovyShell shell = new GroovyShell(binding);
        XSSFWorkbook result = report == null ? new XSSFWorkbook() : report;
        Excel2007Builder builder = new Excel2007Builder(result);
        this.fillBinding(binding, builder, tickets, parameters, shell, messages);
        GroovyShellHelper.wrapShellIntoCacheDecorator((GroovyShell)shell).evaluate(template);
        if (report == null && !builder.isPageAdded()) {
            return null;
        }
        return result;
    }

    private <T, D extends BaseTemplateReportPageDescription> void fillBinding(Binding binding, Excel2007Builder builder, List<T> tickets, Map<String, Object> parameters, GroovyShell shell, List<Message> messages) throws Exception {
        ValueHolder ticketsHolder = new ValueHolder(tickets);
        binding.setVariable("reportContent", (Object)new MethodClosure((Object)new ReportContentClosure(parameters), "doAction"));
        binding.setVariable("setStyle", (Object)new MethodClosure((Object)new SetStyleClosure(builder), "doAction"));
        binding.setVariable("createStyle", (Object)new MethodClosure((Object)new CreateStyleClosure(builder), "doAction"));
        binding.setVariable("columnWidth", (Object)new MethodClosure((Object)new ColumnWidthClosure(builder), "doAction"));
        binding.setVariable("rowHeight", (Object)new MethodClosure((Object)new RowHeightClosure(builder), "doAction"));
        binding.setVariable("createSheet", (Object)new MethodClosure((Object)new CreateSheetClosure(builder), "doAction"));
        binding.setVariable("preserve", (Object)new MethodClosure((Object)new PreserveClosure(builder), "doAction"));
        binding.setVariable("freeze", (Object)new MethodClosure((Object)new FreezeClosure(builder), "doAction"));
        binding.setVariable("rowBreak", (Object)new MethodClosure((Object)new RowBreakClosure(builder), "doAction"));
        binding.setVariable("columnBreak", (Object)new MethodClosure((Object)new ColumnBreakClosure(builder), "doAction"));
        binding.setVariable("landscape", (Object)new MethodClosure((Object)new LandscapeClosure(builder), "doAction"));
        binding.setVariable("fitWidth", (Object)new MethodClosure((Object)new FitWidthClosure(builder), "doAction"));
        binding.setVariable("fitHeight", (Object)new MethodClosure((Object)new FitHeightClosure(builder), "doAction"));
        binding.setVariable("scale", (Object)new MethodClosure((Object)new ScaleClosure(builder), "doAction"));
        binding.setVariable("margin", (Object)new MethodClosure((Object)new MarginClosure(builder), "doAction"));
        binding.setVariable("marginLeft", (Object)new MethodClosure((Object)new MarginLeftClosure(builder), "doAction"));
        binding.setVariable("marginRight", (Object)new MethodClosure((Object)new MarginRightClosure(builder), "doAction"));
        binding.setVariable("marginTop", (Object)new MethodClosure((Object)new MarginTopClosure(builder), "doAction"));
        binding.setVariable("marginBottom", (Object)new MethodClosure((Object)new MarginBottomClosure(builder), "doAction"));
        binding.setVariable("protect", (Object)new MethodClosure((Object)new ProtectClosure(builder), "doAction"));
        binding.setVariable("nextColumn", (Object)new MethodClosure((Object)new NextColumnClosure(builder), "doAction"));
        binding.setVariable("nextRow", (Object)new MethodClosure((Object)new NextRowClosure(builder), "doAction"));
        binding.setVariable("cellIndex", (Object)new MethodClosure((Object)new CellIndexClosure(builder), "doAction"));
        binding.setVariable("text", (Object)new MethodClosure((Object)new TextClosure(builder), "doAction"));
        binding.setVariable("textnc", (Object)new MethodClosure((Object)new TextNCClosure(builder), "doAction"));
        binding.setVariable("number", (Object)new MethodClosure((Object)new NumberClosure(builder), "doAction"));
        binding.setVariable("numbernc", (Object)new MethodClosure((Object)new NumberNCClosure(builder), "doAction"));
        binding.setVariable("date", (Object)new MethodClosure((Object)new DateClosure(builder), "doAction"));
        binding.setVariable("bool", (Object)new MethodClosure((Object)new BooleanClosure(builder), "doAction"));
        binding.setVariable("formula", (Object)new MethodClosure((Object)new FormulaClosure(builder), "doAction"));
        binding.setVariable("picture", (Object)new MethodClosure((Object)new PictureClosure(builder), "doAction"));
        binding.setVariable("tickets", (Object)new MethodClosure(new TicketsClosure(ticketsHolder, shell), "doAction"));
        binding.setVariable("count", (Object)new MethodClosure(new CountClosure(ticketsHolder), "doAction"));
        binding.setVariable("groups", (Object)new MethodClosure(new GroupClosure(ticketsHolder, shell), "doAction"));
        Object allowEmpty = parameters.get("allow-empty-report");
        if (allowEmpty == null) {
            allowEmpty = Boolean.FALSE;
        }
        binding.setVariable("autoFilter", (Object)new MethodClosure((Object)new FilterClosure(builder), "doAction"));
        binding.setVariable("page", (Object)new MethodClosure(new PageClosure(ticketsHolder, shell, builder, (Boolean)allowEmpty), "doAction"));
        binding.setVariable("existingPage", (Object)new MethodClosure(new ExistingPageClosure(ticketsHolder, shell, builder, (Boolean)allowEmpty), "doAction"));
        binding.setVariable("error", (Object)new MethodClosure((Object)new ErrorClosure(MessageType.ERROR, messages), "doAction"));
        binding.setVariable("info", (Object)new MethodClosure((Object)new ErrorClosure(MessageType.MESSAGE, messages), "doAction"));
        binding.setVariable("warn", (Object)new MethodClosure((Object)new ErrorClosure(MessageType.WARNING, messages), "doAction"));
        binding.setVariable("message", (Object)new MethodClosure((Object)new MessageClosure(messages), "doAction"));
        binding.setVariable("parameters", new HashMap<String, Object>(parameters));
        binding.setVariable("requestedParameter", (Object)new MethodClosure((Object)new RequestedParameterClosure(parameters), "doAction"));
        binding.setProperty("allTickets", tickets);
        binding.setVariable("pivotTable", (Object)new MethodClosure((Object)new PivotTableHelper.PivotTableClosure(builder), "doAction"));
        binding.setVariable("namedRange", (Object)new MethodClosure((Object)new RedefineNamgedRangeClosure(builder), "doAction"));
        binding.setVariable("shiftChart", (Object)new MethodClosure((Object)new ShiftChartClosure(builder), "doAction"));
        binding.setVariable("switchPage", (Object)new MethodClosure((Object)new SwitchPageClosure(builder), "doAction"));
        binding.setVariable("moveTo", (Object)new MethodClosure((Object)new MoveToClosure(builder), "doAction"));
        binding.setVariable("getRowIndex", (Object)new MethodClosure((Object)new GetRowIndexClosure(builder), "doAction"));
        binding.setVariable("getColumnIndex", (Object)new MethodClosure((Object)new GetColumnIndexClosure(builder), "doAction"));
        binding.setVariable("getColumnName", (Object)new MethodClosure((Object)new GetColumnNameClosure(builder), "doAction"));
        binding.setVariable("setDefaultSheet", (Object)new MethodClosure((Object)new SetDefaultSheetClosure(builder), "doAction"));
        binding.setVariable("addPicture", (Object)new MethodClosure((Object)new AddPictureClosure(builder), "doAction"));
        binding.setVariable("getPictureRightBottom", (Object)new MethodClosure((Object)new GetPictureRightBottomClosure(builder), "doAction"));
        binding.setVariable("rowAutoHeight", (Object)new MethodClosure((Object)new RowAutoHeightClosure(builder), "doAction"));
        binding.setVariable("columnAutoWidth", (Object)new MethodClosure((Object)new ColumnAutoWidthClosure(builder), "doAction"));
        binding.setVariable("removeSheet", (Object)new MethodClosure((Object)new RemoveSheetClosure(builder), "doAction"));
    }

    public <T, D extends BaseTemplateReportPageDescription> XSSFWorkbook execute(XSSFWorkbook report, byte[] template, List<T> tickets, Map<String, Object> parameters, List<Message> messages, Binding binding) throws Exception {
        GroovyShell shell = new GroovyShell(binding);
        XSSFWorkbook result = report == null ? new XSSFWorkbook() : report;
        Excel2007Builder builder = new Excel2007Builder(result);
        this.fillBinding(binding, builder, tickets, parameters, shell, messages);
        shell.evaluate(new String(template, StandardCharsets.UTF_8));
        if (report == null && !builder.isPageAdded()) {
            return null;
        }
        return result;
    }

    public class RemoveSheetClosure {
        private final Excel2007Builder builder;

        public RemoveSheetClosure(Excel2007Builder builder) {
            this.builder = builder;
        }

        public void doAction(String sheetName) {
            this.builder.removeSheet(sheetName);
        }
    }

    public class ColumnAutoWidthClosure {
        private final Excel2007Builder builder;

        ColumnAutoWidthClosure(Excel2007Builder builder) {
            this.builder = builder;
        }

        public void doAction() {
            this.builder.columnAutoWidth();
        }

        public void doAction(boolean useMergedCells) {
            this.builder.columnAutoWidth(useMergedCells);
        }
    }

    public class RowAutoHeightClosure {
        private final Excel2007Builder builder;

        RowAutoHeightClosure(Excel2007Builder builder) {
            this.builder = builder;
        }

        public void doAction() {
            this.builder.rowAutoHeight();
        }
    }

    static class GetPictureRightBottomClosure {
        private final Excel2007Builder builder;

        GetPictureRightBottomClosure(Excel2007Builder builder) {
            this.builder = builder;
        }

        public Excel2007Builder.CellCoordinate doAction(int pictureId) {
            return this.builder.getPictureRightBottom(pictureId);
        }
    }

    static class AddPictureClosure {
        private final Excel2007Builder builder;

        AddPictureClosure(Excel2007Builder builder) {
            this.builder = builder;
        }

        public int doAction(byte[] content, Excel2007Builder.PictureFormatType formatType) {
            return this.builder.addPicture(content, formatType);
        }
    }

    static class SetDefaultSheetClosure {
        private final Excel2007Builder builder;

        SetDefaultSheetClosure(Excel2007Builder excelBuilder) {
            this.builder = excelBuilder;
        }

        public void doAction(String sheetName) {
            this.builder.setDefaultSheet(sheetName);
        }
    }

    static class SwitchPageClosure {
        private final Excel2007Builder builder;

        SwitchPageClosure(Excel2007Builder excelBuilder) {
            this.builder = excelBuilder;
        }

        public void doAction(String sheetName) {
            this.builder.navigateToSheet(sheetName);
        }
    }

    static class ShiftChartClosure {
        private final Excel2007Builder builder;

        ShiftChartClosure(Excel2007Builder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(int chartIndex, int row, int column) {
            this.builder.shiftChart(chartIndex, row, column);
        }

        void doAction(int row, int column) {
            this.builder.shiftChart(0, row, column);
        }

        void doAction(Map<String, Object> params) {
            int chartIndex = 0;
            Integer idx = (Integer)params.get("index");
            if (idx != null) {
                chartIndex = idx;
            }
            Integer row = (Integer)params.get("row");
            Integer column = (Integer)params.get("column");
            this.builder.shiftChart(chartIndex, row, column);
        }
    }

    static class RedefineNamgedRangeClosure {
        private final Excel2007Builder builder;

        RedefineNamgedRangeClosure(Excel2007Builder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(String rangeName, String referenceFormula) {
            this.builder.redefineNamedRange(rangeName, referenceFormula);
        }
    }

    static class RequestedParameterClosure {
        private final Map<String, Object> parameters;

        RequestedParameterClosure(Map<String, Object> parameters) {
            this.parameters = parameters;
        }

        Object doAction(String key) {
            BaseTemplateReportParameters templateReportParameters = (BaseTemplateReportParameters)this.parameters.get("key-report-params");
            for (RequestedParameterValue requestedParameterValue : templateReportParameters.getRequestedParameters()) {
                if (!TextUtil.isSame((String)requestedParameterValue.getKey(), (String)key)) continue;
                return requestedParameterValue.getValue();
            }
            return null;
        }
    }

    static class ReportContentClosure {
        private final Map<String, Object> parameters;

        ReportContentClosure(Map<String, Object> parameters) {
            this.parameters = parameters;
        }

        public void doAction(byte[] content) {
            this.parameters.put("report-content", content);
        }
    }

    static class MessageClosure {
        private final List<Message> messages;

        MessageClosure(List<Message> msgs) {
            this.messages = msgs;
        }

        public void doAction(Message msg) {
            this.messages.add(msg);
        }
    }

    static class ErrorClosure {
        private final MessageType type;
        private final List<Message> messages;

        ErrorClosure(MessageType type, List<Message> msgs) {
            this.type = type;
            this.messages = msgs;
        }

        public void doAction(String msg) {
            this.messages.add(SystemHelper.createMessage((MessageType)this.type, (String)msg, (Object[])new Object[0]));
        }

        public void doAction(Message msg) {
            Message msg2 = SystemHelper.createMessage((MessageType)this.type, (String)msg.getMessage().toString(), (Object[])new Object[0]);
            msg2.setDetails(msg.getDetails());
            this.messages.add(msg2);
        }

        public void doAction(String msg, Throwable t) {
            this.messages.add(MessagesHelper.createMessage((MessageType)this.type, (String)msg, (Throwable)t, (Object[])new Object[0]));
        }

        public void doAction(Object msg, Object ... parameters) {
            this.messages.add(SystemHelper.createMessage((MessageType)this.type, (String)msg.toString(), (Object[])parameters));
        }

        public void doAction(Object msg, Throwable t, Object ... parameters) {
            this.messages.add(MessagesHelper.createMessage((MessageType)this.type, (String)msg.toString(), (Throwable)t, (Object[])parameters));
        }
    }

    static class CellIndexClosure {
        private final Excel2007Builder builder;

        CellIndexClosure(Excel2007Builder excelBuilder) {
            this.builder = excelBuilder;
        }

        String doAction(Number rowShift, Number columnShift) {
            return this.builder.cellIndex(rowShift.intValue(), columnShift.intValue());
        }

        String doAction() {
            return this.builder.cellIndex(0, 0);
        }
    }

    static class GroupClosure<T>
    extends BaseGroupClosure<T> {
        GroupClosure(ValueHolder<List<T>> ticketsHolder, GroovyShell shell) {
            super(ticketsHolder, shell, false);
        }
    }

    static class ExistingPageClosure<T>
    extends BaseGroupClosure<T> {
        private final Excel2007Builder builder;

        ExistingPageClosure(ValueHolder<List<T>> ticketsHolder, GroovyShell shell, Excel2007Builder excelBuilder, boolean allowEmptyReport) {
            super(ticketsHolder, shell, allowEmptyReport);
            this.builder = excelBuilder;
        }

        @Override
        protected void beforeSectionStarted(String value, List<T> key) {
            this.builder.navigateToSheet(value);
        }
    }

    static class PageClosure<T>
    extends BaseGroupClosure<T> {
        private final Excel2007Builder builder;

        PageClosure(ValueHolder<List<T>> ticketsHolder, GroovyShell shell, Excel2007Builder excelBuilder, boolean allowEmptyReport) {
            super(ticketsHolder, shell, allowEmptyReport);
            this.builder = excelBuilder;
        }

        @Override
        protected void beforeSectionStarted(String value, List<T> key) {
            this.builder.createSheet(value);
        }
    }

    static class FilterClosure {
        private final Excel2007Builder builder;

        FilterClosure(Excel2007Builder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(String name, String range) {
            this.builder.setAutoFilter(name, range);
        }
    }

    static abstract class BaseGroupClosure<T> {
        private final Object delegate;
        private final ValueHolder<List<T>> holder;
        private final boolean allowEmptyReport;

        BaseGroupClosure(ValueHolder<List<T>> ticketsHolder, GroovyShell shell, boolean allowEmptyReport) {
            this.holder = ticketsHolder;
            this.delegate = shell;
            this.allowEmptyReport = allowEmptyReport;
        }

        void doAction(Closure<?> cl) {
            this.doAction(null, cl);
        }

        void doAction(Closure<String> triggerCl, Closure<?> cl) {
            cl.setDelegate(this.delegate);
            LinkedHashMap batches = new LinkedHashMap();
            String lastValue = null;
            ArrayList lastColl = null;
            List originalItems = (List)this.holder.getValue();
            if (originalItems.size() == 0 && this.allowEmptyReport) {
                Object[] n = new Object[]{null};
                String string = triggerCl == null ? "default" : (String)triggerCl.call(n);
                this.beforeSectionStarted(string, null);
                cl.call(n);
                return;
            }
            for (Object e : originalItems) {
                String value;
                String string = value = triggerCl == null ? "default" : (String)triggerCl.call(e);
                if (value == null) {
                    value = "";
                }
                if (lastColl == null || !value.equals(lastValue)) {
                    lastValue = value;
                    lastColl = new ArrayList();
                    batches.put(lastColl, value);
                }
                lastColl.add(e);
            }
            for (Map.Entry entry : batches.entrySet()) {
                this.holder.setValue(entry.getKey());
                this.beforeSectionStarted((String)entry.getValue(), (List)entry.getKey());
                cl.call(entry.getValue());
            }
            this.holder.setValue((Object)originalItems);
        }

        protected void beforeSectionStarted(String value, List<T> key) {
        }
    }

    static class CountClosure<T> {
        private final ValueHolder<List<T>> items;

        CountClosure(ValueHolder<List<T>> ticketsHolder) {
            this.items = ticketsHolder;
        }

        int doAction(Closure<?> cl) {
            return ((List)this.items.getValue()).size();
        }
    }

    static class TicketsClosure<T> {
        private final ValueHolder<List<T>> items;
        private final Object delegate;

        TicketsClosure(ValueHolder<List<T>> ticketsHolder, GroovyShell shell) {
            this.items = ticketsHolder;
            this.delegate = shell;
        }

        void doAction(Closure<?> cl) {
            cl.setDelegate(this.delegate);
            for (Object item : (List)this.items.getValue()) {
                cl.call(item);
            }
        }
    }

    static class RowHeightClosure {
        private final Excel2007Builder builder;

        RowHeightClosure(Excel2007Builder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(Number value, boolean preserve) {
            this.builder.setCurrentRowHeight(value.floatValue(), preserve);
        }

        void doAction(Number value) {
            this.doAction(Float.valueOf(value.floatValue()), true);
        }
    }

    static class ColumnWidthClosure {
        private final Excel2007Builder builder;

        ColumnWidthClosure(Excel2007Builder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(Number value) {
            this.builder.setCurrentColumnWidth(value.intValue());
        }
    }

    static class PictureClosure {
        private final Excel2007Builder builder;

        PictureClosure(Excel2007Builder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(int col1, int col2, int row1, int row2, byte[] picture, int pictureType) {
            this.builder.picture(col1, col2, row1, row2, picture, pictureType, Double.MAX_VALUE, Double.MAX_VALUE);
        }

        void doAction(int col1, int col2, int row1, int row2, byte[] picture, int pictureType, double scale) {
            this.builder.picture(col1, col2, row1, row2, picture, pictureType, scale, scale);
        }

        void doAction(int col1, int col2, int row1, int row2, byte[] picture, int pictureType, double xScale, double yScale) {
            this.builder.picture(col1, col2, row1, row2, picture, pictureType, xScale, yScale);
        }
    }

    static class FormulaClosure {
        private final Excel2007Builder builder;

        FormulaClosure(Excel2007Builder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(String value, String style, int hspan, int vspan) {
            this.builder.formula(value, style, hspan, vspan);
        }

        void doAction(String value, String style) {
            this.doAction(value, style, 0, 0);
        }

        void doAction(String value) {
            this.doAction(value, null, 0, 0);
        }
    }

    static class BooleanClosure {
        private final Excel2007Builder builder;

        BooleanClosure(Excel2007Builder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(Boolean value, String style, int hspan, int vspan) {
            this.builder.bool(value, style, hspan, vspan);
        }

        void doAction(Boolean value, String style) {
            this.doAction(value, style, 0, 0);
        }

        void doAction(Boolean value) {
            this.doAction(value, null, 0, 0);
        }
    }

    static class DateClosure {
        private final Excel2007Builder builder;

        DateClosure(Excel2007Builder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(Date value, String style, int hspan, int vspan) {
            this.builder.date(value, style, hspan, vspan);
        }

        void doAction(Date value, String style) {
            this.doAction(value, style, 0, 0);
        }

        void doAction(Date value) {
            this.doAction(value, null, 0, 0);
        }
    }

    static class NumberNCClosure {
        private final Excel2007Builder builder;

        NumberNCClosure(Excel2007Builder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(BigDecimal value, String style, int hspan, int vspan) {
            this.builder.numbernc(value, style, hspan, vspan);
        }

        void doAction(BigDecimal value, String style) {
            this.doAction(value, style, 0, 0);
        }

        void doAction(BigDecimal value) {
            this.doAction(value, null, 0, 0);
        }
    }

    static class NumberClosure {
        private final Excel2007Builder builder;

        NumberClosure(Excel2007Builder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(BigDecimal value, String style, int hspan, int vspan) {
            this.builder.number(value, style, hspan, vspan);
        }

        void doAction(BigDecimal value, String style) {
            this.doAction(value, style, 0, 0);
        }

        void doAction(BigDecimal value) {
            this.doAction(value, null, 0, 0);
        }
    }

    static class TextNCClosure {
        private final Excel2007Builder builder;

        TextNCClosure(Excel2007Builder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(String value, String style, int hspan, int vspan) {
            this.builder.textnc(value, style, hspan, vspan);
        }

        void doAction(String value, String style) {
            this.doAction(value, style, 0, 0);
        }

        void doAction(String value) {
            this.doAction(value, null, 0, 0);
        }
    }

    static class TextClosure {
        private final Excel2007Builder builder;

        TextClosure(Excel2007Builder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(String value, String style, int hspan, int vspan) {
            this.builder.text(value, style, hspan, vspan);
        }

        void doAction(String value, String style) {
            this.doAction(value, style, 0, 0);
        }

        void doAction(String value) {
            this.doAction(value, null, 0, 0);
        }
    }

    static class ProtectClosure {
        private final Excel2007Builder builder;

        ProtectClosure(Excel2007Builder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction() {
            this.builder.protect(DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EXCEL_PASSWORD, (String)""));
        }
    }

    static class MarginBottomClosure {
        private final Excel2007Builder builder;

        MarginBottomClosure(Excel2007Builder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(double size) {
            this.builder.marginBottom(size);
        }
    }

    static class MarginTopClosure {
        private final Excel2007Builder builder;

        MarginTopClosure(Excel2007Builder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(double size) {
            this.builder.marginTop(size);
        }
    }

    static class MarginRightClosure {
        private final Excel2007Builder builder;

        MarginRightClosure(Excel2007Builder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(double size) {
            this.builder.marginRight(size);
        }
    }

    static class MarginLeftClosure {
        private final Excel2007Builder builder;

        MarginLeftClosure(Excel2007Builder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(double size) {
            this.builder.marginLeft(size);
        }
    }

    static class MarginClosure {
        private final Excel2007Builder builder;

        MarginClosure(Excel2007Builder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(double left, double right, double top, double bottom) {
            this.builder.margin(left, right, top, bottom);
        }
    }

    static class ScaleClosure {
        private final Excel2007Builder builder;

        ScaleClosure(Excel2007Builder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(int scale) {
            this.builder.scale(scale);
        }
    }

    static class FitHeightClosure {
        private final Excel2007Builder builder;

        FitHeightClosure(Excel2007Builder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(int fitHeight) {
            this.builder.fitHeight(fitHeight);
        }
    }

    static class FitWidthClosure {
        private final Excel2007Builder builder;

        FitWidthClosure(Excel2007Builder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(int fitWidth) {
            this.builder.fitWidth(fitWidth);
        }
    }

    static class LandscapeClosure {
        private final Excel2007Builder builder;

        LandscapeClosure(Excel2007Builder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(boolean landscape) {
            this.builder.landscape(landscape);
        }
    }

    static class ColumnBreakClosure {
        private final Excel2007Builder builder;

        ColumnBreakClosure(Excel2007Builder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction() {
            this.builder.columnBreak();
        }
    }

    static class RowBreakClosure {
        private final Excel2007Builder builder;

        RowBreakClosure(Excel2007Builder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction() {
            this.builder.rowBreak();
        }
    }

    static class FreezeClosure {
        private final Excel2007Builder builder;

        FreezeClosure(Excel2007Builder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(int colSplit, int rowSplit) {
            this.builder.freeze(colSplit, rowSplit);
        }
    }

    static class PreserveClosure {
        private final Excel2007Builder builder;

        PreserveClosure(Excel2007Builder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(boolean preserve) {
            this.builder.preserve(preserve);
        }
    }

    static class CreateSheetClosure {
        private final Excel2007Builder builder;

        CreateSheetClosure(Excel2007Builder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(String sheet) {
            this.builder.createSheet(sheet);
        }
    }

    static class CreateStyleClosure {
        private final Excel2007Builder builder;

        CreateStyleClosure(Excel2007Builder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(Map<?, ?> params) {
            String styleName = (String)params.get("name");
            if (!TextUtil.isBlank((String)styleName)) {
                this.builder.createStyle(styleName, params);
            }
        }
    }

    static class SetStyleClosure {
        private final Excel2007Builder builder;

        SetStyleClosure(Excel2007Builder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(String style) {
            this.builder.setStyle(style);
        }
    }

    static class NextRowClosure {
        private final Excel2007Builder builder;

        NextRowClosure(Excel2007Builder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction() {
            this.builder.nextRow();
        }
    }

    static class NextColumnClosure {
        private final Excel2007Builder builder;

        NextColumnClosure(Excel2007Builder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction() {
            this.builder.nextColumn();
        }
    }

    static class GetColumnNameClosure {
        private final Excel2007Builder builder;

        GetColumnNameClosure(Excel2007Builder excelBuilder) {
            this.builder = excelBuilder;
        }

        String doAction() {
            return ExcelUtils.indexToString((int)this.builder.getColumnIndex());
        }
    }

    static class GetColumnIndexClosure {
        private final Excel2007Builder builder;

        GetColumnIndexClosure(Excel2007Builder excelBuilder) {
            this.builder = excelBuilder;
        }

        int doAction() {
            return this.builder.getColumnIndex();
        }
    }

    static class GetRowIndexClosure {
        private final Excel2007Builder builder;

        GetRowIndexClosure(Excel2007Builder excelBuilder) {
            this.builder = excelBuilder;
        }

        int doAction() {
            return this.builder.getRowIndex();
        }
    }

    static class MoveToClosure {
        private final Excel2007Builder builder;

        MoveToClosure(Excel2007Builder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(int rowIndex, int columnIndex) {
            this.builder.moveTo(rowIndex, columnIndex);
        }

        void doAction(Excel2007Builder.CellCoordinate coordinate) {
            this.builder.moveTo(coordinate);
        }
    }

    static class ExcelClosure {
        ExcelClosure() {
        }

        void doAction(Closure<?> cl) {
            cl.call();
        }
    }
}

