/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.template.common.renderer.excel;

import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.reports.model.BaseSingleFileTemplateReportDescription;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportDescription;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportPageDescription;
import com.gridnine.xtrip.server.reports.prepare.template.common.renderer.AdditionalPropertiesProvider;
import com.gridnine.xtrip.server.reports.prepare.template.common.renderer.TemplateReportRenderer;
import com.gridnine.xtrip.server.reports.prepare.template.common.renderer.excel.Excel2007GroovyScriptExecutor;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class Excel2007TemplateReportRenderer
implements TemplateReportRenderer<XSSFWorkbook> {
    private final Excel2007GroovyScriptExecutor executor = new Excel2007GroovyScriptExecutor();

    @Override
    public <T, D extends BaseTemplateReportPageDescription> XSSFWorkbook addPage(XSSFWorkbook report, byte[] template, List<T> tickets, Map<String, Object> parameters, Class<T> cls, AdditionalPropertiesProvider<T> provider, List<Message> messages) throws Exception {
        return this.executor.execute(report, template, tickets, parameters, messages);
    }

    @Override
    public byte[] getData(XSSFWorkbook report) throws Exception {
        XSSFFormulaEvaluator.evaluateAllFormulaCells((XSSFWorkbook)report);
        File tempFile = File.createTempFile(System.getProperty("java.io.tmpdir"), null);
        try (FileOutputStream fos = new FileOutputStream(tempFile);){
            report.write((OutputStream)fos);
            fos.flush();
        }
        report.close();
        System.gc();
        byte[] bytes = Files.readAllBytes(tempFile.toPath());
        tempFile.delete();
        return bytes;
    }

    @Override
    public <D extends BaseTemplateReportDescription> XSSFWorkbook createEmptyReport(D description) throws Exception {
        BaseSingleFileTemplateReportDescription singleFileDescription;
        if (description instanceof BaseSingleFileTemplateReportDescription && (singleFileDescription = (BaseSingleFileTemplateReportDescription)description).getExcelWorkbookTemplate() != null) {
            return new XSSFWorkbook((InputStream)new ByteArrayInputStream(singleFileDescription.getExcelWorkbookTemplate()));
        }
        return null;
    }
}

