/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.template.common.renderer.excel;

import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.reports.prepare.template.common.renderer.excel.ExcelCellStyle;
import com.gridnine.xtrip.server.reports.prepare.template.common.renderer.excel.ExcelCursorPosition;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFPrintSetup;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellRangeAddress;

class ExcelBuilder {
    private static final String KEY_PARENT_STYLE = "parent";
    private static final String KEY_HORIZONTAL_ALIGNMENT = "h_alignment";
    private static final String KEY_VERTICAL_ALIGNMENT = "v_alignment";
    private static final String KEY_BORDER_LEFT = "leftBorder";
    private static final String KEY_BORDER_RIGHT = "rightBorder";
    private static final String KEY_BORDER_BOTTOM = "bottomBorder";
    private static final String KEY_BORDER_TOP = "topBorder";
    private static final String KEY_FONT_FAMILY = "fontFamily";
    private static final String KEY_FONT_HEIGHT = "fontHeight";
    private static final String KEY_FONT_ITALIC = "fontItalic";
    private static final String KEY_FONT_COLOR = "fontColor";
    private static final String KEY_FONT_BOLD = "fontBold";
    private static final String KEY_WRAP_TEXT = "wrapText";
    private static final String KEY_HORIZONTAL_SPAN = "h_span";
    private static final String KEY_VERTICAL_SPAN = "v_span";
    private static final String KEY_FORMAT = "format";
    private static final String KEY_FOREGROUND = "foreground";
    private static final String KEY_LOCKED = "locked";
    private static final String NORMAL_STYLE_NAME = "normal";
    private static final List<String> keys = new ArrayList<String>();
    private static final Map<String, HSSFColor> colors = new HashMap<String, HSSFColor>();
    private static final float defaultRowHeight = 12.5f;
    private final HSSFWorkbook book;
    private HSSFSheet sheet;
    private final ExcelCursorPosition currentPosition = new ExcelCursorPosition();
    private ExcelCellStyle currentStyle;
    private final Map<String, ExcelCellStyle> styles = new HashMap<String, ExcelCellStyle>();
    private final Map<String, Map<String, Object>> styleProperties = new HashMap<String, Map<String, Object>>();
    private boolean pageAdded;
    private float lastRowHeight = 12.5f;
    private boolean preserve = true;

    public ExcelBuilder(HSSFWorkbook workbook) {
        this.book = workbook;
        this.currentStyle = new ExcelCellStyle(this.book);
        this.styles.put(NORMAL_STYLE_NAME, this.currentStyle);
    }

    public void nextColumn() {
        this.currentPosition.setColumn(this.currentPosition.getColumn() + this.currentStyle.getHorizontalSpan());
    }

    public void nextRow() {
        this.currentPosition.setColumn(0);
        this.currentPosition.setRow(this.currentPosition.getRow() + 1);
        HSSFRow row = this.getSheet().getRow(this.currentPosition.getRow());
        if (row == null) {
            row = this.getSheet().createRow(this.currentPosition.getRow());
        }
        if (this.preserve) {
            row.setHeightInPoints(this.lastRowHeight);
        }
    }

    public void setStyle(String styleName) {
        this.currentStyle = this.styles.get(styleName);
        if (this.currentStyle == null) {
            this.currentStyle = this.styles.get(NORMAL_STYLE_NAME);
        }
    }

    public void setCurrentColumnWidth(double width) {
        this.getSheet().setColumnWidth(this.currentPosition.getColumn(), (int)(256.0 * width));
    }

    public void setCurrentRowHeight(float height, boolean preserve) {
        HSSFRow row = this.getSheet().getRow(this.currentPosition.getRow());
        if (row == null) {
            row = this.getSheet().createRow(this.currentPosition.getRow());
        }
        row.setHeightInPoints(height);
        if (preserve) {
            this.lastRowHeight = height;
        }
    }

    public void text(String value, String style, int hspan, int vspan) {
        HSSFCell cell = this.getCurrentCell(style, hspan, vspan);
        if (TextUtil.isBlank((String)value)) {
            cell.setCellType(3);
            return;
        }
        cell.setCellValue((RichTextString)new HSSFRichTextString(value));
    }

    public void textnc(String value, String style, int hspan, int vspan) {
        HSSFCell cell = this.getCurrentCell(style, hspan, vspan);
        if (TextUtil.isBlank((String)value)) {
            cell.setCellType(3);
        } else {
            cell.setCellValue((RichTextString)new HSSFRichTextString(value));
        }
        this.currentPosition.setColumn(this.currentPosition.getColumn() + this.currentStyle.getHorizontalSpan());
    }

    public void number(BigDecimal value, String style, int hspan, int vspan) {
        HSSFCell cell = this.getCurrentCell(style, hspan, vspan);
        if (value == null) {
            cell.setCellType(3);
            return;
        }
        cell.setCellValue(value.doubleValue());
    }

    public void numbernc(BigDecimal value, String style, int hspan, int vspan) {
        HSSFCell cell = this.getCurrentCell(style, hspan, vspan);
        if (value == null) {
            cell.setCellType(3);
        } else {
            cell.setCellValue(value.doubleValue());
            cell.setCellType(0);
        }
        this.currentPosition.setColumn(this.currentPosition.getColumn() + this.currentStyle.getHorizontalSpan());
    }

    public void date(Date value, String style, int hspan, int vspan) {
        HSSFCell cell = this.getCurrentCell(style, hspan, vspan);
        if (value == null) {
            cell.setCellType(3);
            return;
        }
        cell.setCellValue(value);
    }

    public void bool(Boolean value, String style, int hspan, int vspan) {
        HSSFCell cell = this.getCurrentCell(style, hspan, vspan);
        if (value == null) {
            cell.setCellType(3);
            return;
        }
        cell.setCellValue(value.booleanValue());
    }

    public void formula(String value, String style, int hspan, int vspan) {
        HSSFCell cell = this.getCurrentCell(style, hspan, vspan);
        if (TextUtil.isBlank((String)value)) {
            cell.setCellType(3);
            return;
        }
        cell.setCellFormula(value);
    }

    private HSSFCell getCurrentCell(String style, int hspan, int vspan) {
        if (style != null) {
            String compositeStyle;
            this.currentStyle = this.styles.get(style);
            if (this.currentStyle == null && (compositeStyle = this.createCompositeStyle(TextUtil.split((String)style, (String)"\\|", (boolean)true, (boolean)true))) != null) {
                this.currentStyle = this.styles.get(compositeStyle);
            }
        }
        if (this.currentStyle == null) {
            this.currentStyle = this.styles.get(NORMAL_STYLE_NAME);
        }
        if (this.sheet == null) {
            this.createSheet();
        }
        int horizontalSpan = hspan > 0 ? hspan : (int)this.currentStyle.getHorizontalSpan();
        int verticalSpan = vspan > 0 ? vspan : (int)this.currentStyle.getVerticalSpan();
        HSSFCell firstCell = null;
        for (int n = 0; n < verticalSpan; ++n) {
            for (int m = 0; m < horizontalSpan; ++m) {
                HSSFCell cell;
                HSSFRow row = this.getSheet().getRow(this.currentPosition.getRow() + n);
                if (row == null) {
                    row = this.getSheet().createRow(this.currentPosition.getRow() + n);
                }
                if ((cell = row.getCell(this.currentPosition.getColumn() + m)) == null) {
                    cell = row.createCell(this.currentPosition.getColumn() + m);
                }
                if (firstCell == null) {
                    firstCell = cell;
                }
                cell.setCellStyle(this.currentStyle.getStyle());
            }
        }
        if (horizontalSpan > 1 || verticalSpan > 1) {
            this.sheet.addMergedRegion(new CellRangeAddress(this.currentPosition.getRow(), this.currentPosition.getRow() + verticalSpan - 1, this.currentPosition.getColumn(), this.currentPosition.getColumn() + horizontalSpan - 1));
        }
        return firstCell;
    }

    public String cellIndex(int rowShift, int columnShift) {
        int row = this.currentPosition.getRow() + rowShift;
        int column = this.currentPosition.getColumn() + columnShift;
        return String.format("%s%s", ExcelUtils.indexToString((int)column), Integer.toString(row + 1));
    }

    public void createStyle(String styleName, Map<String, Object> properties) {
        Boolean locked;
        String foreground;
        Boolean wrapText;
        String fontColor;
        Boolean fontItalic;
        Boolean fontBold;
        Integer v_span;
        Integer h_span;
        Integer fontHeight;
        String dataFormat;
        String fontFamily;
        String topBorder;
        String bottomBorder;
        String rightBorder;
        String leftBorder;
        String v_alignment;
        String h_alignment;
        ExcelCellStyle style = new ExcelCellStyle(this.book);
        style.setLocked(false);
        String parentStyleName = (String)properties.get(KEY_PARENT_STYLE);
        if (!TextUtil.isBlank((String)parentStyleName)) {
            ExcelCellStyle parentStyle = this.styles.get(parentStyleName);
            style.setParentStyle(parentStyle);
        }
        if (!TextUtil.isBlank((String)(h_alignment = (String)properties.get(KEY_HORIZONTAL_ALIGNMENT)))) {
            style.setHorizontalAlignment(h_alignment);
        }
        if (!TextUtil.isBlank((String)(v_alignment = (String)properties.get(KEY_VERTICAL_ALIGNMENT)))) {
            style.setVerticalAlignment(v_alignment);
        }
        if (!TextUtil.isBlank((String)(leftBorder = (String)properties.get(KEY_BORDER_LEFT)))) {
            style.setBorderLeft(leftBorder);
        }
        if (!TextUtil.isBlank((String)(rightBorder = (String)properties.get(KEY_BORDER_RIGHT)))) {
            style.setBorderRight(rightBorder);
        }
        if (!TextUtil.isBlank((String)(bottomBorder = (String)properties.get(KEY_BORDER_BOTTOM)))) {
            style.setBorderBottom(bottomBorder);
        }
        if (!TextUtil.isBlank((String)(topBorder = (String)properties.get(KEY_BORDER_TOP)))) {
            style.setBorderTop(topBorder);
        }
        if (!TextUtil.isBlank((String)(fontFamily = (String)properties.get(KEY_FONT_FAMILY)))) {
            style.setFontFamily(fontFamily);
        }
        if (!TextUtil.isBlank((String)(dataFormat = (String)properties.get(KEY_FORMAT)))) {
            style.setFormat(dataFormat);
        }
        if ((fontHeight = (Integer)properties.get(KEY_FONT_HEIGHT)) != null) {
            style.setFontHeight(fontHeight.shortValue());
        }
        if ((h_span = (Integer)properties.get(KEY_HORIZONTAL_SPAN)) != null) {
            style.setHorizontalSpan(h_span.shortValue());
        }
        if ((v_span = (Integer)properties.get(KEY_VERTICAL_SPAN)) != null) {
            style.setVerticalSpan(v_span.shortValue());
        }
        if ((fontBold = (Boolean)properties.get(KEY_FONT_BOLD)) != null) {
            style.setFontBold(fontBold);
        }
        if ((fontItalic = (Boolean)properties.get(KEY_FONT_ITALIC)) != null) {
            style.setFontItalic(fontItalic);
        }
        if (!TextUtil.isBlank((String)(fontColor = (String)properties.get(KEY_FONT_COLOR))) && colors.get(fontColor) != null) {
            style.setFontColor(colors.get(fontColor).getIndex());
        }
        if ((wrapText = (Boolean)properties.get(KEY_WRAP_TEXT)) != null) {
            style.setWrapText(wrapText);
        }
        if (!TextUtil.isBlank((String)(foreground = (String)properties.get(KEY_FOREGROUND))) && colors.get(foreground) != null) {
            style.getStyle().setFillPattern((short)1);
            style.getStyle().setFillForegroundColor(colors.get(foreground).getIndex());
        }
        if ((locked = (Boolean)properties.get(KEY_LOCKED)) != null) {
            style.setLocked(locked);
        }
        this.styles.put(styleName, style);
        this.styleProperties.put(styleName, properties);
    }

    public String createCompositeStyle(List<String> names) {
        String styleName = TextUtil.join((String)"|", names, (boolean)true);
        if (TextUtil.isBlank((String)styleName) || this.styles.get(styleName) != null) {
            return null;
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (String name : names) {
            if (TextUtil.isBlank((String)name)) continue;
            properties.putAll(this.getProperties(name));
        }
        this.createStyle(styleName, properties);
        return styleName;
    }

    private Map<String, Object> getProperties(String style) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (String key : keys) {
            Object property = this.getProperty(style, key);
            if (property == null) continue;
            properties.put(key, property);
        }
        return properties;
    }

    private Object getProperty(String style, String property) {
        Map<String, Object> parentProperties;
        String parent = style;
        while (parent != null && (parentProperties = this.styleProperties.get(parent)) != null) {
            if (parentProperties.containsKey(property)) {
                return parentProperties.get(property);
            }
            parent = (String)parentProperties.get(KEY_PARENT_STYLE);
        }
        return null;
    }

    private String prepareSheetName(String name) {
        return name.replaceAll("[\\[\\]*?:/\\\\]*", "");
    }

    public void moveTo(int rowIndex, int columnIndex) {
        HSSFRow row = this.getSheet().getRow(rowIndex);
        if (row == null) {
            row = this.getSheet().createRow(rowIndex);
        }
        row.getCell(columnIndex, Row.CREATE_NULL_AS_BLANK);
        this.currentPosition.setRow(rowIndex);
        this.currentPosition.setColumn(columnIndex);
    }

    public HSSFSheet createSheet(String name) {
        this.sheet = name == null ? this.book.createSheet() : this.book.createSheet(this.prepareSheetName(name));
        this.currentPosition.setRow(0);
        this.currentPosition.setColumn(0);
        this.pageAdded = true;
        this.sheet.setFitToPage(true);
        HSSFPrintSetup ps = this.sheet.getPrintSetup();
        ps.setFitWidth((short)1);
        ps.setFitHeight((short)0);
        ps.setLandscape(true);
        ps.setPaperSize((short)9);
        return this.sheet;
    }

    public void preserve(boolean preserve) {
        this.preserve = preserve;
    }

    public void freeze(int colSplit, int rowSplit) {
        this.getSheet().createFreezePane(colSplit, rowSplit);
    }

    public void rowBreak() {
        this.getSheet().setRowBreak(this.currentPosition.getRow());
    }

    public void columnBreak() {
        this.getSheet().setColumnBreak(this.currentPosition.getColumn());
    }

    public void landscape(boolean landscape) {
        this.getSheet().getPrintSetup().setLandscape(landscape);
    }

    public void fitWidth(int fitWidth) {
        this.getSheet().getPrintSetup().setFitWidth((short)fitWidth);
    }

    public void fitHeight(int fitHeight) {
        this.getSheet().getPrintSetup().setFitHeight((short)fitHeight);
    }

    public void scale(int scale) {
        this.getSheet().getPrintSetup().setScale((short)scale);
    }

    public void margin(double left, double right, double top, double bottom) {
        this.getSheet().setMargin((short)0, left);
        this.getSheet().setMargin((short)1, right);
        this.getSheet().setMargin((short)2, top);
        this.getSheet().setMargin((short)3, bottom);
    }

    public void marginLeft(double size) {
        this.getSheet().setMargin((short)0, size);
    }

    public void marginRight(double size) {
        this.getSheet().setMargin((short)1, size);
    }

    public void marginTop(double size) {
        this.getSheet().setMargin((short)2, size);
    }

    public void marginBottom(double size) {
        this.getSheet().setMargin((short)3, size);
    }

    public void protect(String password) {
        if (password == null) {
            return;
        }
        this.getSheet().protectSheet(password);
    }

    public int getRowIndex() {
        return this.currentPosition.getRow();
    }

    public int getColumnIndex() {
        return this.currentPosition.getColumn();
    }

    public boolean isPageAdded() {
        return this.pageAdded;
    }

    public void rowAutoHeight() {
        HSSFRow row = this.getSheet().getRow(this.currentPosition.getRow());
        if (row == null) {
            row = this.getSheet().createRow(this.currentPosition.getRow());
        }
        row.setHeight((short)-1);
    }

    public void columnAutoWidth() {
        this.getSheet().autoSizeColumn(this.currentPosition.getColumn());
    }

    public void columnAutoWidth(boolean useMergedCells) {
        this.getSheet().autoSizeColumn(this.currentPosition.getColumn(), useMergedCells);
    }

    public HSSFSheet createSheet() {
        return this.createSheet(null);
    }

    public HSSFSheet getSheet() {
        return this.sheet == null ? this.createSheet() : this.sheet;
    }

    public HSSFWorkbook getBook() {
        return this.book;
    }

    static {
        keys.add(KEY_HORIZONTAL_ALIGNMENT);
        keys.add(KEY_VERTICAL_ALIGNMENT);
        keys.add(KEY_BORDER_LEFT);
        keys.add(KEY_BORDER_RIGHT);
        keys.add(KEY_BORDER_BOTTOM);
        keys.add(KEY_BORDER_TOP);
        keys.add(KEY_FONT_FAMILY);
        keys.add(KEY_FONT_HEIGHT);
        keys.add(KEY_FONT_ITALIC);
        keys.add(KEY_FONT_COLOR);
        keys.add(KEY_FONT_BOLD);
        keys.add(KEY_WRAP_TEXT);
        keys.add(KEY_HORIZONTAL_SPAN);
        keys.add(KEY_VERTICAL_SPAN);
        keys.add(KEY_FORMAT);
        keys.add(KEY_FOREGROUND);
        keys.add(KEY_LOCKED);
        colors.put("BLACK", (HSSFColor)new HSSFColor.BLACK());
        colors.put("BROWN", (HSSFColor)new HSSFColor.BROWN());
        colors.put("OLIVE_GREEN", (HSSFColor)new HSSFColor.OLIVE_GREEN());
        colors.put("DARK_GREEN", (HSSFColor)new HSSFColor.DARK_GREEN());
        colors.put("DARK_TEAL", (HSSFColor)new HSSFColor.DARK_TEAL());
        colors.put("DARK_BLUE", (HSSFColor)new HSSFColor.DARK_BLUE());
        colors.put("INDIGO", (HSSFColor)new HSSFColor.INDIGO());
        colors.put("GREY_80_PERCENT", (HSSFColor)new HSSFColor.GREY_80_PERCENT());
        colors.put("ORANGE", (HSSFColor)new HSSFColor.ORANGE());
        colors.put("DARK_YELLOW", (HSSFColor)new HSSFColor.DARK_YELLOW());
        colors.put("GREEN", (HSSFColor)new HSSFColor.GREEN());
        colors.put("TEAL", (HSSFColor)new HSSFColor.TEAL());
        colors.put("BLUE", (HSSFColor)new HSSFColor.BLUE());
        colors.put("BLUE_GREY", (HSSFColor)new HSSFColor.BLUE_GREY());
        colors.put("GREY_50_PERCENT", (HSSFColor)new HSSFColor.GREY_50_PERCENT());
        colors.put("RED", (HSSFColor)new HSSFColor.RED());
        colors.put("LIGHT_ORANGE", (HSSFColor)new HSSFColor.LIGHT_ORANGE());
        colors.put("LIME", (HSSFColor)new HSSFColor.LIME());
        colors.put("SEA_GREEN", (HSSFColor)new HSSFColor.SEA_GREEN());
        colors.put("AQUA", (HSSFColor)new HSSFColor.AQUA());
        colors.put("LIGHT_BLUE", (HSSFColor)new HSSFColor.LIGHT_BLUE());
        colors.put("VIOLET", (HSSFColor)new HSSFColor.VIOLET());
        colors.put("GREY_40_PERCENT", (HSSFColor)new HSSFColor.GREY_40_PERCENT());
        colors.put("PINK", (HSSFColor)new HSSFColor.PINK());
        colors.put("GOLD", (HSSFColor)new HSSFColor.GOLD());
        colors.put("YELLOW", (HSSFColor)new HSSFColor.YELLOW());
        colors.put("BRIGHT_GREEN", (HSSFColor)new HSSFColor.BRIGHT_GREEN());
        colors.put("TURQUOISE", (HSSFColor)new HSSFColor.TURQUOISE());
        colors.put("DARK_RED", (HSSFColor)new HSSFColor.DARK_RED());
        colors.put("SKY_BLUE", (HSSFColor)new HSSFColor.SKY_BLUE());
        colors.put("PLUM", (HSSFColor)new HSSFColor.PLUM());
        colors.put("GREY_25_PERCENT", (HSSFColor)new HSSFColor.GREY_25_PERCENT());
        colors.put("ROSE", (HSSFColor)new HSSFColor.ROSE());
        colors.put("LIGHT_YELLOW", (HSSFColor)new HSSFColor.LIGHT_YELLOW());
        colors.put("LIGHT_GREEN", (HSSFColor)new HSSFColor.LIGHT_GREEN());
        colors.put("LIGHT_TURQUOISE", (HSSFColor)new HSSFColor.LIGHT_TURQUOISE());
        colors.put("PALE_BLUE", (HSSFColor)new HSSFColor.PALE_BLUE());
        colors.put("LAVENDER", (HSSFColor)new HSSFColor.LAVENDER());
        colors.put("WHITE", (HSSFColor)new HSSFColor.WHITE());
        colors.put("CORNFLOWER_BLUE", (HSSFColor)new HSSFColor.CORNFLOWER_BLUE());
        colors.put("LEMON_CHIFFON", (HSSFColor)new HSSFColor.LEMON_CHIFFON());
        colors.put("MAROON", (HSSFColor)new HSSFColor.MAROON());
        colors.put("ORCHID", (HSSFColor)new HSSFColor.ORCHID());
        colors.put("CORAL", (HSSFColor)new HSSFColor.CORAL());
        colors.put("ROYAL_BLUE", (HSSFColor)new HSSFColor.ROYAL_BLUE());
        colors.put("LIGHT_CORNFLOWER_BLUE", (HSSFColor)new HSSFColor.LIGHT_CORNFLOWER_BLUE());
        colors.put("TAN", (HSSFColor)new HSSFColor.TAN());
    }
}

