/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.template.common.renderer.excel;

import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.RequestedParameterValue;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportPageDescription;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportParameters;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.server.model.helpers.GroovyShellHelper;
import com.gridnine.xtrip.server.reports.prepare.template.common.renderer.GroovyRenderersHelper;
import com.gridnine.xtrip.server.reports.prepare.template.common.renderer.excel.ExcelBuilder;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyShell;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.codehaus.groovy.runtime.MethodClosure;

public class ExcelGroovyScriptExecutor {
    public <T, D extends BaseTemplateReportPageDescription> HSSFWorkbook execute(HSSFWorkbook report, byte[] template, List<T> tickets, Map<String, Object> parameters, List<Message> messages) throws Exception {
        Binding binding = new Binding();
        GroovyShell shell = new GroovyShell(binding);
        HSSFWorkbook result = report == null ? new HSSFWorkbook() : report;
        ExcelBuilder builder = new ExcelBuilder(result);
        this.fillBinding(binding, builder, tickets, parameters, shell, messages);
        GroovyShellHelper.wrapShellIntoCacheDecorator((GroovyShell)shell).evaluate(template);
        if (report == null && !builder.isPageAdded()) {
            return null;
        }
        return result;
    }

    private <T, D extends BaseTemplateReportPageDescription> void fillBinding(Binding binding, ExcelBuilder builder, List<T> tickets, Map<String, Object> parameters, GroovyShell shell, List<Message> messages) throws Exception {
        ValueHolder ticketsHolder = new ValueHolder(tickets);
        binding.setVariable("setStyle", (Object)new MethodClosure((Object)new SetStyleClosure(builder), "doAction"));
        binding.setVariable("createStyle", (Object)new MethodClosure((Object)new CreateStyleClosure(builder), "doAction"));
        binding.setVariable("columnWidth", (Object)new MethodClosure((Object)new ColumnWidthClosure(builder), "doAction"));
        binding.setVariable("rowHeight", (Object)new MethodClosure((Object)new RowHeightClosure(builder), "doAction"));
        binding.setVariable("createSheet", (Object)new MethodClosure((Object)new CreateSheetClosure(builder), "doAction"));
        binding.setVariable("moveTo", (Object)new MethodClosure((Object)new MoveToClosure(builder), "doAction"));
        binding.setVariable("preserve", (Object)new MethodClosure((Object)new PreserveClosure(builder), "doAction"));
        binding.setVariable("freeze", (Object)new MethodClosure((Object)new FreezeClosure(builder), "doAction"));
        binding.setVariable("rowBreak", (Object)new MethodClosure((Object)new RowBreakClosure(builder), "doAction"));
        binding.setVariable("columnBreak", (Object)new MethodClosure((Object)new ColumnBreakClosure(builder), "doAction"));
        binding.setVariable("landscape", (Object)new MethodClosure((Object)new LandscapeClosure(builder), "doAction"));
        binding.setVariable("fitWidth", (Object)new MethodClosure((Object)new FitWidthClosure(builder), "doAction"));
        binding.setVariable("fitHeight", (Object)new MethodClosure((Object)new FitHeightClosure(builder), "doAction"));
        binding.setVariable("scale", (Object)new MethodClosure((Object)new ScaleClosure(builder), "doAction"));
        binding.setVariable("margin", (Object)new MethodClosure((Object)new MarginClosure(builder), "doAction"));
        binding.setVariable("getRowIndex", (Object)new MethodClosure((Object)new GetRowIndexClosure(builder), "doAction"));
        binding.setVariable("getColumnIndex", (Object)new MethodClosure((Object)new GetColumnIndexClosure(builder), "doAction"));
        binding.setVariable("marginLeft", (Object)new MethodClosure((Object)new MarginLeftClosure(builder), "doAction"));
        binding.setVariable("marginRight", (Object)new MethodClosure((Object)new MarginRightClosure(builder), "doAction"));
        binding.setVariable("marginTop", (Object)new MethodClosure((Object)new MarginTopClosure(builder), "doAction"));
        binding.setVariable("marginBottom", (Object)new MethodClosure((Object)new MarginBottomClosure(builder), "doAction"));
        binding.setVariable("protect", (Object)new MethodClosure((Object)new ProtectClosure(builder), "doAction"));
        binding.setVariable("nextColumn", (Object)new MethodClosure((Object)new NextColumnClosure(builder), "doAction"));
        binding.setVariable("nextRow", (Object)new MethodClosure((Object)new NextRowClosure(builder), "doAction"));
        binding.setVariable("cellIndex", (Object)new MethodClosure((Object)new CellIndexClosure(builder), "doAction"));
        binding.setVariable("text", (Object)new MethodClosure((Object)new TextClosure(builder), "doAction"));
        binding.setVariable("textnc", (Object)new MethodClosure((Object)new TextNCClosure(builder), "doAction"));
        binding.setVariable("number", (Object)new MethodClosure((Object)new NumberClosure(builder), "doAction"));
        binding.setVariable("numbernc", (Object)new MethodClosure((Object)new NumberNCClosure(builder), "doAction"));
        binding.setVariable("date", (Object)new MethodClosure((Object)new DateClosure(builder), "doAction"));
        binding.setVariable("bool", (Object)new MethodClosure((Object)new BooleanClosure(builder), "doAction"));
        binding.setVariable("formula", (Object)new MethodClosure((Object)new FormulaClosure(builder), "doAction"));
        binding.setVariable("tickets", (Object)new MethodClosure(new GroovyRenderersHelper.TicketsClosure(ticketsHolder, shell), "doAction"));
        binding.setVariable("count", (Object)new MethodClosure(new GroovyRenderersHelper.CountClosure(ticketsHolder), "doAction"));
        binding.setVariable("groups", (Object)new MethodClosure(new GroovyRenderersHelper.GroupClosure(ticketsHolder, shell), "doAction"));
        Object allowEmpty = parameters.get("allow-empty-report");
        if (allowEmpty == null) {
            allowEmpty = Boolean.FALSE;
        }
        binding.setVariable("page", (Object)new MethodClosure(new PageClosure(ticketsHolder, shell, builder, (Boolean)allowEmpty), "doAction"));
        binding.setVariable("error", (Object)new MethodClosure((Object)new GroovyRenderersHelper.ErrorClosure(MessageType.ERROR, messages), "doAction"));
        binding.setVariable("info", (Object)new MethodClosure((Object)new GroovyRenderersHelper.ErrorClosure(MessageType.MESSAGE, messages), "doAction"));
        binding.setVariable("warn", (Object)new MethodClosure((Object)new GroovyRenderersHelper.ErrorClosure(MessageType.WARNING, messages), "doAction"));
        binding.setVariable("message", (Object)new MethodClosure((Object)new GroovyRenderersHelper.MessageClosure(messages), "doAction"));
        binding.setVariable("parameters", new HashMap<String, Object>(parameters));
        binding.setVariable("requestedParameter", (Object)new MethodClosure((Object)new RequestedParameterClosure(parameters), "doAction"));
        binding.setProperty("allTickets", tickets);
        binding.setVariable("rowAutoHeight", (Object)new MethodClosure((Object)new RowAutoHeightClosure(builder), "doAction"));
        binding.setVariable("columnAutoWidth", (Object)new MethodClosure((Object)new ColumnAutoWidthClosure(builder), "doAction"));
    }

    static class GetColumnIndexClosure {
        private final ExcelBuilder builder;

        GetColumnIndexClosure(ExcelBuilder excelBuilder) {
            this.builder = excelBuilder;
        }

        int doAction() {
            return this.builder.getColumnIndex();
        }
    }

    static class GetRowIndexClosure {
        private final ExcelBuilder builder;

        GetRowIndexClosure(ExcelBuilder excelBuilder) {
            this.builder = excelBuilder;
        }

        int doAction() {
            return this.builder.getRowIndex();
        }
    }

    static class MoveToClosure {
        private final ExcelBuilder builder;

        MoveToClosure(ExcelBuilder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(int rowIndex, int columnIndex) {
            this.builder.moveTo(rowIndex, columnIndex);
        }
    }

    static class RequestedParameterClosure {
        private final Map<String, Object> parameters;

        RequestedParameterClosure(Map<String, Object> parameters) {
            this.parameters = parameters;
        }

        Object doAction(String key) {
            BaseTemplateReportParameters templateReportParameters = (BaseTemplateReportParameters)this.parameters.get("key-report-params");
            for (RequestedParameterValue requestedParameterValue : templateReportParameters.getRequestedParameters()) {
                if (!TextUtil.isSame((String)requestedParameterValue.getKey(), (String)key)) continue;
                return requestedParameterValue.getValue();
            }
            return null;
        }
    }

    public class ColumnAutoWidthClosure {
        private final ExcelBuilder builder;

        ColumnAutoWidthClosure(ExcelBuilder builder) {
            this.builder = builder;
        }

        public void doAction() {
            this.builder.columnAutoWidth();
        }

        public void doAction(boolean useMergedCells) {
            this.builder.columnAutoWidth(useMergedCells);
        }
    }

    public class RowAutoHeightClosure {
        private final ExcelBuilder builder;

        RowAutoHeightClosure(ExcelBuilder builder) {
            this.builder = builder;
        }

        public void doAction() {
            this.builder.rowAutoHeight();
        }
    }

    static class CellIndexClosure {
        private final ExcelBuilder builder;

        CellIndexClosure(ExcelBuilder excelBuilder) {
            this.builder = excelBuilder;
        }

        String doAction(Number rowShift, Number columnShift) {
            return this.builder.cellIndex(rowShift.intValue(), columnShift.intValue());
        }

        String doAction() {
            return this.builder.cellIndex(0, 0);
        }
    }

    static class PageClosure<T>
    extends GroovyRenderersHelper.BaseGroupClosure<T> {
        private final ExcelBuilder builder;

        PageClosure(ValueHolder<List<T>> ticketsHolder, GroovyShell shell, ExcelBuilder excelBuilder, boolean allowEmptyReport) {
            super(ticketsHolder, shell, allowEmptyReport);
            this.builder = excelBuilder;
        }

        @Override
        protected void beforeSectionStarted(String value, List<T> key) {
            this.builder.createSheet(value);
        }
    }

    static class RowHeightClosure {
        private final ExcelBuilder builder;

        RowHeightClosure(ExcelBuilder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(Number value, boolean preserve) {
            this.builder.setCurrentRowHeight(value.floatValue(), preserve);
        }

        void doAction(Number value) {
            this.doAction(Float.valueOf(value.floatValue()), true);
        }
    }

    static class ColumnWidthClosure {
        private final ExcelBuilder builder;

        ColumnWidthClosure(ExcelBuilder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(Number value) {
            this.builder.setCurrentColumnWidth(value.doubleValue());
        }
    }

    static class FormulaClosure {
        private final ExcelBuilder builder;

        FormulaClosure(ExcelBuilder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(String value, String style, int hspan, int vspan) {
            this.builder.formula(value, style, hspan, vspan);
        }

        void doAction(String value, String style) {
            this.doAction(value, style, 0, 0);
        }

        void doAction(String value) {
            this.doAction(value, null, 0, 0);
        }
    }

    static class BooleanClosure {
        private final ExcelBuilder builder;

        BooleanClosure(ExcelBuilder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(Boolean value, String style, int hspan, int vspan) {
            this.builder.bool(value, style, hspan, vspan);
        }

        void doAction(Boolean value, String style) {
            this.doAction(value, style, 0, 0);
        }

        void doAction(Boolean value) {
            this.doAction(value, null, 0, 0);
        }
    }

    static class DateClosure {
        private final ExcelBuilder builder;

        DateClosure(ExcelBuilder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(Date value, String style, int hspan, int vspan) {
            this.builder.date(value, style, hspan, vspan);
        }

        void doAction(Date value, String style) {
            this.doAction(value, style, 0, 0);
        }

        void doAction(Date value) {
            this.doAction(value, null, 0, 0);
        }
    }

    static class NumberNCClosure {
        private final ExcelBuilder builder;

        NumberNCClosure(ExcelBuilder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(BigDecimal value, String style, int hspan, int vspan) {
            this.builder.numbernc(value, style, hspan, vspan);
        }

        void doAction(BigDecimal value, String style) {
            this.doAction(value, style, 0, 0);
        }

        void doAction(BigDecimal value) {
            this.doAction(value, null, 0, 0);
        }
    }

    static class NumberClosure {
        private final ExcelBuilder builder;

        NumberClosure(ExcelBuilder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(BigDecimal value, String style, int hspan, int vspan) {
            this.builder.number(value, style, hspan, vspan);
        }

        void doAction(BigDecimal value, String style) {
            this.doAction(value, style, 0, 0);
        }

        void doAction(BigDecimal value) {
            this.doAction(value, null, 0, 0);
        }
    }

    static class TextNCClosure {
        private final ExcelBuilder builder;

        TextNCClosure(ExcelBuilder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(String value, String style, int hspan, int vspan) {
            this.builder.textnc(value, style, hspan, vspan);
        }

        void doAction(String value, String style) {
            this.doAction(value, style, 0, 0);
        }

        void doAction(String value) {
            this.doAction(value, null, 0, 0);
        }
    }

    static class TextClosure {
        private final ExcelBuilder builder;

        TextClosure(ExcelBuilder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(String value, String style, int hspan, int vspan) {
            this.builder.text(value, style, hspan, vspan);
        }

        void doAction(String value, String style) {
            this.doAction(value, style, 0, 0);
        }

        void doAction(String value) {
            this.doAction(value, null, 0, 0);
        }
    }

    static class ProtectClosure {
        private final ExcelBuilder builder;

        ProtectClosure(ExcelBuilder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction() {
            this.builder.protect(DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EXCEL_PASSWORD, (String)""));
        }
    }

    static class MarginBottomClosure {
        private final ExcelBuilder builder;

        MarginBottomClosure(ExcelBuilder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(double size) {
            this.builder.marginBottom(size);
        }
    }

    static class MarginTopClosure {
        private final ExcelBuilder builder;

        MarginTopClosure(ExcelBuilder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(double size) {
            this.builder.marginTop(size);
        }
    }

    static class MarginRightClosure {
        private final ExcelBuilder builder;

        MarginRightClosure(ExcelBuilder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(double size) {
            this.builder.marginRight(size);
        }
    }

    static class MarginLeftClosure {
        private final ExcelBuilder builder;

        MarginLeftClosure(ExcelBuilder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(double size) {
            this.builder.marginLeft(size);
        }
    }

    static class MarginClosure {
        private final ExcelBuilder builder;

        MarginClosure(ExcelBuilder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(double left, double right, double top, double bottom) {
            this.builder.margin(left, right, top, bottom);
        }
    }

    static class ScaleClosure {
        private final ExcelBuilder builder;

        ScaleClosure(ExcelBuilder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(int scale) {
            this.builder.scale(scale);
        }
    }

    static class FitHeightClosure {
        private final ExcelBuilder builder;

        FitHeightClosure(ExcelBuilder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(int fitHeight) {
            this.builder.fitHeight(fitHeight);
        }
    }

    static class FitWidthClosure {
        private final ExcelBuilder builder;

        FitWidthClosure(ExcelBuilder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(int fitWidth) {
            this.builder.fitWidth(fitWidth);
        }
    }

    static class LandscapeClosure {
        private final ExcelBuilder builder;

        LandscapeClosure(ExcelBuilder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(boolean landscape) {
            this.builder.landscape(landscape);
        }
    }

    static class ColumnBreakClosure {
        private final ExcelBuilder builder;

        ColumnBreakClosure(ExcelBuilder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction() {
            this.builder.columnBreak();
        }
    }

    static class RowBreakClosure {
        private final ExcelBuilder builder;

        RowBreakClosure(ExcelBuilder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction() {
            this.builder.rowBreak();
        }
    }

    static class FreezeClosure {
        private final ExcelBuilder builder;

        FreezeClosure(ExcelBuilder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(int colSplit, int rowSplit) {
            this.builder.freeze(colSplit, rowSplit);
        }
    }

    static class PreserveClosure {
        private final ExcelBuilder builder;

        PreserveClosure(ExcelBuilder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(boolean preserve) {
            this.builder.preserve(preserve);
        }
    }

    static class CreateSheetClosure {
        private final ExcelBuilder builder;

        CreateSheetClosure(ExcelBuilder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(String sheet) {
            this.builder.createSheet(sheet);
        }
    }

    static class CreateStyleClosure {
        private final ExcelBuilder builder;

        CreateStyleClosure(ExcelBuilder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(Map<?, ?> params) {
            String styleName = (String)params.get("name");
            if (!TextUtil.isBlank((String)styleName)) {
                this.builder.createStyle(styleName, params);
            }
        }
    }

    static class SetStyleClosure {
        private final ExcelBuilder builder;

        SetStyleClosure(ExcelBuilder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction(String style) {
            this.builder.setStyle(style);
        }
    }

    static class NextRowClosure {
        private final ExcelBuilder builder;

        NextRowClosure(ExcelBuilder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction() {
            this.builder.nextRow();
        }
    }

    static class NextColumnClosure {
        private final ExcelBuilder builder;

        NextColumnClosure(ExcelBuilder excelBuilder) {
            this.builder = excelBuilder;
        }

        void doAction() {
            this.builder.nextColumn();
        }
    }

    static class ExcelClosure {
        ExcelClosure() {
        }

        void doAction(Closure<?> cl) {
            cl.call();
        }
    }
}

