/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.template.common.renderer.excel;

import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportDescription;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportPageDescription;
import com.gridnine.xtrip.server.reports.prepare.template.common.renderer.AdditionalPropertiesProvider;
import com.gridnine.xtrip.server.reports.prepare.template.common.renderer.TemplateReportRenderer;
import com.gridnine.xtrip.server.reports.prepare.template.common.renderer.excel.ExcelGroovyScriptExecutor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFFormulaEvaluator;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class ExcelTemplateReportRenderer
implements TemplateReportRenderer<HSSFWorkbook> {
    private final ExcelGroovyScriptExecutor executor = new ExcelGroovyScriptExecutor();

    @Override
    public <T, D extends BaseTemplateReportPageDescription> HSSFWorkbook addPage(HSSFWorkbook report, byte[] template, List<T> tickets, Map<String, Object> parameters, Class<T> cls, AdditionalPropertiesProvider<T> provider, List<Message> messages) throws Exception {
        return this.executor.execute(report, template, tickets, parameters, messages);
    }

    @Override
    public byte[] getData(HSSFWorkbook report) throws Exception {
        HSSFFormulaEvaluator.evaluateAllFormulaCells((HSSFWorkbook)report);
        report.setActiveSheet(0);
        report.setSelectedTab(0);
        File tempFile = File.createTempFile(System.getProperty("java.io.tmpdir"), null);
        try (FileOutputStream fos = new FileOutputStream(tempFile);){
            report.write((OutputStream)fos);
            fos.flush();
        }
        report.close();
        System.gc();
        byte[] bytes = Files.readAllBytes(tempFile.toPath());
        tempFile.delete();
        return bytes;
    }

    @Override
    public <D extends BaseTemplateReportDescription> HSSFWorkbook createEmptyReport(D description) {
        return null;
    }
}

