/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.template.common.renderer.excel;

import com.gridnine.xtrip.server.reports.prepare.template.common.renderer.excel.Excel2007Builder;
import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.runtime.MethodClosure;

final class PivotTableHelper {
    public static final String PIVOT_TABLE_ROW_CONFIG_COMPACT_NAME = "compact";
    public static final String PIVOT_TABLE_ROW_CONFIG_OUTLINE_FORM_NAME = "outline";

    private PivotTableHelper() {
    }

    static class PivotTableConfiguration {
        private String sourceSheetName;
        private Excel2007Builder.CellArea sourceCellArea;
        private final List<Integer> filters = new ArrayList<Integer>();
        final List<Row> rows = new ArrayList<Row>();
        private final List<Integer> columnGroups = new ArrayList<Integer>();
        private final List<PivotTableColumnConfiguration> columns = new ArrayList<PivotTableColumnConfiguration>();
        private String valuesDataCaption;

        PivotTableConfiguration() {
        }

        String getSourceSheetName() {
            return this.sourceSheetName;
        }

        void setSourceSheetName(String sourceSheetName) {
            this.sourceSheetName = sourceSheetName;
        }

        public Excel2007Builder.CellArea getSourceCellArea() {
            return this.sourceCellArea;
        }

        public void setSourceCellArea(Excel2007Builder.CellArea sourceCellArea) {
            this.sourceCellArea = sourceCellArea;
        }

        public List<Integer> getFilters() {
            return this.filters;
        }

        public List<PivotTableColumnConfiguration> getColumns() {
            return this.columns;
        }

        public List<Integer> getColumnGroups() {
            return this.columnGroups;
        }

        public String getValuesDataCaption() {
            return this.valuesDataCaption;
        }

        public void setValuesDataCaption(String valuesDataCaption) {
            this.valuesDataCaption = valuesDataCaption;
        }

        static class Row {
            int index;
            Excel2007Builder.PivotTableRowConfig config;

            Row() {
            }
        }
    }

    static class PivotTableColumnConfiguration {
        private int columnIndex;
        private PivotTableColumnType columnType;
        private String fieldName;

        PivotTableColumnConfiguration() {
        }

        public int getColumnIndex() {
            return this.columnIndex;
        }

        public void setColumnIndex(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        public PivotTableColumnType getColumnType() {
            return this.columnType;
        }

        public void setColumnType(PivotTableColumnType columnType) {
            this.columnType = columnType;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }
    }

    static enum PivotTableColumnType {
        SUM,
        AVERAGE;

    }

    static class PivotTableClosure {
        private final Excel2007Builder builder;
        private int pivotTableIdCounter = 0;

        PivotTableClosure(Excel2007Builder builder) {
            this.builder = builder;
        }

        void doAction(Closure<?> cl) {
            PivotTableConfiguration tableConfig = new PivotTableConfiguration();
            cl.setProperty("source", (Object)new MethodClosure((Object)new PivotTableConfigSourceClosure(tableConfig, this.builder), "doAction"));
            MethodClosure filterClosure = new MethodClosure((Object)new PivotTableConfigFilterClosure(tableConfig), "doAction");
            cl.setProperty("filters", (Object)filterClosure);
            cl.setProperty("filter", (Object)filterClosure);
            MethodClosure rowClosure = new MethodClosure((Object)new PivotTableConfigRowClosure(tableConfig), "doAction");
            cl.setProperty("rows", (Object)rowClosure);
            cl.setProperty("row", (Object)rowClosure);
            MethodClosure sumClosure = new MethodClosure((Object)new PivotTableConfigColumnClosure(tableConfig, PivotTableColumnType.SUM), "doAction");
            cl.setProperty("sumColumn", (Object)sumClosure);
            MethodClosure averageClosure = new MethodClosure((Object)new PivotTableConfigColumnClosure(tableConfig, PivotTableColumnType.AVERAGE), "doAction");
            cl.setProperty("averageColumn", (Object)averageClosure);
            MethodClosure columnClosure = new MethodClosure((Object)new PivotTableConfigColumnGroupClosure(tableConfig), "doAction");
            cl.setProperty("column", (Object)columnClosure);
            MethodClosure valuesDataCaptionClosure = new MethodClosure((Object)new PivotTableConfigValuesDataCaptionClosure(tableConfig), "doAction");
            cl.setProperty("valuesDataCaption", (Object)valuesDataCaptionClosure);
            cl.call();
            String pivotTableId = Integer.toString(this.pivotTableIdCounter++);
            this.builder.createPivotTable(tableConfig.getSourceSheetName(), tableConfig.getSourceCellArea(), pivotTableId);
            Iterator<Object> iterator = tableConfig.getFilters().iterator();
            while (iterator.hasNext()) {
                int filter = iterator.next();
                this.builder.addPivotTableFilter(pivotTableId, filter);
            }
            for (PivotTableConfiguration.Row row : tableConfig.rows) {
                this.builder.addPivotTableRow(pivotTableId, row.index, row.config);
            }
            iterator = tableConfig.getColumnGroups().iterator();
            while (iterator.hasNext()) {
                int columnGroup = (Integer)iterator.next();
                this.builder.addPivotTableColumn(pivotTableId, columnGroup);
            }
            for (PivotTableColumnConfiguration column : tableConfig.getColumns()) {
                switch (column.getColumnType()) {
                    case SUM: {
                        this.builder.addPivotTableSumColumn(pivotTableId, column.getColumnIndex(), column.getFieldName());
                        break;
                    }
                    case AVERAGE: {
                        this.builder.addPivotTableAverageColumn(pivotTableId, column.getColumnIndex(), column.getFieldName());
                    }
                }
            }
            if (tableConfig.getValuesDataCaption() != null) {
                this.builder.setPivotTableDataCaption(pivotTableId, tableConfig.getValuesDataCaption());
            }
        }
    }

    static class PivotTableConfigValuesDataCaptionClosure {
        private final PivotTableConfiguration tableConfig;

        public PivotTableConfigValuesDataCaptionClosure(PivotTableConfiguration tableConfig) {
            this.tableConfig = tableConfig;
        }

        public void doAction(String valuesDataCaption) {
            this.tableConfig.setValuesDataCaption(valuesDataCaption);
        }
    }

    static class PivotTableConfigColumnGroupClosure {
        private final PivotTableConfiguration tableConfig;

        public PivotTableConfigColumnGroupClosure(PivotTableConfiguration tableConfig) {
            this.tableConfig = tableConfig;
        }

        public void doAction(int index) {
            this.tableConfig.getColumnGroups().add(index);
        }

        public void doAction(int ... indexes) {
            for (int index : indexes) {
                this.doAction(index);
            }
        }
    }

    static class PivotTableConfigColumnClosure {
        private final PivotTableConfiguration tableConfig;
        private final PivotTableColumnType columnType;

        public PivotTableConfigColumnClosure(PivotTableConfiguration tableConfig, PivotTableColumnType columnType) {
            this.tableConfig = tableConfig;
            this.columnType = columnType;
        }

        public void doAction(int index, String fieldName) {
            PivotTableColumnConfiguration config = new PivotTableColumnConfiguration();
            config.setColumnType(this.columnType);
            config.setColumnIndex(index);
            config.setFieldName(fieldName);
            this.tableConfig.getColumns().add(config);
        }

        public void doAction(int ... indexes) {
            for (int index : indexes) {
                this.doAction(index);
            }
        }

        public void doAction(int index) {
            this.doAction(index, null);
        }
    }

    static class PivotTableConfigRowClosure {
        private final PivotTableConfiguration tableConfig;

        public PivotTableConfigRowClosure(PivotTableConfiguration tableConfig) {
            this.tableConfig = tableConfig;
        }

        public void doAction(Map<String, Object> parameters, int ... indexes) {
            Excel2007Builder.PivotTableRowConfig config = new Excel2007Builder.PivotTableRowConfig();
            config.setCompactForm((Boolean)parameters.get(PivotTableHelper.PIVOT_TABLE_ROW_CONFIG_COMPACT_NAME));
            config.setOutlineForm((Boolean)parameters.get(PivotTableHelper.PIVOT_TABLE_ROW_CONFIG_OUTLINE_FORM_NAME));
            for (int index : indexes) {
                PivotTableConfiguration.Row row = new PivotTableConfiguration.Row();
                row.index = index;
                row.config = config;
                this.tableConfig.rows.add(row);
            }
        }

        public void doAction(int ... indexes) {
            this.doAction(Collections.emptyMap(), indexes);
        }
    }

    static class PivotTableConfigFilterClosure {
        private final PivotTableConfiguration tableConfig;

        PivotTableConfigFilterClosure(PivotTableConfiguration configValue) {
            this.tableConfig = configValue;
        }

        public void doAction(int index) {
            this.tableConfig.getFilters().add(index);
        }

        public void doAction(int ... indexes) {
            for (int index : indexes) {
                this.doAction(index);
            }
        }
    }

    static class PivotTableConfigSourceClosure {
        private final PivotTableConfiguration tableConfig;
        private final Excel2007Builder builder;

        PivotTableConfigSourceClosure(PivotTableConfiguration configValue, Excel2007Builder builder) {
            this.tableConfig = configValue;
            this.builder = builder;
        }

        void doAction(String value) {
            this.tableConfig.setSourceSheetName(value);
        }

        private Excel2007Builder.CellCoordinate getCoordinate(Map<String, Object> values) {
            int row = (Integer)values.get("row");
            int column = (Integer)values.get("column");
            return new Excel2007Builder.CellCoordinate(row, column);
        }

        private Excel2007Builder.CellArea getArea(Map<String, Object> values) {
            Excel2007Builder.CellCoordinate leftTop = this.getCoordinate((Map)values.get("leftTop"));
            Excel2007Builder.CellCoordinate rightBottom = this.getCoordinate((Map)values.get("rightBottom"));
            return new Excel2007Builder.CellArea(leftTop, rightBottom);
        }

        void doAction(Map<String, Object> values) {
            String sourceSheet = (String)values.get("sheet");
            if (sourceSheet == null) {
                sourceSheet = this.builder.getSheet().getSheetName();
            }
            Excel2007Builder.CellArea sourceArea = this.getArea(values);
            this.tableConfig.setSourceSheetName(sourceSheet);
            this.tableConfig.setSourceCellArea(sourceArea);
        }
    }
}

