/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.template.common.renderer.jasper;

import com.gridnine.xtrip.common.jr.JasperUtil;
import com.gridnine.xtrip.common.jr.ReportParametersProvider;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportDescription;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportPageDescription;
import com.gridnine.xtrip.common.util.ReflectionUtil;
import com.gridnine.xtrip.server.reports.prepare.template.common.renderer.AdditionalPropertiesProvider;
import com.gridnine.xtrip.server.reports.prepare.template.common.renderer.TemplateReportRenderer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JasperTemplateReportRenderer
implements TemplateReportRenderer<JasperPrint> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public byte[] getData(JasperPrint report) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(report);
        oos.flush();
        oos.close();
        return baos.toByteArray();
    }

    private <T, D extends BaseTemplateReportPageDescription> JRDataSource createDataSource(final List<T> filteredTickets, final AdditionalPropertiesProvider<T> provider, final Class<T> cls) {
        return new JRDataSource(){
            private final Iterator<T> it;
            private T currentItem;
            private Map<String, Object> additionalProperties;
            {
                this.it = filteredTickets.iterator();
                this.currentItem = null;
            }

            public boolean next() {
                if (!this.it.hasNext()) {
                    return false;
                }
                this.currentItem = this.it.next();
                this.additionalProperties = provider.getAdditionalProperties(this.currentItem);
                return true;
            }

            public Object getFieldValue(JRField jrField) {
                Object value = null;
                String fieldName = jrField.getName();
                if (this.additionalProperties.containsKey(fieldName)) {
                    value = this.additionalProperties.get(fieldName);
                } else {
                    Object value1 = this.currentItem;
                    String propertyName = fieldName;
                    value = ReflectionUtil.getValue((Class)cls, value1, (String)propertyName);
                }
                if (value == null) {
                    return null;
                }
                if (value instanceof Enum) {
                    return ((Enum)value).name();
                }
                if (value instanceof EntityReference) {
                    return ((EntityReference)value).toString();
                }
                if (value instanceof DictionaryReference) {
                    return ((DictionaryReference)value).toString();
                }
                return value;
            }
        };
    }

    @Override
    public <T, D extends BaseTemplateReportPageDescription> JasperPrint addPage(JasperPrint report, byte[] template, List<T> tickets, Map<String, Object> parameters, Class<T> cls, AdditionalPropertiesProvider<T> provider, List<Message> messages) throws Exception {
        JasperReport jr = JasperUtil.getReport((byte[])template);
        this.log.debug("trace of template:\r\n" + new String(template, "utf-8"));
        byte[] content = JasperUtil.fillReport((JasperReport)jr, parameters, (JRDataSource)this.createDataSource(tickets, provider, cls), (ReportParametersProvider)new ReportParametersProvider(){

            public Map<JRParameter, Object> fillAdditionalParameters(List<JRParameter> val) {
                return null;
            }
        });
        JasperPrint print = (JasperPrint)JRLoader.loadObject((InputStream)new ByteArrayInputStream(content));
        if (report == null) {
            return print;
        }
        for (Object page : print.getPages()) {
            report.addPage((JRPrintPage)page);
        }
        return report;
    }

    @Override
    public <D extends BaseTemplateReportDescription> JasperPrint createEmptyReport(D description) throws Exception {
        return null;
    }
}

