/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.template.common.renderer.xml;

import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportPageDescription;
import com.gridnine.xtrip.common.util.ValueHolder;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyShell;
import groovy.xml.MarkupBuilder;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.runtime.MethodClosure;

public class XmlGroovyScriptExecutor {
    public <T, D extends BaseTemplateReportPageDescription> String execute(byte[] template, List<T> tickets, Map<String, Object> parameters, List<Message> messages) throws Exception {
        Binding binding = new Binding();
        GroovyShell shell = new GroovyShell(binding);
        StringWriter writer = new StringWriter();
        MarkupBuilder builder = new MarkupBuilder((Writer)writer);
        this.fillBinding(binding, builder, tickets, parameters, shell, messages);
        shell.evaluate(new String(template, "utf-8"));
        return writer.toString();
    }

    private <T, D extends BaseTemplateReportPageDescription> void fillBinding(Binding binding, MarkupBuilder builder, List<T> tickets, Map<String, Object> parameters, GroovyShell shell, List<Message> messages) throws Exception {
        ValueHolder ticketsHolder = new ValueHolder(tickets);
        binding.setProperty("xml", (Object)builder);
        binding.setVariable("tickets", (Object)new MethodClosure(new TicketsClosure(ticketsHolder, shell), "doAction"));
        binding.setVariable("count", (Object)new MethodClosure(new CountClosure(ticketsHolder), "doAction"));
        binding.setVariable("groups", (Object)new MethodClosure(new GroupClosure(ticketsHolder, shell), "doAction"));
        binding.setVariable("error", (Object)new MethodClosure((Object)new ErrorClosure(MessageType.ERROR, messages), "doAction"));
        binding.setVariable("info", (Object)new MethodClosure((Object)new ErrorClosure(MessageType.MESSAGE, messages), "doAction"));
        binding.setVariable("warn", (Object)new MethodClosure((Object)new ErrorClosure(MessageType.WARNING, messages), "doAction"));
        binding.setVariable("message", (Object)new MethodClosure((Object)new MessageClosure(messages), "doAction"));
        binding.setVariable("parameters", new HashMap<String, Object>(parameters));
        binding.setProperty("allTickets", tickets);
    }

    static class MessageClosure {
        private final List<Message> messages;

        MessageClosure(List<Message> msgs) {
            this.messages = msgs;
        }

        public void doAction(Message msg) {
            this.messages.add(msg);
        }
    }

    static class ErrorClosure {
        private final MessageType type;
        private final List<Message> messages;

        ErrorClosure(MessageType messageType, List<Message> msgs) {
            this.type = messageType;
            this.messages = msgs;
        }

        public void doAction(String msg) {
            this.messages.add(SystemHelper.createMessage((MessageType)this.type, (String)msg, (Object[])new Object[0]));
        }

        public void doAction(Message msg) {
            Message msg2 = SystemHelper.createMessage((MessageType)this.type, (String)msg.getMessage().toString(), (Object[])new Object[0]);
            msg2.setDetails(msg.getDetails());
            this.messages.add(msg2);
        }

        public void doAction(String msg, Throwable t) {
            this.messages.add(SystemHelper.createMessage((MessageType)this.type, (String)msg, (Throwable)t, (Object[])new Object[0]));
        }

        public void doAction(Object msg, Object ... parameters) {
            this.messages.add(SystemHelper.createMessage((MessageType)this.type, (String)msg.toString(), (Object[])parameters));
        }

        public void doAction(Object msg, Throwable t, Object ... parameters) {
            this.messages.add(SystemHelper.createMessage((MessageType)this.type, (String)msg.toString(), (Throwable)t, (Object[])parameters));
        }
    }

    static class GroupClosure<T>
    extends BaseGroupClosure<T> {
        GroupClosure(ValueHolder<List<T>> ticketsHolder, GroovyShell shell) {
            super(ticketsHolder, shell);
        }
    }

    static abstract class BaseGroupClosure<T> {
        private final Object delegate;
        private final ValueHolder<List<T>> holder;

        BaseGroupClosure(ValueHolder<List<T>> ticketsHolder, GroovyShell shell) {
            this.holder = ticketsHolder;
            this.delegate = shell;
        }

        void doAction(Closure<?> cl) {
            this.doAction(null, cl);
        }

        void doAction(Closure<String> triggerCl, Closure<?> cl) {
            cl.setDelegate(this.delegate);
            LinkedHashMap batches = new LinkedHashMap();
            String lastValue = null;
            ArrayList lastColl = null;
            List originalItems = (List)this.holder.getValue();
            for (Object e : originalItems) {
                String value;
                String string = value = triggerCl == null ? "default" : (String)triggerCl.call(e);
                if (value == null) {
                    value = "";
                }
                if (lastColl == null || !value.equals(lastValue)) {
                    lastValue = value;
                    lastColl = new ArrayList();
                    batches.put(lastColl, value);
                }
                lastColl.add(e);
            }
            for (Map.Entry entry : batches.entrySet()) {
                this.holder.setValue(entry.getKey());
                this.beforeSectionStarted((String)entry.getValue(), (List)entry.getKey());
                cl.call(entry.getValue());
            }
            this.holder.setValue((Object)originalItems);
        }

        protected void beforeSectionStarted(String value, List<T> key) {
        }
    }

    static class CountClosure<T> {
        private final ValueHolder<List<T>> items;

        CountClosure(ValueHolder<List<T>> ticketsHolder) {
            this.items = ticketsHolder;
        }

        int doAction(Closure<?> cl) {
            return ((List)this.items.getValue()).size();
        }
    }

    static class TicketsClosure<T> {
        private final ValueHolder<List<T>> items;
        private final Object delegate;

        TicketsClosure(ValueHolder<List<T>> ticketsHolder, GroovyShell shell) {
            this.items = ticketsHolder;
            this.delegate = shell;
        }

        void doAction(Closure<?> cl) {
            cl.setDelegate(this.delegate);
            for (Object item : (List)this.items.getValue()) {
                cl.call(item);
            }
        }
    }

    static class ExcelClosure {
        ExcelClosure() {
        }

        void doAction(Closure<?> cl) {
            cl.call();
        }
    }
}

