/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.template.indexbased;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.reports.model.BaseSingleFileTemplateReportDescription;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportDocument;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportParameters;
import com.gridnine.xtrip.common.reports.model.IndexBasedTemplateReportDescription;
import com.gridnine.xtrip.common.reports.model.IndexBasedTemplateReportDocument;
import com.gridnine.xtrip.common.reports.model.IndexBasedTemplateReportPageDescription;
import com.gridnine.xtrip.common.reports.model.IndexBasedTemplateReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportHelper;
import com.gridnine.xtrip.common.reports.model.TemplateReportDocumentIndex;
import com.gridnine.xtrip.common.reports.model.TemplateReportPeriodUse;
import com.gridnine.xtrip.common.reports.render.template.common.CommonTemplateReportHelper;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.reports.prepare.template.common.BaseTemplateReportPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.template.common.TemplateReportHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class IndexBasedTemplateReportPrepareHandler<E extends BaseEntity, I extends EntityIndex<E>>
extends BaseTemplateReportPrepareHandler<I, I, IndexBasedTemplateReportParameters, IndexBasedTemplateReportDescription, IndexBasedTemplateReportPageDescription, IndexBasedTemplateReportDocument> {
    @Override
    public String getId() {
        return "index-based-template-report";
    }

    @Override
    protected void setData(IndexBasedTemplateReportDocument doc, IndexBasedTemplateReportParameters params, Map<String, Object> data) {
        doc.setParameters(params);
    }

    @Override
    protected IndexBasedTemplateReportDocument createDocument() {
        return new IndexBasedTemplateReportDocument();
    }

    @Override
    protected Class<I> getItemClass(IndexBasedTemplateReportDescription description) {
        try {
            return XHelper.getClass((String)description.getIndexClassName());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    protected List<IndexBasedTemplateReportPageDescription> getPages(IndexBasedTemplateReportDescription entity) {
        return entity.getPages();
    }

    @Override
    protected Map<String, Object> getGlobalParameters(Map<String, Object> data, IndexBasedTemplateReportParameters params, List<Message> messages) throws Exception {
        return TemplateReportHelper.getGlobalParameters(params, messages);
    }

    @Override
    protected List<I> createRecords(I product, Map<String, Object> data, List<Message> messages) throws Exception {
        return Collections.singletonList(product);
    }

    @Override
    protected List<I> getItems(IndexBasedTemplateReportParameters params, Map<String, Object> data, List<Message> messages, EntityContainer<IndexBasedTemplateReportDescription> descriptionCtr) throws Exception {
        IndexBasedTemplateReportDescription description = (IndexBasedTemplateReportDescription)EntityStorage.get().resolve(params.getDescription()).getEntity();
        Class idxCls = XHelper.getClass((String)description.getIndexClassName());
        SearchQuery query = new SearchQuery();
        TemplateReportPeriodUse periodUse = description.getPeriodUse();
        if (TextUtil.isBlank((String)description.getQueryScript()) && periodUse != TemplateReportPeriodUse.IGNORE) {
            String datePropertyName = description.getDatePropertyName();
            Date periodBegin = params.getPeriodBegin();
            Date periodEnd = params.getPeriodEnd();
            if (periodUse == null || periodUse == TemplateReportPeriodUse.DATE) {
                periodBegin = MiscUtil.clearTime((Date)periodBegin);
                periodEnd = MiscUtil.setDayEndTime((Date)periodEnd);
            }
            if (datePropertyName != null) {
                query.getCriteria().getCriterions().add(SearchCriterion.le((String)datePropertyName, (Object)periodEnd));
                query.getCriteria().getCriterions().add(SearchCriterion.ge((String)datePropertyName, (Object)periodBegin));
            }
        }
        SearchQuery query2 = CommonTemplateReportHelper.getModifiedCriterions((BaseTemplateReportParameters)params, (BaseSingleFileTemplateReportDescription)description, (List)description.getSortOrders(), messages);
        if (ReportHelper.isHasErrors(messages)) {
            return Collections.emptyList();
        }
        query.getCriteria().getCriterions().addAll(query2.getCriteria().getCriterions());
        query.getCriteria().getOrders().putAll(query2.getCriteria().getOrders());
        query.getPreferredProperties().addAll(query2.getPreferredProperties());
        query.getPreferredProperties().addAll(description.getPrefferedProperties());
        return EntityStorage.get().search(idxCls, query).getData();
    }

    @Override
    protected EntityReference<IndexBasedTemplateReportDescription> getDescription(IndexBasedTemplateReportParameters params) {
        return params.getDescription();
    }

    @Override
    public MiscUtil.Pair<EntityIndex<BaseTemplateReportDocument>, String> searchForDuplicate(IndexBasedTemplateReportParameters parametersNewReport, EntityReference<IndexBasedTemplateReportDescription> reportDescription, boolean periodIntersectionDisallowed) {
        MiscUtil.Pair res = new MiscUtil.Pair(null, null);
        SearchQuery query = IndexBasedTemplateReportPrepareHandler.createBaseSearchQuery((BaseTemplateReportParameters)parametersNewReport, reportDescription, periodIntersectionDisallowed);
        List docsInd = EntityStorage.get().search(TemplateReportDocumentIndex.class, query).getData();
        for (TemplateReportDocumentIndex ind : docsInd) {
            EntityContainer repCont = EntityStorage.get().resolve(ind.getSource());
            if (repCont == null || repCont.getEntity() == null) continue;
            BaseTemplateReportDocument repDoc = (BaseTemplateReportDocument)repCont.getEntity();
            BaseTemplateReportParameters parametersFoundReport = null;
            Method getParametersMethod = null;
            try {
                getParametersMethod = repDoc.getClass().getMethod("getParameters", new Class[0]);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (getParametersMethod != null) {
                try {
                    parametersFoundReport = (BaseTemplateReportParameters)getParametersMethod.invoke((Object)repDoc, new Object[0]);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
            boolean hasEqualParams = false;
            if (parametersFoundReport == null || !(parametersFoundReport instanceof IndexBasedTemplateReportParameters) || !(hasEqualParams = IndexBasedTemplateReportPrepareHandler.compareIndexBasedParams((IndexBasedTemplateReportParameters)parametersFoundReport, parametersNewReport))) continue;
            res.setFirst((Object)ind);
            res.setSecond((Object)ind.getTitle());
            return res;
        }
        return res;
    }

    private static boolean compareIndexBasedParams(IndexBasedTemplateReportParameters p1, IndexBasedTemplateReportParameters p2) {
        boolean equalAgency = p1.getAgency() == null && p2.getAgency() == null || p1.getAgency() != null && p1.getAgency().equals((Object)p2.getAgency());
        boolean equalAdditionalCriterions = IndexBasedTemplateReportPrepareHandler.compareAdditionalCriterions(p1.getAdditionalCriterions(), p2.getAdditionalCriterions());
        boolean equalRequestedParam = IndexBasedTemplateReportPrepareHandler.compareRequestedParams(p1.getRequestedParameters(), p2.getRequestedParameters());
        return equalAgency && equalAdditionalCriterions && equalRequestedParam;
    }
}

