/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.template.indexbased.primorskoe.mediator;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.GdsReference;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.reports.prepare.template.indexbased.primorskoe.mediator.PrimorskoeMediatorReportBatchData;
import com.gridnine.xtrip.server.reports.prepare.template.indexbased.primorskoe.mediator.PrimorskoeMediatorReportBatchRegistryItem;
import com.gridnine.xtrip.server.reports.prepare.template.indexbased.primorskoe.mediator.PrimorskoeMediatorReportBatchSummaryItem;
import com.gridnine.xtrip.server.reports.prepare.template.indexbased.primorskoe.mediator.PrimorskoeMediatorReportData;
import com.gridnine.xtrip.server.reports.prepare.template.indexbased.primorskoe.mediator.PrimorskoeMediatorReportsCommissionsHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public final class PrimorskoeMediatorReportPrepareHelper {
    public static PrimorskoeMediatorReportData prepareReport(List<CommonProductIndex> indexList) throws Exception {
        PrimorskoeMediatorReportData result = new PrimorskoeMediatorReportData();
        result.setDirectorName("\u0421\u043e\u043b\u043e\u0434\u043e\u0432\u043d\u0438\u043a\u043e\u0432\u0430 \u041d.\u041d.");
        result.setExecutrorName("\u041d\u0430\u0437\u0430\u0440\u043e\u0432\u0430 \u041f.\u041d.");
        result.setPrimorskoeFullName("\u041e\u0410\u041e \"\u041f\u0440\u0438\u043c\u043e\u0440\u0441\u043a\u043e\u0435 \u0430\u044d\u0440\u043e\u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u043e\"");
        result.setPrimorskoeShortName("\u041e\u0410\u041e \"\u041f\u0440\u0438\u043c\u0430\u044d\u0440\u043e\u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u043e\"");
        result.setPrimorskoePhoneNumber("+7 (423) 241-05-99 ");
        for (CommonProductIndex idx : indexList) {
            Product prod;
            Product prod2;
            EntityContainer bookingCtr = EntityStorage.get().resolve(idx.getSource());
            if (bookingCtr == null) {
                throw Xeption.forEndUser((String)"\u043d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0437\u0430\u043a\u0430\u0437 \"{0}\"", (Object[])new Object[]{idx.getSource()});
            }
            BaseProduct bp = BookingHelper.findProduct((BookingFile)((BookingFile)bookingCtr.getEntity()), (String)idx.getNavigationKey());
            EntityContainer mediatorCtr = EntityStorage.get().resolve(idx.getMediator());
            if (mediatorCtr == null) {
                throw Xeption.forDeveloper((String)"\u043d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043f\u0440\u043e\u0444\u0438\u043b\u044c \u041f\u043e\u0441\u0440\u0435\u0434\u043d\u0438\u043a\u0430 \"{0}\" \u0432 \u0431\u0438\u043b\u0435\u0442\u0435 {1}", (Object[])new Object[]{idx.getMediator(), idx.getSystemNumbers()});
            }
            String mediatorName = ProfileHelper.getFullName((Organization)((Organization)mediatorCtr.getEntity()), (Locale)LocaleHelper.RU_LOCALE, (boolean)false);
            String mediatorShortName = ((Organization)mediatorCtr.getEntity()).getShortName() != null ? L10nStringHelper.getValue((L10nString)((Organization)mediatorCtr.getEntity()).getShortName(), (Locale)LocaleHelper.RU_LOCALE, (boolean)false) : null;
            PrimorskoeMediatorReportBatchData batchData = (PrimorskoeMediatorReportBatchData)CollectionUtil.find(result.getBatches(), (Object)mediatorName, (coll, name) -> TextUtil.isSame((String)name, (String)coll.getMediatorName()));
            if (batchData == null) {
                batchData = new PrimorskoeMediatorReportBatchData();
                batchData.setMediatorName(mediatorName);
                batchData.setMediatorShortName(mediatorShortName);
                batchData.setMediator((EntityReference<Organization>)idx.getMediator());
                result.getBatches().add(batchData);
            }
            batchData.setContractNumber(PrimorskoeMediatorReportsCommissionsHelper.getContractNumber((EntityReference<Organization>)idx.getMediator()));
            PrimorskoeMediatorReportBatchRegistryItem registryItem = new PrimorskoeMediatorReportBatchRegistryItem();
            if (bp instanceof Product) {
                prod2 = (Product)bp;
                ArrayList<String> airlines = new ArrayList<String>();
                for (SegmentTariff st : prod2.getSegmentTariffs()) {
                    for (Segment seg : st.getSegments()) {
                        Airline airline2 = (Airline)DictionaryCache.get().resolveReference(seg.getAirline());
                        Object airlineCode = "?";
                        if (airline2 != null) {
                            airlineCode = DictHelper.getCodeVariant((BaseDictionary)airline2, (CodeSystem[])new CodeSystem[]{CodeSystem.CRT, CodeSystem.IATA});
                        }
                        if (airlines.contains(airlineCode)) continue;
                        airlines.add((String)airlineCode);
                    }
                }
                registryItem.setAirline(TextUtil.join((String)"-", airlines));
            } else if (bp instanceof RailwayProduct) {
                registryItem.setAirline("\u0416+");
                prod2 = (RailwayProduct)bp;
            }
            ProductHandler handler = GeneralProductHelper.getHandler((BaseProduct)bp);
            EntityContainer issuingAgentCtr = EntityStorage.get().resolve(handler.findIssuingAgent(bp));
            if (issuingAgentCtr != null) {
                for (GdsReference item3 : ((Person)issuingAgentCtr.getEntity()).getGdsReferences()) {
                    if (TextUtil.isBlank((String)item3.getReference())) continue;
                    registryItem.setValidatorCode(item3.getReference());
                    if (item3.getGdsName() != GdsName.SIRENA) continue;
                    registryItem.setValidatorCode(item3.getReference());
                    break;
                }
            }
            registryItem.setTransportationType(handler.getTransportationType(bp));
            ProductStatus status = handler.getStatus(bp);
            registryItem.setStatus(status);
            if (!ProductStatusHandler.getAllVoidStatuses().contains(status)) {
                GeneralProductContractRelationData vendorContractRelation = GeneralProductHelper.getVendorContractRelation((BaseProduct)bp);
                if (vendorContractRelation != null) {
                    for (GeneralProductFop fop : vendorContractRelation.getFops()) {
                        if (fop.getType() == PaymentType.TICKET) continue;
                        registryItem.setPaymentType(fop.getType());
                        break;
                    }
                }
                GeneralProductContractRelationData clientContractRelation = GeneralProductHelper.getClientContractRelation((BaseProduct)bp);
                registryItem.setRefunded(handler.getNextProduct(bp) != null && handler.getStatus(handler.getNextProduct(bp)) == ProductStatus.REFUND);
                if (clientContractRelation.getServiceData().getTotalPrice() != null) {
                    registryItem.setCost(MiscUtil.guarded((BigDecimal)clientContractRelation.getServiceData().getTotalPrice()));
                    registryItem.setTariff(MiscUtil.guarded((BigDecimal)clientContractRelation.getServiceData().getDetalization().getFare()));
                    registryItem.setAirlineIncome(MiscUtil.guarded((BigDecimal)clientContractRelation.getServiceData().getTotalPrice()));
                } else {
                    BigDecimal totalPrice = MiscUtil.guarded((BigDecimal)handler.getEquivalentFare(bp));
                    BigDecimal taxes = MiscUtil.guarded((BigDecimal)GeneralProductHelper.getEquivalentTaxAmount((Collection)handler.getTaxes(bp)));
                    totalPrice = totalPrice.add(taxes);
                    if (handler.getPenalty(bp) != null) {
                        totalPrice = handler.getStatus(bp) == ProductStatus.REFUND ? totalPrice.subtract(handler.getPenalty(bp)) : totalPrice.add(handler.getPenalty(bp));
                    }
                    registryItem.setCost(totalPrice);
                    registryItem.setTariff(MiscUtil.guarded((BigDecimal)handler.getEquivalentFare(bp)));
                    registryItem.setAirlineIncome(totalPrice);
                }
                if (bp instanceof RailwayProduct) {
                    registryItem.setTariff(BigDecimal.ZERO);
                }
                registryItem.setAgencyCommission(GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)vendorContractRelation.getCommissions(), (Set)GeneralProductHelper.commissionPropertyTypes, null, null)));
                registryItem.setAgencyFees(GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)clientContractRelation.getCommissions(), (Set)GeneralProductHelper.feePropertyTypes, null, null)));
                BigDecimal plataZakazchika = registryItem.getAgencyFees();
                registryItem.setPlataZakazchika(plataZakazchika);
                registryItem.setIssuedInExchange(status == ProductStatus.SELL && handler.getPreviousProduct(bp) != null && handler.getStatus(handler.getPreviousProduct(bp)) == ProductStatus.EXCHANGE);
                if (status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE) {
                    registryItem.setCost(registryItem.getCost().negate());
                    registryItem.setTariff(registryItem.getTariff().negate());
                    registryItem.setAirlineIncome(registryItem.getAirlineIncome().negate());
                    registryItem.setAgencyCommission(registryItem.getAgencyCommission().negate());
                    registryItem.setPlataZakazchika(registryItem.getPlataZakazchika().negate());
                    registryItem.setAgencyFees(registryItem.getAgencyFees().negate());
                }
                ArrayList<PaymentType> paymentTypes = new ArrayList<PaymentType>();
                for (GeneralProductFop fop : clientContractRelation.getFops()) {
                    if (fop.getEquivalentAmount() == null || BigDecimal.ZERO.compareTo(fop.getEquivalentAmount()) == 0 || fop.getType() == PaymentType.TICKET || paymentTypes.contains(fop.getType())) continue;
                    paymentTypes.add(fop.getType());
                }
                if (paymentTypes.isEmpty()) {
                    registryItem.setFopsString("SS");
                } else {
                    StringBuilder sb = new StringBuilder();
                    for (int n = 0; n < paymentTypes.size(); ++n) {
                        if (n > 0) {
                            sb.append(", ");
                        }
                        sb.append(PrimorskoeMediatorReportPrepareHelper.getPaymentTypeCode((PaymentType)paymentTypes.get(n)));
                    }
                    sb.append(",SS");
                    registryItem.setFopsString(sb.toString());
                }
            } else {
                registryItem.setAirlineIncome(BigDecimal.ZERO);
                registryItem.setCommission(BigDecimal.ZERO);
                registryItem.setFopsString("");
                registryItem.setTariff(BigDecimal.ZERO);
                registryItem.setPlataZakazchika(BigDecimal.ZERO);
                registryItem.setAgencyCommission(BigDecimal.ZERO);
                registryItem.setAgencyFees(BigDecimal.ZERO);
            }
            registryItem.setOperationDate(handler.findIssueDate(bp));
            StringBuilder sb = new StringBuilder();
            for (Traveller pass : handler.getTravellers(bp)) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(pass.getNameInGds() == null ? pass.getName() : pass.getNameInGds());
            }
            registryItem.setPassengerName(sb.toString());
            registryItem.setProductType(handler.getProductType(bp));
            String prefix = "";
            if (bp instanceof Product) {
                prod = (Product)bp;
                if (AirProductHelper.isTCHTicket((Product)prod)) {
                    if (BookingHelper.isEticket((DictionaryReference)prod.getBlankType())) {
                        prefix = "\u042d ";
                    }
                } else {
                    prefix = prod.getBlankOwnerNumber() + " ";
                }
            }
            if (bp instanceof RailwayProduct && BookingHelper.isEticket((DictionaryReference)(prod = (RailwayProduct)bp).getBlankType())) {
                prefix = "\u042d ";
            }
            StringBuilder sb2 = new StringBuilder();
            for (String number : handler.getProductNumbers(bp)) {
                if (sb2.length() > 0) {
                    sb2.append(",");
                }
                sb2.append(number);
            }
            registryItem.setTicketNumber(prefix + sb2.toString());
            String sortingTicketNumber = TextUtil.join((String)",", (Iterable)handler.getProductNumbers(bp));
            if (bp instanceof Product) {
                prod = (Product)bp;
                sortingTicketNumber = prod.getSystemNumber();
                if (prod.getPreviousProduct() != null && prod.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE) {
                    sortingTicketNumber = prod.getPreviousProduct().getSystemNumber() + "-exchange";
                }
            }
            if (handler.getStatus(bp) == ProductStatus.REFUND) {
                sortingTicketNumber = sortingTicketNumber + "-refund";
            }
            registryItem.setSortingTicketNumber(sortingTicketNumber);
            batchData.getRegistryData().getItems().add(registryItem);
        }
        for (PrimorskoeMediatorReportBatchData batchData : result.getBatches()) {
            Collections.sort(batchData.getRegistryData().getItems(), (item1, item2) -> TextUtil.compare((String)item1.getSortingTicketNumber(), (String)item2.getSortingTicketNumber(), (boolean)false, (boolean)false));
            BigDecimal totalCost = BigDecimal.ZERO;
            BigDecimal totalTariff = BigDecimal.ZERO;
            PrimorskoeMediatorReportsCommissionsHelper.updateCommissions(batchData.getMediator(), batchData.getRegistryData());
            for (PrimorskoeMediatorReportBatchRegistryItem registryItem : batchData.getRegistryData().getItems()) {
                totalCost = totalCost.add(MiscUtil.guarded((BigDecimal)registryItem.getCost()));
                totalTariff = totalTariff.add(MiscUtil.guarded((BigDecimal)registryItem.getTariff()));
                PrimorskoeMediatorReportBatchSummaryItem summaryItem = (PrimorskoeMediatorReportBatchSummaryItem)CollectionUtil.find(batchData.getSummaryData().getItems(), (Object)registryItem.getAirline(), (item, airline) -> TextUtil.equals((String)item.getAirline(), (String)airline, (boolean)true));
                if (summaryItem == null) {
                    summaryItem = new PrimorskoeMediatorReportBatchSummaryItem();
                    summaryItem.setAirline(registryItem.getAirline());
                    batchData.getSummaryData().getItems().add(summaryItem);
                }
                summaryItem.setCommission(MiscUtil.sum((BigDecimal[])new BigDecimal[]{summaryItem.getCommission(), registryItem.getCommission()}));
                summaryItem.setCost(MiscUtil.sum((BigDecimal[])new BigDecimal[]{summaryItem.getCost(), registryItem.getCost()}));
                summaryItem.setTariff(MiscUtil.sum((BigDecimal[])new BigDecimal[]{summaryItem.getTariff(), registryItem.getTariff()}));
            }
            batchData.getSummaryData().setTotalCommission(batchData.getRegistryData().getTotalCommission());
            batchData.getSummaryData().setTotalCost(totalCost);
            batchData.getSummaryData().setTotalTariff(totalTariff);
            batchData.getRegistryData().setTotalTariff(totalTariff);
            batchData.getRegistryData().setTotalCost(totalCost);
            Collections.sort(batchData.getSummaryData().getItems(), (item1, item2) -> TextUtil.compare((String)item1.getAirline(), (String)item2.getAirline(), (boolean)false, (boolean)false));
        }
        Collections.sort(result.getBatches(), (b1, b2) -> TextUtil.compare((String)b1.getMediatorName(), (String)b2.getMediatorName(), (boolean)false, (boolean)false));
        return result;
    }

    private static int getStatusIndex(ProductStatus status) {
        switch (status) {
            case REFUND: {
                return 2;
            }
        }
        return 0;
    }

    private static String getPaymentTypeCode(PaymentType paymentType) {
        switch (paymentType) {
            case INVOICE: {
                return "\u041f\u041f";
            }
            case CREDIT_CARD: {
                return "\u041f\u041a";
            }
            case MTD_AGENCY: {
                return "\u041f\u0421";
            }
            case BANK: {
                return "\u041a\u0411";
            }
            case PTA: {
                return "PT";
            }
            case CREDIT_CARD_AGENCY: {
                return "\u041f\u041a";
            }
            case MTD: {
                return "\u041a";
            }
            case PREPAYMENT: {
                return "\u0410\u0412";
            }
            case SERVICE_DEMAND_AGENCY: {
                return "\u0421\u0422";
            }
            case ELECTRONIC: {
                return "\u041f\u042d";
            }
            case SERVICE_DEMAND: {
                return "RR";
            }
            case CASH: {
                return "\u041a\u041e";
            }
            case INTERLINE: {
                return "\u0412\u0417";
            }
            case CREDIT: {
                return "\u041a\u0420";
            }
        }
        return "";
    }
}

