/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.template.indexbased.primorskoe.mediator;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.server.reports.prepare.template.indexbased.primorskoe.mediator.PrimorskoeMediatorReportBatchRegistryData;
import com.gridnine.xtrip.server.reports.prepare.template.indexbased.primorskoe.mediator.PrimorskoeMediatorReportBatchRegistryItem;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PrimorskoeMediatorReportsCommissionsHelper {
    private static Map<EntityReference<Organization>, MediatorData> mediators = new HashMap<EntityReference<Organization>, MediatorData>();

    public static String getContractNumber(EntityReference<Organization> orgRef) throws Exception {
        MediatorData mediatorData = mediators.get(orgRef);
        if (mediatorData == null) {
            throw Xeption.forDeveloper((String)"\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0434\u0430\u043d\u043d\u044b\u0435 \u043f\u043e\u0441\u0440\u0435\u0434\u043d\u0438\u043a\u0430 {0}", (Object[])new Object[]{orgRef});
        }
        return mediatorData.getContractNumber();
    }

    public static void updateCommissions(EntityReference<Organization> orgRef, PrimorskoeMediatorReportBatchRegistryData data) throws Exception {
        MediatorData mediatorData = mediators.get(orgRef);
        if (mediatorData == null) {
            throw Xeption.forDeveloper((String)"\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0434\u0430\u043d\u043d\u044b\u0435 \u043f\u043e\u0441\u0440\u0435\u0434\u043d\u0438\u043a\u0430 {0}", (Object[])new Object[]{orgRef});
        }
        mediatorData.commissionUpdater.updateCommissions(data);
    }

    private static void register(String orgUid, MediatorData data) {
        mediators.put((EntityReference<Organization>)new EntityReference(orgUid, Organization.class, null), data);
    }

    static {
        PrimorskoeMediatorReportsCommissionsHelper.register("0000000EOJ", new MediatorDataBuilder().contractNumber("12/17-16.01.01.2016").perTicketCommission().amurintourMtd(40.0, 40.0).fixedExchangeRefund(300.0).percentFromAgencyCommission(40.0).end().build());
        PrimorskoeMediatorReportsCommissionsHelper.register("0000000OG1", new MediatorDataBuilder().contractNumber("2/17-17 \u043e\u0442 \"01\" \u044f\u043d\u0432\u0430\u0440\u044f 2017 \u0433\u043e\u0434\u0430").perTicketCommission().asianaAndCorean(1.5, 50.0).mvlAeroflot(1.5).percentFromAgencyFees(20.0).end().build());
        PrimorskoeMediatorReportsCommissionsHelper.register("0000000N1U", new MediatorDataBuilder().contractNumber("8/17-16 01.01.2016").perTicketCommission().asianaAndCorean(1.5, 50.0).percentFromAgencyFees(20.0).end().build());
        PrimorskoeMediatorReportsCommissionsHelper.register("0000000D8Q", new MediatorDataBuilder().contractNumber("3/17-16 \u043e\u0442 \"01\" \u044f\u043d\u0432\u0430\u0440\u044f 2016 \u0433\u043e\u0434\u0430").perTicketCommission().asianaAndCorean(1.5, 50.0).percentFromAgencyFees(20.0).end().build());
        PrimorskoeMediatorReportsCommissionsHelper.register("0000000OF7", new MediatorDataBuilder().contractNumber("1/17-17 01.01.2017").perTicketCommission().percentFromAgencyFees(20.0).end().build());
        PrimorskoeMediatorReportsCommissionsHelper.register("0000000CBK", new MediatorDataBuilder().contractNumber("9/17-16 \u043e\u0442 \"01\" \u044f\u043d\u0432\u0430\u0440\u044f 2016 \u0433\u043e\u0434\u0430").perTicketCommission().asianaAndCorean(1.5, 50.0).percentFromAgencyFees(20.0).end().build());
        PrimorskoeMediatorReportsCommissionsHelper.register("0000000JFJ", new MediatorDataBuilder().contractNumber("11/17-16 \u043e\u0442 01.01.2016 01.01.2016").perTicketCommission().asianaAndCorean(1.5, 50.0).percentFromAgencyFees(20.0).end().build());
        PrimorskoeMediatorReportsCommissionsHelper.register("\u0417\u0430\u0445\u0430\u0440\u044c\u0435\u0432\u0430 \u041b.\u0418.", new MediatorDataBuilder().contractNumber("\u0417\u0430\u0445\u0430\u0440\u044c\u0435\u0432\u0430 \u041b.\u0418.").perTicketCommission().asianaAndCorean(1.5, 50.0).percentFromAgencyFees(20.0).end().build());
        PrimorskoeMediatorReportsCommissionsHelper.register(" \u0412\u0430\u0441\u044c\u043a\u043e\u0432\u0430 \u041c.\u0412. ", new MediatorDataBuilder().contractNumber(" \u0412\u0430\u0441\u044c\u043a\u043e\u0432\u0430 \u041c.\u0412. ").perTicketCommission().asianaAndCorean(1.5, 50.0).percentFromAgencyFees(20.0).end().build());
        PrimorskoeMediatorReportsCommissionsHelper.register("0000000LC6", new MediatorDataBuilder().contractNumber("6/17-16 \u043e\u0442 \"01\" \u044f\u043d\u0432\u0430\u0440\u044f 2016 \u0433\u043e\u0434\u0430").perTicketCommission().asianaAndCorean(1.5, 50.0).percentFromAgencyFees(20.0).end().build());
        PrimorskoeMediatorReportsCommissionsHelper.register("0000000HF2", new MediatorDataBuilder().contractNumber("201/06-17 \u043e\u0442 \"01\" \u044f\u043d\u0432\u0430\u0440\u044f 2016 \u0433\u043e\u0434\u0430").perTicketCommission().customRule(item -> {
            if (item.isRefunded() || item.getStatus() == ProductStatus.REFUND) {
                item.setCommission(BigDecimal.ZERO);
                return true;
            }
            item.setCommission(BigDecimal.valueOf(1L).multiply(item.getTariff()).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP));
            return true;
        }).end().build());
        PrimorskoeMediatorReportsCommissionsHelper.register("0000000NBW", new MediatorDataBuilder().contractNumber("130/06-16 01.05.2016").perTicketCommission().asianaAndCorean(1.5, 50.0).percentFromAgencyFeesAndAgencyCommission(20.0, 50.0).end().build());
        PrimorskoeMediatorReportsCommissionsHelper.register("00000000Y6", new MediatorDataBuilder().contractNumber("63/06-16 \u043e\u0442 \"01\" \u044f\u043d\u0432\u0430\u0440\u044f 2016 \u0433\u043e\u0434\u0430").perTicketCommission().asianaAndCorean(1.5, 50.0).percentFromAgencyFees(20.0).end().build());
        PrimorskoeMediatorReportsCommissionsHelper.register("0000000339", new MediatorDataBuilder().contractNumber("148/06-16 \u043e\u0442 \"10\" \u044f\u043d\u0432\u0430\u0440\u044f 2016 \u0433\u043e\u0434\u0430").perTicketCommission().asianaAndCorean(1.5, 50.0).percentFromAgencyFees(20.0).end().build());
        PrimorskoeMediatorReportsCommissionsHelper.register("\u041e\u041e\u041e \u00ab\u041e\u043f\u0442\u0438\u043c\u0430 \u0442\u0443\u0440\u00bb", new MediatorDataBuilder().contractNumber("\u041e\u041e\u041e \u00ab\u041e\u043f\u0442\u0438\u043c\u0430 \u0442\u0443\u0440\u00bb").perTicketCommission().asianaAndCorean(1.5, 50.0).percentFromAgencyFees(20.0).end().build());
        PrimorskoeMediatorReportsCommissionsHelper.register("000000018B", new MediatorDataBuilder().contractNumber("7/17-16 01.01.2016").perTicketCommission().asianaAndCorean(1.5, 50.0).percentFromAgencyFees(20.0).end().build());
        PrimorskoeMediatorReportsCommissionsHelper.register("0000000QST", new MediatorDataBuilder().contractNumber("209/09-18 \u043e\u0442 \"26\" \u0441\u0435\u043d\u0442\u044f\u0431\u0440\u044f 2018 \u0433\u043e\u0434\u0430").totalCommission(data -> {
            BigDecimal totalFee = BigDecimal.ZERO;
            for (PrimorskoeMediatorReportBatchRegistryItem item : data.getItems()) {
                totalFee = totalFee.add(item.getAgencyFees());
            }
            data.setTotalCommission(BigDecimal.valueOf(50L).multiply(totalFee).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP));
        }).build());
        PrimorskoeMediatorReportsCommissionsHelper.register("_1FR12BOWY", new MediatorDataBuilder().contractNumber("28/17-10 \u043e\u0442 \"15\" \u0441\u0435\u043d\u0442\u044f\u0431\u0440\u044f 2010 01.01.2018").perTicketCommission().asianaAndCorean(1.5, 50.0).percentFromAgencyFees(20.0).end().build());
        PrimorskoeMediatorReportsCommissionsHelper.register("00000009SX", new MediatorDataBuilder().contractNumber("20/17-13 \u043e\u0442 \"01\" \u0438\u044e\u043b\u044f 2013 \u0433\u043e\u0434\u0430").perTicketCommission().customRule(item -> {
            BigDecimal standardComm = BigDecimal.valueOf(0.5).multiply(item.getTariff()).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP);
            BigDecimal maxComm = BigDecimal.valueOf(50L).multiply(item.getAgencyCommission()).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP);
            item.setCommission(maxComm.abs().compareTo(standardComm.abs()) < 0 ? maxComm : standardComm);
            return true;
        }).end().build());
    }

    static interface PrimorskoyeMediatorReportCommissionUpdater {
        public void updateCommissions(PrimorskoeMediatorReportBatchRegistryData var1);
    }

    static class MediatorPerTicketCommissionBuilder {
        private MediatorDataBuilder parent;
        private List<MediatorPerTicketCommissionRule> rules = new ArrayList<MediatorPerTicketCommissionRule>();

        MediatorPerTicketCommissionBuilder(MediatorDataBuilder parent) {
            this.parent = parent;
        }

        MediatorDataBuilder end() {
            this.parent.result.commissionUpdater = new MediatorPerTicketCommissionUpdater(this.rules);
            return this.parent;
        }

        MediatorPerTicketCommissionBuilder customRule(MediatorPerTicketCommissionRule rule) {
            this.rules.add(rule);
            return this;
        }

        MediatorPerTicketCommissionBuilder percentFromAgencyCommission(final double comm) {
            this.rules.add(new MediatorPerTicketCommissionRule(){

                @Override
                public boolean apply(PrimorskoeMediatorReportBatchRegistryItem item) {
                    item.setCommission(BigDecimal.valueOf(comm).multiply(item.getAgencyCommission()).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP));
                    return true;
                }
            });
            return this;
        }

        MediatorPerTicketCommissionBuilder percentFromAgencyFees(final double comm) {
            this.rules.add(new MediatorPerTicketCommissionRule(){

                @Override
                public boolean apply(PrimorskoeMediatorReportBatchRegistryItem item) {
                    item.setCommission(BigDecimal.valueOf(comm).multiply(item.getAgencyFees()).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP));
                    return true;
                }
            });
            return this;
        }

        MediatorPerTicketCommissionBuilder percentFromAgencyFeesAndAgencyCommission(final double commFromFees, final double commFromCommission) {
            this.rules.add(new MediatorPerTicketCommissionRule(){

                @Override
                public boolean apply(PrimorskoeMediatorReportBatchRegistryItem item) {
                    item.setCommission(BigDecimal.valueOf(commFromFees).multiply(item.getAgencyFees()).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP).add(BigDecimal.valueOf(item.getStatus() == ProductStatus.REFUND || item.getStatus() == ProductStatus.EXCHANGE ? -1L : 1L).multiply(BigDecimal.valueOf(commFromCommission).multiply(item.getAgencyCommission()).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP))));
                    return true;
                }
            });
            return this;
        }

        MediatorPerTicketCommissionBuilder fixedExchangeRefund(final double comm) {
            this.rules.add(new MediatorPerTicketCommissionRule(){

                @Override
                public boolean apply(PrimorskoeMediatorReportBatchRegistryItem item) {
                    if (item.isIssuedInExchange() || item.getStatus() == ProductStatus.REFUND) {
                        item.setCommission(BigDecimal.valueOf(comm));
                        return true;
                    }
                    return false;
                }
            });
            return this;
        }

        MediatorPerTicketCommissionBuilder amurintourMtd(final double percent1, final double percent2) {
            this.rules.add(new MediatorPerTicketCommissionRule(){

                @Override
                public boolean apply(PrimorskoeMediatorReportBatchRegistryItem item) {
                    if (item.getPaymentType() == PaymentType.CREDIT) {
                        item.setCommission(BigDecimal.valueOf(percent1).multiply(item.getPlataZakazchika()).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP).add(BigDecimal.valueOf(percent2).multiply(item.getAgencyCommission()).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP)));
                        return true;
                    }
                    return false;
                }
            });
            return this;
        }

        MediatorPerTicketCommissionBuilder asianaAndCorean(final double percent, final double maximum) {
            this.rules.add(new MediatorPerTicketCommissionRule(){

                @Override
                public boolean apply(PrimorskoeMediatorReportBatchRegistryItem item) {
                    if ("KE".equals(item.getAirline()) || "OZ".equals(item.getAirline())) {
                        BigDecimal standardComm = BigDecimal.valueOf(percent).multiply(item.getTariff()).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP);
                        if (maximum == -1.0) {
                            item.setCommission(standardComm);
                            return true;
                        }
                        BigDecimal maxComm = BigDecimal.valueOf(maximum).multiply(item.getAirlineIncome()).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP);
                        item.setCommission(maxComm.abs().compareTo(standardComm.abs()) < 0 ? maxComm : standardComm);
                        return true;
                    }
                    return false;
                }
            });
            return this;
        }

        MediatorPerTicketCommissionBuilder mvlAeroflot(final double percent) {
            this.rules.add(new MediatorPerTicketCommissionRule(){

                @Override
                public boolean apply(PrimorskoeMediatorReportBatchRegistryItem item) {
                    if ("SU".equals(item.getAirline())) {
                        BigDecimal standardComm = BigDecimal.valueOf(percent).multiply(item.getTariff()).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP);
                        item.setCommission(standardComm);
                        return true;
                    }
                    return false;
                }
            });
            return this;
        }
    }

    static interface MediatorPerTicketCommissionRule {
        public boolean apply(PrimorskoeMediatorReportBatchRegistryItem var1);
    }

    static class MediatorPerTicketCommissionUpdater
    implements PrimorskoyeMediatorReportCommissionUpdater {
        private List<MediatorPerTicketCommissionRule> rules;

        MediatorPerTicketCommissionUpdater(List<MediatorPerTicketCommissionRule> rules) {
            this.rules = rules;
        }

        @Override
        public void updateCommissions(PrimorskoeMediatorReportBatchRegistryData data) {
            BigDecimal totalCommission = BigDecimal.ZERO;
            block0: for (PrimorskoeMediatorReportBatchRegistryItem item : data.getItems()) {
                if (item.getProductType() == ProductType.RAILWAY_PRODUCT || item.getProductType() == ProductType.RAILWAY_REFERENCE_MCO || item.getProductType() == ProductType.RAILWAY_CRIMEA_MCO) {
                    item.setCommission(BigDecimal.ZERO);
                    continue;
                }
                for (MediatorPerTicketCommissionRule rule : this.rules) {
                    if (!rule.apply(item)) continue;
                    if (item.getStatus() == ProductStatus.REFUND) {
                        item.setCommission(item.getCommission().negate());
                    }
                    totalCommission = totalCommission.add(item.getCommission());
                    continue block0;
                }
                item.setCommission(BigDecimal.ZERO);
            }
            data.setTotalCommission(totalCommission);
        }
    }

    static class MediatorDataBuilder {
        MediatorData result = new MediatorData();

        MediatorDataBuilder() {
        }

        MediatorDataBuilder contractNumber(String contractNumber) {
            this.result.setContractNumber(contractNumber);
            return this;
        }

        MediatorData build() {
            return this.result;
        }

        MediatorPerTicketCommissionBuilder perTicketCommission() {
            return new MediatorPerTicketCommissionBuilder(this);
        }

        MediatorDataBuilder totalCommission(PrimorskoyeMediatorReportCommissionUpdater updater) {
            this.result.commissionUpdater = updater;
            return this;
        }
    }

    static class MediatorData {
        private String contractNumber;
        private PrimorskoyeMediatorReportCommissionUpdater commissionUpdater;

        MediatorData() {
        }

        public String getContractNumber() {
            return this.contractNumber;
        }

        public void setContractNumber(String contractNumber) {
            this.contractNumber = contractNumber;
        }

        public void setCommissionUpdater(PrimorskoyeMediatorReportCommissionUpdater commissionUpdater) {
            this.commissionUpdater = commissionUpdater;
        }

        public PrimorskoyeMediatorReportCommissionUpdater getCommissionUpdater() {
            return this.commissionUpdater;
        }
    }
}

