/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.template.insuranceaccident;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccident;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccidentHelper;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccidentIndex;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.reports.model.BaseGeneralProductsTemplateReportParameters;
import com.gridnine.xtrip.common.reports.model.BaseSingleFileTemplateReportDescription;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportDocument;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportParameters;
import com.gridnine.xtrip.common.reports.model.GeneralProductsTemplateReportFilteringParameters;
import com.gridnine.xtrip.common.reports.model.GeneralProductsTemplateReportPageDescription;
import com.gridnine.xtrip.common.reports.model.InsuranceAccidentTemplateReportDescription;
import com.gridnine.xtrip.common.reports.model.InsuranceAccidentTemplateReportDocument;
import com.gridnine.xtrip.common.reports.model.InsuranceAccidentTemplateReportParameters;
import com.gridnine.xtrip.common.reports.model.InsuranceAccidentTemplateReportTicket;
import com.gridnine.xtrip.common.reports.render.template.common.CommonTemplateReportHelper;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.reports.prepare.template.common.BaseGroupedTemplateReportPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.template.common.TemplateReportHelper;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsuranceAccidentTemplateReportPrepareHandler
extends BaseGroupedTemplateReportPrepareHandler<InsuranceAccident, InsuranceAccidentTemplateReportTicket, InsuranceAccidentTemplateReportParameters, InsuranceAccidentTemplateReportDescription, GeneralProductsTemplateReportPageDescription, InsuranceAccidentTemplateReportDocument, BookingFile> {
    private static final Logger log = LoggerFactory.getLogger(InsuranceAccidentTemplateReportPrepareHandler.class);

    @Override
    public String getId() {
        return "insurance-accident-template-report";
    }

    @Override
    protected void setData(InsuranceAccidentTemplateReportDocument doc, InsuranceAccidentTemplateReportParameters params, Map<String, Object> data) {
        doc.setParameters(params);
    }

    @Override
    protected InsuranceAccidentTemplateReportDocument createDocument() {
        return new InsuranceAccidentTemplateReportDocument();
    }

    @Override
    protected Class<InsuranceAccidentTemplateReportTicket> getItemClass(InsuranceAccidentTemplateReportDescription description) {
        return InsuranceAccidentTemplateReportTicket.class;
    }

    @Override
    protected List<GeneralProductsTemplateReportPageDescription> getPages(InsuranceAccidentTemplateReportDescription entity) {
        return entity.getPages();
    }

    @Override
    protected Map<String, Object> getGlobalParameters(Map<String, Object> data, InsuranceAccidentTemplateReportParameters params, List<Message> messages) throws Exception {
        Map<String, Object> result = TemplateReportHelper.getGlobalParameters(params, messages);
        result.put(GeneralProductsTemplateReportFilteringParameters.AGENCY.name(), MiscUtil.toString((Object)params.getAgency()));
        result.put(GeneralProductsTemplateReportFilteringParameters.AGENT.name(), MiscUtil.toString((Object)params.getAgent()));
        result.put(GeneralProductsTemplateReportFilteringParameters.BLANK_OWNER.name(), MiscUtil.toString((Object)params.getBlankOwner()));
        result.put(GeneralProductsTemplateReportFilteringParameters.CLIENT.name(), MiscUtil.toString((Object)params.getClient()));
        result.put(GeneralProductsTemplateReportFilteringParameters.SALES_POINT.name(), MiscUtil.toString((Object)params.getSalesPoint()));
        result.put(GeneralProductsTemplateReportFilteringParameters.SUBAGENCY.name(), MiscUtil.toString((Object)params.getSubagency()));
        result.put(GeneralProductsTemplateReportFilteringParameters.SUPPLIER.name(), MiscUtil.toString((Object)params.getSupplier()));
        return result;
    }

    @Override
    protected InsuranceAccident getItem(EntityContainer<BookingFile> ctr, String key) {
        for (Reservation res : ((BookingFile)ctr.getEntity()).getReservations()) {
            for (BaseProduct prod : res.getProducts()) {
                if (!(prod instanceof InsuranceAccident) || !key.equals(prod.getUid())) continue;
                return (InsuranceAccident)prod;
            }
        }
        throw Xeption.forDeveloper((String)"product with navigation key {0} not found in booking file {1}", (Object[])new Object[]{key, ctr.getUid()});
    }

    @Override
    protected List<InsuranceAccidentTemplateReportTicket> createRecords(InsuranceAccident product, Map<String, Object> data, List<Message> messages) throws Exception {
        InsuranceAccidentTemplateReportTicket item = new InsuranceAccidentTemplateReportTicket();
        item.setStatus(product.getStatus());
        item.setUid(product.getUid());
        item.setSystemNumber(product.getSystemNumber());
        item.setBlankOwner(product.getBlankOwner());
        item.setIssueDate(product.getIssueDate());
        item.setSupplier(InsuranceAccidentHelper.getSupplier((InsuranceAccident)product));
        for (Traveller tr : product.getReservation().getBookingFile().getTravellers()) {
            if (tr == null || !TextUtil.isSame((String)tr.getUid(), (String)product.getTravellerUid())) continue;
            item.setTraveler(tr.getName());
            if (tr.getPassport() == null) break;
            item.setPassportNumber(tr.getPassport().getNumber());
            break;
        }
        item.setAmount(product.getEquivalentSum());
        if (product.getInsuranceSum() != null) {
            String equivCurCode;
            BigDecimal premium = product.getInsuranceSum().getValue();
            String eqCur = DictHelper.getEquivCurrency();
            String string = equivCurCode = eqCur != null ? eqCur : "";
            if (product.getInsuranceSum().getCurrency() != null && !TextUtil.isSame((String)product.getInsuranceSum().getCurrency(), (String)equivCurCode)) {
                premium = FinanceHelper.exchange((BigDecimal)premium, (String)product.getInsuranceSum().getCurrency(), (String)equivCurCode, (TariffType)TariffType.REGULAR, (Date)new Date());
            }
            item.setPremium(premium);
        }
        item.setAgent(product.getAgent());
        return Collections.singletonList(item);
    }

    @Override
    protected Map<EntityReference<BookingFile>, Set<String>> getGroupedIndexes(InsuranceAccidentTemplateReportParameters params, Map<String, Object> data, List<Message> messages, EntityContainer<InsuranceAccidentTemplateReportDescription> descriptionCtr) throws Exception {
        SearchQuery result = new SearchQuery();
        if (params.getPeriodBegin() != null) {
            result.getCriteria().getCriterions().add(SearchCriterion.ge((String)InsuranceAccidentIndex.Property.issueDate.name(), (Object)MiscUtil.clearTime((Date)params.getPeriodBegin())));
        }
        if (params.getPeriodEnd() != null) {
            result.getCriteria().getCriterions().add(SearchCriterion.le((String)InsuranceAccidentIndex.Property.issueDate.name(), (Object)MiscUtil.setDayEndTime((Date)params.getPeriodEnd())));
        }
        result.getCriteria().getCriterions().addAll(CommonTemplateReportHelper.getModifiedCriterions((BaseTemplateReportParameters)params, (BaseSingleFileTemplateReportDescription)((BaseSingleFileTemplateReportDescription)EntityStorage.get().resolve(params.getDescription()).getEntity()), messages));
        if (params.getBlankOwner() != null) {
            result.getCriteria().getCriterions().add(SearchCriterion.eq((String)InsuranceAccidentIndex.Property.blankOwner.name(), (Object)params.getBlankOwner()));
            result.getPreferredProperties().add(InsuranceAccidentIndex.Property.blankOwner.name());
        }
        if (params.getAgency() != null) {
            result.getCriteria().getCriterions().add(SearchCriterion.eq((String)InsuranceAccidentIndex.Property.agency.name(), (Object)params.getAgency()));
            result.getPreferredProperties().add(InsuranceAccidentIndex.Property.agency.name());
        }
        if (params.getSalesPoint() != null) {
            result.getCriteria().getCriterions().add(SearchCriterion.eq((String)InsuranceAccidentIndex.Property.salesPoint.name(), (Object)params.getSalesPoint()));
            result.getPreferredProperties().add(InsuranceAccidentIndex.Property.salesPoint.name());
        }
        if (params.getSubagency() != null) {
            result.getCriteria().getCriterions().add(SearchCriterion.eq((String)InsuranceAccidentIndex.Property.subagency.name(), (Object)params.getSubagency()));
            result.getPreferredProperties().add(InsuranceAccidentIndex.Property.subagency.name());
        }
        if (params.getSupplier() != null) {
            result.getCriteria().getCriterions().add(SearchCriterion.eq((String)InsuranceAccidentIndex.Property.supplier.name(), (Object)params.getSupplier()));
            result.getPreferredProperties().add(InsuranceAccidentIndex.Property.supplier.name());
        }
        if (params.getClient() != null) {
            result.getCriteria().getCriterions().add(SearchCriterion.eq((String)InsuranceAccidentIndex.Property.client.name(), (Object)params.getSupplier()));
            result.getPreferredProperties().add(InsuranceAccidentIndex.Property.client.name());
        }
        if (params.getAgent() != null) {
            result.getCriteria().getCriterions().add(SearchCriterion.eq((String)InsuranceAccidentIndex.Property.agent.name(), (Object)params.getAgent()));
            result.getPreferredProperties().add(InsuranceAccidentIndex.Property.agent.name());
        }
        result.getCriteria().getCriterions().add(SearchCriterion.ne((String)InsuranceAccidentIndex.Property.ticketType.name(), (Object)TicketType.CORRECTION));
        if (result.getPreferredProperties().isEmpty()) {
            result.getPreferredProperties().add("uid");
        }
        return EntityStorage.get().search(InsuranceAccidentIndex.class, result).getData().stream().collect(Collectors.groupingBy(InsuranceAccidentIndex::getSource, Collectors.mapping(InsuranceAccidentIndex::getNavigationKey, Collectors.toSet())));
    }

    @Override
    protected EntityReference<InsuranceAccidentTemplateReportDescription> getDescription(InsuranceAccidentTemplateReportParameters params) {
        return params.getDescription();
    }

    @Override
    public MiscUtil.Pair<EntityIndex<BaseTemplateReportDocument>, String> searchForDuplicate(InsuranceAccidentTemplateReportParameters parametersNewReport, EntityReference<InsuranceAccidentTemplateReportDescription> reportDescription, boolean periodIntersectionDisallowed) {
        return InsuranceAccidentTemplateReportPrepareHandler.searchForDuplicateGeneralProductsTemplateReport((BaseGeneralProductsTemplateReportParameters)parametersNewReport, reportDescription, periodIntersectionDisallowed);
    }
}

