/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.template.multifiles;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.BaseSingleFileTemplateReportDocument;
import com.gridnine.xtrip.common.reports.model.MultipleFilesTemplateReportDescription;
import com.gridnine.xtrip.common.reports.model.MultipleFilesTemplateReportDocument;
import com.gridnine.xtrip.common.reports.model.MultipleFilesTemplateReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.model.ReportHelper;
import com.gridnine.xtrip.common.reports.model.TemplateReportPeriodUse;
import com.gridnine.xtrip.server.reports.prepare.PrepareHandlersRegistry;
import com.gridnine.xtrip.server.reports.prepare.PrepareReportCallback;
import com.gridnine.xtrip.server.reports.prepare.ReportPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.ServerReportHelper;
import com.gridnine.xtrip.server.reports.prepare.template.common.BaseGroupedTemplateReportPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.template.multifiles.MultipleFilesTemplateReportServerHandler;
import com.gridnine.xtrip.server.reports.prepare.template.multifiles.MultipleFilesTemplateReportServerHandlersRegistry;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MultipleFilesTemplateReportPrepareHandler
implements ReportPrepareHandler {
    @Override
    public String getId() {
        return "muiltiple-files-template-report";
    }

    @Override
    public void prepareData(Map<String, Object> data) throws Exception {
        ArrayList<Message> messages = (ArrayList<Message>)data.get("key-messages");
        if (messages == null) {
            messages = new ArrayList<Message>();
            data.put("key-messages", messages);
        }
        String oldId = null;
        EntityContainer oldCtr = (EntityContainer)data.get("KEY_REPORT_DOCUMENT");
        if (oldCtr != null) {
            oldId = oldCtr.getUid();
        }
        MultipleFilesTemplateReportParameters params = (MultipleFilesTemplateReportParameters)data.get("key-report-params");
        final EntityContainer descriptionCtr = EntityStorage.get().resolve(params.getDescription());
        this.checkParams(params, (EntityContainer<MultipleFilesTemplateReportDescription>)descriptionCtr, messages);
        if (ReportHelper.isHasErrors(messages)) {
            return;
        }
        if (ServerReportHelper.isToBeStopped(data)) {
            return;
        }
        final PrepareReportCallback callback = ServerReportHelper.getCallback(data);
        int idx = 0;
        HashMap<String, Object> requestedParameters = new HashMap<String, Object>();
        for (Object item : params.getRequestedParameters()) {
            requestedParameters.put(item.getKey(), item.getValue());
        }
        ArrayList<ReportFile> files = new ArrayList<ReportFile>();
        for (final EntityReference item : ((MultipleFilesTemplateReportDescription)descriptionCtr.getEntity()).getDescriptions()) {
            if (ServerReportHelper.isToBeStopped(data)) {
                return;
            }
            MultipleFilesTemplateReportServerHandler handler = MultipleFilesTemplateReportServerHandlersRegistry.get().getHandler(item.getType());
            BaseGroupedTemplateReportPrepareHandler repHandler = (BaseGroupedTemplateReportPrepareHandler)((PrepareHandlersRegistry)Environment.getPublished(PrepareHandlersRegistry.class)).get(handler.getReportId());
            Object newParams = handler.createParameters((MultipleFilesTemplateReportDescription)descriptionCtr.getEntity(), item, params);
            final int offset = Math.round(100 * idx / ((MultipleFilesTemplateReportDescription)descriptionCtr.getEntity()).getDescriptions().size());
            data.put("key-report-params", newParams);
            data.put("KEY_PREPARE_REPORT_CALLBACK", new PrepareReportCallback(){

                @Override
                public void updateProgress(byte progress, String message) {
                    callback.updateProgress((byte)((long)offset + Math.round((double)progress * 1.0 / (double)((MultipleFilesTemplateReportDescription)descriptionCtr.getEntity()).getDescriptions().size())), String.format("%s:%s", item, message));
                }

                @Override
                public boolean isToBeStopped() {
                    return callback.isToBeStopped();
                }
            });
            repHandler.prepareData(data);
            EntityContainer docCtr = (EntityContainer)data.get("KEY_REPORT_DOCUMENT");
            if (docCtr == null) {
                SystemHelper.addMessage(messages, (String)Messages.MultipleFilesTemplateReportPrepareHandler_unableToCreateReport, null, (MessageType)MessageType.ERROR, (Object[])new Object[]{item});
                return;
            }
            files.add(((BaseSingleFileTemplateReportDocument)docCtr.getEntity()).getFile());
            ++idx;
        }
        data.put("key-report-params", params);
        data.remove("KEY_PREPARE_REPORT_CALLBACK");
        EntityContainer result = new EntityContainer(MultipleFilesTemplateReportDocument.class);
        MultipleFilesTemplateReportDocument ett = (MultipleFilesTemplateReportDocument)result.getEntity();
        ett.setCreated(new Date());
        ett.setParameters(params);
        ett.setReportType(((MultipleFilesTemplateReportDescription)descriptionCtr.getEntity()).getReportType());
        ett.setTitle(this.generateTitle((MultipleFilesTemplateReportDescription)descriptionCtr.getEntity(), params));
        ett.getFiles().addAll(files);
        if (oldId != null) {
            result.setUid(oldId);
        }
        data.put("KEY_REPORT_DOCUMENT", result);
        ServerReportHelper.getCallback(data).updateProgress((byte)100, Messages.MultipleFilesTemplateReportPrepareHandler_transferringData);
    }

    private String generateTitle(MultipleFilesTemplateReportDescription entity, MultipleFilesTemplateReportParameters params) {
        if (entity.getPeriodUse() == TemplateReportPeriodUse.IGNORE) {
            return String.format("%s \u043e\u0442 %s", entity, new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        }
        if (entity.getPeriodUse() == TemplateReportPeriodUse.DATE_TIME) {
            return String.format("%s \u0437\u0430 \u043f\u0435\u0440\u0438\u043e\u0434 \u0441 %s \u043f\u043e %s", entity, new SimpleDateFormat("HH:mm").format(new Date()), new SimpleDateFormat("HH:mm(yyyy-MM-dd)").format(new Date()));
        }
        return String.format("%s \u0437\u0430 \u043f\u0435\u0440\u0438\u043e\u0434 %s-%s", entity, new SimpleDateFormat("MM-dd").format(params.getPeriodBegin()), new SimpleDateFormat("MM-dd-yyyy").format(params.getPeriodEnd()));
    }

    private void checkParams(MultipleFilesTemplateReportParameters params, EntityContainer<MultipleFilesTemplateReportDescription> descriptionCtr, List<Message> messages) {
        if (descriptionCtr == null) {
            throw new IllegalStateException(L10nResourcesManager.getStr((String)Messages.AirTicketsTemplateReportPrepareHandler_reportNoTemptale, (Object[])new Object[0]));
        }
        TemplateReportPeriodUse periodUse = ((MultipleFilesTemplateReportDescription)descriptionCtr.getEntity()).getPeriodUse();
        if (periodUse != TemplateReportPeriodUse.IGNORE) {
            if (params.getPeriodBegin() == null) {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.AllProductsTemplateReportPrepareHandler_reportPramsNoPeriodStart, (Object[])new Object[0]));
            }
            if (params.getPeriodEnd() == null) {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.AllProductsTemplateReportPrepareHandler_reportPramsNoPeriodEnd, (Object[])new Object[0]));
            }
        }
    }
}

