/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.template.productindex;

import com.gridnine.xtrip.common.jr.JasperUtil;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.meta.IndexProperty;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.ContractCustomerIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.ProductReportDocument;
import com.gridnine.xtrip.common.reports.model.ProductReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.reports.prepare.ReportPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.template.common.TemplateReportHelper;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JasperReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AirProductsIndexBasedReportPrepareHandler
implements ReportPrepareHandler {
    private static final String KEY_BEGIN_DATE = "BEGIN_DATE";
    private static final String KEY_END_DATE = "END_DATE";
    private static final String KEY_SUBAGENCY_NAME = "SUBAGENCY_NAME";
    private static final String KEY_AGENCY_NAME = "AGENCY_NAME";
    private static final String KEY_SUBAGENT_CONTRACT_NUMBER = "SUBAGENT_CONTRACT_NUMBER";
    private static final String KEY_SUPPLIER_NAME = "SUPPLIER_NAME";
    private static final String KEY_SUPPLIER_CONTRACT_NUMBER = "SUPPLIER_CONTRACT_NUMBER";

    private String getFileName(ProductReportParameters params, ContentType format) {
        StringBuilder result = new StringBuilder("productSalesReport(");
        result.append(params.getPeriodBegin() != null ? new SimpleDateFormat("dd.MM").format(params.getPeriodBegin()) : "?");
        result.append('-').append(params.getPeriodEnd() != null ? new SimpleDateFormat("dd.MM").format(params.getPeriodEnd()) : "?");
        result.append(")").append(String.format(".%s", TemplateReportHelper.getExtension(format)));
        return result.toString();
    }

    private String getReportTitle(ProductReportParameters params) {
        StringBuilder result = new StringBuilder();
        result.append(params.getTemplate());
        result.append(" ").append(L10nResourcesManager.getStr((String)Messages.AirProductsIndexBasedReportPrepareHandler_from, (Object[])new Object[0])).append(" ");
        result.append(params.getPeriodBegin() != null ? new SimpleDateFormat("dd.MM").format(params.getPeriodBegin()) : "?");
        result.append(" ").append(L10nResourcesManager.getStr((String)Messages.AirProductsIndexBasedReportPrepareHandler_to, (Object[])new Object[0])).append(" ").append(params.getPeriodEnd() != null ? new SimpleDateFormat("dd.MM").format(params.getPeriodEnd()) : "?");
        return result.toString();
    }

    private void collectAgencies(EntityReference<Organization> parentReference, Set<EntityReference<Organization>> subagencies) throws Exception {
        if (parentReference == null || subagencies.contains(parentReference)) {
            return;
        }
        subagencies.add(parentReference);
        EntityStorage entityStorage = EntityStorage.get();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OrganizationIndex.Property.parent.name(), parentReference));
        List childIndexes = entityStorage.search(OrganizationIndex.class, query).getData();
        for (OrganizationIndex childIndex : childIndexes) {
            EntityReference childReference = childIndex.getSource();
            this.collectAgencies((EntityReference<Organization>)childReference, subagencies);
        }
    }

    /*
     * WARNING - void declaration
     */
    private JRDataSource getDataSource(ProductReportParameters params, JasperReport jasperReport, Set<Message> messages) throws Exception {
        String property;
        String[] criterions;
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().addAll(params.getAdditionalCriterions());
        if (params.getPeriodBegin() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.ge((String)ProductIndex.Property.issueDate.name(), (Object)MiscUtil.clearTime((Date)params.getPeriodBegin())));
        }
        if (params.getPeriodEnd() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.le((String)ProductIndex.Property.issueDate.name(), (Object)MiscUtil.setDayEndTime((Date)params.getPeriodEnd())));
        }
        if (params.getAgency() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.agency.name(), (Object)params.getAgency()));
        }
        if (params.getSubagency() != null) {
            HashSet<EntityReference<Organization>> agencyReferences = new HashSet<EntityReference<Organization>>();
            this.collectAgencies((EntityReference<Organization>)params.getSubagency(), agencyReferences);
            criterions = new ArrayList();
            for (EntityReference entityReference : agencyReferences) {
                criterions.add(SearchCriterion.eq((String)ProductIndex.Property.subagency.name(), (Object)entityReference));
            }
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()])));
        }
        if (params.getSalesPoint() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.salesPoint.name(), (Object)params.getSalesPoint()));
        }
        if (!TextUtil.isBlank((String)(property = jasperReport.getProperty("xtrip.orders")))) {
            void var8_12;
            criterions = property.split(",");
            int n = criterions.length;
            boolean bl = false;
            while (var8_12 < n) {
                String prop = criterions[var8_12];
                if (!TextUtil.isBlank((String)prop)) {
                    int index = prop.indexOf("=");
                    String propertyName = null;
                    SortOrder order = SortOrder.ASC;
                    if (index != -1 && index < prop.length() - 1) {
                        propertyName = prop.substring(0, index).trim();
                        if (SortOrder.DESC.name().equalsIgnoreCase(prop.substring(index + 1))) {
                            order = SortOrder.DESC;
                        }
                    }
                    boolean found = false;
                    for (ProductIndex.Property pr : ProductIndex.Property.values()) {
                        if (!pr.name().equalsIgnoreCase(propertyName)) continue;
                        found = true;
                        break;
                    }
                    if (found) {
                        query.getCriteria().getOrders().put(propertyName, order);
                    }
                }
                ++var8_12;
            }
        }
        if (params.getSupplier() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.supplier.name(), (Object)params.getSupplier()));
        }
        if (params.getVendor() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.blankOwner.name(), (Object)params.getVendor()));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ProductIndex.Property.ticketType.name(), (Object)TicketType.FAKE));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ProductIndex.Property.ticketType.name(), (Object)TicketType.CORRECTION));
        query.setResultMode(ResultMode.COUNT_ONLY);
        int totalCount = EntityStorage.get().search(ProductIndex.class, query).getTotalCount();
        if (totalCount > 10000) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.AirProductsIndexBasedReportPrepareHandler_tooManyTickets, (Object[])new Object[0]));
            return null;
        }
        if (totalCount == 0) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.reportNoTicket, (Object[])new Object[0]));
            return null;
        }
        query.setResultMode(ResultMode.DATA_ONLY);
        final List data = EntityStorage.get().search(ProductIndex.class, query).getData();
        final Logger logger = LoggerFactory.getLogger(this.getClass());
        return new JRDataSource(){
            private int rowNumber = -1;

            public Object getFieldValue(JRField jrField) {
                String name = jrField.getName();
                if (TextUtil.isBlank((String)name)) {
                    return null;
                }
                try {
                    ProductIndex index = (ProductIndex)data.get(this.rowNumber);
                    Object value = index.getValue(name);
                    if (value == null) {
                        IndexProperty prop = (IndexProperty)((IndexType)MetaRegistry.get().getIndexes().get(ProductIndex.class.getName())).getProperties().get(name);
                        if (prop != null && BigDecimal.class.getName().equals(prop.getType())) {
                            return BigDecimal.ZERO;
                        }
                        if (prop != null && Double.class.getName().equals(prop.getType())) {
                            return 0.0;
                        }
                        if (prop != null && Integer.class.getName().equals(prop.getType())) {
                            return 0;
                        }
                        if (prop != null && Long.class.getName().equals(prop.getType())) {
                            return 0L;
                        }
                        if (prop != null && ("String".equals(prop.getType()) || "text".equals(prop.getType()) || String.class.getName().equals(prop.getType()))) {
                            return "";
                        }
                        return null;
                    }
                    if (value.getClass().isEnum()) {
                        return ((Enum)value).name();
                    }
                    if (value instanceof EntityReference) {
                        ((EntityReference)value).toString();
                    }
                    if (value instanceof Iterable) {
                        StringBuilder sb = new StringBuilder();
                        for (Object obj : (Iterable)value) {
                            if (obj == null) continue;
                            if (sb.length() > 0) {
                                sb.append(", ");
                            }
                            sb.append(obj);
                        }
                        return sb.toString();
                    }
                    return value;
                }
                catch (Exception e) {
                    logger.error("unable to read value of the field " + name, (Throwable)e);
                    return null;
                }
            }

            public boolean next() {
                ++this.rowNumber;
                return this.rowNumber < data.size();
            }
        };
    }

    private Map<String, Object> getParameters(ProductReportParameters params, JasperReport jasperReport, Set<Message> messages) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(KEY_BEGIN_DATE, params.getPeriodBegin());
        result.put(KEY_END_DATE, params.getPeriodEnd());
        result.put(KEY_AGENCY_NAME, this.getOrganizationName((EntityReference<Organization>)params.getAgency(), messages));
        result.put(KEY_SUBAGENCY_NAME, this.getOrganizationName((EntityReference<Organization>)params.getSubagency(), messages));
        result.put(KEY_SUPPLIER_NAME, this.getOrganizationName((EntityReference<Organization>)params.getSupplier(), messages));
        result.put(KEY_SUBAGENT_CONTRACT_NUMBER, this.getContractNumber(ContractType.SUBAGENCY, params, messages));
        result.put(KEY_SUPPLIER_CONTRACT_NUMBER, this.getContractNumber(ContractType.VENDOR, params, messages));
        return result;
    }

    String getContractNumber(ContractType contractType, ProductReportParameters params, Set<Message> messages) {
        EntityReference agent = null;
        EntityReference contragent = null;
        switch (contractType) {
            case VENDOR: {
                agent = params.getSupplier();
                contragent = params.getAgency();
                break;
            }
            case SUBAGENCY: {
                agent = params.getAgency();
                contragent = params.getSubagency();
                break;
            }
        }
        if (agent != null && contragent != null) {
            List data;
            SearchQuery query = new SearchQuery();
            if (params.getVendor() != null) {
                query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.vendor.name(), null), SearchCriterion.eq((String)ContractCustomerIndex.Property.vendor.name(), (Object)params.getVendor())}));
            }
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.supplier.name(), (Object)agent));
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.customer.name(), (Object)contragent));
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.contractType.name(), (Object)contractType));
            if (params.getPeriodBegin() != null) {
                query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.endDate.name(), null), SearchCriterion.ge((String)ContractCustomerIndex.Property.endDate.name(), (Object)params.getPeriodBegin())}));
            }
            if (params.getPeriodEnd() != null) {
                query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.startDate.name(), null), SearchCriterion.le((String)ContractCustomerIndex.Property.startDate.name(), (Object)params.getPeriodEnd())}));
            }
            if (!(data = EntityStorage.get().search(ContractCustomerIndex.class, query).getData()).isEmpty()) {
                if (data.size() > 1) {
                    messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.TemplateReportHelper_findedFewContract, (Object[])new Object[]{params.getAgency(), params.getSubagency(), contractType, ((ContractCustomerIndex)data.get(0)).getNumber()}));
                }
                return ((ContractCustomerIndex)data.get(0)).getNumber();
            }
        }
        return null;
    }

    private String getOrganizationName(EntityReference<Organization> agency, Set<Message> messages) {
        if (agency != null) {
            EntityContainer ctr = EntityStorage.get().resolve(agency);
            if (ctr != null) {
                Organization entity = (Organization)ctr.getEntity();
                return ProfileHelper.getFullName((Organization)entity, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false);
            }
            messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.AirProductsIndexBasedReportPrepareHandler_cantLoadProfileOrg, (Object[])new Object[]{agency}));
        }
        return null;
    }

    @Override
    public String getId() {
        return "air-products-index-based-report";
    }

    @Override
    public void prepareData(Map<String, Object> data) throws Exception {
        LinkedHashSet<Message> messages = new LinkedHashSet<Message>();
        data.put("key-messages", messages);
        ProductReportParameters params = (ProductReportParameters)data.get("key-report-params");
        if (params == null) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.AirProductsIndexBasedReportPrepareHandler_notSetParamsRepotr, (Object[])new Object[0]));
            return;
        }
        EntityContainer templateCtr = EntityStorage.get().resolve(params.getTemplate());
        if (templateCtr == null) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.AirProductsIndexBasedReportPrepareHandler_cantLoadTemplate, (Object[])new Object[]{params.getTemplate()}));
            return;
        }
        JasperReport jasperReport = JasperUtil.getReport((byte[])((TemplateDocument)templateCtr.getEntity()).getContent());
        Map<String, Object> parameters = this.getParameters(params, jasperReport, messages);
        JRDataSource dataSource = this.getDataSource(params, jasperReport, messages);
        if (parameters == null || dataSource == null) {
            return;
        }
        byte[] content = JasperUtil.fillReport((JasperReport)jasperReport, parameters, (JRDataSource)dataSource, null);
        EntityContainer ctr = new EntityContainer(ProductReportDocument.class);
        Date date = new Date();
        ctr.setCreated(date);
        ProductReportDocument doc = (ProductReportDocument)ctr.getEntity();
        doc.setCreated(date);
        doc.setCheckSum(MiscUtil.getCheckSum((byte[])content));
        doc.setParameters(params);
        doc.getMessages().addAll(messages);
        ReportFile file = new ReportFile();
        ContentType format = (ContentType)data.get("KEY_FORMAT");
        if (format != null && format == ContentType.EXCEL) {
            content = JasperUtil.convertToExcel((byte[])content);
            file.setContentType(ContentType.EXCEL);
            file.setContent(content);
        } else if (format == ContentType.XML) {
            file.setContentType(ContentType.XML);
            file.setContent(content);
        } else {
            file.setContentType(ContentType.JASPERPRINT);
            file.setContent(content);
        }
        if (format == null) {
            format = ContentType.JASPERPRINT;
        }
        file.setName(this.getFileName(params, format));
        file.setTitle(this.getReportTitle(params));
        doc.setFile(file);
        data.put("KEY_REPORT_DOCUMENT", ctr);
    }
}

