/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.prepare.template.stockBlank;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.stockcontrol.BlankOrderLogItem;
import com.gridnine.xtrip.common.model.stockcontrol.StockBlank;
import com.gridnine.xtrip.common.model.stockcontrol.StockBlankIndex;
import com.gridnine.xtrip.common.model.stockcontrol.UsageStatus;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.Worklog;
import com.gridnine.xtrip.common.reports.l10n.Messages;
import com.gridnine.xtrip.common.reports.model.BaseSingleFileTemplateReportDescription;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportDocument;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportHelper;
import com.gridnine.xtrip.common.reports.model.StockBlankReportBatch;
import com.gridnine.xtrip.common.reports.model.StockBlankReportBatchGroup;
import com.gridnine.xtrip.common.reports.model.StockBlankReportBatchType;
import com.gridnine.xtrip.common.reports.model.StockBlankReportDescription;
import com.gridnine.xtrip.common.reports.model.StockBlankReportDocument;
import com.gridnine.xtrip.common.reports.model.StockBlankReportPageDescription;
import com.gridnine.xtrip.common.reports.model.StockBlankReportParameters;
import com.gridnine.xtrip.common.reports.model.TemplateReportPeriodUse;
import com.gridnine.xtrip.common.reports.render.template.common.CommonTemplateReportHelper;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.reports.prepare.template.common.BaseTemplateReportPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.template.common.TemplateReportHelper;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StockBlankReportPrepareHandler
extends BaseTemplateReportPrepareHandler<StockBlankReportBatchGroup, StockBlankReportBatchGroup, StockBlankReportParameters, StockBlankReportDescription, StockBlankReportPageDescription, StockBlankReportDocument> {
    private static Pattern numberPattern = Pattern.compile("(\\d+\\s*)+");

    @Override
    public String getId() {
        return "stock-blank-report";
    }

    @Override
    protected void checkParams(StockBlankReportParameters params, EntityContainer<StockBlankReportDescription> descriptionCtr, List<Message> messages) {
        if (params.getWorklog() != null) {
            EntityContainer worklogContainer = EntityStorage.get().resolve(params.getWorklog());
            if (worklogContainer != null) {
                Worklog worklog = (Worklog)worklogContainer.getEntity();
                params.setPeriodBegin(worklog.getStartDate());
                params.setPeriodEnd(worklog.getEndDate());
                params.setLocation(worklog.getCashRegisterWorkplace() != null ? worklog.getCashRegisterWorkplace() : worklog.getSalesPoint());
            }
        } else {
            TemplateReportPeriodUse periodUse = ((StockBlankReportDescription)EntityStorage.get().resolve(params.getDescription()).getEntity()).getPeriodUse();
            if (periodUse == null || periodUse == TemplateReportPeriodUse.DATE) {
                params.setPeriodBegin(MiscUtil.clearTime((Date)params.getPeriodBegin(), (boolean)true, (boolean)true, (boolean)true, (boolean)true));
                params.setPeriodEnd(MiscUtil.setDayEndTime((Date)params.getPeriodEnd(), (boolean)true, (boolean)true, (boolean)true, (boolean)true));
            } else {
                params.setPeriodBegin(MiscUtil.clearTime((Date)params.getPeriodBegin(), (boolean)false, (boolean)false, (boolean)false, (boolean)true));
                params.setPeriodEnd(MiscUtil.setDayEndTime((Date)params.getPeriodEnd(), (boolean)false, (boolean)false, (boolean)false, (boolean)true));
            }
        }
    }

    @Override
    protected String getReportTitle(StockBlankReportParameters parameters, EntityReference<StockBlankReportDescription> description, String fileNameScript) {
        String fileName;
        if (!TextUtil.isBlank((String)fileNameScript)) {
            fileName = TemplateReportHelper.getFileNameFromScript(parameters, fileNameScript);
        } else {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat sdfWithTime = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            SimpleDateFormat frmt = ((StockBlankReportDescription)EntityStorage.get().resolve(description).getEntity()).getPeriodUse() == TemplateReportPeriodUse.DATE_TIME ? sdfWithTime : sdf;
            fileName = L10nResourcesManager.createL10nMessage((String)Messages.TemplateReportHelper_overPeriod, (Object[])new Object[]{((StockBlankReportDescription)EntityStorage.get().resolve(description).getEntity()).getTitle() + " " + parameters.getLocation().toString(), parameters.getPeriodBegin() != null ? frmt.format(parameters.getPeriodBegin()) : "?", parameters.getPeriodEnd() != null ? frmt.format(parameters.getPeriodEnd()) : "?"}).toString();
        }
        return fileName;
    }

    @Override
    protected void setData(StockBlankReportDocument doc, StockBlankReportParameters params, Map<String, Object> data) {
        doc.setParameters(params);
    }

    @Override
    protected StockBlankReportDocument createDocument() {
        return new StockBlankReportDocument();
    }

    @Override
    protected Class<StockBlankReportBatchGroup> getItemClass(StockBlankReportDescription description) {
        return StockBlankReportBatchGroup.class;
    }

    @Override
    protected List<StockBlankReportPageDescription> getPages(StockBlankReportDescription entity) {
        return entity.getPages();
    }

    @Override
    protected Map<String, Object> getGlobalParameters(Map<String, Object> data, StockBlankReportParameters params, List<Message> messages) throws Exception {
        return TemplateReportHelper.getGlobalParameters(params, messages);
    }

    @Override
    protected List<StockBlankReportBatchGroup> createRecords(StockBlankReportBatchGroup product, Map<String, Object> data, List<Message> messages) throws Exception {
        return Collections.singletonList(product);
    }

    @Override
    protected EntityReference<StockBlankReportDescription> getDescription(StockBlankReportParameters params) {
        return params.getDescription();
    }

    @Override
    public MiscUtil.Pair<EntityIndex<BaseTemplateReportDocument>, String> searchForDuplicate(StockBlankReportParameters parametersNewReport, EntityReference<StockBlankReportDescription> reportDescription, boolean periodIntersectionDisallowed) {
        return new MiscUtil.Pair(null, null);
    }

    @Override
    protected List<StockBlankReportBatchGroup> getItems(StockBlankReportParameters params, Map<String, Object> data, List<Message> messages, EntityContainer<StockBlankReportDescription> descriptionCtr) throws Exception {
        EntityContainer worklogContainer;
        StockBlankReportDescription description = (StockBlankReportDescription)EntityStorage.get().resolve(params.getDescription()).getEntity();
        SearchQuery query = new SearchQuery();
        TemplateReportPeriodUse periodUse = description.getPeriodUse();
        Date periodBegin = params.getPeriodBegin();
        Date periodEnd = params.getPeriodEnd();
        EntityReference location = params.getLocation();
        EntityReference blankOwner = params.getBlankOwner();
        EntityReference worklog = params.getWorklog();
        if (worklog != null && (worklogContainer = EntityStorage.get().resolve(params.getWorklog())) != null) {
            Worklog worklogCtr = (Worklog)worklogContainer.getEntity();
            params.setPeriodBegin(worklogCtr.getStartDate());
            params.setPeriodEnd(worklogCtr.getEndDate());
        }
        if ((periodUse == null || periodUse == TemplateReportPeriodUse.DATE) && worklog == null) {
            periodBegin = MiscUtil.clearTime((Date)periodBegin);
            periodEnd = MiscUtil.setDayEndTime((Date)periodEnd);
        }
        List criterions = query.getCriteria().getCriterions();
        criterions.add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.le((String)StockBlankIndex.Property.registrationDate.name(), (Object)periodEnd), SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)StockBlankIndex.Property.operationDate.name(), (Object)periodBegin), SearchCriterion.eq((String)StockBlankIndex.Property.operationDate.name(), null)})}));
        if (location != null) {
            criterions.add(SearchCriterion.contains((String)StockBlankIndex.Property.locations.name(), (Object)location));
        }
        if (blankOwner != null) {
            criterions.add(SearchCriterion.eq((String)StockBlankIndex.Property.owner.name(), (Object)blankOwner));
        }
        List criterions2 = CommonTemplateReportHelper.getModifiedCriterions((BaseTemplateReportParameters)params, (BaseSingleFileTemplateReportDescription)description, messages);
        if (ReportHelper.isHasErrors(messages)) {
            return Collections.emptyList();
        }
        query.getCriteria().getCriterions().addAll(criterions2);
        query.getCriteria().getOrders().put(StockBlankIndex.Property.number.name(), SortOrder.ASC);
        query.getPreferredProperties().add("containerUid");
        SearchResult indexes = EntityStorage.get().search(StockBlankIndex.class, query);
        List<StockBlankReportBatchGroup> result = this.generateBatchGroups((SearchResult<StockBlankIndex>)indexes, params);
        return result;
    }

    private List<StockBlankReportBatchGroup> generateBatchGroups(SearchResult<StockBlankIndex> indexes, StockBlankReportParameters params) {
        TreeMap map = new TreeMap(new Comparator<BlankType>(){

            @Override
            public int compare(BlankType o1, BlankType o2) {
                if (o1.getProductCategory().ordinal() == o2.getProductCategory().ordinal()) {
                    return o1.getCode().compareTo(o2.getCode());
                }
                return o1.getProductCategory().ordinal() - o2.getProductCategory().ordinal();
            }
        });
        EntityStorage es = EntityStorage.get();
        Date beginWithTime = params.getPeriodBegin();
        Date endWithTime = params.getPeriodEnd();
        EntityReference location = params.getLocation();
        for (StockBlankIndex index : indexes.getData()) {
            BlankType type;
            StockBlank blank = (StockBlank)es.resolve(index.getSource()).getEntity();
            List logs = blank.getOrderLogItems();
            Collections.sort(logs, new Comparator<BlankOrderLogItem>(){

                @Override
                public int compare(BlankOrderLogItem o1, BlankOrderLogItem o2) {
                    return o1.getOperationDate().compareTo(o2.getOperationDate());
                }
            });
            Iterator logIter = logs.iterator();
            boolean before = false;
            boolean receipt = false;
            boolean moved = false;
            boolean spend = false;
            boolean after = false;
            while (logIter.hasNext()) {
                BlankOrderLogItem log = (BlankOrderLogItem)logIter.next();
                Date logDate = log.getOperationDate();
                EntityReference logLocation = log.getBlankLocation();
                if (logDate.before(beginWithTime)) {
                    before = logLocation.equals((Object)location);
                }
                if (logDate.after(beginWithTime) && logDate.before(endWithTime) && logLocation.equals((Object)location)) {
                    receipt = true;
                }
                if (!logDate.after(beginWithTime) || !logDate.before(endWithTime) || logLocation.equals((Object)location) || !receipt && !before) continue;
                moved = true;
            }
            if (!before && !receipt) continue;
            if (blank.getOperationDate() != null && blank.getOperationDate().before(endWithTime) && (before || receipt)) {
                spend = true;
            }
            if (blank.getOperationDate() == null && blank.getUsageStatus() == UsageStatus.NEW && !moved && !spend) {
                after = true;
            }
            ArrayList<StockBlankReportBatchType> batchTypes = new ArrayList<StockBlankReportBatchType>();
            if (before) {
                batchTypes.add(StockBlankReportBatchType.before);
            }
            if (receipt) {
                batchTypes.add(StockBlankReportBatchType.receipt);
            }
            if (moved) {
                batchTypes.add(StockBlankReportBatchType.move);
            }
            if (spend) {
                batchTypes.add(StockBlankReportBatchType.spend);
            }
            if (after) {
                batchTypes.add(StockBlankReportBatchType.after);
            }
            if (map.get(type = (BlankType)DictionaryCache.get().resolveReference(blank.getType())) == null) {
                map.put(type, new TreeMap());
            }
            String prefix = StockBlankReportPrepareHandler.getPrefix(blank.getNumber());
            if (((TreeMap)map.get(type)).get(prefix) == null) {
                ((TreeMap)map.get(type)).put(prefix, StockBlankReportPrepareHandler.createBatchGroup(prefix, (DictionaryReference<BlankType>)blank.getType()));
            }
            StockBlankReportPrepareHandler.addToPresortedBatches(blank, batchTypes, (StockBlankReportBatchGroup)((TreeMap)map.get(type)).get(StockBlankReportPrepareHandler.getPrefix(blank.getNumber())));
        }
        ArrayList<StockBlankReportBatchGroup> result = new ArrayList<StockBlankReportBatchGroup>();
        for (TreeMap map2 : map.values()) {
            result.addAll(map2.values());
        }
        return result;
    }

    static String getPrefix(String number) {
        Matcher matcher = numberPattern.matcher(number);
        matcher.find();
        return number.substring(0, matcher.start());
    }

    static long getNumber(String number) {
        Matcher matcher = numberPattern.matcher(number);
        matcher.find();
        return Long.parseLong(matcher.group());
    }

    public static void addToPresortedBatches(StockBlank blank, ArrayList<StockBlankReportBatchType> types, StockBlankReportBatchGroup batchGroup) {
        for (StockBlankReportBatchType type : types) {
            switch (type) {
                case after: {
                    StockBlankReportPrepareHandler.addToBatches(batchGroup.getAfter(), blank);
                    break;
                }
                case before: {
                    StockBlankReportPrepareHandler.addToBatches(batchGroup.getBefore(), blank);
                    break;
                }
                case move: {
                    StockBlankReportPrepareHandler.addToBatches(batchGroup.getMove(), blank);
                    break;
                }
                case receipt: {
                    StockBlankReportPrepareHandler.addToBatches(batchGroup.getReceipt(), blank);
                    break;
                }
                case spend: {
                    StockBlankReportPrepareHandler.addToBatches(batchGroup.getSpend(), blank);
                    break;
                }
            }
        }
    }

    private static void addToBatches(List<StockBlankReportBatch> batches, StockBlank blank) {
        boolean added = false;
        for (StockBlankReportBatch batch : batches) {
            if (StockBlankReportPrepareHandler.getNumber(blank.getNumber()) - batch.getEnd() != 1L) continue;
            batch.add(StockBlankReportPrepareHandler.getNumber(blank.getNumber()));
            added = true;
            break;
        }
        if (!added) {
            batches.add(StockBlankReportPrepareHandler.createBatch(blank));
        }
    }

    private static StockBlankReportBatch createBatch(StockBlank blank) {
        StockBlankReportBatch result = new StockBlankReportBatch();
        long number = StockBlankReportPrepareHandler.getNumber(blank.getNumber());
        result.setBegin(number);
        result.setEnd(number);
        result.setQuantity(1);
        Matcher matcher = numberPattern.matcher(blank.getNumber());
        matcher.find();
        result.setNumberFormat("%0" + Integer.toString(blank.getNumber().length() - matcher.start()) + "d");
        return result;
    }

    private static StockBlankReportBatchGroup createBatchGroup(String prefix, DictionaryReference<BlankType> type) {
        StockBlankReportBatchGroup result = new StockBlankReportBatchGroup();
        result.setBlankType(type);
        result.setPrefix(prefix);
        return result;
    }
}

