/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.render.salesreports.subagent.vip.tch;

import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BlankTypeReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.RoundingMode;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.model.rules.standard.Actions;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.reports.model.ReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.salesreports.subagent.vip.tch.TchVipReportRenderHandler;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.model.helpers.BookingDao;
import com.gridnine.xtrip.server.model.helpers.ProductSearchResult;
import com.gridnine.xtrip.server.model.test.ModelTestBase;
import com.gridnine.xtrip.server.reports.prepare.salesreports.subagent.vip.tch.TchVipSalesReportPrepareHandler;
import com.gridnine.xtrip.server.reports.salesreports.render.RenderSalesReportTestBase;
import java.io.File;
import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;

abstract class TchVipReportTestBase
extends RenderSalesReportTestBase {
    protected EntityReference<Organization> vip = new EntityReference("vip_container_uid", Organization.class, "VIP");
    protected SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    protected EntityReference<CommissionProperties> commission;
    protected Date issueDate;
    protected final double rate1 = 10.0;
    protected EntityReference<SalesPoint> spRef;
    protected final String validatorCode = "00001";
    protected SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
    protected double fare = 100.0;
    protected double zzTax = 50.0;
    protected double xtTax = 50.0;
    protected PaymentType vendorPaymentType = PaymentType.CASH;
    protected boolean eTicket = true;
    protected String airlineCode = "SU";
    protected String arrivalCityCode = "CDG";

    TchVipReportTestBase() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createReport(String startDate, String endDate, String fileName) throws Exception {
        HashMap<String, Object> data = new HashMap<String, Object>();
        ReportParameters params = new ReportParameters();
        params.setPeriodBegin(this.sdf.parse(startDate));
        params.setPeriodEnd(this.sdf.parse(endDate));
        params.setAgency(this.agencyReference);
        params.setBlankOwner(this.tchReference);
        data.put("key-report-params", params);
        TchVipSalesReportPrepareHandler prepareHandler = new TchVipSalesReportPrepareHandler();
        prepareHandler.prepareData(data);
        for (Object obj : (List)data.get("key-messages")) {
            Message message = (Message)obj;
            if (message.getType() != MessageType.ERROR) continue;
            Assert.assertFalse((String)LocaleManager.get().getL10nResourceManager().getMessage(message.getMessage()), (boolean)true);
        }
        TchVipReportRenderHandler renderHandler = new TchVipReportRenderHandler(){

            protected File getTemplateFile() {
                return new File("./plugins/com.gridnine.xtrip.common.reports/templates/salesreports/TchVipReport.xls");
            }
        };
        EntityContainer renderReport = renderHandler.renderReport(data);
        try (FileOutputStream os = new FileOutputStream(this.buildOutputFileName(fileName));){
            os.write(((ReportFile)((ReportDocument)renderReport.getEntity()).getFiles().get(0)).getContent());
        }
    }

    protected String createProduct(String ticketNo, ProductStatus status, String relUid, ProductCategory productCategory, MCOCategory mcoCategory) throws Exception {
        BookingFile bf;
        Reservation reservation;
        EntityContainer bfc = null;
        Product product = null;
        if (!TextUtil.isBlank((String)relUid)) {
            ProductSearchResult searchResult = BookingDao.findProductByUid((String)relUid);
            bfc = searchResult.getContainer();
            reservation = searchResult.getReservation();
            product = new Product();
            reservation.getProducts().add(product);
            product.setReservation(reservation);
            Product relatedProduct = (Product)searchResult.getProduct();
            product.setTicketType(TicketType.OWN);
            product.setTariffType(TariffType.REGULAR);
            product.setValidatorCode("12345678");
            if (productCategory == ProductCategory.AIR) {
                product.setPreviousProduct(relatedProduct);
                relatedProduct.setNextProduct(product);
            } else {
                product.getRelatedProducts().add(relatedProduct);
            }
        } else {
            bfc = new EntityContainer(BookingFile.class);
            bfc.setCreated(new Date());
            bfc.setModified(new Date());
            bf = (BookingFile)bfc.getEntity();
            bf.setCustomerProfile(this.clientReference);
            reservation = new Reservation();
            bf.getReservations().add(reservation);
            reservation.setBookingFile(bf);
            product = new Product();
            product.setTicketType(TicketType.OWN);
            product.setTariffType(TariffType.REGULAR);
            product.setValidatorCode("12345678");
            reservation.getProducts().add(product);
            product.setReservation(reservation);
        }
        bf = (BookingFile)bfc.getEntity();
        bf.setCustomerProfile(this.clientReference);
        Traveller traveller = new Traveller();
        traveller.setName("Test Person");
        bf.getTravellers().add(traveller);
        product.setTraveller(traveller);
        product.setBlankOwnerRef(this.tchReference);
        product.setBlankOwnerNumber("99A");
        product.setCashier(this.agent);
        product.setStatus(ProductStatus.SELL);
        product.setCarrier((DictionaryReference)new AirlineReference(this.airlineCode));
        bf.setAgency(this.agencyReference);
        product.setProductCategory(productCategory);
        product.setMcoCategory(mcoCategory);
        product.setEticket(this.eTicket);
        product.setValidatorCode("00001");
        AirProductHelper.setSupplier((Product)product, this.vip);
        product.setBlankType((DictionaryReference)new BlankTypeReference(this.eTicket ? "99A \u042d61" : "99A 661"));
        Money money = new Money();
        money.setCurrency("RUB");
        money.setValue(BigDecimal.valueOf(this.fare));
        AirProductHelper.setBaseFare((Product)product, (Money)money);
        AirProductHelper.setEquivalentFare((Product)product, (BigDecimal)BigDecimal.valueOf(this.fare));
        Tax tax = new Tax();
        tax.setCode("ZZ");
        tax.setEquivalentAmount(BigDecimal.valueOf(this.zzTax));
        product.getTaxes().add(tax);
        tax = new Tax();
        tax.setCode("XT");
        tax.setEquivalentAmount(BigDecimal.valueOf(this.xtTax));
        product.getTaxes().add(tax);
        product.setStatus(status);
        product.setSystemNumber((this.eTicket ? "\u042d61" : "661") + ticketNo);
        product.getScns().add(ticketNo);
        product.setIssueDate(this.issueDate);
        product.setCarrierNumber(((Airline)DictionaryCache.get().resolveReference(product.getCarrier())).getAirlineNumber());
        AirProductHelper.setAgency((Product)product, (EntityReference)this.agencyReference);
        if (productCategory == ProductCategory.AIR) {
            Segment segment = new Segment();
            segment.setStartDate(this.issueDate);
            segment.setAirline((DictionaryReference)new AirlineReference(this.airlineCode));
            segment.setDepartureLocation((DictionaryReference)new GeoLocationReference("MOW"));
            segment.setArriveLocation((DictionaryReference)new GeoLocationReference(this.arrivalCityCode));
            segment.setFareBasis("farebasis");
            SegmentTariff sppPsgr = new SegmentTariff();
            sppPsgr.getSegments().add(segment);
            product.getSegmentTariffs().add(sppPsgr);
            segment = new Segment();
            segment.setStartDate(this.issueDate);
            segment.setAirline((DictionaryReference)new AirlineReference(this.airlineCode));
            segment.setDepartureLocation((DictionaryReference)new GeoLocationReference(this.arrivalCityCode));
            segment.setArriveLocation((DictionaryReference)new GeoLocationReference("MOW"));
            segment.setFareBasis("farebasis");
            sppPsgr = new SegmentTariff();
            sppPsgr.getSegments().add(segment);
            product.getSegmentTariffs().add(sppPsgr);
        }
        if (product.getStatus() != ProductStatus.VOID) {
            ProductFop vendorFOP = new ProductFop();
            vendorFOP.setAmount(SystemHelper.getMoney((double)(this.fare + this.zzTax + this.xtTax), (String)"RUB"));
            vendorFOP.setOperationDate(this.issueDate);
            vendorFOP.setAgent(new EntityReference("testUid", Person.class, "test agent"));
            vendorFOP.setType(this.vendorPaymentType);
            List vendorFops = AirProductHelper.getVendorContractRelation((Product)product).getFops();
            List clientFops = AirProductHelper.getClientContractRelation((Product)product).getFops();
            vendorFops.add(vendorFOP);
            clientFops.add(XCloneHelper.clone((XCloneable)vendorFOP, (boolean)true));
        }
        EntityStorage.get().save(bfc, false);
        return product.getUid();
    }

    protected void createProfiles() throws Exception {
        EntityContainer commPercent = new EntityContainer(CommissionProperties.class);
        ((CommissionProperties)commPercent.getEntity()).setDisplayName("Commission %");
        ((CommissionProperties)commPercent.getEntity()).setRate(true);
        ((CommissionProperties)commPercent.getEntity()).setRoundingMode(RoundingMode.NONE);
        ((CommissionProperties)commPercent.getEntity()).setRate(true);
        EntityStorage.get().save(commPercent, false);
        this.commission = commPercent.toReference();
        EntityContainer ctr = new EntityContainer(this.vip.getType(), this.vip.getUid());
        ((Organization)ctr.getEntity()).getShortName().setStringValue(this.vip.getCaption());
        ((Organization)ctr.getEntity()).getTypes().add(OrganizationType.AGENCY);
        EntityStorage.get().save(ctr, false);
        Validator validator = new Validator();
        validator.setAgency(this.agencyReference);
        validator.setSupplier(this.vip);
        validator.setBlankOwner(this.tchReference);
        validator.setNumber("00001");
        EntityContainer<SalesPoint> spCtr = this.createSalesPoint("001", "Main SP", "Main SP", (EntityReference<Organization>)this.agencyReference, null, Arrays.asList(validator), null);
        Address address = new Address();
        address.setAddressType(AddressType.FACTUAL);
        address.setCity((DictionaryReference)new GeoLocationReference("MOW"));
        ((SalesPoint)spCtr.getEntity()).getAddresses().add(address);
        EntityStorage.get().save(spCtr, false);
        this.spRef = spCtr.toReference();
        EntityContainer cc = new EntityContainer(Contract.class);
        Contract contract = (Contract)cc.getEntity();
        contract.setSupplier(this.vip);
        contract.setVendor(this.tchReference);
        Calendar cldr = Calendar.getInstance();
        cldr.setTime(this.issueDate);
        cldr.add(2, -6);
        ContractCustomerInfo info = new ContractCustomerInfo();
        contract.getCustomers().add(info);
        info.setIssueDate(cldr.getTime());
        info.setStartDate(cldr.getTime());
        cldr.add(2, 12);
        info.setEndDate(cldr.getTime());
        contract.setContractType(ContractType.VENDOR);
        contract.setSupplier(this.vip);
        info.setCustomer(this.agencyReference);
        info.setNumber("01");
        RuleSet rules = new RuleSet();
        RuleSettings rs = new RuleSettings();
        rs.setTarget((RuleTarget)Targets.PRODUCT_COMMISSION);
        rs.setName("fare1");
        RuleResult res = new RuleResult();
        RuleResultValue value = new RuleResultValue();
        value.setCurrencyCode("%");
        value.setTarget(this.commission);
        value.setValue(10.0);
        res.setAction((RuleAction)Actions.SIMPLE_COMMISSION);
        res.setValue((Object)value);
        rs.getResults().add(res);
        rules.getRules().add(rs);
        contract.setRuleSet(rules);
        EntityStorage.get().save(cc, false);
    }

    protected URL getDictionariesSetupFile() {
        return ModelTestBase.class.getResource("dictionaries.xml");
    }

    protected URL getEntitiesSetupFile() {
        return ModelTestBase.class.getResource("entities.xml");
    }
}

