/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.prepare.divergence.ccc;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BlankTypeReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.parsers.model.CCCExchangeDocument;
import com.gridnine.xtrip.common.reports.model.DivergenceReportParameters;
import com.gridnine.xtrip.common.reports.render.salesreports.divergence.ccc.DivergenceSegmentsReportTicket;
import com.gridnine.xtrip.server.reports.prepare.salesreports.ccc.CCCFilesDivergenceReportPrepareHandler;
import com.gridnine.xtrip.server.reports.salesreports.prepare.divergence.ccc.CCCFilesDivergenceReportTestBase;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class Bug1470Test
extends CCCFilesDivergenceReportTestBase {
    @Test
    public void testIncludePaperTickets() throws Exception {
        this.createProfiles();
        Assert.assertEquals((long)0L, (long)this.getDivergencesCount("999", "999", false));
    }

    @Test
    public void testExcludePaperTickets() throws Exception {
        this.createProfiles();
        Assert.assertEquals((long)1L, (long)this.getDivergencesCount("999", "999", true));
    }

    private int getDivergencesCount(String ccBlankTypeCode, String ticketBlankTypeCode, boolean excludePaperTickets) throws Exception {
        this.createObjects(ccBlankTypeCode, ticketBlankTypeCode);
        HashMap<String, Object> data = new HashMap<String, Object>();
        Calendar cldr = Calendar.getInstance();
        cldr.setTime(this.issueDate);
        cldr.add(2, -6);
        DivergenceReportParameters params = new DivergenceReportParameters();
        params.setPeriodBegin(cldr.getTime());
        cldr.add(2, 12);
        params.setPeriodEnd(cldr.getTime());
        params.setAgency(new EntityReference(this.agencyContainer));
        params.setSupplier(new EntityReference(this.vendorContainer));
        params.setExcludePaperTickets(excludePaperTickets);
        data.put("key-report-params", params);
        CCCFilesDivergenceReportPrepareHandler handler = new CCCFilesDivergenceReportPrepareHandler();
        List<List<DivergenceSegmentsReportTicket>> filteredData = handler.getData(data, null);
        return filteredData.size();
    }

    private void createObjects(String ccBlankTypeCode, String ticketBlankTypeCode) throws Exception {
        CCCExchangeDocument doc = this.createDoc("7453369480101");
        doc.setBlankType((DictionaryReference)new BlankTypeReference(ccBlankTypeCode));
        this.addCCCFile(doc, 2);
        doc.setBlankType((DictionaryReference)new BlankTypeReference(ticketBlankTypeCode));
        this.addProduct(doc);
    }
}

