/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.reports.salesreports.prepare.divergence.ccc;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.parsers.model.CCCExchangeDocument;
import com.gridnine.xtrip.common.reports.model.DivergenceReportParameters;
import com.gridnine.xtrip.common.reports.render.salesreports.divergence.ccc.DivergenceSegmentsReportTicket;
import com.gridnine.xtrip.server.reports.prepare.salesreports.ccc.CCCFilesDivergenceReportPrepareHandler;
import com.gridnine.xtrip.server.reports.salesreports.prepare.divergence.ccc.CCCFilesDivergenceReportTestBase;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class Bug1844Test
extends CCCFilesDivergenceReportTestBase {
    @Test
    public void testSupplierOrdinal() throws Exception {
        this.createProfiles();
        Assert.assertEquals((long)0L, (long)this.getDivergencesCount((EntityReference<Organization>)new EntityReference(this.vendorContainer)));
    }

    @Test
    public void testDifferentSuppliers() throws Exception {
        this.createProfiles();
        Assert.assertEquals((long)1L, (long)this.getDivergencesCount((EntityReference<Organization>)new EntityReference(this.agencyContainer)));
    }

    private int getDivergencesCount(EntityReference<Organization> supplier) throws Exception {
        this.createObjects(supplier);
        HashMap<String, Object> data = new HashMap<String, Object>();
        Calendar cldr = Calendar.getInstance();
        cldr.setTime(this.issueDate);
        cldr.add(2, -6);
        DivergenceReportParameters params = new DivergenceReportParameters();
        params.setPeriodBegin(cldr.getTime());
        cldr.add(2, 12);
        params.setPeriodEnd(cldr.getTime());
        params.setAgency(new EntityReference(this.agencyContainer));
        params.setSupplier(new EntityReference(this.vendorContainer));
        data.put("key-report-params", params);
        CCCFilesDivergenceReportPrepareHandler handler = new CCCFilesDivergenceReportPrepareHandler();
        List<List<DivergenceSegmentsReportTicket>> filteredData = handler.getData(data, null);
        return filteredData.size();
    }

    private void createObjects(EntityReference<Organization> supplier) throws Exception {
        CCCExchangeDocument doc = this.createDoc("7453369480101");
        this.addCCCFile(doc, 2);
        doc.setSupplier(supplier);
        this.addProduct(doc);
    }
}

